/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.waterquality.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.rss.plugins.waterquality.model.Connection;
import hec.wqenginecore.jackson.Entry;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqengineimpl.geometry.WQSubDomainRef;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class ConnectionSet {
    @JsonIgnore
    private Map<WQSubDomainRef, Connection> _upstreamMap = new LinkedHashMap<WQSubDomainRef, Connection>();
    @JsonIgnore
    private Map<WQSubDomainRef, Connection> _downstreamMap = new LinkedHashMap<WQSubDomainRef, Connection>();

    public List<Entry<WQSubDomainRef, Connection>> getUpstreamEntries() {
        return Entry.fromMapEntries(this._upstreamMap.entrySet());
    }

    public List<Entry<WQSubDomainRef, Connection>> getDownstreamEntries() {
        return Entry.fromMapEntries(this._downstreamMap.entrySet());
    }

    public void setUpstreamEntries(List<Entry<WQSubDomainRef, Connection>> list) {
        Entry.setEntries(this._upstreamMap, list);
    }

    public void setDownstreamEntries(List<Entry<WQSubDomainRef, Connection>> list) {
        Entry.setEntries(this._downstreamMap, list);
    }

    @JsonIgnore
    public Collection<WQSubDomainRef> getSubDomainRefs() {
        LinkedHashSet<WQSubDomainRef> linkedHashSet = new LinkedHashSet<WQSubDomainRef>();
        linkedHashSet.addAll(this._upstreamMap.keySet());
        linkedHashSet.addAll(this._downstreamMap.keySet());
        return linkedHashSet;
    }

    public void setUpstream(WQSubDomainRef wQSubDomainRef, Connection connection) {
        if (wQSubDomainRef != null) {
            if (connection == null) {
                this._upstreamMap.remove(wQSubDomainRef);
                return;
            }
            this._upstreamMap.put(wQSubDomainRef, connection);
        }
    }

    public Connection getUpstream(WQSubDomainRef wQSubDomainRef) {
        return this._upstreamMap.get(wQSubDomainRef);
    }

    public Connection getDownstream(WQSubDomainRef wQSubDomainRef) {
        return this._downstreamMap.get(wQSubDomainRef);
    }

    public void setDownstream(WQSubDomainRef wQSubDomainRef, Connection connection) {
        if (wQSubDomainRef != null) {
            if (connection == null) {
                this._downstreamMap.remove(wQSubDomainRef);
                return;
            }
            this._downstreamMap.put(wQSubDomainRef, connection);
        }
    }
}

