/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.waterquality.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.rss.plugins.waterquality.model.ReachCellLengthDefinitionType;
import hec.wqenginecore.jackson.Entry;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqengineimpl.geometry.WQSubDomainRef;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class ReachCellLengthDefinition {
    private ReachCellLengthDefinitionType _type = ReachCellLengthDefinitionType.RAS;
    private Double _globalMinimum = null;
    private Double _globalMaximum = null;
    private Map<WQSubDomainRef, Double> _minimums = new LinkedHashMap<WQSubDomainRef, Double>();
    private Map<WQSubDomainRef, Double> _maximums = new LinkedHashMap<WQSubDomainRef, Double>();

    public void setType(ReachCellLengthDefinitionType reachCellLengthDefinitionType) {
        this._type = reachCellLengthDefinitionType;
    }

    public void setGlobalMinimum(Double d) {
        this._globalMinimum = d;
    }

    public void setGlobalMaximum(Double d) {
        this._globalMaximum = d;
    }

    public void setMaximum(WQSubDomainRef wQSubDomainRef, Double d) {
        if (d == null) {
            this._maximums.remove(wQSubDomainRef);
            return;
        }
        this._maximums.put(wQSubDomainRef, d);
    }

    public void setMinimum(WQSubDomainRef wQSubDomainRef, Double d) {
        if (d == null) {
            this._minimums.remove(wQSubDomainRef);
            return;
        }
        this._minimums.put(wQSubDomainRef, d);
    }

    @JsonIgnore
    public void setMinimums(Map<WQSubDomainRef, Double> map) {
        this._minimums = map;
    }

    @JsonIgnore
    public void setMaximums(Map<WQSubDomainRef, Double> map) {
        this._maximums = map;
    }

    public ReachCellLengthDefinitionType getType() {
        return this._type;
    }

    public Double getGlobalMinimum() {
        return this._globalMinimum;
    }

    public Double getGlobalMaximum() {
        return this._globalMaximum;
    }

    public Double getMinimum(WQSubDomainRef wQSubDomainRef) {
        return this._minimums.get(wQSubDomainRef);
    }

    public Double getMaximum(WQSubDomainRef wQSubDomainRef) {
        return this._maximums.get(wQSubDomainRef);
    }

    @JsonGetter
    public List<Entry<WQSubDomainRef, Double>> getMaximums() {
        return Entry.fromMapEntries(this._maximums.entrySet());
    }

    @JsonSetter
    public void setMaximums(List<Entry<WQSubDomainRef, Double>> list) {
        Entry.setEntries(this._maximums, list);
    }

    @JsonGetter
    public List<Entry<WQSubDomainRef, Double>> getMinimums() {
        return Entry.fromMapEntries(this._minimums.entrySet());
    }

    @JsonSetter
    public void setMinimums(List<Entry<WQSubDomainRef, Double>> list) {
        Entry.setEntries(this._minimums, list);
    }
}

