/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.waterquality.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.rss.plugins.waterquality.model.ReservoirLayerConfiguration;
import hec.rss.plugins.waterquality.model.ReservoirLayerHeightDefinitionType;
import hec.rss.plugins.waterquality.model.ReservoirLayerHeightDeserializer;
import hec.rss.plugins.waterquality.model.ReservoirLayerSpacingType;
import hec.wqenginecore.jackson.Entry;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqengineimpl.geometry.WQSubDomainRef;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class ReservoirLayerHeightDefinition {
    private ReservoirLayerHeightDefinitionType _type = ReservoirLayerHeightDefinitionType.Global;
    private Double _globalHeight = null;
    private Map<WQSubDomainRef, ReservoirLayerConfiguration> _heightMap = new LinkedHashMap<WQSubDomainRef, ReservoirLayerConfiguration>();

    public ReservoirLayerHeightDefinitionType getType() {
        return this._type;
    }

    public Double getGlobalHeight() {
        return this._globalHeight;
    }

    public void setType(ReservoirLayerHeightDefinitionType reservoirLayerHeightDefinitionType) {
        this._type = reservoirLayerHeightDefinitionType;
    }

    public void setGlobalHeight(Double d) {
        this._globalHeight = d;
    }

    public void setHeightMap(Map<WQSubDomainRef, ReservoirLayerConfiguration> map) {
        this._heightMap.clear();
        if (map != null) {
            this._heightMap.putAll(map);
        }
    }

    public ReservoirLayerConfiguration getLayerConfig(WQSubDomainRef wQSubDomainRef) {
        return this._heightMap.get(wQSubDomainRef);
    }

    public List<Double> getVariableHeights(WQSubDomainRef object) {
        List<Double> list = null;
        if ((object = this.getLayerConfig((WQSubDomainRef)object)) != null && ((ReservoirLayerConfiguration)object).getSpacingType() == ReservoirLayerSpacingType.VARIABLE) {
            list = ((ReservoirLayerConfiguration)object).getVariableLayerHeights();
        }
        return list;
    }

    @JsonIgnore
    public void setSpacingType(WQSubDomainRef wQSubDomainRef, ReservoirLayerSpacingType reservoirLayerSpacingType) {
        ReservoirLayerConfiguration reservoirLayerConfiguration = this._heightMap.get(wQSubDomainRef);
        if (reservoirLayerConfiguration != null) {
            reservoirLayerConfiguration.setSpacingType(reservoirLayerSpacingType);
            return;
        }
        this._heightMap.put(wQSubDomainRef, new ReservoirLayerConfiguration(reservoirLayerSpacingType, null, null));
    }

    @JsonIgnore
    public ReservoirLayerSpacingType getSpacingType(WQSubDomainRef wQSubDomainRef) {
        ReservoirLayerSpacingType reservoirLayerSpacingType = ReservoirLayerSpacingType.CONSTANT;
        if (this._heightMap.get(wQSubDomainRef) != null) {
            reservoirLayerSpacingType = this._heightMap.get(wQSubDomainRef).getSpacingType();
        }
        return reservoirLayerSpacingType;
    }

    public void setVariableHeights(WQSubDomainRef wQSubDomainRef, List<Double> list) {
        if (this._heightMap.get(wQSubDomainRef) == null) {
            this._heightMap.put(wQSubDomainRef, new ReservoirLayerConfiguration(ReservoirLayerSpacingType.VARIABLE, null, list));
            return;
        }
        this._heightMap.get(wQSubDomainRef).setVariableLayerHeights(list);
    }

    public Double getConstantHeight(WQSubDomainRef object) {
        Double d = null;
        if ((object = this._heightMap.get(object)) != null && ((ReservoirLayerConfiguration)object).getSpacingType() == ReservoirLayerSpacingType.CONSTANT) {
            d = ((ReservoirLayerConfiguration)object).getConstantLayerHeight();
        }
        return d;
    }

    public void setConstantHeight(WQSubDomainRef wQSubDomainRef, Double d) {
        if (this._heightMap.get(wQSubDomainRef) == null) {
            this._heightMap.put(wQSubDomainRef, new ReservoirLayerConfiguration(ReservoirLayerSpacingType.CONSTANT, d, null));
            return;
        }
        this._heightMap.get(wQSubDomainRef).setConstantLayerHeight(d);
    }

    @JsonIgnore
    public Map<WQSubDomainRef, ReservoirLayerConfiguration> getHeightMap() {
        return this._heightMap;
    }

    @JsonDeserialize(using=ReservoirLayerHeightDeserializer.class)
    public List<Entry<WQSubDomainRef, ReservoirLayerConfiguration>> getEntries() {
        return Entry.fromMapEntries(this._heightMap.entrySet());
    }

    public void setEntries(Collection<Entry<WQSubDomainRef, ReservoirLayerConfiguration>> collection) {
        Entry.setEntries(this._heightMap, collection);
    }
}

