/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.waterquality.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.clientapp.model.TSDataSet;
import hec.data.TimeWindow;
import hec.heclib.util.HecTime;
import hec.io.TimeSeriesContainer;
import hec.lang.annotation.Scriptable;
import hec.map.WorldPt;
import hec.model.Interpolate;
import hec.model.PairedValues;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.model.StreamElement;
import hec.model.TSLocation;
import hec.model.TSRecord;
import hec.model.ValuePair;
import hec.rss.client.WaterControlPortGeometry;
import hec.rss.client.WaterControlPortRowItem;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.ContinuousIntakeControlDevice;
import hec.rss.model.ControlStructure;
import hec.rss.model.DiversionElement;
import hec.rss.model.DivertedOutletElement;
import hec.rss.model.Element;
import hec.rss.model.ElementGraph;
import hec.rss.model.Function;
import hec.rss.model.GatedIntakeControlDevice;
import hec.rss.model.IntakeGeometry;
import hec.rss.model.IntakeOpeningType;
import hec.rss.model.JunctionElement;
import hec.rss.model.OutletGroupElement;
import hec.rss.model.PowerPlantFlow;
import hec.rss.model.PumpFlow;
import hec.rss.model.ReachElement;
import hec.rss.model.ReservoirDamElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOutletElement;
import hec.rss.model.Routing;
import hec.rss.model.RssModelVariableConstants;
import hec.rss.model.RssNode;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.model.Spillway;
import hec.rss.model.Storage;
import hec.rss.model.TimeStepUtil;
import hec.rss.model.WaterControlDevice;
import hec.rss.plugins.waterquality.model.ConnectionMap;
import hec.rss.plugins.waterquality.model.ConnectionSet;
import hec.rss.plugins.waterquality.model.ReachCellLengthDefinition;
import hec.rss.plugins.waterquality.model.ReservoirLayerHeightDefinition;
import hec.rss.plugins.waterquality.model.ReservoirLayerSpacingType;
import hec.rss.plugins.waterquality.model.WQRoutingTable;
import hec.rss.wq.dataSources.DataSourceFactory;
import hec.rss.wq.model.WQRun;
import hec.rss.wq.ui.ParameterMap;
import hec.rss.wq.ui.TimeSeriesDataSource;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.BoundaryCondition;
import hec.wqenginecore.BoundaryConditionSet;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.InitialConditionSet;
import hec.wqenginecore.InterpICValue;
import hec.wqenginecore.WQConsistencyCheck;
import hec.wqenginecore.WQEngineAdapter;
import hec.wqenginecore.WQException;
import hec.wqenginecore.WQFlowComputeType;
import hec.wqenginecore.WQReachHydro;
import hec.wqenginecore.WQResHydro;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.geometry.BoundaryType;
import hec.wqenginecore.geometry.ElevStorInterpType;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.SubDomainBoundary;
import hec.wqenginecore.geometry.SubDomainBoundaryRef;
import hec.wqenginecore.geometry.SubDomainRef;
import hec.wqenginecore.geometry.SubDomainType;
import hec.wqenginecore.geometry.WQControlDevice;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqengineimpl.WQConstituentSet;
import hec.wqengineimpl.geometry.WQGeoSubDomain;
import hec.wqengineimpl.geometry.WQGeoSubDomainBoundary;
import hec.wqengineimpl.geometry.WQGeoSubDomainJunction;
import hec.wqengineimpl.geometry.WQGeometry;
import hec.wqengineimpl.region.WQRegionSet;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.UnitUtil;
import mil.army.usace.hec.metadata.UnitsConversionException;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class RssWQGeometry
extends WQGeometry
implements RssModelVariableConstants {
    private ReachCellLengthDefinition _reachLengthDefinition = new ReachCellLengthDefinition();
    private ReservoirLayerHeightDefinition _reservoirHeightDefinition = new ReservoirLayerHeightDefinition();
    private ConnectionSet _connectionSet = new ConnectionSet();
    @JsonIgnore
    private Map<SubDomainBoundary, TSRecord> _localFlowMap = new HashMap<SubDomainBoundary, TSRecord>();
    @JsonIgnore
    private Map<SubDomainBoundary, TSRecord> _divFlowMap = new HashMap<SubDomainBoundary, TSRecord>();
    @JsonIgnore
    private Map<SubDomainBoundary, List<TSRecord>> _outflowMap = new HashMap<SubDomainBoundary, List<TSRecord>>();
    @JsonIgnore
    private Map<SubDomainBoundary, TSRecord> _inNetworkInflowMap = new HashMap<SubDomainBoundary, TSRecord>();
    @JsonIgnore
    private Map<WQGeoSubDomain, WQRoutingTable> _routingTableMap = new HashMap<WQGeoSubDomain, WQRoutingTable>();
    @JsonIgnore
    private transient boolean _diversionFromDSS = false;
    @JsonIgnore
    private static final Logger LOGGER = Logger.getLogger(RssWQGeometry.class.getName());

    @JsonCreator
    public RssWQGeometry(@JsonProperty(value="id") int n) {
        super(n);
    }

    public void createGeometry(RssSystem rssSystem) throws WQException {
        Object object;
        if (rssSystem == null) {
            throw new WQException("Null RssSystem passed to RssWQGeometry.createGeometry()");
        }
        try {
            object = rssSystem.buildElementGraph(0, false);
        }
        catch (Exception exception) {
            throw new WQException("Failed to build Element Graph", exception);
        }
        ((ElementGraph)object).c();
        object = ((ElementGraph)object).f();
        int n = 0;
        for (Object object2 : object) {
            WQGeoSubDomainJunction wQGeoSubDomainJunction;
            Element element = rssSystem.getElementByOrder((int)object2);
            if (element instanceof ReachElement) {
                double d;
                element = (ReachElement)element;
                double d2 = ConnectionMap.getReachElemLength((ReachElement)element, rssSystem);
                if (d > 0.0) {
                    wQGeoSubDomainJunction = this.createReachSubDomain(n, (ReachElement)element, d2, 1000.0);
                    if (wQGeoSubDomainJunction == null) {
                        throw new WQException("Error in creation of WQ Reach from Network Reach " + element.getDisplayName());
                    }
                    this._subDomainList.add(wQGeoSubDomainJunction);
                    ++n;
                    continue;
                }
                throw new WQException("Water Quality Subdomain Reach: " + element.getName() + " has length < 0");
            }
            if (element instanceof ReservoirElement) {
                element = (ReservoirElement)element;
                double d = this.getReservoirHeightDefinition().getGlobalHeight();
                WQGeoSubDomain wQGeoSubDomain = this.createReservoirSubDomain(n, (ReservoirElement)element, d);
                this._subDomainList.add(wQGeoSubDomain);
                ++n;
                continue;
            }
            if (!(element instanceof JunctionElement)) continue;
            element = (JunctionElement)element;
            wQGeoSubDomainJunction = this.createWQJunction(n, (JunctionElement)element);
            this._subDomainJnctList.add(wQGeoSubDomainJunction);
            ++n;
        }
        this.fillDefaultRegion();
        if (this._subDomainList.isEmpty()) {
            throw new WQException("No WQ subdomains identified for ResSim System " + rssSystem.getDisplayName());
        }
    }

    public WQGeoSubDomain getWQReach(int n) {
        return this.getReaches().stream().filter(subDomain -> subDomain.getElementId() == n).findFirst().orElse(null);
    }

    private void fillDefaultRegion() {
        WQRegionSet wQRegionSet = this.getRegionSet();
        wQRegionSet.setGeometryId(this.getId());
        for (WQGeoSubDomain wQGeoSubDomain : this._subDomainList) {
            wQGeoSubDomain = this.buildRef((SubDomain)wQGeoSubDomain);
            wQRegionSet.addToDefaultIfAbsent((SubDomainRef)wQGeoSubDomain);
        }
    }

    public boolean createBoundaries(RssSystem rssSystem) throws WQException {
        Object object;
        int n;
        if (this._subDomainList == null) {
            return false;
        }
        int n2 = 0;
        for (WQGeoSubDomain wQGeoSubDomain : this._subDomainList) {
            String string;
            Object object22;
            Object object3;
            n = wQGeoSubDomain.getId();
            object = wQGeoSubDomain.getUpstreamElemIds();
            Object object4 = object.iterator();
            while (object4.hasNext()) {
                object3 = (Integer)object4.next();
                boolean bl = false;
                for (Object object22 : this._subDomainList) {
                    int n3 = object22.getId();
                    if (n3 == n) continue;
                    List list = object22.getDownstreamElemIds();
                    for (Object object5 : list) {
                        if (((Integer)object5).intValue() != ((Integer)object3).intValue()) continue;
                        bl = true;
                        boolean bl2 = this.checkBoundaryExists(n3, n);
                        if (bl2) continue;
                        BoundaryType boundaryType = WQGeoSubDomainBoundary.determineType((WQGeoSubDomain)object22, (WQGeoSubDomain)wQGeoSubDomain, (boolean)false);
                        string = this.getElementName(rssSystem, (WQGeoSubDomain)object22, (Integer)object3, boundaryType);
                        boundaryType = new WQGeoSubDomainBoundary((WQGeometry)this, n2, string, (WQGeoSubDomain)object22, wQGeoSubDomain, ((Integer)object3).intValue(), boundaryType);
                        this._subDomainBoundaryList.add(boundaryType);
                        ++n2;
                    }
                }
                if (bl) continue;
                boolean bl3 = false;
                object22 = rssSystem.getElement((Integer)object3);
                if (object22 instanceof JunctionElement) {
                    JunctionElement junctionElement = (JunctionElement)object22;
                    bl3 = this.upstreamNetworkBoundary(junctionElement);
                }
                WQGeoSubDomainBoundary wQGeoSubDomainBoundary = new WQGeoSubDomainBoundary((WQGeometry)this, n2, this.getElementName(rssSystem, (Integer)object3), null, wQGeoSubDomain, bl3, ((Integer)object3).intValue());
                this._subDomainBoundaryList.add(wQGeoSubDomainBoundary);
                ++n2;
            }
            object4 = wQGeoSubDomain.getDownstreamElemIds();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object = (Integer)object3.next();
                boolean bl = false;
                object22 = this._subDomainList.iterator();
                while (object22.hasNext()) {
                    Object object5;
                    WQGeoSubDomain wQGeoSubDomain2 = (WQGeoSubDomain)object22.next();
                    int n4 = wQGeoSubDomain2.getId();
                    if (n4 == n) continue;
                    List list = wQGeoSubDomain2.getUpstreamElemIds();
                    object5 = list.iterator();
                    while (object5.hasNext()) {
                        Integer n5 = (Integer)object5.next();
                        if (n5.intValue() != ((Integer)object).intValue()) continue;
                        bl = true;
                        boolean bl4 = this.checkBoundaryExists(n, n4);
                        if (bl4) continue;
                        string = WQGeoSubDomainBoundary.determineType((WQGeoSubDomain)wQGeoSubDomain, (WQGeoSubDomain)wQGeoSubDomain2, (boolean)false);
                        String string2 = this.getElementName(rssSystem, wQGeoSubDomain, (Integer)object, (BoundaryType)string);
                        object4 = new WQGeoSubDomainBoundary((WQGeometry)this, n2, string2, wQGeoSubDomain, wQGeoSubDomain2, ((Integer)object).intValue(), (BoundaryType)string);
                        this._subDomainBoundaryList.add(object4);
                        ++n2;
                    }
                }
                if (bl) continue;
                object22 = new WQGeoSubDomainBoundary((WQGeometry)this, n2, this.getElementName(rssSystem, (Integer)object), wQGeoSubDomain, null, false, ((Integer)object).intValue());
                this._subDomainBoundaryList.add(object22);
                ++n2;
            }
        }
        for (WQGeoSubDomain wQGeoSubDomain : this._subDomainBoundaryList) {
            n = wQGeoSubDomain.getDownstreamSubDomainId();
            if (n < 0 || (object = this.getSubDomain(n)) == null || object.getType() != SubDomainType.RESERVOIR_1DV) continue;
            double d = this.getDistToReservoirDam(rssSystem, (WQGeoSubDomainBoundary)wQGeoSubDomain);
            wQGeoSubDomain.setDistToResDam(d);
        }
        if (this._subDomainBoundaryList.isEmpty()) {
            System.out.println("Error: No WQ subdomains boundaries identified");
            return false;
        }
        return true;
    }

    public String getElementName(RssSystem object, WQGeoSubDomain wQGeoSubDomain, Integer n, BoundaryType boundaryType) {
        Object object2 = this.getElementName((RssSystem)object, n);
        if ((BoundaryType.RESERVOIR_2_RIVER.equals((Object)boundaryType) || BoundaryType.RESERVOIR_2_RESERVOIR.equals((Object)boundaryType)) && (object = this.getDivertedOutletName((RssSystem)object, wQGeoSubDomain.getElementId(), n)) != null) {
            object2 = object;
        }
        return object2;
    }

    public String getDivertedOutletName(RssSystem rssSystem, Integer object, Integer object2) {
        String string = null;
        if ((object2 = rssSystem.getElement((Integer)object2)) instanceof JunctionElement) {
            object2 = (JunctionElement)object2;
            if ((object = rssSystem.getElement((Integer)object)) instanceof ReservoirElement) {
                object = (ReservoirElement)object;
                if ((object2 = ((Element)object2).getUpstreamNodes(null)) != null && !object2.isEmpty()) {
                    object2 = object2.iterator();
                    while (object2.hasNext()) {
                        Element element;
                        RssReturnStatusConstants rssReturnStatusConstants = (RssNode)object2.next();
                        if ((rssReturnStatusConstants = ((RssNode)rssReturnStatusConstants).getUpstreamElement()) == null || !((element = ((Element)rssReturnStatusConstants).getParent()) instanceof DivertedOutletElement) || !(element = ((Element)rssReturnStatusConstants).getTopParent()).equals(object)) continue;
                        string = rssSystem.getNameForKeyString(rssReturnStatusConstants.getName());
                    }
                }
            }
        }
        return string;
    }

    private boolean upstreamNetworkBoundary(JunctionElement iterator) {
        boolean bl = true;
        iterator = ((Element)((Object)iterator)).getUpstreamNodes(null);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            RssNode rssNode = iterator.next();
            RssNode rssNode2 = rssNode;
            rssNode2 = rssNode;
            if (rssNode.getUpstreamElement() == null) continue;
            bl = false;
            break;
        }
        return bl;
    }

    protected String getElementName(RssSystem rssReturnStatusConstants, SubDomainBoundary subDomainBoundary) {
        String string = null;
        if ((rssReturnStatusConstants = this.getElement((RssSystem)rssReturnStatusConstants, subDomainBoundary)) != null) {
            string = rssReturnStatusConstants.getName();
        }
        return string;
    }

    protected String getElementName(RssSystem rssReturnStatusConstants, int n) {
        String string = null;
        if ((rssReturnStatusConstants = rssReturnStatusConstants.getElement(n)) != null) {
            string = rssReturnStatusConstants.getName();
        }
        return string;
    }

    protected Element getElement(RssSystem rssReturnStatusConstants, SubDomainBoundary subDomainBoundary) {
        rssReturnStatusConstants = rssReturnStatusConstants.getElement(subDomainBoundary.getJnctId());
        return rssReturnStatusConstants;
    }

    public JunctionElement getJunctionElement(RssSystem rssReturnStatusConstants, SubDomainBoundary subDomainBoundary) {
        JunctionElement junctionElement = null;
        if ((rssReturnStatusConstants = this.getElement((RssSystem)rssReturnStatusConstants, subDomainBoundary)) instanceof JunctionElement) {
            junctionElement = (JunctionElement)rssReturnStatusConstants;
        }
        return junctionElement;
    }

    private WQGeoSubDomain createReservoirSubDomain(int n, ReservoirElement reservoirElement, double d) throws WQException {
        RssNode rssNode;
        RssNode rssNode2;
        WQGeoSubDomain wQGeoSubDomain = new WQGeoSubDomain(n, reservoirElement.getDisplayName(), (WQGeometry)this, reservoirElement.getIndex());
        List<RssNode> list = reservoirElement.getUpstreamNodes(null);
        List list2 = ((Element)reservoirElement).getDownstreamNodes(null);
        Object object = list.iterator();
        while (object.hasNext()) {
            rssNode = rssNode2 = object.next();
            wQGeoSubDomain.addUpstreamElemId(rssNode.getUpstreamElement().getIndex());
        }
        object = list2.iterator();
        while (object.hasNext()) {
            rssNode = rssNode2 = object.next();
            wQGeoSubDomain.addDownstreamElemId(rssNode.getDownstreamElement().getIndex());
        }
        object = reservoirElement.getStorageFunction();
        ((Storage)object).initElevStorAndElevAreaPV();
        double d2 = RssWQGeometry.getReservoirMinElevation(reservoirElement);
        double d3 = RssWQGeometry.getReservoirMaxElevation(reservoirElement);
        double d4 = d3 - d2;
        wQGeoSubDomain.discretizeReservoir(d, d4);
        RssNode rssNode3 = list.get(0);
        RssNode rssNode4 = (RssNode)list2.get(0);
        rssNode3 = rssNode3.getLocation();
        rssNode4 = rssNode4.getLocation();
        wQGeoSubDomain.createCellCenters(((WorldPt)rssNode3).e, ((WorldPt)rssNode3).n, ((WorldPt)rssNode4).e, ((WorldPt)rssNode4).n, d2, d3);
        this.setResStorageElevAreaData(reservoirElement, wQGeoSubDomain, d3);
        this.setResOutletGeom(reservoirElement, wQGeoSubDomain);
        this.addWQControlDevices(reservoirElement, wQGeoSubDomain);
        return wQGeoSubDomain;
    }

    public void setResStorageElevAreaData(ReservoirElement namedType, WQGeoSubDomain wQGeoSubDomain, double d) throws WQException {
        int n;
        namedType = namedType.getStorageFunction();
        PairedValues pairedValues = namedType.getElevationStorageValues();
        PairedValues pairedValues2 = namedType.getElevationAreaValues();
        int n2 = n = pairedValues.getPairCount();
        if (pairedValues.getValuePair((int)0).yval > 0.0) {
            ++n2;
        }
        if (d > pairedValues.getLastValuePair().xval) {
            ++n2;
        }
        double[][] dArray = new double[n2][2];
        double[][] dArray2 = new double[n2][2];
        int n3 = 0;
        if (pairedValues.getValuePair((int)0).yval > 0.0) {
            n3 = 1;
        }
        for (int i = 0; i < n; ++i) {
            ValuePair valuePair = pairedValues.getValuePair(i);
            dArray[i + n3][0] = valuePair.xval;
            dArray[i + n3][1] = valuePair.yval;
            ValuePair valuePair2 = pairedValues2.getValuePair(i);
            dArray2[i + n3][0] = valuePair2.xval;
            dArray2[i + n3][1] = valuePair2.yval;
        }
        if (pairedValues.getValuePair((int)0).yval > 0.0) {
            double d2;
            double d3;
            if (namedType.useConicInterpolation()) {
                d3 = dArray[1][0] - namedType.calcInitialConicDepth();
                d2 = namedType.calcConicBottomArea();
            } else {
                double d4 = (dArray[2][1] - dArray[1][1]) / (dArray[2][0] - dArray[1][0]);
                d3 = dArray[1][0] - dArray[1][1] / d4;
                d2 = 0.0;
            }
            dArray[0][0] = d3;
            dArray[0][1] = 0.0;
            dArray2[0][0] = d3;
            dArray2[0][1] = d2;
        }
        if (d > pairedValues.getLastValuePair().xval) {
            dArray[n2 - 1][0] = d;
            dArray[n2 - 1][1] = namedType.elevationToStorage(d);
            dArray2[n2 - 1][0] = d;
            dArray2[n2 - 1][1] = namedType.elevationToArea(d);
        }
        wQGeoSubDomain.setElevStorData(dArray);
        wQGeoSubDomain.setElevAreaData(dArray2);
        if (namedType.useConicInterpolation()) {
            wQGeoSubDomain.setElevStorInterpType(ElevStorInterpType.CONIC.id());
            return;
        }
        wQGeoSubDomain.setElevStorInterpType(ElevStorInterpType.LINEAR.id());
    }

    private boolean checkAreaPairedData(PairedValues pairedValues) {
        boolean bl = false;
        for (int i = 0; i < pairedValues.getPairCount(); ++i) {
            ValuePair valuePair;
            ValuePair valuePair2 = pairedValues.getValuePair(i);
            if (!(valuePair.yval < -0.01)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void addWQControlDevices(ReservoirElement object, WQGeoSubDomain wQGeoSubDomain) {
        if (((ReservoirElement)object).hasWaterControlDeviceOnRes()) {
            int n = 0;
            object = new ArrayList(((Element)object).getElementsByClass(AdjustableFlow.class, null));
            object = object.iterator();
            while (object.hasNext()) {
                WQControlDevice wQControlDevice;
                Element element = (Element)object.next();
                if (!element.hasWaterControlDevice()) continue;
                WaterControlDevice waterControlDevice = element.getWaterControlDevice();
                if (waterControlDevice instanceof GatedIntakeControlDevice) {
                    int n2 = ((GatedIntakeControlDevice)waterControlDevice).getNumberOfPortLevels();
                    wQControlDevice = new WQControlDevice(n, n2);
                    this.passWQControlDeviceData(waterControlDevice, wQControlDevice, element, wQGeoSubDomain.getResReleaseElemId());
                    wQGeoSubDomain.addWqControlDevice(wQControlDevice);
                    ++n;
                    continue;
                }
                if (!(waterControlDevice instanceof ContinuousIntakeControlDevice)) continue;
                wQControlDevice = new WQControlDevice(n, 1);
                this.passWQControlDeviceData(waterControlDevice, wQControlDevice, element, wQGeoSubDomain.getResReleaseElemId());
                wQGeoSubDomain.addWqControlDevice(wQControlDevice);
                ++n;
            }
        }
    }

    public void setResOutletGeom(ReservoirElement object, WQGeoSubDomain wQGeoSubDomain) {
        List<List<Double>> list = this.getReservoirOutletElevations((ReservoirElement)((Object)object));
        List<List<Double>> list2 = this.getReservoirOutletAreas((ReservoirElement)((Object)object));
        List<List<Integer>> list3 = this.getReservoirOutletIds((ReservoirElement)((Object)object));
        double d = RssWQGeometry.getReservoirMinElevation((ReservoirElement)((Object)object));
        double d2 = RssWQGeometry.getReservoirMaxElevation((ReservoirElement)((Object)object));
        for (List<Double> object2 : list) {
            for (int i = 0; i < object2.size(); ++i) {
                double d3 = object2.get(i);
                d3 = Math.max(Math.min(d3, d2), d);
                object2.set(i, d3);
            }
        }
        wQGeoSubDomain.setOutletElevData(list);
        wQGeoSubDomain.setOutletAreaData(list2);
        wQGeoSubDomain.setResReleaseElemId(list3);
        int n = 0;
        for (List<Double> list4 : list) {
            n += list4.size();
        }
        wQGeoSubDomain.setNumOutlets(n);
    }

    private void passWQControlDeviceData(WaterControlDevice waterControlDevice, WQControlDevice wQControlDevice, Element element, List<List<Integer>> list) {
        wQControlDevice.setRssReleaseElemId(element.getIndex());
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            List<Integer> list2 = list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                if (element.getIndex() != list2.get(j).intValue()) continue;
                wQControlDevice.setParentOutletIdx(i);
                wQControlDevice.setChildOutletIdx(j);
                bl = true;
                break;
            }
            if (bl) break;
        }
        if (waterControlDevice instanceof GatedIntakeControlDevice) {
            this.passWQControlDeviceGeom((GatedIntakeControlDevice)waterControlDevice, wQControlDevice);
            return;
        }
        if (waterControlDevice instanceof ContinuousIntakeControlDevice) {
            double[] dArray = new double[]{0.0};
            wQControlDevice.setNumPortLevels(1);
            wQControlDevice.setPortInvertElevation(dArray);
            wQControlDevice.setPortGeomRectangular(new boolean[]{false});
            wQControlDevice.setPortHeight(dArray);
            wQControlDevice.setPortWidth(dArray);
            wQControlDevice.setPortDiameter(dArray);
            wQControlDevice.setNumPortsPerLevel(new int[]{1});
        }
    }

    public void passWQControlDeviceGeom(GatedIntakeControlDevice object, WQControlDevice wQControlDevice) {
        int n = ((GatedIntakeControlDevice)object).getNumberOfPortLevels();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        boolean[] blArray = new boolean[n];
        int[] nArray = new int[n];
        object = ((GatedIntakeControlDevice)object).getPortRows();
        for (int i = 0; i < n; ++i) {
            Cloneable cloneable = (WaterControlPortRowItem)object.get(i);
            dArray[i] = ((WaterControlPortRowItem)cloneable).getInvertElevation();
            nArray[i] = ((WaterControlPortRowItem)cloneable).getNumOfPorts();
            if (((WaterControlPortGeometry)(cloneable = ((WaterControlPortRowItem)cloneable).getGeometry())).getOpeningType() == IntakeOpeningType.Rectangular) {
                blArray[i] = true;
                dArray2[i] = ((WaterControlPortGeometry)cloneable).getHeight();
                dArray3[i] = ((WaterControlPortGeometry)cloneable).getWidth();
                continue;
            }
            blArray[i] = false;
            dArray4[i] = ((WaterControlPortGeometry)cloneable).getDiameter();
        }
        wQControlDevice.setNumPortLevels(n);
        wQControlDevice.setPortInvertElevation(dArray);
        wQControlDevice.setPortGeomRectangular(blArray);
        wQControlDevice.setPortHeight(dArray2);
        wQControlDevice.setPortWidth(dArray3);
        wQControlDevice.setPortDiameter(dArray4);
        wQControlDevice.setNumPortsPerLevel(nArray);
    }

    private List<List<Double>> getReservoirOutletElevations(ReservoirElement object) {
        ArrayList<List<Double>> arrayList = new ArrayList<List<Double>>();
        object = ((ReservoirElement)object).getReservoirOutletElements(null);
        for (int i = 0; i < object.size(); ++i) {
            Object object2 = (Element)object.get(i);
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            object2 = ((Element)object2).getElementVector();
            this.getReservoirOutletElevations((Vector)object2, arrayList2);
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    private void getReservoirOutletElevations(Vector vector, List<Double> list) {
        for (int i = 0; i < vector.size(); ++i) {
            Object object = (Element)vector.get(i);
            Object object2 = ((Element)object).getFunction();
            if (object2 instanceof PowerPlantFlow || object2 instanceof PumpFlow || object2 instanceof Spillway || object2 instanceof AdjustableFlow) {
                object2 = ((ControlStructure)object2).getIntakeGeometry();
                object = 0.0;
                if (((IntakeGeometry)object2).getIntakeOpeningType() == IntakeOpeningType.Rectangular) {
                    object = ((IntakeGeometry)object2).getInvertElevation() + 0.5 * ((IntakeGeometry)object2).getRectangularLength();
                } else if (((IntakeGeometry)object2).getIntakeOpeningType() == IntakeOpeningType.Circular) {
                    object = ((IntakeGeometry)object2).getInvertElevation() + 0.5 * ((IntakeGeometry)object2).getCircularDiameter();
                }
                list.add((Double)object);
                continue;
            }
            if (!(object instanceof OutletGroupElement)) continue;
            object2 = ((Element)object).getElementVector();
            this.getReservoirOutletElevations((Vector)object2, list);
        }
    }

    private List<List<Double>> getReservoirOutletAreas(ReservoirElement object) {
        ArrayList<List<Double>> arrayList = new ArrayList<List<Double>>();
        object = ((ReservoirElement)object).getReservoirOutletElements(null);
        for (int i = 0; i < object.size(); ++i) {
            Object object2 = (Element)object.get(i);
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            object2 = ((Element)object2).getElementVector();
            this.getReservoirOutletAreas((Vector)object2, arrayList2);
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    private void getReservoirOutletAreas(Vector vector, List<Double> list) {
        for (int i = 0; i < vector.size(); ++i) {
            Object object = (Element)vector.get(i);
            Object object2 = ((Element)object).getFunction();
            if (object2 instanceof PowerPlantFlow || object2 instanceof PumpFlow || object2 instanceof Spillway || object2 instanceof AdjustableFlow) {
                object2 = ((ControlStructure)object2).getIntakeGeometry();
                object = 0.0;
                if (((IntakeGeometry)object2).getIntakeOpeningType() == IntakeOpeningType.Rectangular) {
                    object = ((IntakeGeometry)object2).getRectangularLength() * ((IntakeGeometry)object2).getRectangularWidth();
                } else if (((IntakeGeometry)object2).getIntakeOpeningType() == IntakeOpeningType.Circular) {
                    object = 0.7853981633974483 * Math.pow(((IntakeGeometry)object2).getCircularDiameter(), 2.0);
                }
                list.add((Double)object);
                continue;
            }
            if (!(object instanceof OutletGroupElement)) continue;
            object2 = ((Element)object).getElementVector();
            this.getReservoirOutletAreas((Vector)object2, list);
        }
    }

    private List<List<Integer>> getReservoirOutletIds(ReservoirElement object) {
        ArrayList<List<Integer>> arrayList = new ArrayList<List<Integer>>();
        object = ((ReservoirElement)object).getReservoirOutletElements(null);
        for (int i = 0; i < object.size(); ++i) {
            Object object2 = (Element)object.get(i);
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            object2 = new ArrayList(((Element)object2).getElementVector());
            this.getReservoirOutletIds((List<Element>)object2, arrayList2);
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    private void getReservoirOutletIds(List<Element> object, List<Integer> list) {
        Iterator<Element> iterator = object.iterator();
        while (iterator.hasNext()) {
            Element element = iterator.next();
            object = element.getFunction();
            if (object instanceof PowerPlantFlow || object instanceof PumpFlow || object instanceof Spillway || object instanceof AdjustableFlow) {
                list.add(element.getIndex());
                continue;
            }
            if (!(element instanceof OutletGroupElement)) continue;
            object = new ArrayList<Element>(element.getElementVector());
            this.getReservoirOutletIds((List<Element>)object, list);
        }
    }

    public double[] getReservoirLayerElevations(int n) {
        Object object = this.getSubDomain(n);
        if (object != null) {
            double d;
            int n2 = object.getNumCells() + 1;
            double[] dArray = new double[n2];
            double[][] dArray2 = object.getElevStorData();
            object = object.getCellLength();
            dArray[0] = d = dArray2[0][0];
            for (int i = 0; i < n2; ++i) {
                dArray[i + 1] = d += object[i];
            }
            return dArray;
        }
        return new double[0];
    }

    public static double getReservoirMinElevation(ReservoirElement namedType) {
        double d;
        double d2;
        namedType = namedType.getStorageFunction();
        PairedValues pairedValues = namedType.getElevationStorageValues();
        double d3 = pairedValues.getValuePair((int)0).xval;
        double d4 = pairedValues.getValuePair((int)0).yval;
        if (d2 < 0.1) {
            d = d3;
        } else if (namedType.useConicInterpolation()) {
            d = d3 - namedType.calcInitialConicDepth();
        } else {
            namedType = pairedValues.getValuePair(0);
            pairedValues = pairedValues.getValuePair(1);
            double d5 = (pairedValues.yval - namedType.yval) / (pairedValues.xval - namedType.xval);
            d = pairedValues.xval - pairedValues.yval / d5;
        }
        return d;
    }

    public static double getReservoirMaxElevation(ReservoirElement reservoirElement) {
        List list = reservoirElement.getReservoirOutletElements(null);
        int n = list.size();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2;
            Element element = (Element)list.get(i);
            if (!(element instanceof ReservoirDamElement) || (d2 = ((ReservoirDamElement)(element = (ReservoirDamElement)element)).getDamFunction().getTopOfDam()) == Double.NEGATIVE_INFINITY) continue;
            d = Math.max(d, d2);
        }
        if (d == 0.0) {
            PairedValues pairedValues = reservoirElement.getStorageFunction().getElevationStorageValues();
            int n2 = pairedValues.getPairCount();
            d = pairedValues.getValuePair((int)(n2 - 1)).xval;
        }
        return d;
    }

    private double getDistToReservoirDam(RssSystem rssSystem, WQGeoSubDomainBoundary object) throws WQException {
        int n = object.getJnctId();
        TSLocation tSLocation = (JunctionElement)rssSystem.findElement(n);
        tSLocation = tSLocation.getDownstreamNode();
        StreamElement streamElement = tSLocation.getStream();
        double d = tSLocation.getStreamCoord();
        object = this.getSubDomain(object.getDownstreamSubDomainId());
        object = rssSystem.findReservoir(object.getElementId());
        object = ((Element)object).getDownstreamNode();
        tSLocation = ((RssNode)object).getStream();
        double d2 = ((RssNode)object).getStreamCoord();
        object = rssSystem.getAlignment();
        double d3 = object.findDistanceBetween(streamElement, d, (StreamElement)tSLocation, d2);
        if (d3 == -3.4028234663852886E38) {
            LOGGER.log(Level.SEVERE, "Cannot determine distance to reservoir dam along stream alignment");
            throw new WQException("Cannot determine distance to reservoir dam along stream alignment");
        }
        double d4 = ConnectionMap.getStreamAlignLenConversionFactor(rssSystem);
        return d3 * d4;
    }

    private WQGeoSubDomain createReachSubDomain(int n, ReachElement reachElement, double d, double d2) throws WQException {
        WQGeoSubDomain wQGeoSubDomain = null;
        if (reachElement != null) {
            try {
                RssNode rssNode = ((Element)reachElement).getUpstreamNode();
                RssNode rssNode2 = ((Element)reachElement).getDownstreamNode();
                if (rssNode != null && rssNode2 != null) {
                    Element element = rssNode.getUpstreamElement();
                    Element element2 = rssNode2.getDownstreamElement();
                    if (element != null && element2 != null) {
                        WQGeoSubDomain wQGeoSubDomain2 = new WQGeoSubDomain(n, reachElement.getDisplayName(), (WQGeometry)this, reachElement.getIndex());
                        wQGeoSubDomain2.addUpstreamElemId(element.getIndex());
                        wQGeoSubDomain2.addDownstreamElemId(element2.getIndex());
                        wQGeoSubDomain2.createDefaultReach(d, d2);
                        wQGeoSubDomain2.setUpstreamStation(Double.valueOf(rssNode.getStreamStation()));
                        wQGeoSubDomain2.setDownstreamStation(Double.valueOf(rssNode2.getStreamStation()));
                        WorldPt worldPt = rssNode.getLocation();
                        WorldPt worldPt2 = rssNode2.getLocation();
                        wQGeoSubDomain2.createCellCenters(worldPt.e, worldPt.n, worldPt2.e, worldPt2.n, 0.0, 0.0);
                        wQGeoSubDomain = wQGeoSubDomain2;
                    }
                }
            }
            catch (Exception exception) {
                throw new WQException("Error creating WQ Reach for Network Reach " + reachElement.getDisplayName(), exception);
            }
        }
        return wQGeoSubDomain;
    }

    private WQGeoSubDomainJunction createWQJunction(int n, JunctionElement junctionElement) {
        return new WQGeoSubDomainJunction((WQGeometry)this, n, junctionElement.getDisplayName(), junctionElement.getIndex());
    }

    public void createLocalBoundaries(RssSystem rssSystem) throws WQException {
        for (WQGeoSubDomain wQGeoSubDomain : this._subDomainList) {
            if (wQGeoSubDomain.getType() == SubDomainType.REACH_1D) {
                this.createLocalBoundariesReach(wQGeoSubDomain, rssSystem);
                continue;
            }
            if (wQGeoSubDomain.getType() != SubDomainType.RESERVOIR_1DV) continue;
            this.createLocalBoundariesRes(wQGeoSubDomain, rssSystem);
        }
        for (WQGeoSubDomain wQGeoSubDomain : this._subDomainList) {
            if (wQGeoSubDomain.getType() != SubDomainType.RESERVOIR_1DV) continue;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            Object object = (ReservoirElement)rssSystem.getElement(wQGeoSubDomain.getElementId());
            object = ((ReservoirElement)object).getReservoirOutletElements(null);
            block2: for (int i = 0; i < object.size(); ++i) {
                Element element = (Element)object.get(i);
                RssNode rssNode = element.getDownstreamNode();
                for (WQGeoSubDomainBoundary wQGeoSubDomainBoundary : this._subDomainBoundaryList) {
                    int n = wQGeoSubDomainBoundary.getUpstreamSubDomainId();
                    int n2 = wQGeoSubDomainBoundary.getJnctId();
                    int n3 = n = n == wQGeoSubDomain.getId() ? 1 : 0;
                    if (rssNode != null && rssNode.getDownstreamElement() != null) {
                        n2 = rssNode.getDownstreamElement().getIndex() == n2 ? 1 : 0;
                    } else {
                        int n4 = n2 = n2 == element.getIndex() ? 1 : 0;
                    }
                    if (n == 0 || n2 == 0) continue;
                    arrayList.add(wQGeoSubDomainBoundary.getId());
                    continue block2;
                }
            }
            if (arrayList.size() == wQGeoSubDomain.getOutletElev().size()) {
                wQGeoSubDomain.setOutletBCIds(arrayList);
                continue;
            }
            throw new WQException("Water Quality Geometry creation error: Outlet BC id length != outlet elevation length");
        }
    }

    public boolean createLocalBoundariesReach(WQGeoSubDomain wQGeoSubDomain, RssSystem rssReturnStatusConstants) {
        boolean bl;
        Element element;
        Object object;
        Object object2;
        int n = this.getNumSubdomainBoundaries();
        int n2 = wQGeoSubDomain.getId();
        List list = this.findUpstreamBoundaries(n2);
        int n3 = ((WQGeoSubDomainBoundary)list.get(0)).getJnctId();
        Object object3 = ((RssSystem)rssReturnStatusConstants).getElement(n3);
        if (object3 instanceof JunctionElement) {
            object3 = (JunctionElement)object3;
            Object object5 = ((JunctionElement)object3).getLocalFlowVector();
            object5 = object5.iterator();
            while (object5.hasNext()) {
                Object object6 = object5.next();
                if (!(object6 instanceof String[])) continue;
                String[] stringArray = (String[])object6;
                String object4 = stringArray[0];
                object6 = RssWQGeometry.formBoundaryName((JunctionElement)object3, object4);
                object2 = new WQGeoSubDomainBoundary((WQGeometry)this, n, object6, null, wQGeoSubDomain, n3, BoundaryType.LOCAL_INFLOW);
                this._subDomainBoundaryList.add(object2);
                ++n;
            }
            new Vector();
            object5 = ((JunctionElement)object3).getDiversions(null);
            int n4 = ((Vector)object5).size();
            for (int i = 0; i < n4; ++i) {
                DiversionElement diversionElement = (DiversionElement)((Vector)object5).elementAt(i);
                diversionElement.getName();
                object2 = RssWQGeometry.formBoundaryName((JunctionElement)object3, diversionElement);
                object = new WQGeoSubDomainBoundary((WQGeometry)this, n, (String)object2, wQGeoSubDomain, null, n3, BoundaryType.LOCAL_DIVERSION);
                this._subDomainBoundaryList.add(object);
                object2 = ((Element)diversionElement).getDownstreamNode();
                if (object2 != null) {
                    element = ((RssNode)object2).getDownstreamElement();
                    object.setDsDiversionJnctId(element.getIndex());
                }
                ++n;
            }
        }
        if ((bl = this.isEndOfExtent((List<WQGeoSubDomainBoundary>)(object3 = this.findDownstreamBoundaries(n2)))) && (object3 = ((RssSystem)rssReturnStatusConstants).getElement(n3 = ((WQGeoSubDomainBoundary)object3.get(0)).getJnctId())) instanceof JunctionElement) {
            JunctionElement junctionElement = (JunctionElement)object3;
            String[] stringArray = junctionElement.getLocalFlowVector();
            for (Object e : stringArray) {
                if (!(e instanceof String[])) continue;
                stringArray = (String[])e;
                object2 = stringArray[0];
                object = RssWQGeometry.formBoundaryName(junctionElement, (String)object2);
                object2 = new WQGeoSubDomainBoundary((WQGeometry)this, n, (String)object, null, wQGeoSubDomain, n3, BoundaryType.LOCAL_INFLOW);
                this._subDomainBoundaryList.add(object2);
                ++n;
            }
            new Vector();
            Vector vector = junctionElement.getDiversions(null);
            int n4 = vector.size();
            for (int i = 0; i < n4; ++i) {
                object2 = (DiversionElement)vector.elementAt(i);
                object = RssWQGeometry.formBoundaryName(junctionElement, (DiversionElement)object2);
                object2 = ((Element)object2).getDownstreamNode();
                element = null;
                if (object2 != null) {
                    rssReturnStatusConstants = ((RssNode)object2).getDownstreamElement();
                    List list2 = this.findDownstreamSubDomains(rssReturnStatusConstants.getIndex());
                    if (list2.size() > 1) {
                        System.out.println("Error in WQ Geometry: Channel bifurcations not supported");
                        System.out.println("Junction: " + rssReturnStatusConstants.getName());
                        return false;
                    }
                    if (list2.size() == 1) {
                        element = (WQGeoSubDomain)list2.get(0);
                    }
                }
                rssReturnStatusConstants = new WQGeoSubDomainBoundary((WQGeometry)this, n, (String)object, wQGeoSubDomain, (WQGeoSubDomain)element, n3, BoundaryType.LOCAL_DIVERSION);
                this._subDomainBoundaryList.add(rssReturnStatusConstants);
                ++n;
            }
        }
        return true;
    }

    private boolean isEndOfExtent(List<WQGeoSubDomainBoundary> object) {
        boolean bl = false;
        object = object.iterator();
        while (object.hasNext()) {
            WQGeoSubDomainBoundary wQGeoSubDomainBoundary = (WQGeoSubDomainBoundary)object.next();
            if (wQGeoSubDomainBoundary.getBoundaryType() != BoundaryType.RIVER_OUTFLOW && wQGeoSubDomainBoundary.getBoundaryType() != BoundaryType.RESERVOIR_OUTFLOW) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean createLocalBoundariesRes(WQGeoSubDomain wQGeoSubDomain, RssSystem rssSystem) {
        Object object;
        int n = this.getNumSubdomainBoundaries();
        ReservoirElement reservoirElement = rssSystem.findReservoir(wQGeoSubDomain.getName());
        int n2 = wQGeoSubDomain.getId();
        Object object2 = this.findUpstreamBoundaries(n2);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            String string;
            Object object3;
            Object object4 = (WQGeoSubDomainBoundary)object2.next();
            int n3 = object4.getJnctId();
            if (hashSet.contains(n3)) continue;
            hashSet.add(n3);
            object = rssSystem.getElement(n3);
            if (!(object instanceof JunctionElement)) continue;
            object4 = (JunctionElement)object;
            object = ((JunctionElement)object4).getLocalFlowVector();
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (!(e instanceof String[])) continue;
                String[] stringArray = (String[])e;
                object3 = stringArray[0];
                string = RssWQGeometry.formBoundaryName((JunctionElement)object4, (String)object3);
                object3 = new WQGeoSubDomainBoundary((WQGeometry)this, n, string, null, wQGeoSubDomain, n3, BoundaryType.LOCAL_INFLOW);
                this._subDomainBoundaryList.add(object3);
                ++n;
            }
            new Vector();
            object = ((JunctionElement)object4).getDiversions(null);
            int n4 = ((Vector)object).size();
            for (int i = 0; i < n4; ++i) {
                object3 = (DiversionElement)((Vector)object).elementAt(i);
                string = RssWQGeometry.formBoundaryName((JunctionElement)object4, (DiversionElement)object3);
                if ((object3 = ((Element)object3).getDownstreamNode()) != null) {
                    object3 = ((RssNode)object3).getDownstreamElement();
                    object3 = new WQGeoSubDomainBoundary((WQGeometry)this, n, string, wQGeoSubDomain.getId(), object3.getIndex(), n3, BoundaryType.LOCAL_DIVERSION);
                    this._subDomainBoundaryList.add(object3);
                } else {
                    object3 = new WQGeoSubDomainBoundary((WQGeometry)this, n, string, wQGeoSubDomain, null, n3, BoundaryType.LOCAL_DIVERSION);
                    this._subDomainBoundaryList.add(object3);
                }
                ++n;
            }
        }
        object2 = reservoirElement.getDivertedOutlets();
        if (!object2.isEmpty()) {
            for (int i = 0; i < object2.size(); ++i) {
                DivertedOutletElement divertedOutletElement = (DivertedOutletElement)object2.get(i);
                object = ((Element)divertedOutletElement).getDownstreamNode();
                if (object != null) continue;
                object = new WQGeoSubDomainBoundary((WQGeometry)this, n, divertedOutletElement.getFullName(), wQGeoSubDomain, null, divertedOutletElement.getIndex(), BoundaryType.DIVERTED_OUTLET);
                this._subDomainBoundaryList.add(object);
                ++n;
            }
        }
        return true;
    }

    public static String formBoundaryName(JunctionElement junctionElement, String string) {
        return junctionElement.getName() + " - " + string;
    }

    public static String formBoundaryName(JunctionElement junctionElement, DiversionElement diversionElement) {
        return junctionElement.getName() + " - " + diversionElement.getName();
    }

    public void initHydro(RssSystem rssSystem, RssRun rssRun, WQRun wQRun, WQEngineAdapter wQEngineAdapter, WQFlowComputeType wQFlowComputeType) throws WQException {
        Object object;
        SubDomainBoundary subDomainBoundary;
        this._localFlowMap.clear();
        this._divFlowMap.clear();
        this._outflowMap.clear();
        this._inNetworkInflowMap.clear();
        Object object2 = this.getBoundariesInExtent();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            subDomainBoundary = (SubDomainBoundary)object2.next();
            object = this.getJunctionElement(rssSystem, subDomainBoundary);
            if (object == null) continue;
            if (subDomainBoundary.getBoundaryType() == BoundaryType.LOCAL_INFLOW) {
                this.updateLocalFlowMap(rssSystem, rssRun, (JunctionElement)object, subDomainBoundary);
                continue;
            }
            if (subDomainBoundary.getBoundaryType() == BoundaryType.LOCAL_DIVERSION) {
                this.updateLocalDivMap(rssRun, (JunctionElement)object, subDomainBoundary);
                continue;
            }
            if (subDomainBoundary.getBoundaryType() == BoundaryType.RESERVOIR_OUTFLOW || subDomainBoundary.getBoundaryType() == BoundaryType.RIVER_OUTFLOW) {
                this.updateOutflowMap(rssRun, (JunctionElement)object, subDomainBoundary);
                continue;
            }
            if (subDomainBoundary.getDownstreamSubDomainId() <= 0) continue;
            this.updateInNetworkFlowMap(rssRun, (JunctionElement)object, subDomainBoundary);
        }
        object2 = this.getSubDomainsInExtent();
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (SubDomain)object.next();
            subDomainBoundary = (WQGeoSubDomain)object2;
            subDomainBoundary.createHydro();
            if (subDomainBoundary.getType() == SubDomainType.REACH_1D) {
                this.initReachHydro((SubDomain)subDomainBoundary, rssSystem, rssRun);
                continue;
            }
            if (subDomainBoundary.getType() != SubDomainType.RESERVOIR_1DV) continue;
            this.initResHydro((SubDomain)subDomainBoundary, rssSystem, rssRun, wQRun, wQEngineAdapter, wQFlowComputeType);
        }
        boolean bl = rssRun.getAlternative().getWaterQualityOptions().getCoupledFlowWQCompute();
        this._diversionFromDSS = !bl;
    }

    private void updateLocalFlowMap(RssSystem object, RssRun rssRun, JunctionElement iterator, SubDomainBoundary subDomainBoundary) {
        rssRun = rssRun.getRegOutputTSData();
        String string = iterator.getName() + " - ";
        int n = string.length();
        String string2 = subDomainBoundary.getName().substring(n);
        iterator = ((JunctionElement)((Object)iterator)).getLocalFlowVector();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string3;
            Object object2 = iterator.next();
            if (!(object2 instanceof String[]) || !(string3 = (object2 = (String[])object2)[0]).equals(string2)) continue;
            int n2 = Integer.parseInt(object2[3]);
            object = ((RssSystem)object).getNode(n2);
            object = ((RssNode)object).getTSRecordProxy(0).getName();
            object = rssRun.getTSRecord((String)object, 0);
            this._localFlowMap.put(subDomainBoundary, (TSRecord)object);
            return;
        }
    }

    private void updateLocalDivMap(RssRun rssRun, JunctionElement object, SubDomainBoundary subDomainBoundary) {
        rssRun = rssRun.getRegOutputTSData();
        String string = subDomainBoundary.getName().replaceFirst(object.getName() + " - ", "");
        new Vector();
        object = ((JunctionElement)object).getDiversions(null);
        int n = object.size();
        for (int i = 0; i < n; ++i) {
            DiversionElement diversionElement = (DiversionElement)object.get(i);
            String string2 = diversionElement.getName();
            if (!string2.equals(string)) continue;
            object = diversionElement.getNode(0).getTSRecordProxy(0).getName();
            rssRun = rssRun.getTSRecord((String)object, 0);
            this._divFlowMap.put(subDomainBoundary, (TSRecord)rssRun);
            return;
        }
    }

    private void updateOutflowMap(RssRun rssRun, JunctionElement object, SubDomainBoundary subDomainBoundary) {
        rssRun = rssRun.getRegOutputTSData();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        object = ((Element)object).getDownstreamNodes(null);
        int n = object.size();
        for (int i = 0; i < n; ++i) {
            Object object2 = (RssNode)object.get(i);
            if (object2 == null) continue;
            object2 = ((RssNode)object2).getTSRecordProxy(0).getName();
            object2 = rssRun.getTSRecord((String)object2, 0);
            arrayList.add(object2);
        }
        this._outflowMap.put(subDomainBoundary, arrayList);
    }

    private void updateInNetworkFlowMap(RssRun rssRun, JunctionElement object, SubDomainBoundary subDomainBoundary) {
        rssRun = rssRun.getRegOutputTSData();
        WQGeoSubDomain wQGeoSubDomain = this.getSubDomain(subDomainBoundary.getUpstreamSubDomainId());
        boolean bl = false;
        if (wQGeoSubDomain != null && wQGeoSubDomain.getType() == SubDomainType.RESERVOIR_1DV) {
            bl = true;
        }
        if (object != null) {
            object = ((Element)object).getUpstreamNodes(null);
            int n = object.size();
            for (int i = 0; i < n; ++i) {
                Object object2;
                boolean bl2;
                RssNode rssNode = (RssNode)object.get(i);
                if (rssNode == null || rssNode.getUpstreamElement() == null) continue;
                if (!bl) {
                    bl2 = rssNode.getUpstreamElement().getIndex() == wQGeoSubDomain.getElementId();
                } else {
                    object2 = rssNode.getUpstreamElement();
                    bl2 = false;
                    if (((Element)object2).getParent() instanceof ReservoirDamElement) {
                        bl2 = ((Element)object2).getParent().getParent().getIndex() == wQGeoSubDomain.getElementId();
                    } else if (((Element)object2).getParent() instanceof DivertedOutletElement) {
                        boolean bl3 = bl2 = ((Element)object2).getParent().getParent().getIndex() == wQGeoSubDomain.getElementId();
                    }
                }
                if (!bl2) continue;
                object2 = rssNode.getTSRecordProxy(0).getName();
                rssNode = rssRun.getTSRecord((String)object2, 0);
                this._inNetworkInflowMap.put(subDomainBoundary, (TSRecord)rssNode);
            }
        }
    }

    private void initReachHydro(SubDomain object, RssSystem object2, RssRun rssRun) throws WQException {
        boolean bl = rssRun.getAlternative().getWaterQualityOptions().getCoupledFlowWQCompute();
        WQRoutingTable wQRoutingTable = new WQRoutingTable(this, (WQGeoSubDomain)object);
        wQRoutingTable.init();
        this._routingTableMap.put((WQGeoSubDomain)object, wQRoutingTable);
        rssRun = rssRun.getRegOutputTSData();
        WQReachHydro wQReachHydro = object.getReachHydro();
        object2 = ((RssSystem)object2).findReach(object.getName());
        if (!(((Element)object2).getFunction() instanceof Routing)) {
            throw new WQException("Routing function not found for WQ reach " + object.getName());
        }
        Routing routing = (Routing)((Element)object2).getFunction();
        if (bl) {
            wQReachHydro.init(object, routing.getNumberSubreaches(), 7);
        } else {
            wQReachHydro.init(object, 1, 7);
        }
        object2 = ((Element)object2).getNode(0);
        object2 = ((RssNode)object2).getTSRecordProxy(0);
        object2 = rssRun.getTSRecord(object2.getName(), 0);
        double[] dArray = object2.getTSArray();
        object2 = dArray;
        double d = dArray[0];
        object2 = bl ? (Object)new double[routing.getNumberSubreaches() + 1] : (Object)new double[2];
        Arrays.fill((double[])object2, d);
        wQReachHydro.setSubreachFlow((double[])object2);
        object2 = wQReachHydro.interpolateHydro((double[])object2);
        for (int i = 0; i < object.getNumFaces(); ++i) {
            wQReachHydro.setFlowFace(i, (double)object2[i]);
        }
        this.setReachHydraulicProperties((SubDomain)object);
        double d2 = wQRoutingTable.getTotalVolForFlow(d);
        object = wQRoutingTable.getCellVolsForTotalVol(d2);
        wQReachHydro.setCellVol((double[])object);
    }

    public void setInitialCellVolumes() {
        List list = this.getSubDomainsInExtent();
        for (SubDomain subDomain : list) {
            if (subDomain.getType() != SubDomainType.REACH_1D) continue;
            list = subDomain.getReachHydro();
            double[] dArray = list.getXSArea();
            int n = dArray.length - 1;
            int[][] nArray = subDomain.getCellFaces();
            double[] dArray2 = subDomain.getCellLength();
            double[] dArray3 = new double[n];
            for (int i = 0; i < n; ++i) {
                int n2 = nArray[i][0];
                int n3 = nArray[i][1];
                dArray3[i] = 0.5 * (dArray[n2] + dArray[n3]) * dArray2[i];
            }
            list.setCellVol(dArray3);
        }
    }

    private void setReachHydraulicProperties(SubDomain subDomain) throws WQException {
        String string;
        double d;
        double d2;
        double d3;
        int n;
        WQReachHydro wQReachHydro = subDomain.getReachHydro();
        Object object = (WQGeoSubDomain)subDomain;
        double[] dArray = object.getXRAS();
        double[] dArray2 = object.getXFace();
        int n2 = dArray.length;
        int n3 = dArray2.length;
        if (n2 == 0) {
            String string2 = object.getSingleRASRiver();
            String string3 = object.getSingleRASReach();
            object = object.getSingleRASStation();
            for (int i = 0; i < subDomain.getNumFaces(); ++i) {
                double d4 = this.getRASSteadyFlowXSArea(string2, string3, (String)object, wQReachHydro.getFlow(i));
                double d5 = this.getRASSteadyFlowTopWidth(string2, string3, (String)object, wQReachHydro.getFlow(i));
                wQReachHydro.setXSAreaFace(i, d4);
                wQReachHydro.setSfcWidthFace(i, d5);
            }
            return;
        }
        for (n = 0; n < n2; ++n) {
            dArray[n] = 1.0 - dArray[n];
        }
        for (n = 0; n < n3; ++n) {
            dArray2[n] = 1.0 - dArray2[n];
        }
        String[] stringArray = object.getXRASRiver();
        String[] stringArray2 = object.getXRASReach();
        String[] stringArray3 = object.getXRASStation();
        for (n = 0; n < subDomain.getNumFacesInternal(); ++n) {
            int n4;
            double d6 = dArray2[n + 1];
            d3 = Math.abs(wQReachHydro.getFlow(n));
            n3 = 0;
            d2 = 0.0;
            d = 0.0;
            for (n4 = 0; n4 < n2; ++n4) {
                if (!(Math.abs(d6 - dArray[n4]) < 1.0E-6)) continue;
                String string4 = stringArray[n4];
                string = stringArray2[n4];
                object = stringArray3[n4];
                d2 = this.getRASSteadyFlowXSArea(string4, string, (String)object, d3);
                d = this.getRASSteadyFlowTopWidth(string4, string, (String)object, d3);
                n3 = 1;
                break;
            }
            if (n3 == 0) {
                n4 = Interpolate.bisearch((double[])dArray, (double)d6, (int)n2);
                if (n4 < 0) {
                    String string5 = stringArray[0];
                    string = stringArray2[0];
                    object = stringArray3[0];
                    d2 = this.getRASSteadyFlowXSArea(string5, string, (String)object, d3);
                    d = this.getRASSteadyFlowTopWidth(string5, string, (String)object, d3);
                } else if (n4 >= n2 - 1) {
                    String string6 = stringArray[n2 - 1];
                    string = stringArray2[n2 - 1];
                    object = stringArray3[n2 - 1];
                    d2 = this.getRASSteadyFlowXSArea(string6, string, (String)object, d3);
                    d = this.getRASSteadyFlowTopWidth(string6, string, (String)object, d3);
                } else {
                    String string7 = stringArray[n4];
                    string = stringArray2[n4];
                    object = stringArray3[n4];
                    double d7 = this.getRASSteadyFlowXSArea(string7, string, (String)object, d3);
                    double d8 = this.getRASSteadyFlowTopWidth(string7, string, (String)object, d3);
                    string7 = stringArray[n4 + 1];
                    string = stringArray2[n4 + 1];
                    object = stringArray3[n4 + 1];
                    double d9 = this.getRASSteadyFlowXSArea(string7, string, (String)object, d3);
                    double d10 = this.getRASSteadyFlowTopWidth(string7, string, (String)object, d3);
                    double d11 = dArray[n4 + 1] - dArray[n4];
                    d2 = (d6 - dArray[n4]) * (d9 - d7) / d11 + d7;
                    d = (d6 - dArray[n4]) * (d10 - d8) / d11 + d8;
                }
            }
            wQReachHydro.setXSAreaFace(n, d2);
            wQReachHydro.setSfcWidthFace(n, d);
        }
        n = subDomain.getNumFacesInternal();
        d3 = Math.abs(wQReachHydro.getFlow(n));
        String string8 = stringArray[0];
        string = stringArray2[0];
        object = stringArray3[0];
        d2 = this.getRASSteadyFlowXSArea(string8, string, (String)object, d3);
        d = this.getRASSteadyFlowTopWidth(string8, string, (String)object, d3);
        wQReachHydro.setXSAreaFace(n, d2);
        wQReachHydro.setSfcWidthFace(n, d);
        d3 = Math.abs(wQReachHydro.getFlow(++n));
        string8 = stringArray[n2 - 1];
        string = stringArray2[n2 - 1];
        object = stringArray3[n2 - 1];
        d2 = this.getRASSteadyFlowXSArea(string8, string, (String)object, d3);
        d = this.getRASSteadyFlowTopWidth(string8, string, (String)object, d3);
        wQReachHydro.setXSAreaFace(n, d2);
        wQReachHydro.setSfcWidthFace(n, d);
    }

    private void initResHydro(SubDomain subDomain, RssSystem rssSystem, RssRun iterator, WQRun wQRun, WQEngineAdapter wQEngineAdapter, WQFlowComputeType object) throws WQException {
        WQResHydro wQResHydro = subDomain.getResHydro();
        wQResHydro.init(subDomain, 7, wQEngineAdapter);
        this.setResHydroForStep(subDomain, rssSystem, (RssRun)((Object)iterator), wQRun, wQEngineAdapter, (WQFlowComputeType)object, 0);
        iterator = subDomain.getWqControlDevices();
        if (iterator != null) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                wQRun = (WQControlDevice)iterator.next();
                int n = wQRun.getNumPortLevels();
                double[] dArray = new double[n];
                Arrays.fill(dArray, 0.0);
                dArray[0] = 1.0;
                wQResHydro.setTCDFlowRatios(dArray, wQRun.getId());
                int n2 = wQRun.getRssReleaseElemId();
                object = rssSystem.getElement(n2);
                if (!((object = object.getWaterControlDevice()) instanceof ContinuousIntakeControlDevice)) continue;
                if ((object = (ContinuousIntakeControlDevice)object).useElevationForMaxIntake()) {
                    double[] dArray2 = new double[]{object.getMaxIntake()};
                    wQEngineAdapter.reallocateWQControlDeviceElevs(subDomain, (WQControlDevice)wQRun, 1, dArray2);
                    continue;
                }
                double d = object.getMaxIntake();
                object = (ReservoirElement)rssSystem.getElement(subDomain.getElementId());
                RunTimeStep runTimeStep = new RunTimeStep();
                new RunTimeStep().step = 0;
                double d2 = object.getStorageFunction().getElevation(runTimeStep);
                double d3 = RssWQGeometry.getReservoirMinElevation((ReservoirElement)object);
                object = new double[]{Math.max(d2 - d, d3)};
                wQEngineAdapter.reallocateWQControlDeviceElevs(subDomain, (WQControlDevice)wQRun, 1, (double[])object);
            }
        }
    }

    private double getLocalInflow(SubDomainBoundary subDomainBoundary, int n) throws WQException {
        TSRecord tSRecord = this._localFlowMap.get(subDomainBoundary);
        if (tSRecord == null) {
            throw new WQException("Failed to find local inflow for Water Quality Boundary " + subDomainBoundary.getName() + "Timestep " + n);
        }
        double d = tSRecord.getValue(n);
        return d;
    }

    private double getLocalDiversion(SubDomainBoundary subDomainBoundary, int n) throws WQException {
        double d;
        TSRecord tSRecord = this._divFlowMap.get(subDomainBoundary);
        if (tSRecord != null) {
            d = this._diversionFromDSS ? -1.0 * tSRecord.getValue(n) : tSRecord.getValue(n);
        } else {
            throw new WQException("Failed to find local inflow for Water Quality Boundary " + subDomainBoundary.getName() + "Timestep " + n);
        }
        return d;
    }

    private double getInNetworkInflow(SubDomainBoundary subDomainBoundary, int n) {
        double d = 0.0;
        if ((subDomainBoundary = this._inNetworkInflowMap.get(subDomainBoundary)) != null) {
            d = subDomainBoundary.getValue(n);
        }
        return d;
    }

    private double getOutflow(SubDomainBoundary object, int n) throws WQException {
        double d = 0.0;
        TSRecord tSRecord2 = this._outflowMap.get(object);
        if (tSRecord2 != null) {
            for (TSRecord tSRecord2 : tSRecord2) {
                d += tSRecord2.getValue(n);
            }
        } else {
            throw new WQException("Failed to find outflow for Water Quality Boundary " + object.getName() + "Timestep " + n);
        }
        return d;
    }

    @Scriptable
    public WQGeoSubDomain getWQSubdomain(Element element) {
        if (this._subDomainList == null) {
            return null;
        }
        for (WQGeoSubDomain wQGeoSubDomain : this._subDomainList) {
            if (wQGeoSubDomain.getElementId() != element.getIndex()) continue;
            return wQGeoSubDomain;
        }
        return null;
    }

    public WQGeoSubDomainBoundary getWQSubdomainBoundaryByName(String string) {
        if (this._subDomainBoundaryList == null) {
            return null;
        }
        for (WQGeoSubDomainBoundary wQGeoSubDomainBoundary : this._subDomainBoundaryList) {
            if (wQGeoSubDomainBoundary.getName() == null || !wQGeoSubDomainBoundary.getName().equals(string)) continue;
            return wQGeoSubDomainBoundary;
        }
        return null;
    }

    @Scriptable
    public WQControlDevice getWQControlDevice(Element element) {
        Object object = element.getTopParent();
        if (object instanceof ReservoirElement && (object = this.getWQSubdomain((Element)object)) != null) {
            object = object.getWqControlDevices();
            object = object.iterator();
            while (object.hasNext()) {
                WQControlDevice wQControlDevice = (WQControlDevice)object.next();
                if (wQControlDevice.getRssReleaseElemId() != element.getIndex()) continue;
                return wQControlDevice;
            }
        }
        return null;
    }

    public WQGeoSubDomain getSubdom(String string) {
        if (this._subDomainList == null) {
            return null;
        }
        for (WQGeoSubDomain wQGeoSubDomain : this._subDomainList) {
            if (!wQGeoSubDomain.getName().equals(string)) continue;
            return wQGeoSubDomain;
        }
        return null;
    }

    public void setHydroForStep(RssSystem object, RssRun rssRun, WQRun wQRun, WQEngineAdapter wQEngineAdapter, WQFlowComputeType wQFlowComputeType, int n) throws WQException {
        List list2 = this.getSubDomainsInExtent();
        for (List list2 : list2) {
            if ((list2 = (WQGeoSubDomain)list2).getType() == SubDomainType.REACH_1D) {
                this.setReachHydroForStep((SubDomain)list2, (RssSystem)object, rssRun, n);
                continue;
            }
            if (list2.getType() != SubDomainType.RESERVOIR_1DV) continue;
            this.setResHydroForStep((SubDomain)list2, (RssSystem)object, rssRun, wQRun, wQEngineAdapter, wQFlowComputeType, n);
        }
        List list3 = this.getBoundariesInExtent();
        object = list3.iterator();
        while (object.hasNext()) {
            rssRun = (SubDomainBoundary)object.next();
            list2 = (WQGeoSubDomainBoundary)rssRun;
            this.setBoundaryFlowsForStep((WQGeoSubDomainBoundary)list2, n);
        }
    }

    private void setReachHydroForStep(SubDomain subDomain, RssSystem object, RssRun rssRun, int n) throws WQException {
        int n2 = rssRun.getAlternative().getWaterQualityOptions().getCoupledFlowWQCompute();
        WQReachHydro wQReachHydro = subDomain.getReachHydro();
        object = ((RssSystem)object).findReach(subDomain.getName());
        Function function = ((Element)object).getFunction();
        function = (Routing)function;
        Object object2 = ((Element)object).getNode(0);
        object = ((Element)object).getNode(1);
        object2 = ((RssNode)object2).getTSRecordProxy(0);
        TSDataSet tSDataSet = rssRun.getRegOutputTSData();
        object2 = tSDataSet.getTSRecord(object2.getName(), 0);
        double[] dArray = object2.getTSArray();
        object2 = dArray;
        double cfr_ignored_0 = dArray[n - 1];
        Object object3 = object2[n];
        object2 = ((RssNode)object).getTSRecordProxy(0);
        object2 = tSDataSet.getTSRecord(object2.getName(), 0);
        double[] dArray2 = object2.getTSArray();
        object = dArray2;
        double d = dArray2[n];
        object = n2 != 0 ? (Object)((Routing)function).getSubreachFlowArray((double)object3, d, n) : (Object)new double[]{(double)object3, d};
        wQReachHydro.setSubreachFlow((double[])object);
        object = wQReachHydro.interpolateHydro((double[])object);
        for (n = 0; n < subDomain.getNumFacesInternal(); ++n) {
            wQReachHydro.setFlowFace(n, (double)object[n + 1]);
        }
        for (n = 0; n < subDomain.getNumFacesFlow(); ++n) {
            n2 = subDomain.getNumFacesInternal() + n;
            if (n == 0) {
                wQReachHydro.setFlowFace(n2, (double)object3);
                continue;
            }
            wQReachHydro.setFlowFace(n2, d);
        }
        this.setReachHydraulicProperties(subDomain);
        this.updateCellVolumes((double[])object, wQReachHydro, rssRun);
    }

    public void updateCellVolumes(double[] dArray, WQReachHydro wQReachHydro, RssRun rssRun) {
        double[] dArray2 = wQReachHydro.getCellVol();
        double d = rssRun.getRunTimeWindow().getTimeStepSeconds();
        int n = dArray2.length;
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            double d2 = (dArray[i] - dArray[i + 1]) * d;
            dArray3[i] = dArray2[i] + d2;
        }
        wQReachHydro.setCellVol(dArray3);
    }

    public double[] distributeHydro(double d, double d2, WQRoutingTable object, RssRun object2, WQReachHydro wQReachHydro) {
        double d3 = ((RssRun)object2).getRunTimeWindow().getTimeStepSeconds();
        double d4 = (d - d2) * d3;
        double[] dArray = wQReachHydro.getCellVol();
        int n = dArray.length;
        double d5 = Arrays.stream(dArray).sum();
        double d6 = d5 + d4;
        object = ((WQRoutingTable)object).getCellVolsForTotalVol(d6);
        double[] dArray2 = new double[n + 1];
        object2 = dArray2;
        dArray2[0] = d;
        for (int i = 0; i < n; ++i) {
            object2[i + 1] = object2[i] - (object[i] - dArray[i]) / d3;
        }
        return object2;
    }

    private void setResHydroForStep(SubDomain subDomain, RssSystem rssSystem, RssRun rssRun, WQRun wQRun, WQEngineAdapter wQEngineAdapter, WQFlowComputeType object, int n) throws WQException {
        int n2;
        int n3;
        wQRun = rssRun.getRegOutputTSData();
        object = rssSystem.findReservoir(subDomain.getName());
        WQResHydro wQResHydro = subDomain.getResHydro();
        double d = this.getSeepage(n, (TSDataSet)wQRun, (ReservoirElement)object);
        wQResHydro.setSeepage(d);
        double d2 = this.getEvapPrecip(n, (TSDataSet)wQRun, (ReservoirElement)object);
        wQResHydro.setEvapPrecip(d2);
        double d3 = this.getStorage(n, (TSDataSet)wQRun, (ReservoirElement)object);
        double d4 = this.getElev(n, (TSDataSet)wQRun, (ReservoirElement)object);
        wQResHydro.setStorage(d3);
        int[] nArray = subDomain.getArrayFlowFaceBoundaryIdx();
        int n4 = nArray.length;
        double[] dArray = new double[n4];
        Arrays.fill(dArray, 0.0);
        for (int i = 0; i < n4; ++i) {
            int n5 = nArray[i];
            WQGeoSubDomainBoundary wQGeoSubDomainBoundary = this.getBoundary(n5);
            if (wQGeoSubDomainBoundary == null) continue;
            if (wQGeoSubDomainBoundary.getBoundaryType() == BoundaryType.LOCAL_INFLOW) {
                dArray[i] = this.getLocalInflow((SubDomainBoundary)wQGeoSubDomainBoundary, n);
                continue;
            }
            if (wQGeoSubDomainBoundary.isInflow(subDomain)) {
                dArray[i] = this.getInNetworkInflow((SubDomainBoundary)wQGeoSubDomainBoundary, n);
                continue;
            }
            int n6 = wQGeoSubDomainBoundary.getJnctId();
            List list = ((ReservoirElement)object).getReservoirOutletElements(null);
            for (int j = 0; j < list.size(); ++j) {
                ReservoirOutletElement reservoirOutletElement;
                if (list.get(j) instanceof ReservoirDamElement) {
                    reservoirOutletElement = (ReservoirDamElement)list.get(j);
                    if (((ReservoirDamElement)reservoirOutletElement).getTailwaterElement().getDownstreamNode().getDownstreamElement().getIndex() != n6) continue;
                    Object object2 = ((ReservoirDamElement)reservoirOutletElement).getTailwaterElement().getDownstreamNode().getTSRecordProxy(0);
                    object2 = wQRun.getTSRecord(object2.getName(), 0);
                    object2 = object2.getTSArray();
                    dArray[i] = dArray[i] + object2[n];
                    continue;
                }
                if (!(list.get(j) instanceof DivertedOutletElement)) continue;
                reservoirOutletElement = (DivertedOutletElement)list.get(j);
                Object object3 = reservoirOutletElement.getDownstreamNode();
                n3 = object3 != null && ((RssNode)object3).getDownstreamElement().getIndex() == n6 ? 1 : 0;
                int n7 = n2 = object3 == null && wQGeoSubDomainBoundary.getDownstreamSubDomainId() == -2 && reservoirOutletElement.getIndex() == n6 ? 1 : 0;
                if (n3 == 0 && n2 == 0) continue;
                object3 = ((DivertedOutletElement)reservoirOutletElement).getTailNode().getTSRecordProxy(0);
                object3 = wQRun.getTSRecord(object3.getName(), 0);
                object3 = object3.getTSArray();
                dArray[i] = dArray[i] + object3[n];
            }
        }
        wQResHydro.setFlows(dArray);
        ArrayList<Double> arrayList = this.getReservoirOutletFlows((ReservoirElement)object, (TSDataSet)wQRun, n);
        wQResHydro.setOutletFlows(arrayList);
        List list = subDomain.getWqControlDevices();
        if (list != null) {
            for (WQControlDevice wQControlDevice : list) {
                int n8 = this.getTCDTotalOutletIdx(wQControlDevice, (WQGeoSubDomain)subDomain);
                double d5 = arrayList.get(n8);
                double[] dArray2 = wQEngineAdapter.getWQCDInletLevels(subDomain, wQControlDevice);
                n3 = dArray2.length;
                n2 = 0;
                for (double d6 : dArray2) {
                    if (!(d4 > d6)) continue;
                    ++n2;
                }
                if (n <= rssRun.getRunTimeWindow().getNumLookbackSteps() + 1) {
                    dArray2 = wQControlDevice.evenlyDistributeFlows(d5, n3, n2);
                    wQResHydro.setTCDFlows(dArray2, wQControlDevice.getId());
                    continue;
                }
                boolean bl = rssRun.isCoupledWQCompute();
                int n9 = wQControlDevice.getRssReleaseElemId();
                Element element = rssSystem.getElement(n9);
                if (element == null) {
                    throw new WQException("Release element not found for Water Quality Control Device on reservoir " + object.getName() + ". Release elem id: " + n9);
                }
                if (bl) {
                    double d7;
                    double d6;
                    d6 = wQResHydro.getTotalTCDFlowRatios(wQControlDevice.getId());
                    if (Math.abs(d7 - 1.0) > 0.01 && d5 > 0.1) {
                        rssRun.printWarningMessage("Script-calculated WQCD flow ratios at " + subDomain.getName() + " don't account for all flow. Using evenly distributed flows.");
                        rssRun.printWarningMessage("Release element: " + element.getDisplayName());
                        rssRun.printWarningMessage("Sum of WQCD Flow Ratios: " + d6);
                        RssRun rssRun2 = rssRun;
                        rssRun2.printWarningMessage("Time: " + rssRun2.getRunTimeWindow().getTimeAtStep(n).toString());
                        double[] dArray3 = wQControlDevice.evenlyDistributeFlows(d5, n3, n2);
                        wQResHydro.setTCDFlows(dArray3, wQControlDevice.getId());
                        if (!(element.getWaterControlDevice() instanceof GatedIntakeControlDevice)) continue;
                        ((GatedIntakeControlDevice)element.getWaterControlDevice()).setFlows(n, dArray3);
                        continue;
                    }
                    wQResHydro.setTCDFlowFromRatios(d5, wQControlDevice.getId());
                    double[] dArray4 = wQResHydro.getTCDFlows(wQControlDevice.getId());
                    if (!(element.getWaterControlDevice() instanceof GatedIntakeControlDevice)) continue;
                    ((GatedIntakeControlDevice)element.getWaterControlDevice()).setFlows(n, dArray4);
                    continue;
                }
                rssRun.printWarningMessage("WQ Rules in post-process WQ compute not supported yet. Reservoir: " + object.getName() + ". Using evenly distributed flows.");
                double[] dArray5 = wQControlDevice.evenlyDistributeFlows(d5, n3, n2);
                wQResHydro.setTCDFlows(dArray5, wQControlDevice.getId());
            }
        }
    }

    private ArrayList<Double> getReservoirOutletFlows(ReservoirElement object, TSDataSet tSDataSet, int n) {
        object = ((ReservoirElement)object).getReservoirOutletElements(null);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < object.size(); ++i) {
            Object object2 = (Element)object.get(i);
            object2 = ((Element)object2).getElementVector();
            this.getReservoirOutletFlows((Vector)object2, tSDataSet, n, arrayList);
        }
        return arrayList;
    }

    private void getReservoirOutletFlows(Vector vector, TSDataSet tSDataSet, int n, ArrayList<Double> arrayList) {
        for (int i = 0; i < vector.size(); ++i) {
            Object object = (Element)vector.get(i);
            RssNode rssNode = ((Element)object).getDownstreamNode();
            Function function = ((Element)object).getFunction();
            if (function instanceof Spillway || function instanceof AdjustableFlow) {
                object = rssNode.getTSRecordProxy(0);
                object = tSDataSet.getTSRecord(object.getName(), 0);
                object = object.getTSArray();
                arrayList.add((double)object[n]);
                continue;
            }
            if (!(object instanceof OutletGroupElement)) continue;
            object = ((Element)object).getElementVector();
            this.getReservoirOutletFlows((Vector)object, tSDataSet, n, arrayList);
        }
    }

    private int getTCDTotalOutletIdx(WQControlDevice wQControlDevice, WQGeoSubDomain object) {
        object = object.getResReleaseElemId();
        int n = wQControlDevice.getRssReleaseElemId();
        int n2 = 0;
        boolean bl = false;
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (List)object.next();
            object2 = object2.iterator();
            while (object2.hasNext()) {
                int n3 = (Integer)object2.next();
                if (n3 == n) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) continue;
        }
        return n2;
    }

    private void setBoundaryFlowsForStep(WQGeoSubDomainBoundary wQGeoSubDomainBoundary, int n) throws WQException {
        switch (wQGeoSubDomainBoundary.getBoundaryType()) {
            case LOCAL_INFLOW: {
                double d = this.getLocalInflow((SubDomainBoundary)wQGeoSubDomainBoundary, n);
                wQGeoSubDomainBoundary.setSavedFlow(d);
                return;
            }
            case LOCAL_DIVERSION: {
                double d = this.getLocalDiversion((SubDomainBoundary)wQGeoSubDomainBoundary, n);
                wQGeoSubDomainBoundary.setSavedFlow(d);
                return;
            }
            case RIVER_OUTFLOW: 
            case RESERVOIR_OUTFLOW: {
                double d = this.getOutflow((SubDomainBoundary)wQGeoSubDomainBoundary, n);
                wQGeoSubDomainBoundary.setSavedFlow(d);
                return;
            }
            case RESERVOIR_INFLOW_IN_NETWORK: 
            case RIVER_INFLOW_IN_NETWORK: {
                double d = this.getInNetworkInflow((SubDomainBoundary)wQGeoSubDomainBoundary, n);
                wQGeoSubDomainBoundary.setSavedFlow(d);
            }
        }
    }

    private double getStorage(int n, TSDataSet object, ReservoirElement reservoirElement) {
        reservoirElement = reservoirElement.getStorageFunction().getTSRecordProxy(11);
        object = object.getTSRecord(reservoirElement.getName(), 11);
        double[] dArray = object.getTSArray();
        object = dArray;
        return dArray[n];
    }

    private double getElev(int n, TSDataSet object, ReservoirElement reservoirElement) {
        reservoirElement = reservoirElement.getStorageFunction().getTSRecordProxy(10);
        object = object.getTSRecord(reservoirElement.getName(), 10);
        double[] dArray = object.getTSArray();
        object = dArray;
        return dArray[n];
    }

    private double getEvapPrecip(int n, TSDataSet object, ReservoirElement reservoirElement) {
        double d = 0.0;
        if (reservoirElement.getStorageFunction().getEvapType() != -1 && (object = object.getTSRecord((reservoirElement = reservoirElement.getStorageFunction().getTSRecordProxy(17)).getName(), 17)) != null) {
            double[] dArray = object.getTSArray();
            object = dArray;
            d = dArray[n];
            if (d == -3.4028234663852886E38) {
                d = 0.0;
            }
        }
        return d;
    }

    public void setReachLengthDefinition(ReachCellLengthDefinition reachCellLengthDefinition) {
        this._reachLengthDefinition = reachCellLengthDefinition;
    }

    public void setReservoirHeightDefinition(ReservoirLayerHeightDefinition reservoirLayerHeightDefinition) {
        this._reservoirHeightDefinition = reservoirLayerHeightDefinition;
    }

    public void applyReservoirHeightDefinition(RssSystem rssSystem) throws WQException {
        Object object = this.getSubDomainsInExtent();
        switch (this._reservoirHeightDefinition.getType()) {
            case Global: {
                Double d = this._reservoirHeightDefinition.getGlobalHeight();
                if (d == null) break;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    object = (SubDomain)iterator.next();
                    if (!object.getType().equals((Object)SubDomainType.RESERVOIR_1DV)) continue;
                    Element element = rssSystem.getElement(object.getElementId());
                    ReservoirElement reservoirElement = (ReservoirElement)element;
                    WQGeoSubDomain wQGeoSubDomain = (WQGeoSubDomain)object;
                    double d2 = RssWQGeometry.getReservoirMinElevation(reservoirElement);
                    double d3 = RssWQGeometry.getReservoirMaxElevation(reservoirElement);
                    double d4 = d3 - d2;
                    wQGeoSubDomain.discretizeReservoir(d.doubleValue(), d4);
                    this.updateCellCenters(wQGeoSubDomain, reservoirElement, d2, d3);
                    this.associateBoundaries(wQGeoSubDomain, false);
                }
                return;
            }
            case SubDomain: {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    SubDomain subDomain = (SubDomain)iterator.next();
                    if (!subDomain.getType().equals((Object)SubDomainType.RESERVOIR_1DV)) continue;
                    object = rssSystem.getElement(subDomain.getElementId());
                    ReservoirElement reservoirElement = (ReservoirElement)object;
                    WQGeoSubDomain wQGeoSubDomain = (WQGeoSubDomain)subDomain;
                    double d = RssWQGeometry.getReservoirMinElevation(reservoirElement);
                    double d5 = RssWQGeometry.getReservoirMaxElevation(reservoirElement);
                    Object object2 = this._reservoirHeightDefinition.getSpacingType(wQGeoSubDomain.getRef());
                    if (object2 == ReservoirLayerSpacingType.CONSTANT) {
                        object2 = this._reservoirHeightDefinition.getConstantHeight(wQGeoSubDomain.getRef());
                        if (object2 == null) continue;
                        double d6 = d5 - d;
                        wQGeoSubDomain.discretizeReservoir(((Double)object2).doubleValue(), d6);
                        this.updateCellCenters(wQGeoSubDomain, reservoirElement, d, d5);
                        this.associateBoundaries(wQGeoSubDomain, false);
                        continue;
                    }
                    object2 = this._reservoirHeightDefinition.getVariableHeights(wQGeoSubDomain.getRef());
                    if (object2 != null) {
                        wQGeoSubDomain.discretizeReservoir((List)object2, d, d5);
                        this.updateCellCenters(wQGeoSubDomain, reservoirElement, d, d5);
                        this.associateBoundaries(wQGeoSubDomain, false);
                        continue;
                    }
                    throw new WQException("Variable reservoir layer elevations missing for subdomain " + subDomain.getName());
                }
                break;
            }
        }
    }

    private void updateCellCenters(WQGeoSubDomain wQGeoSubDomain, ReservoirElement object, double d, double d2) {
        Object object2 = ((Element)object).getUpstreamNodes(null);
        object = ((Element)object).getDownstreamNodes(null);
        object2 = object2.get(0);
        object = (RssNode)object.get(0);
        object2 = ((RssNode)object2).getLocation();
        object = ((RssNode)object).getLocation();
        wQGeoSubDomain.createCellCenters(((WorldPt)object2).e, ((WorldPt)object2).n, ((WorldPt)object).e, ((WorldPt)object).n, d, d2);
    }

    private double getSeepage(int n, TSDataSet object, ReservoirElement reservoirElement) {
        double d = 0.0;
        if (reservoirElement.getStorageFunction().getSeepageType() != -1 && (object = object.getTSRecord((reservoirElement = reservoirElement.getStorageFunction().getTSRecordProxy(19)).getName(), 19)) != null) {
            double[] dArray = object.getTSArray();
            object = dArray;
            d = dArray[n];
            if (d == -3.4028234663852886E38) {
                d = 0.0;
            }
        }
        return d;
    }

    public ReachCellLengthDefinition getReachLengthDefinition() {
        return this._reachLengthDefinition;
    }

    public ReservoirLayerHeightDefinition getReservoirHeightDefinition() {
        return this._reservoirHeightDefinition;
    }

    public void setConnectionSet(ConnectionSet connectionSet) {
        this._connectionSet = connectionSet;
    }

    public ConnectionSet getConnectionSet() {
        return this._connectionSet;
    }

    public Map<JunctionElement, List<SubDomainBoundary>> getBoundariesForBCEd(RssSystem rssSystem) {
        HashMap<JunctionElement, List<SubDomainBoundary>> hashMap = new HashMap<JunctionElement, List<SubDomainBoundary>>();
        if (this._subDomainBoundaryList != null) {
            for (WQGeoSubDomainBoundary wQGeoSubDomainBoundary : this._subDomainBoundaryList) {
                Object object;
                if (!wQGeoSubDomainBoundary.isInflow() || !wQGeoSubDomainBoundary.getInExtent() || (object = this.getJunctionElement(rssSystem, (SubDomainBoundary)wQGeoSubDomainBoundary)) == null) continue;
                object = hashMap.computeIfAbsent((JunctionElement)object, junctionElement -> new ArrayList());
                object.add(wQGeoSubDomainBoundary);
            }
        }
        return hashMap;
    }

    public int findCellForStreamStation(SubDomain subDomain, double d) {
        int n = 0;
        if (subDomain.getType() != SubDomainType.REACH_1D) {
            return 0;
        }
        double d2 = subDomain.getUpstreamStation();
        double d3 = subDomain.getDownstreamStation();
        double d4 = (d - d3) / (d2 - d3);
        d4 = Math.min(d4, 1.0);
        d4 = Math.max(d4, 0.0);
        double[] dArray = subDomain.getXFace();
        int n2 = subDomain.getNumCells();
        for (int i = 0; i < n2; ++i) {
            double d5;
            double d6 = 1.0 - dArray[i + 1];
            if (!(d5 >= d4)) continue;
            n = i;
            break;
        }
        return n;
    }

    public void interpolateICSet(RssSystem rssSystem, List<SubDomainBoundary> list, InitialConditionSet initialConditionSet, WQConstituentSet object, BoundaryConditionSet object2, RunTimeWindow runTimeWindow) {
        Object object3;
        Object object4;
        Map<SubDomainBoundaryRef, SubDomainBoundary> map;
        Object object5;
        if (rssSystem == null || list == null || initialConditionSet == null || object == null || object2 == null || runTimeWindow == null) {
            return;
        }
        object = object.getConstituentList();
        Object object6 = runTimeWindow.getStartTime();
        runTimeWindow = runTimeWindow.getEndTime();
        HashMap<Integer, Map<SubDomainBoundaryRef, SubDomainBoundary>> hashMap = new HashMap<Integer, Map<SubDomainBoundaryRef, SubDomainBoundary>>();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object5 = (Constituent)iterator.next();
            map = new HashMap();
            for (SubDomainBoundary subDomainBoundary : list) {
                object4 = subDomainBoundary.getRef();
                object3 = initialConditionSet.getCondition((SubDomainBoundaryRef)object4, object5.getId());
                if (object3 == null) continue;
                boolean bl = (object3 = object3.getOverride()) == null && (object3 = RssWQGeometry.a((BoundaryCondition)(subDomainBoundary = (BoundaryCondition)object2.getBoundaryConditions().stream().filter(arg_0 -> RssWQGeometry.a((Constituent)object5, subDomainBoundary, arg_0)).findFirst().orElse(null)), object6, (HecTime)runTimeWindow)) == null;
                subDomainBoundary = new InterpICValue((Double)object3, bl);
                map.put((SubDomainBoundaryRef)object4, subDomainBoundary);
            }
            hashMap.put(object5.getId(), map);
        }
        iterator = object.iterator();
        while (iterator.hasNext()) {
            object5 = (Constituent)iterator.next();
            map = (Map)hashMap.get(object5.getId());
            for (SubDomainBoundary subDomainBoundary : list) {
                Element element;
                InterpICValue interpICValue;
                Object object72;
                object4 = subDomainBoundary.getRef();
                object3 = (InterpICValue)map.get(object4);
                if (object3 == null || !object3.isInterp()) continue;
                int n = subDomainBoundary.getJnctId();
                object = rssSystem.getElement(n);
                object2 = new ArrayList();
                if (object instanceof JunctionElement) {
                    object2 = rssSystem.getDownstreamElements((Element)object);
                }
                int n2 = -1;
                object6 = null;
                n = 0;
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    object5 = (Element)object2.next();
                    if (object5 instanceof JunctionElement) {
                        for (Object object72 : list) {
                            if (object72.getJnctId() != object5.getIndex() || (interpICValue = (InterpICValue)map.get(element = object72.getRef())) == null || interpICValue.isInterp()) continue;
                            object6 = interpICValue.getValue();
                            n2 = object5.getIndex();
                            n = 1;
                            break;
                        }
                    } else if (object5 instanceof ReservoirElement) break;
                    if (n == 0) continue;
                }
                int n3 = -1;
                object5 = null;
                n = 0;
                object4 = new ArrayList();
                if (object instanceof JunctionElement) {
                    object4 = rssSystem.getUpstreamElements((Element)object);
                }
                object72 = object4.iterator();
                while (object72.hasNext()) {
                    element = (Element)object72.next();
                    if (element instanceof JunctionElement) {
                        interpICValue = list.iterator();
                        while (interpICValue.hasNext()) {
                            object = (SubDomainBoundary)interpICValue.next();
                            if (object.getJnctId() != element.getIndex()) continue;
                            object = object.getRef();
                            if ((object = (InterpICValue)map.get(object)) == null || object.isInterp()) continue;
                            object5 = object.getValue();
                            n3 = element.getIndex();
                            n = 1;
                            break;
                        }
                    } else if (element instanceof ReservoirElement) break;
                    if (n == 0) continue;
                }
                if (n3 > 0 && n2 > 0) {
                    object72 = ((Double)object5 + object6.doubleValue()) / 2.0;
                    object3.setValue((Double)object72);
                    continue;
                }
                if (n3 > 0) {
                    object3.setValue((Double)object5);
                    continue;
                }
                if (n2 <= 0) continue;
                object3.setValue((Double)object6);
            }
        }
        initialConditionSet.setInterpolatedJunctionICMap(hashMap);
    }

    private static Double a(BoundaryCondition boundaryCondition, HecTime object, HecTime hecTime) {
        if (boundaryCondition != null) {
            Object object2 = boundaryCondition.getSelectedDataSource();
            if ((object2 = DataSourceFactory.a((Data)object2)) instanceof TimeSeriesDataSource) {
                object2 = (TimeSeriesDataSource)object2;
                ParameterMap parameterMap = new ParameterMap();
                object = new TimeWindow(object.getJavaDate(0), true, hecTime.getJavaDate(0), true);
                parameterMap.a(TimeSeriesDataSource.TIME_WINDOW_PARAMETER, object);
                object = object2.getTimeSeries(parameterMap);
                if (object != null && !object.isEmpty() && (object = (TimeSeriesContainer)object.get(0)) != null && ((TimeSeriesContainer)object).numberValues > 0) {
                    double d = ((TimeSeriesContainer)object).values[0];
                    if (boundaryCondition.getConstituentId() == 1) {
                        try {
                            d = UnitUtil.convertUnits((double)((TimeSeriesContainer)object).values[0], (String)((TimeSeriesContainer)object).units, (String)"deg C");
                        }
                        catch (UnitsConversionException unitsConversionException) {
                            LOGGER.log(Level.WARNING, "Cannot convert units for time series data: " + ((TimeSeriesContainer)object).fullName + " from " + ((TimeSeriesContainer)object).units + " to deg C");
                        }
                    }
                    return d;
                }
            }
        }
        return null;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public WQConsistencyCheck checkRssSystemConsistency(RssSystem var1_1) {
        var2_2 = "ResSim Network: " + var1_1.getName();
        var2_2 = new WQConsistencyCheck(var2_2);
        var3_3 = this.getSubDomainsInExtent();
        for (Object var6_8 : var3_3) {
            if (var6_8.getType() != SubDomainType.RESERVOIR_1DV) continue;
            var4_6 = var6_8.getElementId();
            var4_5 = (ReservoirElement)var1_1.getElement(var4_6);
            if (var4_5 == null) {
                var7_9 = "Reservoir: " + var6_8.getName() + " not found in ResSim system";
                var2_2.addErrorMessage((String)var7_9);
                continue;
            }
            if (var4_5.getStorageFunction() == null) {
                var7_9 = "Reservoir: " + var4_5.getName() + " is missing Storage Function data";
                var2_2.addErrorMessage((String)var7_9);
                continue;
            }
            var7_9 = var4_5.getStorageFunction().getElevationAreaValues();
            var8_10 = this.checkAreaPairedData((PairedValues)var7_9);
            if (var7_9.getPairCount() == 0 || var8_10 != 0) {
                var6_8 = WqI18n.a("RssWQGeom.StorageElevAreaData.Msg").format((Object)var4_5.getDisplayName());
                var2_2.addErrorMessage((String)var6_8);
                continue;
            }
            v0 = var6_8.getElevAreaData();
            var6_8 = v0;
            if (v0.length > 0) {
                var8_10 = ((Duration)var6_8[0]).length;
                for (var13_16 = 0; var13_16 < var8_10; ++var13_16) {
                    if (!(var6_8[1][var13_16] < -0.1)) continue;
                    var14_18 = "Reservoir: " + var4_5.getName() + " does not have pool area data incorporated into the WQ geometry. Use the Update From Network button in the WQ Geometry";
                    var2_2.addErrorMessage(var14_18);
                    break;
                }
            }
            var8_11 = this.getReservoirOutletElevations(var4_5);
            var13_15 = RssWQGeometry.getReservoirMinElevation(var4_5);
            var15_19 = RssWQGeometry.getReservoirMaxElevation(var4_5);
            for (Iterator<List<Double>> var7_9 : var8_11) {
                var8_11 = var7_9.iterator();
                while (var8_11.hasNext()) {
                    var9_13 = (Double)var8_11.next();
                    if (v1 < var13_15) {
                        var10_14 = "Reservoir: " + var4_5.getName() + " has outlet below minimum reservoir elevation. Minimum res elevation used.";
                        var2_2.addWarningMessage((String)var10_14);
                        continue;
                    }
                    if (!(var9_13 > var15_19)) continue;
                    var10_14 = "Reservoir: " + var4_5.getName() + " has outlet above maximum reservoir elevation. Max res elevation used.";
                    var2_2.addWarningMessage((String)var10_14);
                }
            }
            var6_8 = this.getReservoirOutletAreas(var4_5);
            var7_9 = var6_8.iterator();
            while (var7_9.hasNext()) {
                var8_11 = var7_9.next();
                for (Object var10_14 : var8_11) {
                    if (!(v2 <= 0.0)) continue;
                    var6_8 = "Reservoir: " + var4_5.getName() + " has outlet area of zero";
                    var2_2.addWarningMessage((String)var6_8);
                }
            }
        }
        for (SubDomain var8_12 : var3_3) {
            block16: {
                block15: {
                    if (var8_12 /* !! */ .getType() != SubDomainType.REACH_1D) continue;
                    var4_7 = var8_12 /* !! */ .getElementId();
                    var5_4 = (ReachElement)var1_1.getElement(var4_7);
                    if (var5_4 == null) {
                        var6_8 = "Reach: " + var8_12 /* !! */ .getName() + " not found in ResSim system";
                        var2_2.addErrorMessage((String)var6_8);
                        continue;
                    }
                    var6_8 = var5_4.getDefinedTimeStepDurations();
                    if (var6_8 == null) break block15;
                    var8_12 /* !! */  = TimeStepUtil.TIME_STEP_ALL.getDuration();
                    if (!Arrays.stream(var6_8).noneMatch((Predicate<Duration>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, a(java.time.Duration java.time.Duration ), (Ljava/time/Duration;)Z)((Duration)var8_12 /* !! */ ))) ** GOTO lbl76
                    if (((Duration[])var6_8).length > 1) {
                        var6_8 = var5_4.getFunction(var6_8[0], null);
                    } else {
                        var13_17 = "Can't identify routing method for reach: " + var5_4.getName();
                        var2_2.addErrorMessage(var13_17);
                        continue;
lbl76:
                        // 1 sources

                        var6_8 = var5_4.getFunction((Duration)var8_12 /* !! */ , null);
                    }
                    break block16;
                }
                var6_8 = var5_4.getFunction();
            }
            if (var6_8 != null) continue;
            var8_12 /* !! */  = "Can't identify routing method for reach: " + var5_4.getName();
            var2_2.addErrorMessage((String)var8_12 /* !! */ );
        }
        return var2_2;
    }

    public static void main(String[] object) {
        object = "Unable to create default reservoir with the following spacing : Height=%s, Max Cell Height=%s";
        String.format("Unable to create default reservoir with the following spacing : Height=%s, Max Cell Height=%s", 0, 1);
    }

    private static /* synthetic */ boolean a(Duration duration, Duration duration2) {
        return duration2.equals(duration);
    }

    private static /* synthetic */ boolean a(Constituent constituent, SubDomainBoundary subDomainBoundary, BoundaryCondition boundaryCondition) {
        return constituent.getId() == boundaryCondition.getConstituentId() && subDomainBoundary.getJnctId() == boundaryCondition.getBoundaryRef().getJnctId();
    }
}

