/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.waterquality.model;

import hec.heclib.util.HecTime;
import hec.model.RunTimeWindow;
import hec.rss.model.TimeStepUtil;
import hec.wqenginecore.WQTime;
import java.time.Duration;

public class RssWQTime
extends WQTime {
    private int a;

    public void setWQTimeFromRTW(RunTimeWindow runTimeWindow) {
        this._startTime = runTimeWindow.getStartTime().dateAndTime(-13);
        this._endTime = runTimeWindow.getEndTime().dateAndTime(-13);
        this._lookbackTime = runTimeWindow.getLookbackTime().dateAndTime(-13);
        this._deltaTinSec = runTimeWindow.getTimeStepSeconds();
        this._nSteps = runTimeWindow.getForecastSteps();
        this._nLookbackSteps = runTimeWindow.getNumLookbackSteps();
        this._offset = 0;
        this._redoSteps = 0;
    }

    public void setWQTimeStep(int n, int n2) {
        this.a = n2;
        this._wqDeltaTinSec = n != -1 ? (double)(switch (n2) {
            case 3 -> Duration.ofDays(n);
            case 2 -> Duration.ofHours(n);
            case 1 -> Duration.ofMinutes(n);
            default -> TimeStepUtil.TIME_STEP_ALL.getDuration();
        }).getSeconds() : this._deltaTinSec;
        this._wqStepsPerHydroStep = (int)Math.round(this._deltaTinSec / this._wqDeltaTinSec);
    }

    public void setCurrentTimeForStep(int n, int n2) {
        HecTime hecTime = new HecTime(this._startTime);
        n2 = (n += this._offset) * (int)this._deltaTinSec + n2 * (int)this._wqDeltaTinSec;
        hecTime.addSeconds(n2);
        this._currentTime = hecTime.dateAndTime(-13);
        this._currentTimeDays = (double)n2 / 86400.0;
        this._currentStep = n;
    }

    public void setTimeOffset(RunTimeWindow runTimeWindow, RunTimeWindow runTimeWindow2) {
        long l = runTimeWindow.getStartTime().getTimeInMillis() - runTimeWindow2.getStartTime().getTimeInMillis();
        int n = (int)(l / 1000L);
        this._offset = (int)Math.round((double)n / this._deltaTinSec);
        this._nLookbackSteps = runTimeWindow.getNumLookbackSteps();
        if (this._offset > 0) {
            this._redoSteps = this._currentStep - this._offset;
        }
    }
}

