/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.waterquality.model;

import hec.data.Units;
import hec.model.Interpolate;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.wqenginecore.WQException;
import hec.wqenginecore.flowtable.FlowTable;
import hec.wqengineimpl.geometry.WQGeoSubDomain;
import java.util.Arrays;

public class WQRoutingTable {
    private double[][] a;
    private double[] b;
    private double[] c;
    private final RssWQGeometry d;
    private final WQGeoSubDomain e;

    public WQRoutingTable(RssWQGeometry rssWQGeometry, WQGeoSubDomain wQGeoSubDomain) {
        this.d = rssWQGeometry;
        this.e = wQGeoSubDomain;
    }

    public void init() throws WQException {
        Object object;
        WQRoutingTable wQRoutingTable = this;
        FlowTable flowTable = wQRoutingTable.d.getFlowTable();
        double[] dArray = wQRoutingTable.e.getXRAS();
        int n = dArray.length;
        Units units = wQRoutingTable.d.getFlowUnits();
        if (n == 0) {
            object = wQRoutingTable.e.getSingleRASRiver();
            var6_15 = wQRoutingTable.e.getSingleRASReach();
            var7_20 = wQRoutingTable.e.getSingleRASStation();
            wQRoutingTable.b = flowTable.getFlows((String)object, var6_15, var7_20, units);
        } else {
            String[] stringArray = wQRoutingTable.e.getXRASRiver();
            String[] stringArray2 = wQRoutingTable.e.getXRASReach();
            String[] stringArray3 = wQRoutingTable.e.getXRASStation();
            int n2 = n / 2;
            object = stringArray[n2];
            var6_15 = stringArray2[n2];
            var7_20 = stringArray3[n2];
            wQRoutingTable.b = flowTable.getFlows((String)object, var6_15, var7_20, units);
        }
        wQRoutingTable = this;
        int n3 = wQRoutingTable.e.getNumCells();
        dArray = wQRoutingTable.e.getCellLength();
        double[] dArray2 = wQRoutingTable.e.getXRAS();
        object = wQRoutingTable.e.getXFace();
        int n4 = dArray2.length;
        int n5 = ((Object)object).length;
        int n6 = wQRoutingTable.b.length;
        wQRoutingTable.a = new double[n6][n3];
        if (n4 == 0) {
            var21_33 = wQRoutingTable.e.getSingleRASRiver();
            var22_34 = wQRoutingTable.e.getSingleRASReach();
            var23_35 = wQRoutingTable.e.getSingleRASStation();
            for (var19_36 = 0; var19_36 < n6; ++var19_36) {
                double d = wQRoutingTable.d.getRASSteadyFlowXSArea((String)var21_33, (String)var22_34, (String)var23_35, wQRoutingTable.b[var19_36]);
                for (var18_37 = 0; var18_37 < n3; ++var18_37) {
                    double d2;
                    double d3 = dArray[var18_37];
                    wQRoutingTable.a[var19_36][var18_37] = d2 = d3 * d;
                }
            }
        } else {
            for (var19_36 = 0; var19_36 < n4; ++var19_36) {
                dArray2[var19_36] = 1.0 - dArray2[var19_36];
            }
            for (var19_36 = 0; var19_36 < n5; ++var19_36) {
                object[var19_36] = 1.0 - object[var19_36];
            }
            var21_33 = wQRoutingTable.e.getXRASRiver();
            var22_34 = wQRoutingTable.e.getXRASReach();
            var23_35 = wQRoutingTable.e.getXRASStation();
            for (var18_37 = 0; var18_37 < n6; ++var18_37) {
                double d;
                double[] dArray3 = new double[n5];
                for (var19_36 = 0; var19_36 < wQRoutingTable.e.getNumFacesInternal(); ++var19_36) {
                    int n7;
                    Object object2 = object[var19_36 + 1];
                    boolean bl = false;
                    Object object3 = 0.0;
                    for (n7 = 0; n7 < n4; ++n7) {
                        if (!(Math.abs((double)(object2 - dArray2[n7])) < 1.0E-6)) continue;
                        object3 = wQRoutingTable.d.getRASSteadyFlowXSArea(var21_33[n7], var22_34[n7], var23_35[n7], wQRoutingTable.b[var18_37]);
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        int n8 = Interpolate.bisearch((double[])dArray2, (double)object2, (int)n4);
                        if (n8 < 0) {
                            n7 = 0;
                            object3 = wQRoutingTable.d.getRASSteadyFlowXSArea(var21_33[0], var22_34[0], var23_35[0], wQRoutingTable.b[var18_37]);
                        } else if (n8 >= n4 - 1) {
                            n7 = n4 - 1;
                            object3 = wQRoutingTable.d.getRASSteadyFlowXSArea(var21_33[n7], var22_34[n7], var23_35[n7], wQRoutingTable.b[var18_37]);
                        } else {
                            n7 = n8;
                            double d4 = wQRoutingTable.d.getRASSteadyFlowXSArea(var21_33[n7], var22_34[n7], var23_35[n7], wQRoutingTable.b[var18_37]);
                            d = wQRoutingTable.d.getRASSteadyFlowXSArea(var21_33[n7 + 1], var22_34[n7 + 1], var23_35[n7 + 1], wQRoutingTable.b[var18_37]);
                            double d5 = dArray2[n7 + 1] - dArray2[n7];
                            object3 = (object2 - dArray2[n7]) * (d - d4) / d5 + d4;
                        }
                    }
                    FlowTable.checkRASTableValue((double)object3, (String)"flow area", (String)var21_33[n7], (String)var22_34[n7], (String)var23_35[n7]);
                    dArray3[var19_36] = object3;
                }
                var19_36 = wQRoutingTable.e.getNumFacesInternal();
                double d6 = wQRoutingTable.d.getRASSteadyFlowXSArea(var21_33[0], var22_34[0], var23_35[0], wQRoutingTable.b[var18_37]);
                FlowTable.checkRASTableValue((double)d6, (String)"flow area", (String)var21_33[0], (String)var22_34[0], (String)var23_35[0]);
                dArray3[var19_36] = d6;
                d6 = wQRoutingTable.d.getRASSteadyFlowXSArea(var21_33[n4 - 1], var22_34[n4 - 1], var23_35[n4 - 1], wQRoutingTable.b[var18_37]);
                FlowTable.checkRASTableValue((double)d6, (String)"flow area", (String)var21_33[n4 - 1], (String)var22_34[n4 - 1], (String)var23_35[n4 - 1]);
                dArray3[++var19_36] = d6;
                int[][] nArray = wQRoutingTable.e.getCellFaces();
                for (var19_36 = 0; var19_36 < n3; ++var19_36) {
                    double d7;
                    double d8 = dArray[var19_36];
                    double d9 = dArray3[nArray[var19_36][0]];
                    d = dArray3[nArray[var19_36][1]];
                    wQRoutingTable.a[var18_37][var19_36] = d7 = 0.5 * (d9 + d) * d8;
                }
            }
        }
        wQRoutingTable = this;
        n3 = wQRoutingTable.a.length;
        wQRoutingTable.c = new double[n3];
        int n9 = wQRoutingTable.a[0].length;
        for (int i = 0; i < n3; ++i) {
            double d = 0.0;
            for (int j = 0; j < n9; ++j) {
                d += wQRoutingTable.a[i][j];
            }
            wQRoutingTable.c[i] = d;
        }
    }

    public double[] getCellVolsForTotalVol(double d) {
        int n = this.a.length;
        int n2 = this.a[0].length;
        double[] dArray = new double[n2];
        int n3 = Interpolate.bisearch((double[])this.c, (double)d, (int)this.c.length);
        if (n3 < 0) {
            dArray = Arrays.copyOf(this.a[0], n2);
        } else if (n3 >= n - 1) {
            if (n > 1) {
                int n4 = n - 2;
                double d2 = this.c[--n] - this.c[n4];
                double d3 = d - this.c[n];
                double d4 = d3 / d2;
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = d4 * (this.a[n][i] - this.a[n4][i]) + this.a[n][i];
                }
            } else {
                dArray = Arrays.copyOf(this.a[n - 1], n2);
            }
        } else {
            double[] dArray2 = Arrays.copyOf(this.a[n3], n2);
            double[] dArray3 = Arrays.copyOf(this.a[n3 + 1], n2);
            double d5 = this.c[n3 + 1] - this.c[n3];
            for (int i = 0; i < n2; ++i) {
                dArray[i] = (d - this.c[n3]) * (dArray3[i] - dArray2[i]) / d5 + dArray2[i];
            }
        }
        return dArray;
    }

    public double getTotalVolForFlow(double d) {
        double d2;
        int n = this.b.length;
        int n2 = Interpolate.bisearch((double[])this.b, (double)d, (int)this.b.length);
        if (n2 < 0) {
            d2 = this.c[0];
        } else if (n2 >= n - 1) {
            if (n > 1) {
                int n3 = n - 2;
                int n4 = n - 1;
                double d3 = this.b[n4] - this.b[n3];
                double d4 = d - this.b[n4];
                double d5 = d4 / d3;
                d2 = d5 * (this.c[n4] - this.c[n3]) + this.c[n4];
            } else {
                d2 = this.c[n - 1];
            }
        } else {
            double d6 = this.c[n2];
            double d7 = this.c[n2 + 1];
            double d8 = this.b[n2 + 1] - this.b[n2];
            d2 = (d - this.b[n2]) * (d7 - d6) / d8 + d6;
        }
        return d2;
    }
}

