/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.waterquality.testapp;

import hec.clientapp.model.SimulationPeriod;
import hec.clientapp.model.SimulationRun;
import hec.clientapp.server.RmiAppImpl;
import hec.io.Identifier;
import hec.rss.RssRmiWorkspace;
import hec.rss.model.RssSimRun;
import hec.util.AlternativeEntry;
import hec.util.SimTestConfigFile;
import hec.util.SimulationEntry;
import hec.util.WatershedEntry;
import java.io.File;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;

public class WQTestApp {
    public static void main(String[] object) {
        object = "J:\\work_2023\\USBR_temperature_modeling\\testing_watersheds\\TestSimulations.xml";
        WQTestApp wQTestApp = new WQTestApp();
        File file = new File((String)object);
        if (file.exists()) {
            wQTestApp.runTestScript((String)object);
        }
    }

    public void runTestScript(String iterator) {
        String string = "testuser";
        Object object = "WQTest running Test Script: " + (String)((Object)iterator);
        System.out.println((String)object);
        RmiAppImpl rmiAppImpl = RmiAppImpl.getApp();
        RmiFileManager rmiFileManager = rmiAppImpl.getFileManager();
        SimTestConfigFile simTestConfigFile = new SimTestConfigFile((String)((Object)iterator));
        if (simTestConfigFile.loadFile()) {
            iterator = simTestConfigFile.getWatersheds();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                simTestConfigFile = (WatershedEntry)iterator.next();
                object = "Opening watershed " + simTestConfigFile.getPath();
                System.out.println((String)object);
                Object object2 = new Identifier(simTestConfigFile.getPath());
                try {
                    object2 = rmiFileManager.openFile(string, object2);
                    object2 = rmiAppImpl.openWorkspace(string, object2, null, null);
                    if (object2 == null) {
                        object = "ERROR: Failed to open Watershed " + simTestConfigFile.getPath();
                        System.out.println((String)object);
                        continue;
                    }
                    object = "Watershed: " + object2.getTitleName() + "\n";
                    System.out.println((String)object);
                    RssRmiWorkspace rssRmiWorkspace = (RssRmiWorkspace)object2.getChildWorkspace("rss");
                    Object object3 = simTestConfigFile.getSimulations();
                    object = "Number of Simulations: " + object3.size();
                    System.out.println((String)object);
                    object3 = object3.iterator();
                    while (object3.hasNext()) {
                        Object object4 = (SimulationEntry)object3.next();
                        Identifier identifier = new Identifier(object4.getPath());
                        identifier = (SimulationPeriod)rssRmiWorkspace.getManager(SimulationPeriod.class.getName(), identifier);
                        if (identifier == null) {
                            object = "ERROR: Failed to load Simulation " + object4.getPath();
                            System.out.println((String)object);
                            continue;
                        }
                        identifier.loadWorkspace(null, simTestConfigFile.getBaseDirectory());
                        object = "\tSimulation:" + identifier.getName() + "\n";
                        System.out.println((String)object);
                        object4 = object4.getAlternatives();
                        object4 = object4.iterator();
                        while (object4.hasNext()) {
                            AlternativeEntry alternativeEntry = (AlternativeEntry)object4.next();
                            object = "Running alternative " + alternativeEntry.getName();
                            System.out.println((String)object);
                            object = identifier.getSimulationRun(alternativeEntry.getName());
                            if (object == null) {
                                object = "\t\tAlternative:" + alternativeEntry.getName() + "\tfailed to compute\n";
                                System.out.println((String)object);
                                object = "ERROR: Failed to find SimulationRun " + alternativeEntry.getName();
                                System.out.println((String)object);
                                continue;
                            }
                            if (!(object instanceof RssSimRun)) {
                                object = "\t\tAlternative:" + alternativeEntry.getName() + "\tfailed to compute\n";
                                System.out.println((String)object);
                                object = "ERROR: SimulationRun " + alternativeEntry.getName() + " is not an instance of RssSimRun";
                                System.out.println((String)object);
                                continue;
                            }
                            identifier.setComputeAll(true);
                            if (identifier.computeRun((SimulationRun)object, -1)) {
                                object = "Computed successfully";
                                System.out.println((String)object);
                                continue;
                            }
                            object = "ERROR: failed to compute";
                            System.out.println((String)object);
                        }
                    }
                    object2.closeWorkspace(string);
                }
                catch (Exception exception) {
                    object2 = exception;
                    object = exception.toString();
                    System.out.println((String)object);
                }
            }
            return;
        }
        object = "Failed to load Test Script " + (String)((Object)iterator);
        System.out.println((String)object);
    }
}

