/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.script;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.clientapp.client.ClientWorkspace;
import hec.io.Identifier;
import hec.lang.ClientAppCheck;
import hec.script.ScriptManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.rmi.RemoteException;
import mil.army.usace.hec.rmi.csinterface.RMIScheduler;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.util.RMAIO;

public class ClientAppWrapper {
    protected ClientAppWrapper() {
    }

    public static ClientWorkspace openWatershed(String string) {
        Object object;
        if (!ClientAppCheck.haveClientApp()) {
            System.out.println("openWatershed: functionality not available outside of the CWMS environment");
            return null;
        }
        if (string == null) {
            System.out.println("openWatershed:no Watershed file specified.");
            return null;
        }
        if (ClientApp.app() == null) {
            System.out.println("openWatershed:no ClientApp");
            return null;
        }
        RmiFileManager cfr_ignored_0 = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        if (!RMAIO.isFullPath((String)string)) {
            string = RMAIO.userNameToFileName((String)string);
            object = new StringBuffer(ClientApp.app().getAppStartDir());
            ((StringBuffer)object).append("/");
            ((StringBuffer)object).append("base");
            ((StringBuffer)object).append("/");
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append("/");
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append(".wksp");
            string = ((StringBuffer)object).toString();
        }
        System.out.println("openWatershed:opening workspace file " + string);
        object = new Identifier(string);
        try {
            string = ((RmiFileManager)ClientApp.app().getFileManager().getRemote()).openFile(ClientApp.app().getUser(), (Identifier)object);
        }
        catch (RemoteException remoteException) {
            System.out.println("openWatershed:rmi error opening file " + object.getPath() + " " + String.valueOf(remoteException));
            return null;
        }
        if (string == null) {
            System.out.println("openWatershed:failed to open watershed file " + object.getPath());
            return null;
        }
        Object object2 = string.getFile();
        object = object2.getBufferedReader();
        System.out.println("openWatershed:creating Identifier for " + object2.getPath());
        try {
            object2 = ((BufferedReader)object).readLine();
            while (object2 != null) {
                object2 = ((String)object2).trim();
                String string2 = RMAIO.getType((String)object2, (String)"=");
                object2 = RMAIO.getParam((String)object2, (String)"=");
                if (string2.compareTo("WorkspaceName") == 0) {
                    string.setName((String)object2);
                } else if (string2.compareTo("WorkspaceDescription") == 0) {
                    string.setDescription((String)object2);
                }
                object2 = ((BufferedReader)object).readLine();
            }
            ((BufferedReader)object).close();
        }
        catch (Exception exception) {
            System.out.println("openWatershed:Error Reading File  " + String.valueOf(exception));
            exception.printStackTrace();
            return null;
        }
        boolean bl = false;
        try {
            bl = ClientApp.app().openWorkspace((Identifier)string, true);
        }
        catch (Exception exception) {
            System.out.println("openWatershed:exception opening watershed " + String.valueOf(exception));
        }
        if (!bl) {
            System.out.println("openWatershed:ClientApp.openWorkspace returned false");
        }
        return ClientApp.Workspace();
    }

    public static boolean isWatershedOpened() {
        if (!ClientAppCheck.haveClientApp()) {
            System.out.println("isWatershedOpened: functionality not available outside of the CWMS environment");
            return false;
        }
        return ClientApp.Workspace() != null;
    }

    public static boolean openWatershed() {
        if (!ClientAppCheck.haveClientApp()) {
            System.out.println("openWatershed: functionality not available outside of the CWMS environment");
            return false;
        }
        return ClientApp.app().openWorkspace();
    }

    public static ClientWorkspace getWatershed() {
        if (!ClientAppCheck.haveClientApp()) {
            System.out.println("getWatershed: functionality not available outside of the CWMS environment");
            return null;
        }
        return ClientApp.Workspace();
    }

    public static boolean closeWatershed() {
        if (ClientAppWrapper.isWatershedOpened()) {
            System.out.println("closeWatershed: closing " + ClientApp.Workspace().getWorkspaceConfigFile(""));
            ClientApp.Workspace().close();
            return true;
        }
        return false;
    }

    public static boolean localExec(String string) {
        Runtime runtime = Runtime.getRuntime();
        try {
            if (RMAIO.getOSType() == 2) {
                runtime.exec(string);
            } else {
                runtime.exec("start " + string);
            }
        }
        catch (IOException iOException) {
            System.out.println("localExec: io error " + String.valueOf(iOException) + " running " + string);
            return false;
        }
        return true;
    }

    public static ClientMode getCurrentModule() {
        if (!ClientAppCheck.haveClientApp()) {
            System.out.println("getCurrentModule: functionality not available outside of the CWMS environment");
            return null;
        }
        if (ClientApp.frame() != null) {
            return ClientApp.frame().getCurrentMode();
        }
        return null;
    }

    public static boolean selectModule(String string) {
        if (!ClientAppCheck.haveClientApp()) {
            System.out.println("selectModule: functionality not available outside of the CWMS environment");
            return false;
        }
        if (string == null) {
            return false;
        }
        if (ClientApp.frame() == null) {
            return false;
        }
        return ClientApp.frame().selectMode(string);
    }

    public static void selectModule(int n) {
        if (!ClientAppCheck.haveClientApp()) {
            System.out.println("selectModule: functionality not available outside of the CWMS environment");
            return;
        }
        if (n < 0) {
            return;
        }
        if (ClientApp.frame() == null) {
            return;
        }
        ClientApp.frame().selectMode(n);
    }

    public static boolean getScriptModule(String string) {
        if (!ClientAppCheck.haveClientApp()) {
            System.out.println("getScriptModule: functionality not available outside of the CWMS environment");
            return true;
        }
        if (string == null || string.length() <= 0) {
            return false;
        }
        ScriptManager scriptManager = ClientApp.Workspace().getScriptManager();
        return scriptManager.downLoadModule(string);
    }

    public static String getWatershedName() {
        if (!ClientAppCheck.haveClientApp()) {
            System.out.println("getWatershedName: functionality not available outside of the CWMS environment");
            return null;
        }
        if (ClientApp.Workspace() != null) {
            return ClientApp.Workspace().getTitleName();
        }
        return null;
    }

    public static void printLogMessage(String string) {
        if (!ClientAppCheck.haveClientApp()) {
            System.out.println("printLogMessage: functionality not available outside of the CWMS environment");
            return;
        }
        RMIScheduler rMIScheduler = ClientApp.app().getScheduler().getRMIScheduler();
        if (rMIScheduler == null) {
            ClientApp.app().getScheduler().logMessage(string);
            return;
        }
        try {
            rMIScheduler.logMessage(string);
            return;
        }
        catch (RemoteException remoteException) {
            ClientApp.app().getScheduler().logMessage(string);
            return;
        }
    }
}

