/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.server;

import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.TSDataSet;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.UserId;
import hec.rss.AutoLoadRssRmiWorkspace;
import hec.rss.model.GVDataSet;
import hec.rss.model.PDCDataSet;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.server.RssRmiWorkspaceImpl;
import hec.rss.wq.model.BoundaryConditionSetManager;
import hec.rss.wq.model.ConstituentSetManager;
import hec.rss.wq.model.CrossSectionManager;
import hec.rss.wq.model.InitialConditionSetManager;
import hec.rss.wq.model.MetData;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.model.dispersionCoeff.DispersionSetManager;
import hec.rss.wq.model.massinjection.MassInjectionSetManager;
import hec.rss.wq.model.wqParameters.ParameterSetManager;
import java.io.File;
import java.io.FilenameFilter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.util.RMAFilenameFilter;
import rma.util.RMAFilenameFilterSet;
import rma.util.RMAIO;

public class AutoLoadRssRmiWorkspaceImpl
extends RssRmiWorkspaceImpl
implements AutoLoadRssRmiWorkspace {
    protected static final String a = "rss";
    private boolean _workingDirSet;

    public AutoLoadRssRmiWorkspaceImpl(int n) throws RemoteException {
        super(n);
        this._typeOfWorkspace = "autorss";
    }

    public AutoLoadRssRmiWorkspaceImpl(Integer n) throws RemoteException {
        this((int)n);
    }

    public AutoLoadRssRmiWorkspaceImpl(String string, Identifier identifier) throws RemoteException {
        this(8089);
        this.setIdentifier(string, identifier);
        this._lockedBy = string;
        try {
            this.addUser(string);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace(System.out);
            return;
        }
    }

    @Override
    public boolean load() {
        this._managerProxys.clear();
        HecFile hecFile = this.identifier.getFile();
        if (hecFile != null) {
            this.readConfiguration(hecFile);
            return true;
        }
        return false;
    }

    @Override
    protected synchronized void readConfiguration(HecFile hecFile) {
        if (!this._workingDirSet) {
            return;
        }
        System.out.println("readConfiguration:reading file " + hecFile.getPath());
        super.readConfiguration(hecFile);
        if (this.updateWorkspace()) {
            this.writeConfiguration(hecFile);
        }
    }

    public boolean updateWorkspace() {
        Object object;
        RmiFileManager rmiFileManager;
        try {
            rmiFileManager = this.getFileManager();
        }
        catch (Exception exception) {
            System.out.println("updateWorkspace: RMI Error getting RmiFileManager " + String.valueOf(exception));
            return false;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        try {
            File file = new File(RMAIO.concatPath((String)this.getWorkspacePath(), (String)a));
            System.out.println("updateWorkspace:checking folder " + file.getAbsolutePath());
            object = new RMAFilenameFilterSet(a);
            object.addFilter((FilenameFilter)new RMAFilenameFilter(new String[]{"ralt"}));
            object.addFilter((FilenameFilter)new RMAFilenameFilter(new String[]{"rssrun"}));
            object.addFilter((FilenameFilter)new RMAFilenameFilter(new String[]{"rsys"}));
            object.addFilter((FilenameFilter)new RMAFilenameFilter(new String[]{"fits"}));
            object.addFilter((FilenameFilter)new RMAFilenameFilter(new String[]{"igv"}));
            object.addFilter((FilenameFilter)new RMAFilenameFilter(new String[]{"met"}));
            object.addFilter((FilenameFilter)new RMAFilenameFilter(new String[]{"wqParameters"}));
            object.addFilter((FilenameFilter)new RMAFilenameFilter(new String[]{"constituentSet"}));
            object.addFilter((FilenameFilter)new RMAFilenameFilter(new String[]{"boundaryCondSet"}));
            object.addFilter((FilenameFilter)new RMAFilenameFilter(new String[]{"dispersionCoeff"}));
            object.addFilter((FilenameFilter)new RMAFilenameFilter(new String[]{"initialCondSet"}));
            object.addFilter((FilenameFilter)new RMAFilenameFilter(new String[]{"crossSections"}));
            object.addFilter((FilenameFilter)new RMAFilenameFilter(new String[]{"geometry"}));
            object.addFilter((FilenameFilter)new RMAFilenameFilter(new String[]{"massInjection"}));
            AutoLoadRssRmiWorkspaceImpl.a(file, (RMAFilenameFilterSet)object, arrayList);
        }
        catch (Exception exception) {}
        if (arrayList.isEmpty()) {
            return false;
        }
        int n = arrayList.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Manager manager;
            object = (File)arrayList.get(i);
            System.out.println("updateWorkspace:found " + ((File)object).getAbsolutePath());
            object = new Identifier(((File)object).getAbsolutePath());
            ManagerProxy managerProxy = this.getManagerProxy((Identifier)object);
            String string = object.getPath();
            if (managerProxy != null && !string.endsWith(".rsys")) {
                object = managerProxy.loadManager(null, null);
                if (object == null) continue;
                Object object2 = object;
                if (!object2.readFile(object2.getIdentifier())) continue;
                managerProxy.setIndex(object.getIndex());
                managerProxy.getId().setName(object.getName());
                continue;
            }
            String string2 = string.endsWith(".rsys") ? RssSystem.class.getName() : (string.endsWith(".ralt") ? RssAlt.class.getName() : (string.endsWith(".rssrun") ? this.getRunClassName() : (string.endsWith(".fits") || string.endsWith(".wqits") ? TSDataSet.class.getName() : (string.endsWith(".wqpdc") ? PDCDataSet.class.getName() : (string.endsWith(".igv") ? GVDataSet.class.getName() : (string.endsWith(".met") ? MetData.class.getName() : (string.endsWith(".wqParameters") ? ParameterSetManager.class.getName() : (string.endsWith(".constituentSet") ? ConstituentSetManager.class.getName() : (string.endsWith(".boundaryCondSet") ? BoundaryConditionSetManager.class.getName() : (string.endsWith("dispersionCoeff") ? DispersionSetManager.class.getName() : (string.endsWith(".initialCondSet") ? InitialConditionSetManager.class.getName() : (string.endsWith(".crossSections") ? CrossSectionManager.class.getName() : (string.endsWith(".geometry") ? WqGeometry.class.getName() : (string.endsWith(".massInjection") ? MassInjectionSetManager.class.getName() : null))))))))))))));
            if (string2 == null || (manager = this._managerProxys.newManager(string2)) == null) continue;
            try {
                string = rmiFileManager.openFile(UserId.getUserId(), (Identifier)object);
            }
            catch (RemoteException remoteException) {
                System.out.println("updateWorkspace:failed to open file " + object.getPath() + " RMI Error:" + String.valueOf(remoteException));
                continue;
            }
            manager.getIdentifier().copy((Identifier)string);
            manager.readFile((Identifier)string);
            int n3 = manager.getIndex();
            managerProxy = manager.getProxyList().getManagerProxy((Identifier)string);
            if (managerProxy != null) {
                managerProxy.setIndex(n3);
                managerProxy.getId().setName(manager.getName());
            }
            System.out.println("updateWorkspace:found new " + string2 + " at " + object.getPath());
            ++n2;
        }
        return n2 > 0;
    }

    private static List<File> a(File fileArray, RMAFilenameFilterSet rMAFilenameFilterSet, List<File> list) {
        if ((fileArray = fileArray.listFiles((FilenameFilter)rMAFilenameFilterSet)) == null) {
            return list;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                AutoLoadRssRmiWorkspaceImpl.a(fileArray[i], rMAFilenameFilterSet, list);
                continue;
            }
            list.add(fileArray[i]);
        }
        return list;
    }

    @Override
    public void setWorkingDirectory(String string) {
        if (RMAIO.pathsEqual((String)this.getWorkspacePath(), (String)string)) {
            return;
        }
        if ((string = string.replace('\\', '/')).endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        System.out.println("setWorkingDirectory:dir=" + string);
        super.setWorkspacePath(string);
        this._workingDirSet = true;
        string = this.getWorkspacePath();
        String string2 = string + "/rss/" + this._typeOfWorkspace + ".conf";
        Identifier identifier = new Identifier(string2);
        try {
            string = this.openFile(UserId.getUserId(), identifier);
            if (string == null) {
                string = this.newFile(UserId.getUserId(), identifier);
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("setWorkspacePath:Error opening " + string2 + " Error:" + String.valueOf(remoteException));
            return;
        }
        this.setIdentifier(UserId.getUserId(), (Identifier)string);
        ((RssRmiWorkspaceImpl)this).load();
    }

    @Override
    protected synchronized void writeConfiguration(HecFile hecFile) {
        super.writeConfiguration(hecFile);
    }

    public ManagerProxy getManagerProxy(Identifier identifier) {
        return this._managerProxys.getManagerProxy(identifier);
    }
}

