/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.server;

import hec.clientapp.client.ClientApp;
import hec.rss.client.ObsDataPanel;
import hec.rss.client.diversion.DiversionPanel;
import hec.rss.model.DiversionElement;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.model.TimeStepRoutingElement;
import hec.rss.server.DiversionEditorDlg$1;
import hec.rss.server.LossesPanel;
import hec.rss.server.routing.RoutingDialogParent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import rma.swing.ButtonCmdPanel;
import rma.swing.ClosableDialog;
import rma.swing.RmaInsets;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaNavigationPanel;
import rma.util.RMAIO;

public class DiversionEditorDlg
extends RoutingDialogParent
implements ItemListener,
ClosableDialog {
    private boolean _canceled = false;
    private DiversionPanel _diversionPanel = new DiversionPanel((JDialog)((Object)this));
    private LossesPanel _lossPanel = new LossesPanel();
    private ObsDataPanel _obsDataPanel = new ObsDataPanel();
    private RssSystem _system;
    private DiversionElement _currDivElem;
    private RmaNavigationPanel _navPanel;
    private JTabbedPane tabbedPane;
    private RmaJDescriptionField descriptionTxt;
    private RmaJComboBox<String> diversionCombo;
    private ButtonCmdPanel cmdPanel;
    private String _modelName = "Rss";
    private boolean _isRssLp = false;
    private JMenuItem _closeMenu;
    private RmaJColorComboBox _fillColorCombo;
    private Object[] _defaultFillColor;

    public DiversionEditorDlg(Frame frame, boolean bl, String string) {
        super(frame, bl);
        this._modelName = string;
        this.buildControls();
        this.addListeners();
        this.pack();
        this.setSize(850, 600);
        DiversionEditorDlg diversionEditorDlg = this;
        diversionEditorDlg.setLocationRelativeTo(diversionEditorDlg.getParent());
    }

    public DiversionEditorDlg(Frame frame, boolean bl) {
        this(frame, bl, "Rss");
    }

    protected void buildControls() {
        this.setDefaultCloseOperation(0);
        this.setTitle("Diversion Editor");
        this.getContentPane().setLayout(new GridBagLayout());
        this.setVisible(false);
        this.setSize(550, 540);
        this.tabbedPane = new JTabbedPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.ipadx = 499;
        gridBagConstraints.ipady = 223;
        this.getContentPane().add((Component)this.tabbedPane, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        JLabel jLabel = new JLabel("Diversion Fill Color:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._fillColorCombo = new RmaJColorComboBox();
        this._fillColorCombo.setModifiable(true);
        this._defaultFillColor = new Object[]{Color.WHITE, "Default"};
        this._fillColorCombo.addItem((Object)this._defaultFillColor);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._fillColorCombo, gridBagConstraints);
        this.cmdPanel = new ButtonCmdPanel(14);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.ipadx = 73;
        gridBagConstraints.ipady = 13;
        this.getContentPane().add((Component)this.cmdPanel, gridBagConstraints);
        jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        jLabel = new JLabel("Diversion Name");
        jLabel.setDisplayedMnemonic('N');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.diversionCombo = new RmaJComboBox();
        jLabel.setLabelFor((Component)this.diversionCombo);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)this.diversionCombo, gridBagConstraints);
        this._navPanel = new RmaNavigationPanel();
        this._navPanel.fillForm(this.diversionCombo);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        jPanel.add((Component)this._navPanel, gridBagConstraints);
        jLabel = new JLabel("Description");
        jLabel.setDisplayedMnemonic('D');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(7, 5, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.descriptionTxt = new RmaJDescriptionField();
        jLabel.setLabelFor((Component)this.descriptionTxt);
        this.descriptionTxt.setMargin(new Insets(0, 0, 0, 0));
        this.descriptionTxt.setLineWrap(true);
        this.descriptionTxt.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        jPanel.add((Component)this.descriptionTxt, gridBagConstraints);
        this.tabbedPane.addTab("Operations", null, (Component)((Object)this._diversionPanel));
        this.tabbedPane.addTab("Routing", null, (Component)((Object)this._routingPanel));
        this.tabbedPane.addTab("Losses", null, this._lossPanel);
        this.tabbedPane.addTab("Observed Data", null, this._obsDataPanel);
        this.buildMenus();
        this.tabChanged();
    }

    private void buildMenus() {
        JMenu jMenu = new JMenu("Diversion");
        this.addMenu(jMenu, 0);
        this._closeMenu = new JMenuItem("Close");
        jMenu.add(this._closeMenu);
    }

    protected void addListeners() {
        this.diversionCombo.addItemListener((ItemListener)this);
        this.addCommandPanelListener();
        this.tabbedPane.addChangeListener(changeEvent -> this.tabChanged());
        this._closeMenu.addActionListener(actionEvent -> this.windowClosing());
        this.addWindowListener(new DiversionEditorDlg$1(this));
    }

    private void addCommandPanelListener() {
        this.cmdPanel.addCmdPanelListener(actionEvent -> {
            switch (actionEvent.getID()) {
                case 8: {
                    if (!this.applyAction()) break;
                    this.setCanceled(false);
                    this.setVisible(false);
                    return;
                }
                case 2: {
                    this.applyAction();
                    return;
                }
                case 4: {
                    this.cancelAction();
                }
            }
        });
    }

    void cancelAction() {
        if (this.isModified() && this.isEditable()) {
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), "Data Has Changed. Save before closing?", "Save Changes?", 1);
            if (n == 2) {
                return;
            }
            if (n == 0) {
                this.saveForm();
            }
            this.setModified(false);
        }
        this.setVisible(false);
        this.setCanceled(true);
        this.dispose();
    }

    private void tabChanged() {
        Component component = this.tabbedPane.getSelectedComponent();
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar.getMenuCount() > 1) {
            for (int i = jMenuBar.getMenuCount() - 1; i > 0; --i) {
                jMenuBar.remove(i);
            }
        }
        if (component == this._diversionPanel) {
            this.addDiversionMenus(jMenuBar);
        }
        if (component == this._routingPanel) {
            this.addRoutingMenu();
        }
        jMenuBar.repaint();
    }

    private void addDiversionMenus(JMenuBar jMenuBar) {
        List<JMenu> list = this._diversionPanel.getMenus();
        for (int i = 0; i < list.size(); ++i) {
            jMenuBar.add(list.get(i));
        }
    }

    public void addNotify() {
        super.addNotify();
        this.getRootPane().setDefaultButton(null);
    }

    public boolean closeDialog() {
        this.setVisible(false);
        return true;
    }

    private void windowClosing() {
        this.setVisible(false);
    }

    private void setCanceled(boolean bl) {
        this._canceled = bl;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void saveForm() {
        this.applyAction();
    }

    private boolean applyAction() {
        if (this._currDivElem == null) {
            return true;
        }
        this._currDivElem.setDescription(this.descriptionTxt.getText());
        String string = this._fillColorCombo.getSelectedColorName();
        if ("Default".equals(string)) {
            string = null;
        }
        this._currDivElem.setFillColorName(string);
        boolean bl = this._diversionPanel.saveForm(this._currDivElem);
        if (bl && this._currDivElem.hasReach()) {
            this._lossPanel.savePanel(this._currDivElem);
            this._routingPanel.savePanel(this._currDivElem.getReachElement());
        }
        if (bl) {
            this._obsDataPanel.savePanel(this._currDivElem);
            this.setModified(false);
            ClientApp.frame().getMapPanel().paintMap();
        }
        return bl;
    }

    private void fillCombo(RssSystem stringArray) {
        this.diversionCombo.removeItemListener((ItemListener)this);
        stringArray = stringArray.getDiversionNames();
        if (this.diversionCombo.getItemCount() > 0) {
            this.diversionCombo.removeAllItems();
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.diversionCombo.addItem((Object)stringArray[i]);
            }
        }
        this.diversionCombo.addItemListener((ItemListener)this);
    }

    @Override
    public void itemStateChanged(ItemEvent object) {
        if (((ItemEvent)object).getStateChange() == 1 && (object = ((EventObject)object).getSource()) == this.diversionCombo) {
            this.diversionComboChanged();
        }
    }

    public void diversionComboChanged() {
        if (this.isModified() && this.isVisible() && this._currDivElem != null) {
            DiversionEditorDlg diversionEditorDlg = this;
            int n = JOptionPane.showConfirmDialog((Component)((Object)diversionEditorDlg), "Diversion " + diversionEditorDlg._currDivElem.getName() + " has changed.  Save Changes?", "Save Changes to Diversion", 0);
            if (n == 0) {
                this.applyAction();
            }
        }
        String string = (String)this.diversionCombo.getSelectedItem();
        this.selectDiversion(string, false);
    }

    public void setRssSystem(RssSystem rssSystem) {
        this._system = rssSystem;
        this._diversionPanel.setRssSystem(rssSystem);
        this.fillCombo(rssSystem);
        this.setAlternative(rssSystem.getAlternative());
        this.setTitle("Diversion Editor - Network: " + rssSystem.getName());
    }

    public boolean initDlg() {
        if (this._system == null) {
            RMAIO.postError((Component)((Object)this), (String)"Invalid Reservoir Network");
            return false;
        }
        if (this.diversionCombo.getItemCount() <= 0) {
            RMAIO.postError((Component)((Object)this), (String)"Need to create a Diversion first");
            return false;
        }
        return true;
    }

    public void selectDiversion(String string) {
        this.selectDiversion(string, true);
    }

    public void selectDiversion(String string, boolean bl) {
        if (string != null && this.diversionCombo.getItemCount() > 0) {
            DiversionElement diversionElement;
            this._currDivElem = diversionElement = this._system.findDiversion(string);
            if (bl) {
                this.diversionCombo.setSelectedItem((Object)string);
            }
            this.descriptionTxt.setText(this._currDivElem.getDescription());
            string = this._currDivElem.getFillColorName();
            if (string == null) {
                this._fillColorCombo.setSelectedItem((Object)this._defaultFillColor);
            } else {
                this._fillColorCombo.setSelectedColorName(string);
            }
            this._diversionPanel.fillForm(this._currDivElem);
            if (this._currDivElem.hasReach()) {
                this.tabbedPane.setEnabledAt(1, true);
                this.tabbedPane.setEnabledAt(2, true);
                this.tabbedPane.setEnabledAt(3, true);
                this._lossPanel.fillPanel(this._currDivElem);
                if (this._modelName.equalsIgnoreCase("RssLp")) {
                    this._routingPanel.setupForRssLp();
                    this._lossPanel.setupForRssLp();
                }
                this._routingPanel.fillPanel((TimeStepRoutingElement)this._currDivElem.getReachElement());
            } else {
                this.tabbedPane.setSelectedIndex(0);
                this.tabbedPane.setEnabledAt(1, false);
                this.tabbedPane.setEnabledAt(2, false);
                this.tabbedPane.setEnabledAt(3, true);
            }
            this._obsDataPanel.fillPanel(this._currDivElem);
        } else if (this.diversionCombo.getItemCount() > 0) {
            this.diversionCombo.setSelectedIndex(-1);
            this.diversionCombo.setSelectedIndex(0);
        }
        this.setModified(false);
    }

    public void setAlternative(RssAlt rssAlt) {
        this._diversionPanel.setAlternative(rssAlt);
        this._routingPanel.setAlternative(rssAlt);
    }
}

