/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.server;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.model.PairedValues;
import hec.model.PairedValuesTableModel;
import hec.rss.gfx2d.SimpleJTableData;
import hec.rss.model.RssSystem;
import hec.rss.server.JRatingCurvePanel$1;
import hec.rss.server.JRatingCurvePanel$MyG2dPanel;
import hec.rss.server.JunctionElementData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableModel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJTable;
import rma.swing.print.PageText;
import rma.util.RMAIO;

public class JRatingCurvePanel
extends JPanel {
    private static Color a = UIManager.getColor("TextField.disabledBackground");
    String _xColLabel = "Stage (%S)";
    String _yColLabel = "Discharge (%S)";
    String[] _colLabels = new String[]{this._xColLabel, this._yColLabel};
    RmaJTable _ratingCurveTable = new RmaJTable((Component)this);
    JRatingCurvePanel$MyG2dPanel _ratingCurvePlot = new JRatingCurvePanel$MyG2dPanel(this);
    RmaJLabel _datumLabel = new RmaJLabel("Stage Datum (%S)");
    RmaJDecimalField _datumTxt = new RmaJDecimalField();
    String _stageUnits = "ft";
    String _dischargeUnits = "cfs";
    SimpleJTableData _ratingCurveData;
    String _plotLegendName = "Stage-Discharge";
    String _plotTitle = "Rating Curve";

    public JRatingCurvePanel() {
        this.setLayout(new GridBagLayout());
        this._ratingCurveTable.setModel((TableModel)new PairedValuesTableModel(this._colLabels, new boolean[]{true, true}));
        this._ratingCurveTable.setDoubleCellEditor();
        ((PairedValuesTableModel)this._ratingCurveTable.getModel()).setShouldAddBlankRows(true);
        this._ratingCurveTable.setPrecision(2);
        this._ratingCurveTable.setUnitsHeaderRenderer();
        this._ratingCurveTable.getScrollPane().setVerticalScrollBarPolicy(22);
        this._ratingCurveTable.getScrollPane().setHorizontalScrollBarPolicy(30);
        JRatingCurvePanel jRatingCurvePanel = this;
        jRatingCurvePanel.add((Component)jRatingCurvePanel._ratingCurveTable.getScrollPane(), new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
        Serializable serializable = new JPanel();
        ((Container)serializable).setLayout(new GridBagLayout());
        ((Container)serializable).add((Component)this._datumLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 0), 0, 0));
        ((Container)serializable).add((Component)this._datumTxt, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 25, 5, 10), 0, 0));
        this.add((Component)serializable, new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._datumLabel.setLabelFor((Component)this._datumTxt);
        this._ratingCurveTable.addCellEditorListener((CellEditorListener)new JRatingCurvePanel$1(this));
        JRatingCurvePanel jRatingCurvePanel2 = this;
        jRatingCurvePanel2.add((Component)((Object)jRatingCurvePanel2._ratingCurvePlot), new RmaGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 100, 100));
        JRatingCurvePanel jRatingCurvePanel3 = this;
        jRatingCurvePanel3.configureRatingCurvePlot(jRatingCurvePanel3._ratingCurvePlot);
        serializable = new Vector();
        this._ratingCurveData = this.getRatingCurveData();
        ((Vector)serializable).addElement(this._ratingCurveData);
        this._ratingCurvePlot.setPlotObjects((List)((Object)serializable));
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._ratingCurveTable.setEnabled(bl);
        this._ratingCurveTable.setBackground(bl ? Color.white : a);
        this._ratingCurvePlot.setEnabled(bl);
        this._datumTxt.setEnabled(bl);
    }

    public void setTablePrintHeaders(RssSystem rssSystem, JunctionElementData junctionElementData) {
        ClientApp.app();
        Object object = new String("Workspace: " + ClientApp.Workspace().getTitleName());
        object = (String)object + "\n ResSim System: " + rssSystem.getName();
        object = (String)object + "\n Junction: " + junctionElementData.a;
        object = (String)object + "\n Rating Curve \n ";
        rssSystem = new PageText((String)object, 0);
        this._ratingCurveTable.setPrintTitle((PageText)rssSystem);
    }

    public void fillForm(PairedValues pairedValues) {
        this.clearPanel();
        if (pairedValues == null) {
            return;
        }
        ((PairedValuesTableModel)this._ratingCurveTable.getModel()).setPairedValues(pairedValues);
        ParamDouble paramDouble = new ParamDouble();
        pairedValues.getDatum(paramDouble);
        this._datumTxt.setValue(paramDouble);
        this.ratingCurveReplot();
    }

    public PairedValues storeForm(PairedValues pairedValues) {
        pairedValues.clearValues();
        this._ratingCurveTable.commitEdit(true);
        Vector vector = this._ratingCurveTable.getCells();
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) == null || ((Vector)vector.elementAt(i)).size() < 2) continue;
            Object e = ((Vector)vector.elementAt(i)).elementAt(0);
            Object e2 = ((Vector)vector.elementAt(i)).elementAt(1);
            double d = RMAIO.parseDouble(e);
            double d2 = RMAIO.parseDouble(e2);
            if (d == Double.NEGATIVE_INFINITY && d2 == Double.NEGATIVE_INFINITY) continue;
            pairedValues.addPair(d, d2);
        }
        pairedValues.setDatum(this._datumTxt.getParamValue());
        return pairedValues;
    }

    public void clearPanel() {
        this._ratingCurveTable.commitEdit(true);
        this._ratingCurveTable.clearCells();
        this.ratingCurveReplot();
    }

    public void configureRatingCurvePlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Discharge (%S)";
        g2dPlotProp.y1AxisProp.name = "Stage (%S)";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    public void ratingCurveReplot() {
        this._ratingCurveData.setData(this._ratingCurveTable, 1, 0);
        this._ratingCurveData.name = this._plotLegendName;
    }

    private SimpleJTableData getRatingCurveData() {
        SimpleJTableData simpleJTableData = new SimpleJTableData();
        new SimpleJTableData().xunits = "Discharge (%S)";
        simpleJTableData.yunits = "Stage (%S)";
        simpleJTableData.setData(null, -1, -1);
        simpleJTableData.addToPairedDataContainerReveresed(false);
        return simpleJTableData;
    }

    void cancel() {
        this._ratingCurveTable.removeEditor();
    }

    public void setPopupPlotLegendName(String string) {
        this._plotLegendName = string;
    }

    public void setPopupPlotTitle(String string) {
        this._plotTitle = string;
    }
}

