/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.server;

import hec.clientapp.client.ClientApp;
import hec.data.DataSetIllegalArgumentException;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.model.ModelVariable;
import hec.model.PairedValues;
import hec.model.PairedValuesExt;
import hec.rss.client.IndependentVariableDialog;
import hec.rss.client.datum.VerticalDatumPanel;
import hec.rss.model.Element;
import hec.rss.model.IndependentVariable;
import hec.rss.model.Junction;
import hec.rss.model.Junction$JuncRatingType;
import hec.rss.model.JunctionElement;
import hec.rss.model.RssRatingObject;
import hec.rss.model.RssSystem;
import hec.rss.model.StateVariable;
import hec.rss.model.VerticalDatumSettings;
import hec.rss.server.JRatingCurvePanelWithVerticalDatum$1;
import hec.rss.server.JRatingCurvePanelWithVerticalDatum$2;
import hec.rss.server.JRatingCurvePanelWithVerticalDatum$3;
import hec.rss.server.JRatingCurvePanelWithVerticalDatum$MyG2dPanel;
import hec.rss.server.JRatingCurvePanelWithVerticalDatum$PairedValuesExtPanel;
import hec.rss.server.JRatingCurvePanelWithVerticalDatum$PairedValuesPanel;
import hec.rss.server.JRatingCurvePanelWithVerticalDatum$RatingCurvePanel;
import hec.rss.server.JRatingCurvePanelWithVerticalDatum$RatingTablePanel;
import hec.rss.server.JunctionElementData;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTextField;
import rma.swing.print.PageText;

public class JRatingCurvePanelWithVerticalDatum
extends DefaultJPanel {
    static final Color a = UIManager.getColor("TextField.disabledBackground");
    String _xColLabel = "Stage (%S)";
    String _yColLabel = "Discharge (%S)";
    G2dPanel _ratingCurvePlot = new JRatingCurvePanelWithVerticalDatum$MyG2dPanel(this);
    RmaJLabel _datumLabel = new RmaJLabel("Reference Elevation (%S)");
    RmaJDecimalField _datumTxt = new JRatingCurvePanelWithVerticalDatum$1(this);
    String _plotLegendName = "Stage-Discharge";
    String _plotTitle = "Rating Curve";
    Element _parentElement;
    protected IndependentVariableDialog _independentVariableDialog;
    protected IndependentVariable _independentVariable;
    JButton _defineButton;
    protected JRatingCurvePanelWithVerticalDatum$PairedValuesExtPanel _twoVariableStagePanel;
    protected JRatingCurvePanelWithVerticalDatum$RatingCurvePanel _ratingCurvePanel;
    protected JRatingCurvePanelWithVerticalDatum$PairedValuesPanel _modelVariablePanel;
    private JPanel _cardPanel;
    protected JPanel _rcPanel;
    JRatingCurvePanelWithVerticalDatum$RatingTablePanel _currentPanel;
    JButton _editColumnValuesButton = new JButton("Edit Column Values");
    private RmaJRadioButton _rcRadio;
    private RmaJRadioButton _functionOfRadio;
    private JPanel _functionNamePanel;
    RmaJTextField _functionOfTxt;
    RmaJCheckBox _outOfRangeCheckBox;
    private boolean _isFillingTable = false;
    public static final String RATING_CURVE_TYPE = "Rating Curve";
    public static final String PAIRED_VALUES_TYPE = "Paired Values";
    public static final String TWO_VARIABLE_TYPE = "Two Variable";
    static final String[] b = new String[]{" "};
    int _currentFunctionType = -1;
    int _xParamId = -1;
    int _yParamId = Parameter.PARAMID_ELEV;
    int _zParamId = -1;
    String _xParamString = "undef x";
    String _yParamString = "Stage";
    String _zParamString = "undef z";
    String _zLocationName = "";
    VerticalDatumPanel _verticalDatumPanel;
    VerticalDatumSettings _verticalDatumSettings;

    public JRatingCurvePanelWithVerticalDatum() {
        this.setLayout(new GridBagLayout());
        JComponent jComponent = new JPanel();
        jComponent.setLayout(new GridBagLayout());
        new GridBagConstraints();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add(jComponent, gridBagConstraints);
        this._rcRadio = new RmaJRadioButton("Simple Rating", true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        jComponent.add((Component)this._rcRadio, gridBagConstraints);
        this._functionOfRadio = new RmaJRadioButton("Rating Function", true);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        jComponent.add((Component)this._functionOfRadio, gridBagConstraints);
        this._outOfRangeCheckBox = new RmaJCheckBox("Set Stage values to Missing for out of range Flows");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        gridBagConstraints.anchor = 18;
        jComponent.add((Component)this._outOfRangeCheckBox, gridBagConstraints);
        this._outOfRangeCheckBox.setVisible(false);
        this._functionNamePanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        jComponent.add((Component)this._functionNamePanel, gridBagConstraints);
        jComponent = new JLabel("Function Of:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this._functionNamePanel.add((Component)jComponent, gridBagConstraints);
        this._functionOfTxt = new RmaJTextField();
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this._functionNamePanel.add((Component)this._functionOfTxt, gridBagConstraints);
        this._functionOfTxt.setEditable(false);
        this._functionOfTxt.setModifiable(false);
        this._defineButton = new JButton("Define...");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridy = 0;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        gridBagConstraints.anchor = 17;
        this._functionNamePanel.add((Component)this._defineButton, gridBagConstraints);
        jComponent = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)0);
        this.add(jComponent, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        jComponent.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        jComponent.add((Component)jPanel2, gridBagConstraints);
        this._cardPanel = new JPanel(new CardLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)0);
        jPanel2.add((Component)this._cardPanel, gridBagConstraints);
        boolean bl = Boolean.getBoolean("ResSim.UsesVerticalDatum");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = bl ? 0.0 : 0.1;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.ipady = 100;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        jPanel.add((Component)this._ratingCurvePlot, gridBagConstraints);
        this._ratingCurvePanel = new JRatingCurvePanelWithVerticalDatum$RatingCurvePanel(this);
        this._cardPanel.add((Component)((Object)this._ratingCurvePanel), RATING_CURVE_TYPE);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0500;
        jPanel3.add((Component)this._datumLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 25);
        jPanel3.add((Component)this._datumTxt, gridBagConstraints);
        this._datumLabel.setLabelFor((Component)this._datumTxt);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        this._verticalDatumPanel = new VerticalDatumPanel();
        this._verticalDatumPanel.setBorder(BorderFactory.createTitledBorder("Native Vertical Datum"));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this._verticalDatumPanel.setMinimumSize(this._verticalDatumPanel.getPreferredSize());
        jPanel.add((Component)this._verticalDatumPanel, gridBagConstraints);
        this._verticalDatumPanel.setVisible(bl);
        JRatingCurvePanelWithVerticalDatum jRatingCurvePanelWithVerticalDatum = this;
        jRatingCurvePanelWithVerticalDatum.add(jRatingCurvePanelWithVerticalDatum._editColumnValuesButton, new RmaGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._editColumnValuesButton.setVisible(false);
        this._defineButton.addActionListener(new JRatingCurvePanelWithVerticalDatum$2(this));
        Object object = new ButtonGroup();
        ((ButtonGroup)object).add((AbstractButton)this._rcRadio);
        ((ButtonGroup)object).add((AbstractButton)this._functionOfRadio);
        object = new JRatingCurvePanelWithVerticalDatum$3(this);
        this._rcRadio.addActionListener((ActionListener)object);
        this._functionOfRadio.addActionListener((ActionListener)object);
        this._twoVariableStagePanel = new JRatingCurvePanelWithVerticalDatum$PairedValuesExtPanel(this);
        this._twoVariableStagePanel.setName(TWO_VARIABLE_TYPE);
        this._modelVariablePanel = new JRatingCurvePanelWithVerticalDatum$PairedValuesPanel(this);
        this._modelVariablePanel.setName(PAIRED_VALUES_TYPE);
        this._cardPanel.add((Component)((Object)this._modelVariablePanel), PAIRED_VALUES_TYPE);
        this._cardPanel.add((Component)((Object)this._twoVariableStagePanel), TWO_VARIABLE_TYPE);
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, RATING_CURVE_TYPE);
    }

    public void setRatingFuncOnly() {
        this._rcRadio.setVisible(false);
        this._functionOfRadio.setVisible(false);
        this._defineButton.setText("Define...");
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._ratingCurvePanel.setEnabled(bl);
        this._twoVariableStagePanel.setEnabled(bl);
        this._modelVariablePanel.setEnabled(bl);
        this._datumTxt.setEnabled(bl);
        this.selectRadioAction();
        this._defineButton.setEnabled(bl && this._functionOfRadio.isSelected());
    }

    public void setTablePrintHeaders(RssSystem rssSystem, JunctionElementData junctionElementData) {
        ClientApp.app();
        Object object = new String("Workspace: " + ClientApp.Workspace().getTitleName());
        object = (String)object + "\n ResSim System: " + rssSystem.getName();
        object = (String)object + "\n Junction: " + junctionElementData.a;
        object = (String)object + "\n Rating Curve \n ";
        rssSystem = new PageText((String)object, 0);
        this._ratingCurvePanel.setPrintTitle((PageText)rssSystem);
    }

    public void setElement(Element element) {
        this._parentElement = element;
    }

    public void setIndependentVariable(IndependentVariable independentVariable) {
        this._independentVariable = independentVariable;
    }

    public IndependentVariable getIndependentVariable() {
        return this._independentVariable;
    }

    public void setVerticalDatumSettings(VerticalDatumSettings verticalDatumSettings) {
        this._verticalDatumSettings = verticalDatumSettings;
        this._verticalDatumPanel.fillPanel(verticalDatumSettings);
    }

    public VerticalDatumSettings getVerticalDatumSettings() {
        this._verticalDatumSettings = this._verticalDatumPanel.savePanel();
        int n = this._parentElement.getUnitSystem();
        String string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)n);
        this._verticalDatumSettings.setUnits(string);
        return this._verticalDatumSettings;
    }

    public void fillForm(JunctionElement namedType, JunctionElementData object) {
        this._isFillingTable = true;
        Junction junction = (Junction)namedType.getFunction();
        this.setTablePrintHeaders(namedType.getSystem(), (JunctionElementData)object);
        this.setPopupPlotTitle("Rating Curve: " + junction.getName());
        this.setVerticalDatumSettings(junction.getVerticalDatumSettings());
        this.setElement((Element)namedType);
        this._ratingCurvePanel.setData(junction.getRatingCurve());
        namedType = junction.getRatingObject();
        this.fillRatingObject((RssRatingObject)namedType);
        this.showOutOfRangeCheckBox(true);
        object = junction.getRatingType();
        if (object == Junction$JuncRatingType.RATINGOBJECT) {
            this._functionOfRadio.setSelected(true);
        } else {
            this._rcRadio.setSelected(true);
        }
        this._outOfRangeCheckBox.setSelected(namedType.getOutOfRangeValuesToMissing());
        this.selectRadioAction();
        object = new ParamDouble();
        namedType.getStageDatum((ParamDouble)object);
        this._datumTxt.setValue((ParamDouble)object);
        this.setModified(false);
        this._isFillingTable = false;
        this.plotTable();
    }

    public void fillRatingObject(RssRatingObject object) {
        if (object == null) {
            return;
        }
        this._independentVariable = ((RssRatingObject)object).getIndependentVariable();
        PairedValues pairedValues = ((RssRatingObject)object).getIndependentVariableRatingCurve();
        if (pairedValues != null) {
            this._modelVariablePanel.setData(pairedValues);
        }
        int n = 2;
        if (this._independentVariable != null) {
            n = this._independentVariable.getType();
        }
        if (n == 5) {
            if ((object = ((RssRatingObject)object).getIndependentVariableRatingCurveExt()) != null) {
                this.setFunctionType(n, object);
                this._twoVariableStagePanel.setData(object);
            }
            this._currentPanel = this._twoVariableStagePanel;
            this._editColumnValuesButton.setVisible(true);
        } else {
            this._currentPanel = this._modelVariablePanel;
            object = this._modelVariablePanel.saveTable();
            this.setFunctionType(n, object);
            this._editColumnValuesButton.setVisible(false);
        }
        this._currentFunctionType = n;
    }

    public void showOutOfRangeCheckBox(boolean bl) {
        this._outOfRangeCheckBox.setVisible(bl);
        this.revalidate();
    }

    protected void selectRadioAction() {
        if (this._rcRadio.isSelected()) {
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, RATING_CURVE_TYPE);
            this._defineButton.setEnabled(false);
            this._editColumnValuesButton.setVisible(false);
            this._functionOfTxt.setText("Simple Rating Curve");
        } else {
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, this._currentPanel.getName());
            this._defineButton.setEnabled(true);
            if (this._currentPanel.getName() == TWO_VARIABLE_TYPE) {
                this._editColumnValuesButton.setVisible(true);
            } else {
                this._editColumnValuesButton.setVisible(false);
            }
            JRatingCurvePanelWithVerticalDatum jRatingCurvePanelWithVerticalDatum = this;
            String string = jRatingCurvePanelWithVerticalDatum.buildFunctionOfString(jRatingCurvePanelWithVerticalDatum._independentVariable);
            this._functionOfTxt.setText(string);
        }
        this.plotTable();
    }

    public boolean storeForm(JunctionElement namedType) {
        boolean bl = true;
        Object object = this.storePairedValuesRating((namedType = (Junction)namedType.getFunction()).getRatingCurve());
        if (!(object.getPairCount() <= 0 || object.canInterpX() && object.canInterpY())) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Flow and Stage values of your function must be a continuously increasing sequence.", "Rating Curve Error", 2);
            bl = false;
        } else {
            namedType.setRatingCurve((PairedValues)object);
        }
        object = this.getIndependentVariable();
        if (object != null) {
            object = namedType.getRatingObject();
            if ((object = this.storeRatingObject((RssRatingObject)object)) == null) {
                bl = false;
            } else {
                namedType.setRatingObject((RssRatingObject)object);
            }
        }
        object = this.getVerticalDatumSettings();
        namedType.setVerticalDatumSettings((VerticalDatumSettings)object);
        if (this._rcRadio.isSelected()) {
            namedType.setRatingType(Junction$JuncRatingType.PAIREDVALUES);
        } else {
            namedType.setRatingType(Junction$JuncRatingType.RATINGOBJECT);
        }
        if (bl) {
            this.setModified(false);
        }
        return bl;
    }

    public PairedValues storePairedValuesRating(PairedValues pairedValues) {
        this._ratingCurvePanel.saveTable(pairedValues);
        pairedValues.setDatum(this._datumTxt.getParamValue());
        return pairedValues;
    }

    public RssRatingObject storeRatingObject(RssRatingObject rssRatingObject) {
        Object object = this._twoVariableStagePanel.saveTable();
        if (object instanceof PairedValuesExt && this._currentPanel == this._twoVariableStagePanel) {
            if ((object = (PairedValuesExt)object).getNumberCurves() > 0) {
                if (!object.canInterpX()) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "The " + object.getParamXString() + " X values of your function must be a continuously increasing sequence.", "Rating Curve Error", 2);
                    return null;
                }
                double[] dArray = object.getCurveLabelValues();
                double d = 0.0;
                if (dArray == null || dArray.length == 0) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "The column label values of your function must be defined through the Edit Column Values button.", "Rating Curve Error", 2);
                    return null;
                }
                if (dArray != null && dArray.length > 1) {
                    for (int i = 0; i < dArray.length; ++i) {
                        if (i != 0 && d > dArray[i]) {
                            JOptionPane.showMessageDialog((Component)((Object)this), "The column label values of your function must be a continuously increasing sequence.", "Rating Curve Error", 2);
                            return null;
                        }
                        d = dArray[i];
                    }
                }
            }
            rssRatingObject.setIndependentVariableRatingCurveExt((PairedValuesExt)object);
        }
        if ((object = this._modelVariablePanel.saveTable()) instanceof PairedValues) {
            if ((object = (PairedValues)object).getYArray() != null && object.getXArray() != null && object.getYArray().length > 0 && object.getXArray().length > 0 && !object.canInterpX()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "The " + object.getParamXString() + " values of your function must be a continuously increasing sequence.", "Rating Curve Error", 2);
                return null;
            }
            rssRatingObject.setIndependentVariableRatingCurve((PairedValues)object);
        }
        rssRatingObject.setIndependentVariable(this._independentVariable);
        boolean bl = this._functionOfRadio.isSelected();
        rssRatingObject.setUsesIndependentVariable(bl);
        rssRatingObject.setOutOfRangeValuesToMissing(this._outOfRangeCheckBox.isSelected());
        rssRatingObject.setStageDatum(this._datumTxt.getParamValue());
        return rssRatingObject;
    }

    public PairedValuesExt getIndependentVariableRatingCurveExt(PairedValuesExt pairedValuesExt) {
        pairedValuesExt.clearValues();
        Object object = this._twoVariableStagePanel.saveTable();
        if (object instanceof PairedValuesExt) {
            return (PairedValuesExt)object;
        }
        return pairedValuesExt;
    }

    public PairedValues getIndependentVariableRatingCurve(PairedValues pairedValues) {
        pairedValues.clearValues();
        Object object = this._modelVariablePanel.saveTable();
        if (object instanceof PairedValues) {
            return (PairedValues)object;
        }
        return pairedValues;
    }

    public boolean getUsesIndependentVariable() {
        return this._functionOfRadio.isSelected();
    }

    protected void displayDefineFunctionDialog() {
        this._independentVariableDialog = new IndependentVariableDialog((Dialog)SwingUtilities.windowForComponent((Component)((Object)this)), true, 2, "Elevation");
        this._independentVariableDialog.setNetwork(this._parentElement.getSystem());
        this._independentVariableDialog.setElement(this._parentElement);
        this._independentVariableDialog.showTwoVariableEditColumn(false);
        if (this._independentVariable != null) {
            this._independentVariableDialog.setIndependentVariable(this._independentVariable);
        }
        this._independentVariableDialog.setExternalVariableName(this._parentElement.getName());
        this._independentVariableDialog.setVisible(true);
        if (this._independentVariableDialog.isCanceled()) {
            return;
        }
        IndependentVariable independentVariable = this._independentVariable;
        this._independentVariable = this._independentVariableDialog.getIndependentVariable();
        int n = this._independentVariable.getType();
        Object object = null;
        if (independentVariable != null) {
            int n2 = independentVariable.getType();
            if (n == 3 && n == n2) {
                if (!this._currentPanel.isEmpty()) {
                    object = this._currentPanel.saveTable();
                }
            } else if (n2 == 5 && n == 5) {
                n2 = independentVariable.getColVariable().getType();
                int n3 = independentVariable.getRowVariable().getType();
                int n4 = this._independentVariable.getColVariable().getType();
                int n5 = this._independentVariable.getRowVariable().getType();
                String[] stringArray = independentVariable.getTwoVariableColumnValues();
                if (stringArray != null && stringArray.length > 0) {
                    this._independentVariable.setTwoVariableColumnValues(stringArray);
                }
                if (n2 == n4 && n3 == n5) {
                    if (!this._currentPanel.isEmpty()) {
                        object = this._currentPanel.saveTable();
                    }
                    if (this._independentVariable.getRowVariable().areTheSame(independentVariable.getRowVariable()) && this._independentVariable.getColVariable().areTheSame(independentVariable.getColVariable())) {
                        if (this._independentVariable.getRowVariable().timeSeriesOptionsAreTheSame(independentVariable.getRowVariable()) && this._independentVariable.getColVariable().timeSeriesOptionsAreTheSame(independentVariable.getColVariable())) {
                            this.setModified(false);
                            return;
                        }
                        this.setModified(true);
                        return;
                    }
                }
                if (this._currentPanel instanceof JRatingCurvePanelWithVerticalDatum$PairedValuesExtPanel) {
                    ((JRatingCurvePanelWithVerticalDatum$PairedValuesExtPanel)this._currentPanel).clearPanel();
                }
            } else if (this._independentVariable.areTheSame(independentVariable)) {
                if (this._independentVariable.timeSeriesOptionsAreTheSame(independentVariable)) {
                    this.setModified(false);
                    return;
                }
                this.setModified(true);
                return;
            }
        }
        this.setFunctionType(n, object);
        this.setModified(true);
    }

    public void setFunctionType(int n, Object object) {
        this._currentFunctionType = n;
        JRatingCurvePanelWithVerticalDatum jRatingCurvePanelWithVerticalDatum = this;
        Object object2 = jRatingCurvePanelWithVerticalDatum.buildFunctionOfString(jRatingCurvePanelWithVerticalDatum._independentVariable);
        this._functionOfTxt.setText((String)object2);
        this._yParamString = "Stage";
        this._yParamId = Parameter.PARAMID_STAGE;
        this._zParamString = "";
        this._zParamId = -1;
        if (n == 2 || n == 3 || n == 4) {
            this._xParamId = -1;
            if (n == 2) {
                object2 = this._independentVariable.getModelVariable();
                if (object2 != null) {
                    this._xParamId = object2.getParamId();
                    this._xParamString = Parameter.getParamString((int)this._xParamId);
                }
            } else if (n == 4) {
                object2 = this._parentElement.getSystem().getStateVariable(this._independentVariable.getStateVariableId());
                this._xParamString = ((StateVariable)object2).getParamName();
                try {
                    Parameter parameter = new Parameter(((StateVariable)object2).getParamType());
                    this._xParamId = parameter.getParameterId();
                }
                catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
                    System.out.println("setFunctionType:Illegal Parameter " + String.valueOf((Object)dataSetIllegalArgumentException));
                    this._xParamId = -1;
                }
            } else {
                this._xParamString = this._independentVariable.getTimeSeriesName();
                this._xParamId = -1;
            }
            this._modelVariablePanel.setData(object);
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, PAIRED_VALUES_TYPE);
            this._currentPanel = this._modelVariablePanel;
        } else if (n == 5) {
            String[] stringArray = new String[1];
            object2 = stringArray;
            stringArray[0] = " ";
            if (this._independentVariable.getRowVariable().getType() == 2 || this._independentVariable.getRowVariable().getType() == 3 || this._independentVariable.getRowVariable().getType() == 4) {
                int n2;
                this._xParamId = -1;
                int n3 = this._independentVariable.getRowVariable().getType();
                if (n3 == 2) {
                    ModelVariable modelVariable = this._independentVariable.getRowVariable().getModelVariable();
                    if (modelVariable != null) {
                        this._xParamId = modelVariable.getParamId();
                        this._xParamString = Parameter.getParamString((int)this._xParamId);
                    }
                } else if (n3 == 4) {
                    StateVariable stateVariable = this._parentElement.getSystem().getStateVariable(this._independentVariable.getRowVariable().getStateVariableId());
                    this._xParamString = stateVariable.getParamName();
                    try {
                        stateVariable = new Parameter(stateVariable.getParamType());
                        this._xParamId = stateVariable.getParameterId();
                        this._xParamString = Parameter.getParamString((int)this._xParamId);
                    }
                    catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
                        System.out.println("setFunctionType:Illegal Parameter " + String.valueOf((Object)dataSetIllegalArgumentException));
                        this._xParamId = -1;
                    }
                } else {
                    this._xParamString = this._independentVariable.getRowVariable().getTimeSeriesName();
                    this._xParamId = -1;
                }
                if (object == null) {
                    object = new PairedValuesExt();
                }
                ((PairedValuesExt)object).setParamXId(this._xParamId);
                ((PairedValuesExt)object).setParamYId(this._yParamId);
                ((PairedValuesExt)object).setUnitSystem(this._parentElement.getUnitSystem());
                if (this._independentVariable != null && this._independentVariable.getTwoVariableColumnValues() != null && this._independentVariable.getTwoVariableColumnValues().length > 0) {
                    object2 = this._independentVariable.getTwoVariableColumnValues();
                }
                if ((n2 = this._independentVariable.getColVariable().getType()) == 2) {
                    ModelVariable modelVariable = this._independentVariable.getColVariable().getModelVariable();
                    if (modelVariable != null) {
                        this._zParamId = modelVariable.getParamId();
                        this._zLocationName = this._parentElement.getSystem().getNameForKeyString(this._independentVariable.getColVariable().getTSProxyName());
                    }
                } else if (n2 == 4) {
                    this._zLocationName = this._independentVariable.getColVariable().getStateVariableName();
                    StateVariable stateVariable = this._parentElement.getSystem().getStateVariable(this._independentVariable.getColVariable().getStateVariableId());
                    this._zParamString = stateVariable.getParamName();
                    try {
                        stateVariable = new Parameter(stateVariable.getParamType());
                        this._zParamId = stateVariable.getParameterId();
                        this._zParamString = Parameter.getParamString((int)this._zParamId);
                    }
                    catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
                        System.out.println("setFunctionType:Illegal Parameter " + String.valueOf((Object)dataSetIllegalArgumentException));
                        this._zParamId = -1;
                    }
                } else if (n2 == 3) {
                    this._zLocationName = this._independentVariable.getColVariable().getTimeSeriesName();
                    this._zParamId = -1;
                }
                ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, TWO_VARIABLE_TYPE);
                this._currentPanel = this._twoVariableStagePanel;
                this._twoVariableStagePanel.setData(object);
                this._twoVariableStagePanel.rebuildTableModel((PairedValuesExt)object, (String[])object2);
            }
        }
        if (n == 5) {
            this._editColumnValuesButton.setVisible(true);
        } else {
            this._editColumnValuesButton.setVisible(false);
        }
        this._currentPanel.rebuildTableColumnLabels();
        this.plotTable();
    }

    public void plotTable() {
        if (this._isFillingTable) {
            return;
        }
        Vector<G2dData> vector = new Vector<G2dData>();
        if (this._rcRadio.isSelected()) {
            JRatingCurvePanelWithVerticalDatum jRatingCurvePanelWithVerticalDatum = this;
            jRatingCurvePanelWithVerticalDatum.configureRatingCurvePlot(jRatingCurvePanelWithVerticalDatum._ratingCurvePlot);
            var2_2 = (G2dData)this._ratingCurvePanel.getPlotObjects();
            ((G2dData)this._ratingCurvePanel.getPlotObjects()).name = RATING_CURVE_TYPE;
            var2_2.lineStyleName = "Flow";
            if (var2_2 != null) {
                vector.add((G2dData)var2_2);
            }
        } else {
            if (this._currentFunctionType != -1 && this._currentPanel != null && (var2_2 = this._currentPanel.getPlotObjects()) != null) {
                v1.name = "Function of: " + this._functionOfTxt.getText();
                var2_2.lineStyleName = "Flow";
                if (var2_2 != null) {
                    vector.add((G2dData)var2_2);
                }
            }
            this._ratingCurvePlot.clearPanel();
            if (this._currentFunctionType == 5) {
                JRatingCurvePanelWithVerticalDatum jRatingCurvePanelWithVerticalDatum = this;
                jRatingCurvePanelWithVerticalDatum.configurePairedValuesExtPlot(jRatingCurvePanelWithVerticalDatum._ratingCurvePlot);
            } else {
                JRatingCurvePanelWithVerticalDatum jRatingCurvePanelWithVerticalDatum = this;
                jRatingCurvePanelWithVerticalDatum.configurePairedValuesPlot(jRatingCurvePanelWithVerticalDatum._ratingCurvePlot);
            }
        }
        int n = ClientApp.app().getClientUnitSystem();
        this._ratingCurvePlot.setPlotObjects(vector);
        this._ratingCurvePlot.setDisplayUnitsSystem(n);
        this._ratingCurvePlot.paintGfx();
        this._ratingCurvePlot.revalidate();
    }

    public String buildFunctionOfString(IndependentVariable object) {
        if (object == null) {
            return "Function Not Defined";
        }
        if (((IndependentVariable)object).getType() == 5) {
            String string = "***";
            String string2 = "***";
            IndependentVariable independentVariable = ((IndependentVariable)object).getColVariable();
            object = ((IndependentVariable)object).getRowVariable();
            if (independentVariable != null) {
                string = independentVariable.buildFunctionOfString(this._parentElement.getSystem());
            }
            if (object != null) {
                string2 = ((IndependentVariable)object).buildFunctionOfString(this._parentElement.getSystem());
            }
            object = string2 + "; " + string;
            return object;
        }
        return ((IndependentVariable)object).buildFunctionOfString(this._parentElement.getSystem());
    }

    public void clearPanel() {
        this._currentFunctionType = -1;
        this._currentPanel = null;
        this._independentVariable = null;
        this._ratingCurvePanel.clearPanel();
        this._twoVariableStagePanel.clearPanel();
    }

    public void configureRatingCurvePlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Flow (%S)";
        g2dPlotProp.y1AxisProp.name = "Stage (%S)";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    private void configurePairedValuesPlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        g2dPlotProp.x1AxisProp.name = this._xParamId == -1 ? this._xParamString + "(n/a)" : this._xParamString + " (%S)";
        g2dPlotProp.y1AxisProp.name = this._yParamString + this.getAdditionalYParamString() + " (%S" + this.getAdditionalYUnitsString() + ")";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    private void configurePairedValuesExtPlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        g2dPlotProp.x1AxisProp.name = this._xParamId == -1 ? this._xParamString + " (n/a)" : this._xParamString + " (%S)";
        g2dPlotProp.y1AxisProp.name = this._yParamString + this.getAdditionalYParamString() + " (%S" + this.getAdditionalYUnitsString() + ")";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    protected String getAdditionalYParamString() {
        return "";
    }

    protected String getAdditionalYUnitsString() {
        return "";
    }

    void cancel() {
    }

    public void setPopupPlotLegendName(String string) {
        this._plotLegendName = string;
    }

    public void setPopupPlotTitle(String string) {
        this._plotTitle = string;
    }
}

