/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.server;

import hec.map.MapLabelItem;
import hec.model.StreamElement;
import hec.rss.server.JnctInfo$SymKey;
import hec.rss.server.JunctionElementData;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import rma.swing.RmaInsets;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJList;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;

public class JnctInfo
extends JPanel {
    boolean fComponentsAdjusted = false;
    JLabel descriptionLabel;
    JLabel streamLabel;
    RmaJTextField _streamTxt;
    JLabel stationLabel;
    RmaJDecimalField _stationTxt;
    JLabel triLabel;
    JList triList;
    JCheckBox knownFlowCheckBox;
    RmaJIntegerField _cpIndexTxt;
    JLabel cpIndexLabel;
    RmaJLabel _labelPositionLabel;
    RmaJComboBox _labelPositionCombo;
    private final RmaJColorComboBox _fillColorCombo;
    private final Object[] _defaultFillColor;
    boolean isM = false;
    private boolean _allowsJunctionMovement = true;

    public JnctInfo() {
        this.setLayout(new GridBagLayout());
        this.setSize(405, 305);
        Object object = new Insets(5, 5, 5, 5);
        this.cpIndexLabel = new RmaJLabel("CP Index");
        this.cpIndexLabel.setDisplayedMnemonic('C');
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = object;
        JnctInfo jnctInfo = this;
        jnctInfo.add((Component)jnctInfo.cpIndexLabel, gridBagConstraints);
        this._cpIndexTxt = new RmaJIntegerField();
        this.cpIndexLabel.setLabelFor((Component)this._cpIndexTxt);
        this._cpIndexTxt.setMargin(new Insets(0, 0, 0, 0));
        this._cpIndexTxt.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.insets = object;
        JnctInfo jnctInfo2 = this;
        jnctInfo2.add((Component)jnctInfo2._cpIndexTxt, gridBagConstraints);
        this._cpIndexTxt.setVisible(false);
        this.cpIndexLabel.setVisible(false);
        this.streamLabel = new RmaJLabel("Stream");
        this.streamLabel.setDisplayedMnemonic('S');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = object;
        JnctInfo jnctInfo3 = this;
        jnctInfo3.add((Component)jnctInfo3.streamLabel, gridBagConstraints);
        this._streamTxt = new RmaJTextField();
        this._streamTxt.setModifiable(false);
        this.streamLabel.setLabelFor((Component)this._streamTxt);
        this._streamTxt.setMargin(new Insets(0, 0, 0, 0));
        this._streamTxt.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = object;
        JnctInfo jnctInfo4 = this;
        jnctInfo4.add((Component)jnctInfo4._streamTxt, gridBagConstraints);
        this.stationLabel = new RmaJLabel("Stream Station");
        this.stationLabel.setDisplayedMnemonic('r');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = object;
        JnctInfo jnctInfo5 = this;
        jnctInfo5.add((Component)jnctInfo5.stationLabel, gridBagConstraints);
        this._stationTxt = new RmaJDecimalField();
        this.stationLabel.setLabelFor((Component)this._stationTxt);
        this._stationTxt.setPrecision(2);
        this._stationTxt.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.insets = object;
        JnctInfo jnctInfo6 = this;
        jnctInfo6.add((Component)jnctInfo6._stationTxt, gridBagConstraints);
        this.triLabel = new RmaJLabel("Tributaries");
        this.triLabel.setDisplayedMnemonic('T');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = object;
        JnctInfo jnctInfo7 = this;
        jnctInfo7.add((Component)jnctInfo7.triLabel, gridBagConstraints);
        this.triList = new RmaJList((ListModel)new RmaListModel(false));
        this.triLabel.setLabelFor(this.triList);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = object;
        JScrollPane jScrollPane = new JScrollPane(this.triList);
        this.add((Component)jScrollPane, gridBagConstraints);
        this.knownFlowCheckBox = new JCheckBox("Outflow known during hindcast.");
        this.knownFlowCheckBox.setMnemonic('O');
        this.knownFlowCheckBox.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = object;
        this._labelPositionLabel = new RmaJLabel("Label Position");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = object;
        JnctInfo jnctInfo8 = this;
        jnctInfo8.add((Component)jnctInfo8._labelPositionLabel, gridBagConstraints);
        this._labelPositionCombo = new RmaJComboBox((Object[])MapLabelItem.POSITION_STRINGS);
        this._labelPositionCombo.setModifiable(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = object;
        JnctInfo jnctInfo9 = this;
        jnctInfo9.add((Component)jnctInfo9._labelPositionCombo, gridBagConstraints);
        object = new JLabel("Junction Fill Color:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add((Component)object, gridBagConstraints);
        this._fillColorCombo = new RmaJColorComboBox();
        this._fillColorCombo.setModifiable(true);
        this._defaultFillColor = new Object[]{Color.WHITE, "Default"};
        this._fillColorCombo.addItem((Object)this._defaultFillColor);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        JnctInfo jnctInfo10 = this;
        jnctInfo10.add((Component)jnctInfo10._fillColorCombo, gridBagConstraints);
        object = new JnctInfo$SymKey(this);
        this._stationTxt.addKeyListener((KeyListener)object);
    }

    public boolean isModified() {
        return this.isM;
    }

    @Override
    public void addNotify() {
        Component[] componentArray = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + componentArray.width, this.insets().top + insets.bottom + componentArray.height);
        componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Point point = componentArray[i].getLocation();
            point.translate(this.getInsets().left, this.getInsets().top);
            componentArray[i].setLocation(point);
        }
        this.fComponentsAdjusted = true;
    }

    public void clearForm() {
        this._streamTxt.setText("");
        this._stationTxt.setText("");
        ((RmaListModel)this.triList.getModel()).removeAllElements();
        this._cpIndexTxt.setText("");
        this.isM = false;
    }

    public JunctionElementData storeForm(JunctionElementData junctionElementData) {
        this.isM = false;
        junctionElementData.c = this._stationTxt.getValue();
        Object object = new String[((RmaListModel)this.triList.getModel()).size()];
        ((RmaListModel)this.triList.getModel()).copyInto(object);
        junctionElementData.e = object;
        junctionElementData.j = this._labelPositionCombo.getSelectedIndex();
        object = this._fillColorCombo.getSelectedColorName();
        if ("Default".equals(object)) {
            object = null;
        }
        junctionElementData.k = object;
        if (this._cpIndexTxt.isVisible()) {
            junctionElementData.g = this._cpIndexTxt.getValue();
        }
        return junctionElementData;
    }

    public void fillForm(JunctionElementData object) {
        this.isM = false;
        this._streamTxt.setText(((JunctionElementData)object).d);
        this._stationTxt.setValue(((JunctionElementData)object).c);
        if (((JunctionElementData)object).e != null) {
            for (int i = 0; i < ((JunctionElementData)object).e.length; ++i) {
                ((RmaListModel)this.triList.getModel()).addElement((Object)((JunctionElementData)object).e[i]);
            }
        }
        this._labelPositionCombo.setSelectedIndex(((JunctionElementData)object).j);
        String string = ((JunctionElementData)object).k;
        if (string == null) {
            this._fillColorCombo.setSelectedItem((Object)this._defaultFillColor);
        } else {
            this._fillColorCombo.setSelectedColorName(string);
        }
        if (this._cpIndexTxt.isVisible() && ((JunctionElementData)object).g > 0) {
            this._cpIndexTxt.setValue(((JunctionElementData)object).g);
        }
        if (((JunctionElementData)object).h > 0L) {
            this._stationTxt.setEditable(false);
            return;
        }
        if (this._allowsJunctionMovement) {
            object = SwingUtilities.windowForComponent(this);
            if (object instanceof RmaJDialog && !(object = (RmaJDialog)object).isEditable()) {
                return;
            }
            this._stationTxt.setEditable(true);
        }
    }

    public void fillForm(JunctionElementData junctionElementData, StreamElement streamElement) {
        this.fillForm(junctionElementData);
        if (streamElement != null) {
            junctionElementData = streamElement.getUpstreamNode();
            streamElement = streamElement.getDownstreamNode();
            if (this._stationTxt.isEditable()) {
                this._stationTxt.setMaxValue(junctionElementData.getStation());
                this._stationTxt.setMinValue(streamElement.getStation());
            }
        }
    }

    public void showCPIndex(boolean bl) {
        this._cpIndexTxt.setVisible(bl);
        this.cpIndexLabel.setVisible(bl);
    }

    void jTextArea1_keyTyped(KeyEvent keyEvent) {
        this.isM = true;
    }

    void StationTxt_keyTyped(KeyEvent keyEvent) {
        this.isM = true;
    }

    public void setAllowJunctionMovement(boolean bl) {
        this._allowsJunctionMovement = bl;
    }
}

