/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.server;

import hec.clientapp.client.ClientApp;
import hec.model.StreamElement;
import hec.rss.client.ObsDataPanel;
import hec.rss.model.JunctionElement;
import hec.rss.model.RssSystem;
import hec.rss.server.JRatingCurvePanelWithVerticalDatum;
import hec.rss.server.JnctInfo;
import hec.rss.server.JnctLocalFlow;
import hec.rss.server.JunctionDialog$1;
import hec.rss.server.JunctionDialog$NameIndex;
import hec.rss.server.JunctionDialog$NameIndexListModel;
import hec.rss.server.JunctionElementData;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.ClosableDialog;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJLabel;
import rma.swing.RmaJTabbedPane;
import rma.swing.RmaNavigationPanel;
import rma.util.RMAIO;

public class JunctionDialog
extends RmaJDialog
implements ItemListener,
ChangeListener,
ButtonCmdPanelListener,
ClosableDialog {
    protected JPanel _namePanel;
    protected JLabel _nameLabel;
    protected RmaJComboBox _systemChoice;
    protected RmaNavigationPanel _navPanel;
    protected JPanel _jPanel1;
    protected RmaJTabbedPane _jTabbedPane1;
    protected RmaJDescriptionField _descriptionTxt;
    protected ButtonCmdPanel _cmdPanel = new ButtonCmdPanel(14);
    protected JRatingCurvePanelWithVerticalDatum _ratingCurvePanel = new JRatingCurvePanelWithVerticalDatum();
    protected JnctLocalFlow _localFlowPanel = new JnctLocalFlow();
    protected JnctInfo _infoPanel = new JnctInfo();
    protected ObsDataPanel _obsDataPanel = new ObsDataPanel();
    protected RssSystem _system = null;
    protected JunctionElement _juncElem = null;
    protected JunctionElementData _jed = new JunctionElementData();
    private String _modelName = "ResSim";

    public JunctionDialog(Frame frame, boolean bl) {
        this(frame, bl, "ResSim");
    }

    public JunctionDialog(Frame frame, String string, boolean bl) {
        this(frame, bl);
        this.setTitle(string);
    }

    public JunctionDialog(Frame frame, boolean bl, String string) {
        super(frame, bl);
        this._modelName = string;
        JunctionDialog junctionDialog = this;
        junctionDialog.buildControls(junctionDialog._modelName);
        this.addListeners();
        JunctionDialog junctionDialog2 = this;
        junctionDialog2.setLocationRelativeTo(junctionDialog2.getParent());
    }

    protected void buildControls(String object) {
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(480, 480);
        this._namePanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)this._namePanel, gridBagConstraints);
        this._nameLabel = new RmaJLabel("Name");
        this._nameLabel.setDisplayedMnemonic('N');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this._namePanel.add((Component)this._nameLabel, gridBagConstraints);
        this._systemChoice = ((String)object).equals("RssLp") ? new RmaJComboBox((ComboBoxModel)((Object)new JunctionDialog$NameIndexListModel(this))) : new RmaJComboBox();
        this._systemChoice.setModifiable(false);
        this._nameLabel.setLabelFor((Component)this._systemChoice);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this._namePanel.add((Component)this._systemChoice, gridBagConstraints);
        this._navPanel = new RmaNavigationPanel();
        this._navPanel.fillForm((JComboBox)this._systemChoice);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 13;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        gridBagConstraints.weightx = 0.0;
        this._namePanel.add((Component)this._navPanel, gridBagConstraints);
        object = new JLabel("Description");
        ((JLabel)object).setDisplayedMnemonic('D');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this._namePanel.add((Component)object, gridBagConstraints);
        this._descriptionTxt = new RmaJDescriptionField();
        ((JLabel)object).setLabelFor((Component)this._descriptionTxt);
        this._descriptionTxt.setMargin(new Insets(0, 0, 0, 0));
        this._descriptionTxt.setLineWrap(true);
        this._descriptionTxt.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.ipadx = 200;
        this._namePanel.add((Component)this._descriptionTxt, gridBagConstraints);
        this._jPanel1 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)this._jPanel1, gridBagConstraints);
        this._jTabbedPane1 = new RmaJTabbedPane();
        this._jTabbedPane1.setBounds(5, 5, 470, 321);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this._jPanel1.add((Component)this._jTabbedPane1, gridBagConstraints);
        this.getContentPane().add((Component)this._cmdPanel, new RmaGridBagConstraints(0, 3, 1, 0, 1.0, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.setTitle("Junction Editor");
        this._jTabbedPane1.addTab("Info", null, (Component)this._infoPanel);
        this._jTabbedPane1.addTab("Local Flow", null, (Component)this._localFlowPanel);
        this._jTabbedPane1.addTab("Rating Curve", null, (Component)((Object)this._ratingCurvePanel));
        this._jTabbedPane1.addTab("Observed Data", null, (Component)this._obsDataPanel);
        this._jTabbedPane1.setSelectedIndex(0);
    }

    protected void addListeners() {
        this._systemChoice.addItemListener((ItemListener)this);
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)this);
        this._jTabbedPane1.addChangeListener((ChangeListener)this);
        JunctionDialog junctionDialog = this;
        junctionDialog.setLocationRelativeTo(junctionDialog.getParent());
        this.addWindowListener(new JunctionDialog$1(this));
    }

    public void addNotify() {
        super.addNotify();
        this.getRootPane().setDefaultButton(null);
    }

    public void buttonCmdActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getID() == 8) {
            this.handleOkAction();
            return;
        }
        if (actionEvent.getID() == 4) {
            this.handleCancelAction();
            return;
        }
        if (actionEvent.getID() == 2) {
            this.handleApplyAction();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent object) {
        if ((object = ((EventObject)object).getSource()) == this._systemChoice) {
            this.systemChoiceStateChange();
        }
    }

    boolean handleApplyAction() {
        if (this.validateComponents()) {
            boolean bl = this.storeForm();
            ClientApp.frame().getMapPanel().paintMap();
            return bl;
        }
        return false;
    }

    void handleOkAction() {
        if (this.handleApplyAction()) {
            this.setVisible(false);
            ClientApp.frame().getMapPanel().paintMap();
            return;
        }
        this.setVisible(true);
    }

    public void handleCancelAction() {
        if (this.isModified() && this.isVisible() && this._juncElem != null) {
            JunctionDialog junctionDialog = this;
            int n = JOptionPane.showConfirmDialog((Component)((Object)junctionDialog), "Junction " + junctionDialog._juncElem.getName() + " has changed.  Save Changes?", "Save Changes to Junction", 0);
            if (n == 0) {
                this.handleApplyAction();
            } else {
                this._localFlowPanel.cancel();
                this._ratingCurvePanel.cancel();
            }
        }
        this.setVisible(false);
    }

    void systemChoiceStateChange() {
        if (this.isModified() && this.isVisible() && this._juncElem != null) {
            JunctionDialog junctionDialog = this;
            int n = JOptionPane.showConfirmDialog((Component)((Object)junctionDialog), "Junction " + junctionDialog._juncElem.getName() + " has changed.  Save Changes?", "Save Changes to Junction", 0);
            if (n == 0) {
                this.handleApplyAction();
            }
        }
        this._localFlowPanel.setTableFocus();
        String string = this._systemChoice.getSelectedItem().toString();
        if (string == null) {
            return;
        }
        if (this._system == null) {
            return;
        }
        this._juncElem = this._system.findJunction(string);
        this.clearDlg();
        if (this._juncElem != null) {
            this._juncElem.getData(this._jed);
            JunctionDialog junctionDialog = this;
            junctionDialog.fillForm(junctionDialog._jed, this._juncElem.getStream());
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
    }

    public boolean initDlg() {
        if (this._system == null) {
            RMAIO.postError((Component)((Object)this), (String)"Invalid Reservoir Network");
            return false;
        }
        if (this._systemChoice.getItemCount() <= 0) {
            RMAIO.postError((Component)((Object)this), (String)"Need to create a Junction first");
            return false;
        }
        return true;
    }

    public void fillForm(JunctionElementData junctionElementData, StreamElement streamElement) {
        this.clearDlg();
        if (junctionElementData == null) {
            return;
        }
        if (this._system == null) {
            return;
        }
        this._descriptionTxt.setText(junctionElementData.b);
        this._localFlowPanel.setTablePrintHeaders(this._system, junctionElementData);
        this._localFlowPanel.fillForm(junctionElementData);
        if (this._modelName.equalsIgnoreCase("RssLp")) {
            this._infoPanel.showCPIndex(true);
        } else {
            this._infoPanel.showCPIndex(false);
        }
        this._infoPanel.fillForm(junctionElementData, streamElement);
        this._ratingCurvePanel.fillForm(this._juncElem, junctionElementData);
        this._obsDataPanel.fillPanel(this._juncElem);
        JunctionDialog junctionDialog = this;
        junctionDialog.updateUnitSystem((Container)((Object)junctionDialog));
        this.setModified(false);
    }

    public boolean storeForm() {
        if (this._system == null || this._juncElem == null) {
            return false;
        }
        this._jed = this._localFlowPanel.storeForm(this._jed, this._system);
        if (!this._localFlowPanel.isStoreSuccess()) {
            return false;
        }
        this._jed = this._infoPanel.storeForm(this._jed);
        this._ratingCurvePanel.storeForm(this._juncElem);
        this._jed.b = this._descriptionTxt.getText();
        this._juncElem.setData(this._jed);
        this._obsDataPanel.savePanel(this._juncElem);
        this._system.setModified(true);
        this.setModified(false);
        return true;
    }

    public void clearDlg() {
        this._localFlowPanel.clearForm();
        this._infoPanel.clearForm();
        this._obsDataPanel.clearPanel();
        this._descriptionTxt.setText("");
    }

    public void setRssSystem(RssSystem object) {
        this._system = object;
        this._systemChoice.removeItemListener((ItemListener)this);
        if (this._system != null) {
            this._systemChoice.removeAllItems();
            object = this._modelName.equals("RssLp") ? this._system.getElementVectorByClass("hec.rss.model.JunctionElement") : this._system.getElementNameVector("hec.rss.model.JunctionElement");
            if (object != null) {
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    Object object2 = ((Vector)object).elementAt(i);
                    if (object2 == null) continue;
                    if (this._modelName.equals("RssLp")) {
                        if (object2 instanceof JunctionElement) {
                            object2 = (JunctionElement)object2;
                            this._systemChoice.addItem((Object)new JunctionDialog$NameIndex(this, object2.getName(), ((JunctionElement)object2).getCPIndex()));
                            continue;
                        }
                        this._systemChoice.addItem((Object)object2.toString());
                        continue;
                    }
                    this._systemChoice.addItem((Object)object2.toString());
                }
            }
        }
        this._systemChoice.addItemListener((ItemListener)this);
        JunctionDialog junctionDialog = this;
        junctionDialog.setTitle("Junction Editor - Network: " + junctionDialog._system.getName());
    }

    public void selectJunction(String string) {
        this._systemChoice.removeItemListener((ItemListener)this);
        this._systemChoice.setSelectedItem((Object)string);
        this._systemChoice.addItemListener((ItemListener)this);
        this.systemChoiceStateChange();
    }

    public boolean closeDialog() {
        this.setVisible(false);
        return true;
    }

    public void setAllowJunctionMovement(boolean bl) {
        this._infoPanel.setAllowJunctionMovement(bl);
    }

    public ButtonCmdPanel getButtonCmdPanel() {
        return this._cmdPanel;
    }
}

