/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.server;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.model.PairedValues;
import hec.model.PairedValuesTableModel;
import hec.rss.gfx2d.SimpleJTableData;
import hec.rss.model.DiversionElement;
import hec.rss.model.DivertedOutletElement;
import hec.rss.model.Element;
import hec.rss.model.ReachElement;
import hec.rss.model.RssSystem;
import hec.rss.server.LossesPanel$1;
import hec.rss.server.LossesPanel$2;
import hec.rss.server.LossesPanel$3;
import hec.rss.server.LossesPanel$4;
import hec.rss.server.LossesPanel$5;
import hec.rss.server.LossesPanel$MyG2dPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJFrame;
import rma.swing.RmaJLabel;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.swing.RmaValidComponent;
import rma.swing.print.PageText;

public class LossesPanel
extends JPanel
implements RmaValidComponent {
    SimpleJTableData _seepData = this.getSeepData();
    Element _element;
    static final Color a = UIManager.getColor("TextField.disabledBackground");
    public static final String TABNAME = "Losses";
    RmaJRadioButton constSeepRadio;
    JRadioButton ratioRadio;
    JRadioButton reFuncSeepRadio;
    RmaJDecimalField constSeepText;
    RmaJDecimalField ratioText;
    RmaJTable reSeepTable;
    LossesPanel$MyG2dPanel reSeepPlot;

    public LossesPanel() {
        this.setLayout(new GridBagLayout());
        LossesPanel lossesPanel = this;
        lossesPanel.buildSeepagePanel(lossesPanel);
    }

    public boolean isValid(boolean bl) {
        return true;
    }

    void buildSeepagePanel(JPanel serializable) {
        Object object = new JPanel();
        ((Container)object).setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        ((Container)serializable).add((Component)object, gridBagConstraints);
        this.ratioRadio = new RmaJRadioButton("Return Ratio (0.0-1.0)");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        ((Container)object).add((Component)this.ratioRadio, gridBagConstraints);
        this.ratioText = new RmaJDecimalField();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        ((Container)object).add((Component)this.ratioText, gridBagConstraints);
        this.constSeepRadio = new RmaJRadioButton("Constant Seepage (%S)");
        this.constSeepRadio.setMnemonic('C');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        ((Container)object).add((Component)this.constSeepRadio, gridBagConstraints);
        this.constSeepText = new RmaJDecimalField();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)1, (int)0, (int)0);
        ((Container)object).add((Component)this.constSeepText, gridBagConstraints);
        this.constSeepRadio.setLabelFor((Component)this.constSeepText);
        this.reFuncSeepRadio = new RmaJRadioButton("Seepage as a function of Flow");
        this.reFuncSeepRadio.setMnemonic('S');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        ((Container)serializable).add(this.reFuncSeepRadio, gridBagConstraints);
        object = new String[]{"Flow(%S)", "Seepage(%S)"};
        this.reSeepTable = new RmaJTable((Component)serializable);
        this.reSeepTable.setModel((TableModel)new PairedValuesTableModel((String[])object, new boolean[]{true, true}));
        ((PairedValuesTableModel)this.reSeepTable.getModel()).setShouldAddBlankRows(true);
        this.reSeepTable.setNumRows(10);
        this.reSeepTable.clearColors();
        this.reSeepTable.setDoubleCellEditor();
        this.reSeepTable.setUnitsHeaderRenderer();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)30, (int)0, (int)0);
        ((Container)serializable).add(this.reSeepTable.getScrollPane(), gridBagConstraints);
        object = new RmaJLabel("  ");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        ((Container)serializable).add((Component)object, gridBagConstraints);
        this.reSeepPlot = new LossesPanel$MyG2dPanel(this);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.ipady = 100;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)10, (int)0, (int)10);
        ((Container)serializable).add((Component)((Object)this.reSeepPlot), gridBagConstraints);
        LossesPanel lossesPanel = this;
        lossesPanel.configureSeepPlot(lossesPanel.reSeepPlot);
        serializable = new Vector<SimpleJTableData>();
        ((Vector)serializable).addElement(this._seepData);
        this.reSeepPlot.setPlotObjects((List)((Object)serializable));
        serializable = new JButton("Plot");
        ((AbstractButton)serializable).setMnemonic('P');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        object = new ButtonGroup();
        ((ButtonGroup)object).add((AbstractButton)this.constSeepRadio);
        ((ButtonGroup)object).add(this.ratioRadio);
        ((ButtonGroup)object).add(this.reFuncSeepRadio);
        this.constSeepRadio.addActionListener((ActionListener)new LossesPanel$1(this));
        this.ratioRadio.addActionListener(new LossesPanel$2(this));
        this.reFuncSeepRadio.addActionListener(new LossesPanel$3(this));
        this.reSeepTable.addCellEditorListener((CellEditorListener)new LossesPanel$4(this));
        ((AbstractButton)serializable).addActionListener(new LossesPanel$5(this));
        this.constSeepRadio.doClick();
    }

    public String getTabname() {
        return TABNAME;
    }

    private void seepReplot() {
        Vector<SimpleJTableData> vector = new Vector<SimpleJTableData>();
        this._seepData.setData(this.reSeepTable, 0, 1);
        this._seepData.name = "Seepage";
        vector.addElement(this._seepData);
        this.reSeepPlot.setPlotObjects(vector);
    }

    public void savePanel(DiversionElement diversionElement) {
        if (diversionElement == null) {
            return;
        }
        if (this.reFuncSeepRadio.isSelected()) {
            diversionElement.setSeepageType(1);
        } else if (this.ratioRadio.isSelected()) {
            diversionElement.setSeepageType(2);
        } else {
            diversionElement.setSeepageType(0);
        }
        PairedValues pairedValues = new PairedValues();
        diversionElement.setSeepageValues(this.saveTable(pairedValues));
        diversionElement.setConstSeepage(this.constSeepText.getParamValue());
        diversionElement.setReturnRatio(this.ratioText.getValue());
    }

    public void savePanel(DivertedOutletElement divertedOutletElement) {
        if (divertedOutletElement == null) {
            return;
        }
        if (this.reFuncSeepRadio.isSelected()) {
            divertedOutletElement.setSeepageType(1);
        } else if (this.ratioRadio.isSelected()) {
            divertedOutletElement.setSeepageType(2);
        } else {
            divertedOutletElement.setSeepageType(0);
        }
        PairedValues pairedValues = new PairedValues();
        divertedOutletElement.setSeepageValues(this.saveTable(pairedValues));
        divertedOutletElement.setConstSeepage(this.constSeepText.getParamValue());
        divertedOutletElement.setReturnRatio(this.ratioText.getValue());
    }

    public void savePanel(ReachElement reachElement) {
        if (reachElement == null) {
            return;
        }
        if (this.reFuncSeepRadio.isSelected()) {
            reachElement.setSeepageType(1);
        } else {
            reachElement.setSeepageType(0);
        }
        PairedValues pairedValues = new PairedValues();
        reachElement.setSeepageValues(this.saveTable(pairedValues));
        reachElement.setConstSeepage(this.constSeepText.getParamValue());
    }

    public PairedValues saveTable(PairedValues pairedValues) {
        this.reSeepTable.commitEdit(true);
        ((PairedValuesTableModel)this.reSeepTable.getModel()).storeData(pairedValues);
        return pairedValues;
    }

    public void fillPanel(DiversionElement object) {
        this.clearPanel();
        if (object == null) {
            this.seepReplot();
            return;
        }
        this.ratioRadio.setVisible(true);
        this.ratioText.setVisible(true);
        int n = ((DiversionElement)object).getSeepageType();
        this._element = object;
        ParamDouble paramDouble = new ParamDouble();
        ((DiversionElement)object).getConstSeepage(paramDouble);
        this.fillPanel(n, ((DiversionElement)object).getSeepageValues(), paramDouble, ((DiversionElement)object).getReturnRatio());
        object = SwingUtilities.windowForComponent(this);
        if (object instanceof RmaJDialog) {
            ((RmaJDialog)object).updateUnitSystem((Container)this);
            return;
        }
        ((RmaJFrame)object).updateUnitSystem((Container)this);
    }

    public void fillPanel(DivertedOutletElement object) {
        if (object == null) {
            this.seepReplot();
            return;
        }
        this.ratioRadio.setVisible(true);
        this.ratioText.setVisible(true);
        int n = ((DivertedOutletElement)object).getSeepageType();
        this._element = object;
        ParamDouble paramDouble = new ParamDouble();
        ((DivertedOutletElement)object).getConstSeepage(paramDouble);
        this.fillPanel(n, ((DivertedOutletElement)object).getSeepageValues(), paramDouble, ((DivertedOutletElement)object).getReturnRatio());
        object = SwingUtilities.windowForComponent(this);
        if (object instanceof RmaJDialog) {
            ((RmaJDialog)object).updateUnitSystem((Container)this);
            return;
        }
        ((RmaJFrame)object).updateUnitSystem((Container)this);
    }

    public void fillPanel(ReachElement object) {
        int n = ((ReachElement)object).getSeepageType();
        if (object == null) {
            this.seepReplot();
            return;
        }
        this._element = object;
        ParamDouble paramDouble = new ParamDouble();
        ((ReachElement)object).getConstSeepage(paramDouble);
        this.fillPanel(n, ((ReachElement)object).getSeepageValues(), paramDouble, 0.0);
        this.ratioRadio.setVisible(false);
        this.ratioText.setVisible(false);
        object = SwingUtilities.windowForComponent(this);
        if (object instanceof RmaJDialog) {
            ((RmaJDialog)object).updateUnitSystem((Container)this);
            return;
        }
        ((RmaJFrame)object).updateUnitSystem((Container)this);
    }

    private void fillPanel(int n, PairedValues pairedValues, ParamDouble paramDouble, double d) {
        if (pairedValues != null) {
            this.fillSeepTable(pairedValues);
        }
        if (n == 1) {
            this.reFuncSeepRadio.doClick();
        } else if (n == 0) {
            this.constSeepRadio.doClick();
        } else if (n == 2) {
            this.ratioRadio.doClick();
        } else {
            System.out.println("unknown seepage type " + n);
            this.clearPanel();
        }
        this.constSeepText.setValue(paramDouble);
        this.ratioText.setValue(d);
        this.seepReplot();
    }

    public void setTablePrintHeaders(RssSystem rssSystem, ReachElement reachElement) {
        ClientApp.app();
        Object object = new String("Workspace: " + ClientApp.Workspace().getTitleName());
        object = (String)object + "\n ResSim System: " + rssSystem.getName();
        object = (String)object + "\n Reach: " + reachElement.getName();
        object = (String)object + "\n Seepage Losses \n ";
        rssSystem = new PageText((String)object, 0);
        this.reSeepTable.setPrintTitle((PageText)rssSystem);
    }

    private void fillSeepTable(PairedValues pairedValues) {
        ((PairedValuesTableModel)this.reSeepTable.getModel()).setPairedValues(pairedValues);
        this.seepReplot();
    }

    public void clearPanel() {
        this.reSeepTable.clearCells();
        this.constSeepText.setText("");
        this.constSeepRadio.doClick();
    }

    private void configureSeepPlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Flow(%S)";
        g2dPlotProp.y1AxisProp.name = "Seepage(%S)";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    private SimpleJTableData getSeepData() {
        SimpleJTableData simpleJTableData = new SimpleJTableData();
        new SimpleJTableData().xunits = "Flow(%S)";
        simpleJTableData.yunits = "Seepage(%S)";
        simpleJTableData.setData(null, -1, -1);
        simpleJTableData.addToPairedDataContainerReveresed(false);
        return simpleJTableData;
    }

    public void setupForRssLp() {
        this.ratioRadio.doClick();
        this.constSeepRadio.setEnabled(false);
        this.reFuncSeepRadio.setEnabled(false);
    }
}

