/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.server;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.TSDataSet;
import hec.heclib.util.intContainer;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOp;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.server.NameRssAltDialog$SymWindow;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.util.RMAIO;

public class NameRssAltDialog
extends RmaJDialog
implements ActionListener,
ButtonCmdPanelListener {
    public static final int EDIT_ALTERNATIVE_MODE = 0;
    public static final int CREATE_ALTERNATIVE_MODE = 1;
    private int _editMode = 1;
    private String _description;
    private String _label;
    private boolean _isCanceled = false;
    private RssAlt _alt = null;
    Vector _sysIDList = new Vector();
    Vector _opIDList = new Vector();
    Vector _tsdataIDList = new Vector();
    JLabel jAlternativeLabel = new JLabel("Name:");
    JLabel jDescriptionLabel = new JLabel("Description:");
    JLabel jTimeSeriesLabel = new JLabel("Time Series Data Set:");
    JLabel jSystemLabel = new JLabel("Reservoir System:");
    JLabel jResTableLabel = new JLabel("Reservoir Operation Set Selection");
    JComboBox jSystemComboBox = new JComboBox();
    JComboBox jTimeSeriesComboBox = new JComboBox();
    String[] colLabels = new String[]{"Reservoir", "Operation Set"};
    RmaJTable jReservoirTable;
    RmaJTextField jNameTxt;
    RmaJTextField jDescriptionTxt;

    public NameRssAltDialog(Frame serializable, boolean bl) {
        super(serializable, bl);
        NameRssAltDialog nameRssAltDialog = this;
        this.jReservoirTable = new RmaJTable((Component)((Object)nameRssAltDialog), (Object[])nameRssAltDialog.colLabels);
        this.jNameTxt = new RmaJTextField();
        this.jDescriptionTxt = new RmaJTextField();
        serializable = new Insets(5, 5, 0, 0);
        Object object = new Insets(5, 5, 5, 5);
        Insets insets = new Insets(5, 5, 0, 5);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(430, 270);
        this.setTitle("Create a new RES Alternative");
        this.getContentPane().add((Component)this.jAlternativeLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)serializable, 0, 0));
        this.getContentPane().add((Component)this.jDescriptionLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, (Insets)serializable, 0, 0));
        this.getContentPane().add((Component)this.jNameTxt, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.getContentPane().add((Component)this.jDescriptionTxt, new RmaGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.getContentPane().add((Component)this.jSystemLabel, new RmaGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, (Insets)serializable, 0, 0));
        this.getContentPane().add((Component)this.jSystemComboBox, new RmaGridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.getContentPane().add((Component)this.jTimeSeriesLabel, new RmaGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, (Insets)serializable, 0, 0));
        this.getContentPane().add((Component)this.jTimeSeriesComboBox, new RmaGridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.getContentPane().add((Component)this.jResTableLabel, new RmaGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.jReservoirTable.setAddRemoveEnabled(false);
        this.jReservoirTable.getScrollPane().setHorizontalScrollBarPolicy(30);
        this.jReservoirTable.getScrollPane().setVerticalScrollBarPolicy(22);
        this.jReservoirTable.setHorizontalAlignment(2);
        this.jReservoirTable.setColumnEnabled(false, 0);
        this.getContentPane().add((Component)this.jReservoirTable.getScrollPane(), new RmaGridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        serializable = new ButtonCmdPanel(12);
        this.getContentPane().add((Component)serializable, new RmaGridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 16, 2, (Insets)object, 0, 0));
        object = new NameRssAltDialog$SymWindow(this);
        this.addWindowListener((WindowListener)object);
        serializable.addCmdPanelListener(this);
        this.jSystemComboBox.addActionListener(this);
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        this.jAlternativeLabel.setDisplayedMnemonic('N');
        this.jAlternativeLabel.setLabelFor((Component)this.jNameTxt);
        this.jDescriptionLabel.setDisplayedMnemonic('D');
        this.jDescriptionLabel.setLabelFor((Component)this.jDescriptionTxt);
        this.jTimeSeriesLabel.setDisplayedMnemonic('T');
        this.jTimeSeriesLabel.setLabelFor(this.jTimeSeriesComboBox);
        this.jSystemLabel.setDisplayedMnemonic('S');
        this.jSystemLabel.setLabelFor(this.jSystemComboBox);
        this.jResTableLabel.setDisplayedMnemonic('R');
        this.jResTableLabel.setLabelFor((Component)this.jReservoirTable);
    }

    public NameRssAltDialog(Frame frame, String string, boolean bl) {
        this(frame, bl);
        this.setTitle(string);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            int n;
            Rectangle rectangle = this.getParent().getBounds();
            Rectangle rectangle2 = this.getBounds();
            int n2 = rectangle.x + (rectangle.width - rectangle2.width) / 2;
            if (n2 < 10) {
                n2 = 10;
            }
            if ((n = rectangle.y + (rectangle.height - rectangle2.height) / 2) < 10) {
                n = 10;
            }
            this.setLocation(n2, n);
            this.fillTable();
            this.setModified(false);
        }
        super.setVisible(bl);
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if ((object = ((EventObject)object).getSource()) == this.jSystemComboBox) {
            this.SystemComboBox_ActionPerformed();
        }
    }

    public void buttonCmdActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getID() == 8) {
            this.cmdOk_Action();
            return;
        }
        if (actionEvent.getID() == 4) {
            this.cmdCancel_Action();
        }
    }

    void Dialog1_WindowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    void cmdOk_Action() {
        if (this.jNameTxt.getText().trim().length() == 0) {
            RMAIO.postWarning((Component)((Object)this), (String)"Need to specify a Alternative name");
            return;
        }
        if (!this.validateTable()) {
            return;
        }
        this._isCanceled = false;
        this._label = this.jNameTxt.getText();
        this._description = this.jDescriptionTxt.getText();
        this.setVisible(false);
    }

    void cmdCancel_Action() {
        this._isCanceled = true;
        this.setVisible(false);
        this.dispose();
    }

    private void SystemComboBox_ActionPerformed() {
        this.fillTSDataSetCombo();
        if (this.jTimeSeriesComboBox.getItemCount() > 0) {
            this.jTimeSeriesComboBox.setSelectedIndex(0);
        }
        this.fillTable();
    }

    public boolean isCanceled() {
        return this._isCanceled;
    }

    public void setNameLabel(String string) {
    }

    public String getLabel() {
        return this._label;
    }

    public String getName() {
        return this._label;
    }

    public void setName(String string) {
        this.jNameTxt.setText(string);
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String string) {
        this.jDescriptionTxt.setText(string);
    }

    public void setEditingMode(int n) {
        if (n == 0) {
            this.jSystemComboBox.setEnabled(false);
            this.jTimeSeriesComboBox.setEnabled(false);
            this.jNameTxt.setEnabled(false);
            this._editMode = n;
            return;
        }
        if (n == 1) {
            this.jSystemComboBox.setEnabled(true);
            this.jTimeSeriesComboBox.setEnabled(true);
            this.jNameTxt.setEnabled(true);
            this._editMode = n;
        }
    }

    public void setEditingAlternative(RssAlt rssAlt) {
        this._alt = rssAlt;
    }

    public void selectSystem(String string) {
        if (string == null) {
            return;
        }
        this.jSystemComboBox.removeActionListener(this);
        this.jSystemComboBox.setSelectedItem(string);
        this.jSystemComboBox.addActionListener(this);
        this.fillTSDataSetCombo();
        if (this.jTimeSeriesComboBox.getItemCount() > 0) {
            this.jTimeSeriesComboBox.setSelectedIndex(0);
        }
    }

    public void selectTimeSeries(String string) {
        if (string == null) {
            return;
        }
        this.jTimeSeriesComboBox.setSelectedItem(string);
    }

    public void setSystemIDList(Vector vector) {
        this._sysIDList = vector;
        this.jSystemComboBox.removeActionListener(this);
        if (this.jSystemComboBox.getItemCount() > 0) {
            this.jSystemComboBox.removeAllItems();
        }
        for (int i = 0; i < vector.size(); ++i) {
            Identifier identifier = (Identifier)vector.elementAt(i);
            this.jSystemComboBox.addItem(identifier.getName());
        }
        this.jSystemComboBox.addActionListener(this);
    }

    public void setTSDataSetIDList(Vector vector) {
        this._tsdataIDList = vector;
        this.fillTSDataSetCombo();
    }

    void fillTSDataSetCombo() {
        Identifier identifier;
        if (this.jTimeSeriesComboBox.getItemCount() > 0) {
            this.jTimeSeriesComboBox.removeAllItems();
        }
        if ((identifier = this.getSelectedSystem()) == null || this._tsdataIDList == null) {
            return;
        }
        for (int i = 0; i < this._tsdataIDList.size(); ++i) {
            Identifier identifier2 = (Identifier)this._tsdataIDList.elementAt(i);
            ClientApp.app();
            TSDataSet tSDataSet = (TSDataSet)ClientApp.Workspace().openManager("rss", identifier2);
            if (tSDataSet == null) continue;
            if (identifier._path.equals(tSDataSet.getParentPath())) {
                this.jTimeSeriesComboBox.addItem(identifier2);
            }
            ClientApp.app();
            ClientApp.Workspace().unloadManager("rss", tSDataSet.getIdentifier());
        }
    }

    public Identifier getSelectedSystem() {
        int n = this.jSystemComboBox.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return (Identifier)this._sysIDList.elementAt(n);
    }

    public Identifier getSelectedTSDataSet() {
        int n = this.jTimeSeriesComboBox.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return (Identifier)this.jTimeSeriesComboBox.getSelectedItem();
    }

    public void setOperationsIDList(Vector vector) {
    }

    public Identifier getSelectedOperations() {
        return new Identifier();
    }

    private void fillTable() {
        Object object = this.getSelectedSystem();
        if (object == null) {
            return;
        }
        ClientApp.app();
        object = (RssSystem)ClientApp.Workspace().openManager("rss", (Identifier)object);
        if (object == null) {
            return;
        }
        String[] stringArray = ((RssSystem)object).getReservoirNames();
        if (stringArray == null || stringArray.length == 0) {
            this.jReservoirTable.setNumRows(0);
            return;
        }
        this.jReservoirTable.commitEdit(true);
        this.jReservoirTable.clearCells();
        this.jReservoirTable.setNumRows(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            NamedType namedType = ((RssSystem)object).findReservoir(stringArray[i]);
            if (namedType == null) continue;
            this.jReservoirTable.setCell((Object)namedType, i, 0);
            ReservoirOp reservoirOp = namedType.getReservoirOp();
            if (reservoirOp == null) continue;
            Vector<OpSet> vector = reservoirOp.getOperationSets();
            this.jReservoirTable.setComboBoxRowEditor(i, 1, vector);
            if (vector.size() <= 0 || this._editMode != 1) {
                if (vector.size() <= 0 || this._editMode != 0 || this._alt == null) continue;
                int n = this._alt.getResOpSetSelection(namedType.getIndex());
                if ((namedType = reservoirOp.getOperationSet(n)) != null) {
                    this.jReservoirTable.setCell((Object)namedType, i, 1);
                    continue;
                }
            }
            this.jReservoirTable.setCell((Object)vector.elementAt(0), i, 1);
        }
    }

    private boolean validateTable() {
        for (int i = 0; i < this.jReservoirTable.getNumRows(); ++i) {
            Object object;
            ReservoirElement reservoirElement = (ReservoirElement)this.jReservoirTable.getCell(i, 0);
            if (reservoirElement == null || (object = this.jReservoirTable.getCell(i, 1)) != null && !object.toString().equals("")) continue;
            RMAIO.postError((Component)((Object)this), (String)("Need to select an Operations set for Reservoir - " + reservoirElement.getName()));
            return false;
        }
        return true;
    }

    public Hashtable getOpSetIndex() {
        Hashtable<intContainer, Integer> hashtable = new Hashtable<intContainer, Integer>();
        for (int i = 0; i < this.jReservoirTable.getNumRows(); ++i) {
            ReservoirElement reservoirElement = (ReservoirElement)this.jReservoirTable.getCell(i, 0);
            OpSet opSet = (OpSet)this.jReservoirTable.getCell(i, 1);
            hashtable.put(new intContainer(reservoirElement.getIndex()), new Integer(opSet.getIndex()));
        }
        return hashtable;
    }
}

