/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.server;

import hec.clientapp.client.ClientApp;
import hec.rss.client.ObsDataPanel;
import hec.rss.model.Element;
import hec.rss.model.ReachElement;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.model.TimeStepRoutingElement;
import hec.rss.server.LossesPanel;
import hec.rss.server.ReachDlg$1;
import hec.rss.server.ReachDlg$2;
import hec.rss.server.routing.RoutingDialogParent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.ClosableDialog;
import rma.swing.RmaInsets;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaNavigationPanel;
import rma.util.RMAIO;

public class ReachDlg
extends RoutingDialogParent
implements ActionListener,
ItemListener,
ClosableDialog {
    JTabbedPane _tabbedPane;
    JPanel jPanel2;
    JLabel nameLbl;
    JLabel descriptionLbl;
    RmaJDescriptionField descriptionTxt;
    RmaJComboBox<String> reachCmb;
    ButtonCmdPanel _cmdPanel;
    private JMenu _reachMenu = new JMenu("Reach");
    private JMenuItem _closeReachMenuItem = new JMenuItem("Close", 99);
    private LossesPanel lossesPanel = null;
    private ObsDataPanel obsDataPanel = null;
    private RssSystem _system = null;
    private String _currentReach = null;
    private boolean _canceled = false;
    private String _modelName = "Rss";
    private RmaJColorComboBox _fillColorCombo;
    private Object[] _defaultFillColor;

    public ReachDlg(Frame frame, boolean bl, String string) {
        super(frame, bl);
        this._modelName = string;
        this.buildMenus();
        this.initLayout();
        this.buildGui();
        this.setTitle("Reach Editor");
        this.addTabPanels(string);
        this.addListeners();
        ReachDlg reachDlg = this;
        reachDlg.setLocationRelativeTo(reachDlg.getParent());
        this.setDefaultCloseOperation(0);
    }

    private void addTabPanels(String string) {
        if (string.equalsIgnoreCase("Rss")) {
            this.lossesPanel = new LossesPanel();
            this.obsDataPanel = new ObsDataPanel();
            this._tabbedPane.addTab("Routing", null, (Component)((Object)this._routingPanel));
            this._tabbedPane.addTab("Losses", null, this.lossesPanel);
            this._tabbedPane.addTab("Observed Data", null, this.obsDataPanel);
            return;
        }
        if (string.equalsIgnoreCase("RssLp")) {
            this._tabbedPane.addTab("Routing", null, (Component)((Object)this._routingPanel));
        }
    }

    private void addListeners() {
        this.addWindowListener();
        this.addCommandPanelListeners();
        this.addReachListener();
        this.addTabChangeListener();
    }

    private void addReachListener() {
        this.reachCmb.addItemListener((ItemListener)this);
    }

    private void addWindowListener() {
        this.addWindowListener(new ReachDlg$1(this));
    }

    private void addCommandPanelListeners() {
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new ReachDlg$2(this));
    }

    private void buildGui() {
        this.jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.nameLbl = new JLabel("Reach Name");
        this.nameLbl.setDisplayedMnemonic('R');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jPanel2.add((Component)this.nameLbl, gridBagConstraints);
        this.descriptionLbl = new JLabel("Description");
        this.descriptionLbl.setDisplayedMnemonic('D');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(7, 5, 0, 0);
        this.jPanel2.add((Component)this.descriptionLbl, gridBagConstraints);
        this.descriptionTxt = new RmaJDescriptionField();
        this.descriptionLbl.setLabelFor((Component)this.descriptionTxt);
        this.descriptionTxt.setMargin(new Insets(0, 0, 0, 0));
        this.descriptionTxt.setLineWrap(true);
        this.descriptionTxt.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        gridBagConstraints.ipadx = 200;
        this.jPanel2.add((Component)this.descriptionTxt, gridBagConstraints);
        this.reachCmb = new RmaJComboBox();
        this.nameLbl.setLabelFor((Component)this.reachCmb);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jPanel2.add((Component)this.reachCmb, gridBagConstraints);
        Object object = new RmaNavigationPanel();
        object.fillForm(this.reachCmb);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.jPanel2.add((Component)object, gridBagConstraints);
        this._tabbedPane = new JTabbedPane();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 5, 0, 5);
        gridBagConstraints.ipadx = 499;
        gridBagConstraints.ipady = 223;
        this.getContentPane().add((Component)this._tabbedPane, gridBagConstraints);
        object = new JPanel(new GridBagLayout());
        ((JComponent)object).setOpaque(true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this.getContentPane().add((Component)object, gridBagConstraints);
        JLabel jLabel = new JLabel("Reach Fill Color:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)object).add((Component)jLabel, gridBagConstraints);
        this._fillColorCombo = new RmaJColorComboBox();
        this._fillColorCombo.setModifiable(true);
        this._defaultFillColor = new Object[]{Color.WHITE, "Default"};
        this._fillColorCombo.addItem((Object)this._defaultFillColor);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)object).add((Component)this._fillColorCombo, gridBagConstraints);
        this._cmdPanel = new ButtonCmdPanel(14);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this._cmdPanel, gridBagConstraints);
    }

    private void initLayout() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setVisible(false);
        this.setSize(550, 630);
    }

    private void buildMenus() {
        this.buildReachMenu();
        ReachDlg reachDlg = this;
        reachDlg.addMenu(reachDlg._reachMenu, 0);
    }

    private void buildReachMenu() {
        this._reachMenu.add(this._closeReachMenuItem);
        this._closeReachMenuItem.addActionListener(this);
        this._reachMenu.setMnemonic('R');
    }

    private void addTabChangeListener() {
        this._tabbedPane.addChangeListener(changeEvent -> this.tabChanged());
    }

    private void tabChanged() {
        String string = this._tabbedPane.getTitleAt(this._tabbedPane.getSelectedIndex());
        if ("Routing".equals(string)) {
            this.addRoutingMenu();
            return;
        }
        this.removeRoutingMenu();
    }

    public void addNotify() {
        super.addNotify();
        this.getRootPane().setDefaultButton(null);
    }

    public ReachDlg(Frame frame, boolean bl) {
        this(frame, bl, "Rss");
        ReachDlg reachDlg = this;
        reachDlg.setLocationRelativeTo(reachDlg.getParent());
    }

    public ReachDlg(Frame frame, String string, boolean bl) {
        this(frame, bl);
        this.setTitle(string);
        ReachDlg reachDlg = this;
        reachDlg.setLocationRelativeTo(reachDlg.getParent());
    }

    public boolean closeDialog() {
        this.setVisible(false);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._closeReachMenuItem) {
            this.buttonCancelAction();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent object) {
        if (((ItemEvent)object).getStateChange() == 2) {
            return;
        }
        if ((object = ((EventObject)object).getSource()) == this.reachCmb) {
            this.reachChoice_StateChange();
        }
    }

    void buttonOkAction() {
        ReachDlg reachDlg = this;
        reachDlg.saveForm(reachDlg._currentReach);
        this.setVisible(false);
        this.setCanceled(false);
        this.dispose();
    }

    void buttonApplyAction() {
        ReachDlg reachDlg = this;
        reachDlg.saveForm(reachDlg._currentReach);
    }

    void buttonCancelAction() {
        if (this.isModified() && this.isEditable()) {
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), "Data Has Changed. Save before closing?", "Save Changes?", 1);
            if (n == 2) {
                return;
            }
            if (n == 0) {
                this.saveForm();
            }
            this.setModified(false);
        }
        this.setVisible(false);
        this.setCanceled(true);
        this.dispose();
    }

    void setCanceled(boolean bl) {
        this._canceled = bl;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void saveForm() {
        ReachDlg reachDlg = this;
        reachDlg.saveForm(reachDlg._currentReach);
    }

    public void saveForm(String object) {
        String string;
        if (!this.isVisible()) {
            return;
        }
        if (this._system == null) {
            return;
        }
        if (object == null) {
            return;
        }
        if ((object = this._system.findReach((String)object)) == null) {
            return;
        }
        this._routingPanel.savePanel((Element)object);
        if (this.lossesPanel != null) {
            this.lossesPanel.savePanel((ReachElement)object);
        }
        if (this.obsDataPanel != null) {
            this.obsDataPanel.savePanel((Element)object);
        }
        if ("Default".equals(string = this._fillColorCombo.getSelectedColorName())) {
            string = null;
        }
        ((ReachElement)object).setFillColorName(string);
        object.setDescription(this.descriptionTxt.getText());
        this._system.setModified(true);
        this.setModified(false);
        ClientApp.frame().getMapPanel().paintMap();
    }

    public boolean initDlg() {
        if (this._system == null) {
            RMAIO.postError((Component)((Object)this), (String)"Invalid Reservoir Network");
            return false;
        }
        String[] stringArray = this._system.getReachNames();
        if (stringArray == null || stringArray.length == 0) {
            RMAIO.postError((Component)((Object)this), (String)"Need to create a Reach first");
            return false;
        }
        this.reachCmb.removeAllItems();
        this.reachCmb.removeItemListener((ItemListener)this);
        for (int i = 0; i < stringArray.length; ++i) {
            this.reachCmb.addItem((Object)stringArray[i]);
        }
        this.addReachListener();
        this._currentReach = (String)this.reachCmb.getSelectedItem();
        ReachDlg reachDlg = this;
        reachDlg.fillForm(reachDlg._currentReach);
        return true;
    }

    @Deprecated
    public void initForm() {
        if (this._system == null) {
            return;
        }
        String[] stringArray = this._system.getReachNames();
        if (stringArray == null) {
            return;
        }
        this.reachCmb.removeAllItems();
        this.reachCmb.removeItemListener((ItemListener)this);
        for (int i = 0; i < stringArray.length; ++i) {
            this.reachCmb.addItem((Object)stringArray[i]);
        }
        this.addReachListener();
        this._currentReach = (String)this.reachCmb.getSelectedItem();
        ReachDlg reachDlg = this;
        reachDlg.fillForm(reachDlg._currentReach);
    }

    public void selectReach(String string) {
        if (string == null) {
            return;
        }
        this.reachCmb.setSelectedItem((Object)string);
        this._currentReach = string;
        ReachDlg reachDlg = this;
        reachDlg.fillForm(reachDlg._currentReach);
    }

    public void fillForm(String object) {
        if (object == null) {
            return;
        }
        if (this._system == null) {
            return;
        }
        if ((object = this._system.findReach((String)object)) == null) {
            return;
        }
        this.descriptionTxt.setText(object.getDescription());
        String string = ((ReachElement)object).getFillColorName();
        if (string == null) {
            this._fillColorCombo.setSelectedItem((Object)this._defaultFillColor);
        } else {
            this._fillColorCombo.setSelectedColorName(string);
        }
        if (this._modelName.equalsIgnoreCase("RssLp")) {
            this._routingPanel.setupForRssLp();
        }
        this._routingPanel.setTablePrintHeaders(this._system, (Element)object);
        this._routingPanel.fillPanel((TimeStepRoutingElement)object);
        if (this.lossesPanel != null) {
            this.lossesPanel.setTablePrintHeaders(this._system, (ReachElement)object);
        }
        if (this.lossesPanel != null) {
            this.lossesPanel.fillPanel((ReachElement)object);
        }
        if (this.obsDataPanel != null) {
            this.obsDataPanel.fillPanel((Element)object);
        }
        this.setModified(false);
    }

    public void clearForm() {
        this.descriptionTxt.setText("");
        this._routingPanel.clearPanel();
        if (this.lossesPanel != null) {
            this.lossesPanel.clearPanel();
        }
        if (this.obsDataPanel != null) {
            this.obsDataPanel.clearPanel();
        }
    }

    public void setSystem(RssSystem rssSystem) {
        this._system = rssSystem;
        this.setTitle("Reach Editor - Network: " + rssSystem.getName());
    }

    public void reachChoice_StateChange() {
        String string;
        if (this.isModified() && this.isVisible() && this._currentReach != null) {
            ReachDlg reachDlg = this;
            int n = JOptionPane.showConfirmDialog((Component)((Object)reachDlg), "Reach " + reachDlg._currentReach + " has changed.  Save Changes?", "Save Changes to Reach", 0);
            if (n == 0) {
                ReachDlg reachDlg2 = this;
                reachDlg2.saveForm(reachDlg2._currentReach);
            }
        }
        if ((string = (String)this.reachCmb.getSelectedItem()) == null) {
            return;
        }
        this._currentReach = string;
        this.fillForm(string);
    }

    public void setAlternative(RssAlt rssAlt) {
        this._routingPanel.setAlternative(rssAlt);
    }
}

