/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.server;

import hec.clientapp.client.ClientApp;
import hec.data.Parameter;
import hec.model.PairedValues;
import hec.model.PairedValuesTableModel;
import hec.rss.gfx2d.SimpleJTableData;
import hec.rss.model.Function;
import hec.rss.model.LagAndKRouting;
import hec.rss.server.RoutingPanel;
import hec.rss.server.RoutingPanel$IRoutingPanel;
import hec.rss.server.RoutingPanel$LagKDPanel$1;
import hec.rss.server.RoutingPanel$LagKDPanel$2;
import hec.rss.server.RoutingPanel$MyG2dPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.util.RMAIO;

class RoutingPanel$LagKDPanel
extends JPanel
implements RoutingPanel$IRoutingPanel<LagAndKRouting>,
ActionListener {
    private RmaJDecimalField _lagConst;
    private RmaJDecimalField _kConst;
    SimpleJTableData _lagData = this.getLagData();
    SimpleJTableData _kData = this.getKData();
    private RmaJRadioButton _lagConstRB;
    private RmaJRadioButton _lagVaryingRB;
    private RmaJRadioButton _kConstRB;
    private RmaJRadioButton _kVaryingRB;
    private RmaJTable _lagTable;
    private RmaJTable _kTable;
    RoutingPanel$MyG2dPanel lagPlot;
    RoutingPanel$MyG2dPanel kPlot;
    LagAndKRouting _vlk;
    final /* synthetic */ RoutingPanel this$0;

    public RoutingPanel$LagKDPanel(RoutingPanel routingPanel) {
        this.this$0 = routingPanel;
        this.initComponents();
        this._vlk = new LagAndKRouting();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        Serializable serializable = new JPanel(new GridBagLayout());
        Object object = new GridBagConstraints();
        ((JComponent)serializable).setBorder(BorderFactory.createTitledBorder("Lag Values"));
        object.gridx = 0;
        object.gridy = 0;
        object.gridwidth = 3;
        object.gridheight = 1;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.anchor = 17;
        object.fill = 1;
        object.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        this.add((Component)serializable, object);
        JPanel jPanel = new JPanel(new GridBagLayout());
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.gridwidth = 2;
        object.gridheight = 4;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.anchor = 17;
        object.fill = 2;
        object.insets = RmaInsets.insets((int)10, (int)0, (int)0, (int)0);
        ((Container)serializable).add(jPanel, object);
        this._lagConstRB = new RmaJRadioButton("Constant Lag (hrs)");
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.anchor = 17;
        object.fill = 0;
        object.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        jPanel.add((Component)this._lagConstRB, object);
        this._lagConst = new RmaJDecimalField();
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        object.gridy = 0;
        object.anchor = 17;
        object.fill = 2;
        object.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)65);
        jPanel.add((Component)this._lagConst, object);
        this._lagVaryingRB = new RmaJRadioButton("Lag vs. Inflow");
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 1;
        object.gridheight = 1;
        object.anchor = 17;
        object.fill = 0;
        object.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        jPanel.add((Component)this._lagVaryingRB, object);
        object = new String[]{"Inflow (%S)", "Lag (hrs.)"};
        this._lagTable = new RmaJTable((Component)this);
        object = new PairedValuesTableModel(object, new boolean[]{true, true});
        PairedValues pairedValues = new PairedValues();
        pairedValues.setUnitSystem(ClientApp.Workspace().getUnitSystem());
        pairedValues.setParamXId(Parameter.PARAMID_FLOW);
        pairedValues.setParamYId(Parameter.PARAMID_TRAVEL);
        this._lagTable.setModel((TableModel)object);
        ((PairedValuesTableModel)this._lagTable.getModel()).setShouldAddBlankRows(true);
        ((PairedValuesTableModel)this._lagTable.getModel()).setPairedValues(pairedValues);
        this._lagTable.setDoubleCellEditor();
        this._lagTable.setUnitsHeaderRenderer();
        this._lagTable.addCellEditorListener((CellEditorListener)new RoutingPanel$LagKDPanel$1(this));
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 2;
        object.gridheight = 4;
        object.gridwidth = 2;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.ipadx = 100;
        object.ipady = 100;
        object.anchor = 17;
        object.fill = 1;
        object.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        jPanel.add((Component)this._lagTable.getScrollPane(), object);
        this.lagPlot = new RoutingPanel$MyG2dPanel(this.this$0);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        object.gridy = 0;
        object.gridwidth = 1;
        object.gridheight = 1;
        object.ipadx = 100;
        object.ipady = 100;
        object.anchor = 12;
        object.fill = 1;
        object.insets = RmaInsets.insets((int)0, (int)10, (int)0, (int)10);
        ((Container)serializable).add((Component)((Object)this.lagPlot), object);
        this.this$0.configureLagPlot(this.lagPlot);
        serializable = new Vector<SimpleJTableData>();
        ((Vector)serializable).addElement(this._lagData);
        this.lagPlot.setPlotObjects((List)((Object)serializable));
        this.lagPlot.paintGfx();
        this.lagReplot();
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add((AbstractButton)this._lagConstRB);
        ((ButtonGroup)serializable).add((AbstractButton)this._lagVaryingRB);
        serializable = new JPanel(new GridBagLayout());
        ((JComponent)serializable).setBorder(BorderFactory.createTitledBorder("K Values"));
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 1;
        object.gridheight = 1;
        object.gridwidth = 3;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.anchor = 17;
        object.fill = 1;
        object.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)5);
        this.add((Component)serializable, object);
        jPanel = new JPanel(new GridBagLayout());
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.gridwidth = 2;
        object.gridheight = 4;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.anchor = 17;
        object.fill = 2;
        object.insets = RmaInsets.insets((int)10, (int)0, (int)0, (int)0);
        ((Container)serializable).add(jPanel, object);
        this._kConstRB = new RmaJRadioButton("Constant K (hrs)");
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.anchor = 17;
        object.fill = 0;
        object.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        jPanel.add((Component)this._kConstRB, object);
        this._kConst = new RmaJDecimalField();
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        object.gridy = 0;
        object.anchor = 17;
        object.fill = 2;
        object.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)65);
        jPanel.add((Component)this._kConst, object);
        this._kVaryingRB = new RmaJRadioButton("K vs. Outflow");
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 1;
        object.anchor = 17;
        object.fill = 0;
        object.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        jPanel.add((Component)this._kVaryingRB, object);
        object = new String[]{"Outflow (%S)", "K (hrs.)"};
        this._kTable = new RmaJTable((Component)this);
        object = new PairedValuesTableModel(object, new boolean[]{true, true});
        pairedValues = new PairedValues();
        pairedValues.setUnitSystem(ClientApp.Workspace().getUnitSystem());
        pairedValues.setParamXId(Parameter.PARAMID_FLOW);
        pairedValues.setParamYId(Parameter.PARAMID_TRAVEL);
        this._kTable.setModel((TableModel)object);
        ((PairedValuesTableModel)this._kTable.getModel()).setShouldAddBlankRows(true);
        ((PairedValuesTableModel)this._kTable.getModel()).setPairedValues(pairedValues);
        this._kTable.setDoubleCellEditor();
        this._kTable.setUnitsHeaderRenderer();
        this._kTable.addCellEditorListener((CellEditorListener)new RoutingPanel$LagKDPanel$2(this));
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 2;
        object.gridheight = 2;
        object.gridwidth = 2;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.ipadx = 100;
        object.ipady = 100;
        object.anchor = 10;
        object.fill = 1;
        object.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        jPanel.add((Component)this._kTable.getScrollPane(), object);
        this.kPlot = new RoutingPanel$MyG2dPanel(this.this$0);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        object.gridy = 0;
        object.gridwidth = 1;
        object.gridheight = 1;
        object.weightx = 0.0;
        object.weighty = 0.0;
        object.ipadx = 100;
        object.ipady = 100;
        object.anchor = 11;
        object.fill = 1;
        object.insets = RmaInsets.insets((int)0, (int)10, (int)5, (int)10);
        ((Container)serializable).add((Component)((Object)this.kPlot), object);
        this.this$0.configureKPlot(this.kPlot);
        serializable = new Vector<SimpleJTableData>();
        ((Vector)serializable).addElement(this._kData);
        this.kPlot.setPlotObjects((List)((Object)serializable));
        this.kReplot();
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add((AbstractButton)this._kConstRB);
        ((ButtonGroup)serializable).add((AbstractButton)this._kVaryingRB);
        this._lagConstRB.addActionListener((ActionListener)this);
        this._lagVaryingRB.addActionListener((ActionListener)this);
        this._kConstRB.addActionListener((ActionListener)this);
        this._kVaryingRB.addActionListener((ActionListener)this);
        if (!this._lagConstRB.isSelected() && !this._lagVaryingRB.isSelected()) {
            this._lagConstRB.setSelected(true);
            this.enableLagTable(false);
        }
        if (!this._kConstRB.isSelected() && !this._kVaryingRB.isSelected()) {
            this._kConstRB.setSelected(true);
            this.enableKTable(false);
        }
    }

    @Override
    public void clearPanel() {
        this._lagConst.setText("");
        this._kConst.setText("");
        this._lagTable.clearCells();
        this._kTable.clearCells();
        this._lagConstRB.setSelected(true);
        this._lagVaryingRB.setSelected(false);
        this.enableLagTable(false);
        this._kConstRB.setSelected(true);
        this._kVaryingRB.setSelected(false);
        this.enableKTable(false);
        this._lagTable.commitEdit(true);
        this._kTable.commitEdit(true);
        this._lagData.clearData();
        this._kData.clearData();
    }

    private void lagReplot() {
        Vector<SimpleJTableData> vector = new Vector<SimpleJTableData>();
        this._lagData.xunits = "Inflow (%S)";
        this._lagData.yunits = "Lag (hrs.)";
        this._lagData.setData(this._lagTable, 0, 1);
        this._lagData.name = "Lag";
        vector.addElement(this._lagData);
        this.lagPlot.setPlotObjects(vector);
    }

    private SimpleJTableData getLagData() {
        SimpleJTableData simpleJTableData = new SimpleJTableData();
        new SimpleJTableData().xunits = "Inflow (%S)";
        simpleJTableData.yunits = "Lag (hrs.)";
        simpleJTableData.setData(null, -1, -1);
        simpleJTableData.addToPairedDataContainerReveresed(false);
        return simpleJTableData;
    }

    private void kReplot() {
        Vector<SimpleJTableData> vector = new Vector<SimpleJTableData>();
        this._kData.xunits = "Outflow (%S)";
        this._kData.yunits = "K (hrs.)";
        this._kData.setData(this._kTable, 0, 1);
        this._kData.name = "K";
        vector.addElement(this._kData);
        this.kPlot.setPlotObjects(vector);
    }

    private SimpleJTableData getKData() {
        SimpleJTableData simpleJTableData = new SimpleJTableData();
        new SimpleJTableData().xunits = "Outflow (%S)";
        simpleJTableData.yunits = "K (hrs.)";
        simpleJTableData.setData(null, -1, -1);
        simpleJTableData.addToPairedDataContainerReveresed(false);
        return simpleJTableData;
    }

    protected void enableKTable(boolean bl) {
        this._kTable.setEnabled(bl);
        this._kTable.setBackground(bl ? Color.white : RoutingPanel.a);
        this._kTable.setEnabled(bl);
        this._kConst.setEnabled(!bl);
    }

    @Override
    public boolean canHandleFunction(Function function) {
        return function.getClass().equals(LagAndKRouting.class);
    }

    @Override
    public void savePanel(LagAndKRouting lagAndKRouting) {
        String string;
        if (lagAndKRouting == null) {
            lagAndKRouting = this._vlk;
        }
        if (this._lagConstRB.isSelected()) {
            lagAndKRouting.setIsConstantLag(true);
            if (RMAIO.parseDouble((String)this._lagConst.getText()) == Double.NEGATIVE_INFINITY || RMAIO.parseDouble((String)this._lagConst.getText()) == 0.0) {
                string = "Constant Lag value missing or equal to zero";
                JOptionPane.showMessageDialog(this, string, "Incomplete Form", 2);
            } else {
                lagAndKRouting.setConstantLag(RMAIO.parseDouble((String)this._lagConst.getText()));
            }
        } else {
            lagAndKRouting.setIsConstantLag(false);
        }
        this._lagTable.commitEdit(true);
        string = new PairedValues();
        ((PairedValuesTableModel)this._lagTable.getModel()).storeData((PairedValues)string);
        if (!lagAndKRouting.isConstantLag() && string.size() == 0) {
            string = "Lag vs. Inflow values are missing";
            JOptionPane.showMessageDialog(this, string, "Incomplete Form", 2);
        } else {
            lagAndKRouting.setInflowLagTable((PairedValues)string);
        }
        if (this._kConstRB.isSelected()) {
            lagAndKRouting.setIsConstantK(true);
            if (RMAIO.parseDouble((String)this._kConst.getText()) == Double.NEGATIVE_INFINITY || RMAIO.parseDouble((String)this._kConst.getText()) == 0.0) {
                string = "Constant K value missing or equal to zero";
                JOptionPane.showMessageDialog(this, string, "Incomplete Form", 2);
            } else {
                lagAndKRouting.setConstantK(RMAIO.parseDouble((String)this._kConst.getText()));
            }
        } else {
            lagAndKRouting.setIsConstantK(false);
        }
        this._kTable.commitEdit(true);
        string = new PairedValues();
        ((PairedValuesTableModel)this._kTable.getModel()).storeData((PairedValues)string);
        if (!lagAndKRouting.isConstantK() && string.size() == 0) {
            string = "K vs. Outflow values are missing";
            JOptionPane.showMessageDialog(this, string, "Incomplete Form", 2);
            return;
        }
        lagAndKRouting.setOutflowKTable((PairedValues)string);
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if ((object = ((EventObject)object).getSource()) == this._lagConstRB) {
            this.enableLagTable(false);
            return;
        }
        if (object == this._lagVaryingRB) {
            this.enableLagTable(true);
            return;
        }
        if (object == this._kConstRB) {
            this.enableKTable(false);
            return;
        }
        if (object == this._kVaryingRB) {
            this.enableKTable(true);
        }
    }

    @Override
    public LagAndKRouting getFunction() {
        return this._vlk;
    }

    @Override
    public void fillPanel(LagAndKRouting lagAndKRouting) {
        this._vlk = lagAndKRouting;
        if (lagAndKRouting.isConstantLag()) {
            this._lagConstRB.setSelected(true);
            this.enableLagTable(false);
        } else {
            this._lagVaryingRB.setSelected(true);
            this.enableLagTable(true);
        }
        this._lagConst.setValue(lagAndKRouting.getConstantLag());
        PairedValues pairedValues = lagAndKRouting.getInflowLagTable();
        if (pairedValues != null) {
            pairedValues.setUnitSystem(ClientApp.Workspace().getUnitSystem());
            pairedValues.setParamXId(Parameter.PARAMID_FLOW);
            pairedValues.setParamYId(Parameter.PARAMID_TRAVEL);
            ((PairedValuesTableModel)this._lagTable.getModel()).setPairedValues(pairedValues);
            this._lagTable.setUnitsHeaderRenderer();
            this.lagReplot();
        }
        if (lagAndKRouting.isConstantK()) {
            this._kConstRB.setSelected(true);
            this.enableKTable(false);
        } else {
            this._kVaryingRB.setSelected(true);
            this.enableKTable(true);
        }
        this._kConst.setValue(lagAndKRouting.getConstantK());
        pairedValues = lagAndKRouting.getOutflowKTable();
        if (pairedValues != null) {
            pairedValues.setUnitSystem(ClientApp.Workspace().getUnitSystem());
            pairedValues.setParamXId(Parameter.PARAMID_FLOW);
            pairedValues.setParamYId(Parameter.PARAMID_TRAVEL);
            ((PairedValuesTableModel)this._kTable.getModel()).setPairedValues(pairedValues);
            this._kTable.setUnitsHeaderRenderer();
            this.kReplot();
        }
    }

    protected void enableLagTable(boolean bl) {
        this._lagTable.setEnabled(bl);
        this._lagTable.setBackground(bl ? Color.white : RoutingPanel.a);
        this._lagTable.setEnabled(bl);
        this._lagConst.setEnabled(!bl);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }
}

