/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.server;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.rss.model.Channel;
import hec.rss.model.ChannelType;
import hec.rss.model.CircularChannel;
import hec.rss.model.Function;
import hec.rss.model.MuskingumCungePrismRouting;
import hec.rss.model.MuskingumCungeRouting;
import hec.rss.model.TrapezoidalChannel;
import hec.rss.server.RoutingPanel;
import hec.rss.server.RoutingPanel$IRoutingPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import rma.services.ServiceLookup;
import rma.services.units.UnitsComponent;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJRadioButton;
import rma.util.NumberFormat;
import rma.util.RMAConst;
import rma.util.RMAIO;

class RoutingPanel$MuskingumCungePrismPanel
extends JPanel
implements RoutingPanel$IRoutingPanel<MuskingumCungeRouting>,
UnitsComponent {
    private RmaJDecimalField _channelLength;
    private RmaJDecimalField _channelSlope;
    private RmaJDecimalField _refQDf;
    private JPanel _mcStabilityFactors;
    private RmaJLabel _channelSlopeLabel;
    private RmaJComboBox _subIntervals;
    private JPanel _channelShape;
    private RmaJDecimalField _bottomWidth;
    private RmaJDecimalField _sideSlope;
    private JRadioButton _prismaticRadioButton;
    private JRadioButton _circularRadioButton;
    private RmaJDecimalField _channelDiameter;
    private RmaJDecimalField _manning;
    private JLabel _jLabel13;
    private JLabel _jLabel14;
    private JLabel _jLabel19;
    private ButtonGroup _bGroup1;
    MuskingumCungeRouting _function;
    final /* synthetic */ RoutingPanel this$0;

    private RoutingPanel$MuskingumCungePrismPanel(RoutingPanel routingPanel) {
        this.this$0 = routingPanel;
        this.initComponents();
        this._function = new MuskingumCungeRouting();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        Object object = "Channel Length (%S)";
        object = new RmaJLabel((String)object);
        ((JLabel)object).setLabelFor((Component)this._channelLength);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)20, (int)0, (int)0);
        this.add((Component)object, gridBagConstraints);
        this._channelLength = new RmaJDecimalField();
        this._channelLength.setMinValue(0.0);
        this._channelLength.setMargin(RmaInsets.INSETS0000);
        this._channelLength.setAutoscrolls(false);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5000;
        RoutingPanel$MuskingumCungePrismPanel routingPanel$MuskingumCungePrismPanel = this;
        routingPanel$MuskingumCungePrismPanel.add((Component)routingPanel$MuskingumCungePrismPanel._channelLength, gridBagConstraints);
        ((JLabel)object).setLabelFor((Component)this._channelLength);
        this.this$0._undefParamDouble.setParameterId(Parameter.PARAMID_LENGTH);
        this._channelLength.setValue(this.this$0._undefParamDouble);
        this._channelSlope = new RmaJDecimalField();
        this._channelSlope.setMinValue(0.0);
        this._channelSlope.setMargin(RmaInsets.INSETS0000);
        this._channelSlope.setAutoscrolls(false);
        this._channelSlope.setSelectionColor(new Color(0));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5000;
        RoutingPanel$MuskingumCungePrismPanel routingPanel$MuskingumCungePrismPanel2 = this;
        routingPanel$MuskingumCungePrismPanel2.add((Component)routingPanel$MuskingumCungePrismPanel2._channelSlope, gridBagConstraints);
        this._manning = new RmaJDecimalField();
        this._manning.setMaxValue(1.0);
        this._manning.setMargin(RmaInsets.INSETS0000);
        this._manning.setAutoscrolls(false);
        this._manning.setSelectionColor(new Color(0));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)0, (int)5, (int)0);
        RoutingPanel$MuskingumCungePrismPanel routingPanel$MuskingumCungePrismPanel3 = this;
        routingPanel$MuskingumCungePrismPanel3.add((Component)routingPanel$MuskingumCungePrismPanel3._manning, gridBagConstraints);
        object = "Channel Slope (%S)";
        this._channelSlopeLabel = new RmaJLabel((String)object);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)20, (int)0, (int)0);
        RoutingPanel$MuskingumCungePrismPanel routingPanel$MuskingumCungePrismPanel4 = this;
        routingPanel$MuskingumCungePrismPanel4.add((Component)routingPanel$MuskingumCungePrismPanel4._channelSlopeLabel, gridBagConstraints);
        object = new RmaJLabel("Manning's n");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)20, (int)5, (int)0);
        this.add((Component)object, gridBagConstraints);
        this._mcStabilityFactors = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)8, (int)5, (int)5, (int)5);
        RoutingPanel$MuskingumCungePrismPanel routingPanel$MuskingumCungePrismPanel5 = this;
        routingPanel$MuskingumCungePrismPanel5.add((Component)routingPanel$MuskingumCungePrismPanel5._mcStabilityFactors, gridBagConstraints);
        object = "Default Reference Flow (%S)";
        object = new RmaJLabel((String)object);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)25, (int)3, (int)10);
        this._mcStabilityFactors.add((Component)object, gridBagConstraints);
        this._refQDf = new RmaJDecimalField();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)25, (int)3, (int)0);
        gridBagConstraints.ipadx = 70;
        this._mcStabilityFactors.add((Component)this._refQDf, gridBagConstraints);
        ((JLabel)object).setLabelFor((Component)this._refQDf);
        object = new RmaJLabel("Routing Timestep Subintervals");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)25, (int)3, (int)10);
        this._mcStabilityFactors.add((Component)object, gridBagConstraints);
        this._subIntervals = new RmaJComboBox((Object[])RoutingPanel.b);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)25, (int)3, (int)0);
        this._mcStabilityFactors.add((Component)this._subIntervals, gridBagConstraints);
        this._channelShape = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)15, (int)0);
        RoutingPanel$MuskingumCungePrismPanel routingPanel$MuskingumCungePrismPanel6 = this;
        routingPanel$MuskingumCungePrismPanel6.add((Component)routingPanel$MuskingumCungePrismPanel6._channelShape, gridBagConstraints);
        this._jLabel13 = new RmaJLabel("Bottom Width (%S)");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)3, (int)10, (int)0, (int)10);
        this._channelShape.add((Component)this._jLabel13, gridBagConstraints);
        this._jLabel14 = new RmaJLabel("Side Slope (h/v)");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)10, (int)0, (int)10);
        this._channelShape.add((Component)this._jLabel14, gridBagConstraints);
        this._bottomWidth = new RmaJDecimalField();
        this._bottomWidth.setMargin(RmaInsets.INSETS0000);
        this._bottomWidth.setAutoscrolls(false);
        this._bottomWidth.setSelectionColor(new Color(0));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)3, (int)10, (int)0, (int)0);
        this._jLabel13.setLabelFor((Component)this._bottomWidth);
        this._channelShape.add((Component)this._bottomWidth, gridBagConstraints);
        this.this$0._undefParamDouble.setParameterId(Parameter.PARAMID_LENGTH);
        this._bottomWidth.setValue(this.this$0._undefParamDouble);
        this._sideSlope = new RmaJDecimalField();
        this._sideSlope.setMargin(RmaInsets.INSETS0000);
        this._sideSlope.setAutoscrolls(false);
        this._sideSlope.setSelectionColor(new Color(0));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)10, (int)0, (int)0);
        this._channelShape.add((Component)this._sideSlope, gridBagConstraints);
        this._prismaticRadioButton = new RmaJRadioButton("Prismatic");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)3, (int)20, (int)0, (int)0);
        this._channelShape.add((Component)this._prismaticRadioButton, gridBagConstraints);
        object = "Channel Diameter (%S)";
        this._jLabel19 = new RmaJLabel((String)object);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)10, (int)10, (int)0, (int)10);
        this._channelShape.add((Component)this._jLabel19, gridBagConstraints);
        this._channelDiameter = new RmaJDecimalField();
        this._channelDiameter.setMargin(RmaInsets.INSETS0000);
        this._channelDiameter.setAutoscrolls(false);
        this._channelDiameter.setSelectionColor(new Color(0));
        this._channelDiameter.setAlignmentX(0.0f);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)10, (int)10, (int)0, (int)0);
        this._jLabel19.setLabelFor((Component)this._channelDiameter);
        this._channelShape.add((Component)this._channelDiameter, gridBagConstraints);
        this.this$0._undefParamDouble.setParameterId(Parameter.PARAMID_LENGTH);
        this._channelDiameter.setValue(this.this$0._undefParamDouble);
        this._circularRadioButton = new RmaJRadioButton("Circular");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)10, (int)20, (int)0, (int)0);
        this._channelShape.add((Component)this._circularRadioButton, gridBagConstraints);
        object = new JPanel();
        ((Container)object).setLayout(new FlowLayout(1, 5, 5));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 9;
        gridBagConstraints.weightx = 6.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this.add((Component)object, gridBagConstraints);
        object = "Channel Shape";
        this._channelShape.setBorder(BorderFactory.createTitledBorder((String)object));
        object = "Muskingum-Cunge Stability Control";
        this._mcStabilityFactors.setBorder(BorderFactory.createTitledBorder((String)object));
        this._circularRadioButton.addActionListener(actionEvent -> this.selectCircularChannel());
        this._prismaticRadioButton.addActionListener(actionEvent -> this.selectPrismaticChannel());
        this._bGroup1 = new ButtonGroup();
        this._bGroup1.add(this._circularRadioButton);
        this._bGroup1.add(this._prismaticRadioButton);
        this._prismaticRadioButton.setSelected(true);
    }

    void selectPrismaticChannel() {
        this._bottomWidth.setEnabled(true);
        this._sideSlope.setEnabled(true);
        this._channelDiameter.setEnabled(false);
        this._jLabel13.setEnabled(true);
        this._jLabel14.setEnabled(true);
        this._jLabel19.setEnabled(false);
    }

    void selectCircularChannel() {
        this._bottomWidth.setEnabled(false);
        this._sideSlope.setEnabled(false);
        this._channelDiameter.setEnabled(true);
        this._jLabel13.setEnabled(false);
        this._jLabel14.setEnabled(false);
        this._jLabel19.setEnabled(true);
    }

    @Override
    public void savePanel(MuskingumCungeRouting object) {
        int n;
        Object object2;
        if (this._circularRadioButton.isSelected()) {
            ((MuskingumCungeRouting)object).setChannelType(ChannelType.CIRCLE);
            object2 = ((MuskingumCungeRouting)object).getChannel();
            ((CircularChannel)object2).setDiameter(this._channelDiameter.getParamValue());
            ((CircularChannel)object2).setManningsN(this._manning.getValue());
        } else {
            ((MuskingumCungeRouting)object).setChannelType(ChannelType.TRAPEZOID);
            object2 = ((MuskingumCungeRouting)object).getChannel();
            ((TrapezoidalChannel)object2).setBottomWidth(this._bottomWidth.getParamValue());
            ((TrapezoidalChannel)object2).setSideSlope(this._sideSlope.getValue());
            ((TrapezoidalChannel)object2).setManningsN(this._manning.getValue());
        }
        ((Channel)object2).setchannelLength(this._channelLength.getParamValue());
        ((Channel)object2).setSlope(this._channelSlope.getValue());
        object2 = this._subIntervals.getSelectedItem();
        if (object2 instanceof String && (n = RMAIO.parseInt((Object)object2)) > 0) {
            ((MuskingumCungeRouting)object).setNumberOfTimestepSubintervals(n);
        }
        ((MuskingumCungeRouting)object).setMaximumExpectedFlow(this._refQDf.getParamValue());
        double d = this._refQDf.getValue();
        if (!RMAConst.isValidValue((double)d) || d <= 0.0) {
            object = "Default Reference Flow value missing, or less than or equal to zero";
            JOptionPane.showMessageDialog(this, object, "Incomplete Form", 2);
        }
    }

    @Override
    public boolean canHandleFunction(Function function) {
        return function.getClass().equals(MuskingumCungeRouting.class);
    }

    @Override
    public MuskingumCungeRouting getFunction() {
        return this._function;
    }

    @Override
    public void fillPanel(MuskingumCungeRouting object) {
        this._function = object;
        Channel channel = ((MuskingumCungeRouting)object).getChannel();
        ParamDouble paramDouble = new ParamDouble();
        this.this$0._undefParamDouble = new ParamDouble(Double.NEGATIVE_INFINITY, paramDouble.getParameterId(), ((Function)object).getUnitSystem(), 2);
        channel.getLength(paramDouble);
        paramDouble.setPrecision(2);
        this._channelLength.setValue(paramDouble);
        this._channelSlope.setPrecision(6);
        this._channelSlope.setValue(channel.getSlope());
        ((MuskingumCungeRouting)object).getMaximumExpectedFlow(paramDouble);
        this._refQDf.setValue(paramDouble);
        object = RMAIO.toString((int)((MuskingumCungeRouting)object).getNumberOfTimestepSubintervals());
        this._subIntervals.setSelectedItem(object);
        if (channel instanceof TrapezoidalChannel) {
            this._prismaticRadioButton.setSelected(true);
            object = (TrapezoidalChannel)channel;
            this._manning.setPrecision(3);
            this._manning.setValue(((TrapezoidalChannel)object).getManningsN());
            this._sideSlope.setPrecision(3);
            this._sideSlope.setValue(((TrapezoidalChannel)object).getSideSlope());
            ((TrapezoidalChannel)object).getBottomWidth(paramDouble);
            this._bottomWidth.setPrecision(2);
            this._bottomWidth.setValue(paramDouble);
            this._channelDiameter.setValue(this.this$0._undefParamDouble);
            this.selectPrismaticChannel();
            return;
        }
        if (channel instanceof CircularChannel) {
            this._circularRadioButton.setSelected(true);
            object = (CircularChannel)channel;
            this._manning.setPrecision(3);
            this._manning.setValue(((CircularChannel)object).getManningsN());
            ((CircularChannel)object).getDiameter(paramDouble);
            this._channelDiameter.setValue(paramDouble);
            this._bottomWidth.setValue(this.this$0._undefParamDouble);
            this._sideSlope.setValue(this.this$0._undefParamDouble);
            this.selectCircularChannel();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void fillPanel(MuskingumCungePrismRouting var1_1) {
        var1_1.setIsSI(false);
        var2_2 = new ParamDouble();
        var1_1.getchannelLength(var2_2);
        var2_2.setPrecision(2);
        this._channelLength.setValue(var2_2);
        var3_3 /* !! */  = var1_1.getchannelSlope();
        this._channelSlope.setText(new NumberFormat("%.6f").form(var3_3 /* !! */ [0]));
        var3_3 /* !! */  = var1_1.getmanningsN();
        this._manning.setText(new NumberFormat("%.3f").form(var3_3 /* !! */ [0]));
        v0 = var1_1.getchannelType();
        var3_3 /* !! */  = v0;
        if (v0 == null) ** GOTO lbl-1000
        if (var3_3 /* !! */ [0] == 80 || var3_3 /* !! */ [0] == 112) {
            this._prismaticRadioButton.setSelected(true);
        } else if (var3_3 /* !! */ [0] == 67 || var3_3 /* !! */ [0] == 99) {
            this._circularRadioButton.setSelected(true);
        } else lbl-1000:
        // 2 sources

        {
            this._prismaticRadioButton.setSelected(true);
        }
        var1_1.getbottomWidth(var2_2);
        this.this$0._undefParamDouble = new ParamDouble(-Infinity, var2_2.getParameterId(), var1_1.getUnitSystem(), 2);
        if (this._circularRadioButton.isSelected()) {
            var1_1.getbottomWidth();
            this._channelDiameter.setValue(var2_2);
            this._bottomWidth.setValue(this.this$0._undefParamDouble);
            this._sideSlope.setValue(this.this$0._undefParamDouble);
            this.selectCircularChannel();
            return;
        }
        if (this._prismaticRadioButton.isSelected()) {
            this._bottomWidth.setValue(var2_2);
            var3_3 /* !! */  = var1_1.getsideSlope();
            this._sideSlope.setText(new NumberFormat("%.3f").form(var3_3 /* !! */ [0]));
            this._channelDiameter.setValue(this.this$0._undefParamDouble);
            this.selectPrismaticChannel();
        }
    }

    @Override
    public void clearPanel() {
        this.this$0._undefParamDouble.setParameterId(Parameter.PARAMID_LENGTH);
        this._channelLength.setValue(this.this$0._undefParamDouble);
        this._channelSlope.setText("");
        this._sideSlope.setText("");
        this._manning.setText("");
    }

    public String getDisplayUnitsString(int n) {
        return "";
    }

    public void setDisplayScaleFactor(int n, double d) {
    }

    public void setDisplayUnitsSystem(int n) {
        if (n == 1) {
            this._channelSlopeLabel.setText("Channel Slope (ft/ft)");
        } else {
            this._channelSlopeLabel.setText("Channel Slope (m/m)");
        }
        this._channelSlopeLabel.invalidate();
        this._channelSlopeLabel.repaint();
        ServiceLookup.getUnitsDisplayService().updateUnitSystem((Container)this);
    }
}

