/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.server;

import hec.clientapp.client.ClientApp;
import hec.data.Parameter;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.model.PairedValues;
import hec.model.PairedValuesTableModel;
import hec.rss.gfx2d.SimpleJTableData;
import hec.rss.model.Function;
import hec.rss.model.SsarrRouting;
import hec.rss.server.RoutingPanel;
import hec.rss.server.RoutingPanel$IRoutingPanel;
import hec.rss.server.RoutingPanel$SsarrRoutingPanel$1;
import hec.rss.server.RoutingPanel$SsarrRoutingPanel$2;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;

public class RoutingPanel$SsarrRoutingPanel
extends JPanel
implements RoutingPanel$IRoutingPanel<SsarrRouting>,
ActionListener {
    private RmaJRadioButton tableRadioButton;
    private RmaJRadioButton equationRadioButton;
    private RmaJIntegerField numberOfSubreaches_tf;
    private RmaJDecimalField kts_df;
    private RmaJDecimalField n_df;
    private RmaJTable _ssarrTable;
    private boolean hasData = false;
    SsarrRouting _function = null;
    final /* synthetic */ RoutingPanel this$0;

    public RoutingPanel$SsarrRoutingPanel(RoutingPanel routingPanel) {
        this.this$0 = routingPanel;
        this.buildPanel();
        this._function = new SsarrRouting();
    }

    @Override
    public boolean canHandleFunction(Function function) {
        return function.getClass().equals(SsarrRouting.class);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._ssarrTable.setEnabled(bl);
        this._ssarrTable.setBackground(bl ? Color.white : RoutingPanel.a);
        this._ssarrTable.setEnabled(bl);
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if ((object = ((EventObject)object).getSource()) == this.tableRadioButton) {
            this.selectInterpolationTable();
            return;
        }
        if (object == this.equationRadioButton) {
            this.selectEquationMethod();
        }
    }

    @Override
    public void savePanel(SsarrRouting ssarrRouting) {
        ssarrRouting.setNumberReaches(this.numberOfSubreaches_tf.getValue());
        if (this.tableRadioButton.isSelected()) {
            ssarrRouting.setUseTable(true);
        } else {
            ssarrRouting.setUseTable(false);
        }
        this._ssarrTable.commitEdit(true);
        PairedValues pairedValues = new PairedValues();
        ((PairedValuesTableModel)this._ssarrTable.getModel()).storeData(pairedValues);
        ssarrRouting.setOutflowTimeOfStorageTable(pairedValues);
        ssarrRouting.setKTS(this.kts_df.getValue());
        ssarrRouting.setNCoefficient(this.n_df.getValue());
        ssarrRouting.setNumberReaches(this.numberOfSubreaches_tf.getValue());
    }

    @Override
    public void fillPanel(SsarrRouting ssarrRouting) {
        this._function = ssarrRouting;
        if (ssarrRouting == null) {
            return;
        }
        if (ssarrRouting.useTable()) {
            this.tableRadioButton.setSelected(true);
            this.selectInterpolationTable();
        } else {
            this.equationRadioButton.setSelected(true);
            this.selectEquationMethod();
        }
        this.kts_df.setValue(ssarrRouting.getKTS());
        this.n_df.setValue(ssarrRouting.getNCoefficient());
        PairedValues pairedValues = ssarrRouting.getOutflowTimeOfStorageTable();
        if (pairedValues == null) {
            return;
        }
        ((PairedValuesTableModel)this._ssarrTable.getModel()).setPairedValues(pairedValues);
        this.numberOfSubreaches_tf.setValue(ssarrRouting.getNumberReaches());
        this.hasData = true;
    }

    @Override
    public SsarrRouting getFunction() {
        return this._function;
    }

    @Override
    public void clearPanel() {
        this._ssarrTable.commitEdit(true);
        this._ssarrTable.clearCells();
        this._ssarrTable.setNumRows(10);
        this.hasData = false;
    }

    public void ratingCurveReplot() {
        Vector<SimpleJTableData> vector = new Vector<SimpleJTableData>();
        this.this$0._ssarrArray.setData(this._ssarrTable, 1, 0);
        vector.addElement(this.this$0._ssarrArray);
        this.this$0._g2dPanelSsarr.setPlotObjects(vector);
        this.this$0._g2dPanelSsarr.paintGfx();
        this.this$0._g2dPanelSsarr.revalidate();
    }

    public void plotSSARRTable() {
        this.this$0._ssarrArray.setData(this._ssarrTable, 0, 1);
    }

    protected void buildPanel() {
        Serializable serializable = new GridBagLayout();
        this.setLayout((LayoutManager)((Object)serializable));
        this.setVisible(false);
        JPanel jPanel = new JPanel();
        serializable = new GridBagLayout();
        jPanel.setLayout((LayoutManager)((Object)serializable));
        this.tableRadioButton = new RmaJRadioButton("Use Interpolation Table");
        this.tableRadioButton.setSelected(true);
        this.tableRadioButton.setModifiable(false);
        serializable = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, RmaInsets.INSETS0500, 0, 0);
        jPanel.add((Component)this.tableRadioButton, serializable);
        this.equationRadioButton = new RmaJRadioButton("TS = KTS/Q**n");
        serializable = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, RmaInsets.INSETS0500, 0, 0);
        jPanel.add((Component)this.equationRadioButton, serializable);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add((AbstractButton)this.tableRadioButton);
        ((ButtonGroup)serializable).add((AbstractButton)this.equationRadioButton);
        jPanel.setBorder(BorderFactory.createTitledBorder("Time of Storage Method"));
        serializable = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, RmaInsets.INSETS0500, 0, 0);
        this.add((Component)jPanel, serializable);
        serializable = new String[]{"Outflow\n(%S)", "Time Of Storage\n(hours)"};
        this._ssarrTable = new RmaJTable((Component)this);
        this._ssarrTable.addCellEditorListener((CellEditorListener)this.this$0);
        serializable = new PairedValuesTableModel((String[])serializable, new boolean[]{true, true});
        serializable.setUnitSystem(ClientApp.Workspace().getUnitSystem());
        this._ssarrTable.setModel((TableModel)((Object)serializable));
        ((PairedValuesTableModel)this._ssarrTable.getModel()).setShouldAddBlankRows(true);
        this._ssarrTable.setHorizontalAlignment(4);
        this._ssarrTable.setDoubleCellEditor(0);
        for (int i = 1; i < 2; ++i) {
            serializable = this._ssarrTable.setDoubleCellEditor(1);
            if (serializable == null) continue;
            serializable.setMinValue(0.0);
        }
        this._ssarrTable.setUnitsHeaderRenderer();
        serializable = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, RmaInsets.insets((int)10, (int)10, (int)10, (int)10), 0, 0);
        RoutingPanel$SsarrRoutingPanel routingPanel$SsarrRoutingPanel = this;
        routingPanel$SsarrRoutingPanel.add((Component)routingPanel$SsarrRoutingPanel._ssarrTable.getScrollPane(), serializable);
        this._ssarrTable.addCellEditorListener((CellEditorListener)new RoutingPanel$SsarrRoutingPanel$1(this));
        JPanel jPanel2 = new JPanel();
        serializable = new GridBagLayout();
        jPanel2.setLayout((LayoutManager)((Object)serializable));
        RmaJLabel rmaJLabel = new RmaJLabel("KTS");
        serializable = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, RmaInsets.insets((int)5, (int)20, (int)0, (int)0), 0, 0);
        jPanel2.add((Component)rmaJLabel, serializable);
        this.kts_df = new RmaJDecimalField();
        serializable = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, RmaInsets.insets((int)5, (int)10, (int)0, (int)60), 0, 0);
        jPanel2.add((Component)this.kts_df, serializable);
        rmaJLabel = new RmaJLabel("n");
        serializable = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, RmaInsets.insets((int)5, (int)20, (int)5, (int)0), 0, 0);
        jPanel2.add((Component)rmaJLabel, serializable);
        this.n_df = new RmaJDecimalField();
        serializable = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, RmaInsets.insets((int)5, (int)10, (int)5, (int)60), 0, 0);
        jPanel2.add((Component)this.n_df, serializable);
        jPanel2.setBorder(BorderFactory.createTitledBorder("Time of Storage Equation"));
        serializable = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, RmaInsets.insets((int)0, (int)5, (int)5, (int)0), 0, 0);
        this.add((Component)jPanel2, serializable);
        jPanel2 = new JPanel();
        serializable = new GridBagLayout();
        jPanel2.setLayout((LayoutManager)((Object)serializable));
        rmaJLabel = new RmaJLabel("Number of Subreaches");
        serializable = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, RmaInsets.insets((int)5, (int)10, (int)5, (int)10), 0, 0);
        jPanel2.add((Component)rmaJLabel, serializable);
        this.numberOfSubreaches_tf = new RmaJIntegerField();
        this.numberOfSubreaches_tf.setMinValue(1);
        int n = this.this$0.getMaxNumberSubReaches();
        this.numberOfSubreaches_tf.setMaxValue(n);
        Cloneable cloneable = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, RmaInsets.insets((int)5, (int)10, (int)5, (int)10), 0, 0);
        jPanel2.add((Component)this.numberOfSubreaches_tf, cloneable);
        cloneable = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, RmaInsets.insets((int)0, (int)0, (int)5, (int)0), 0, 0);
        this.add((Component)jPanel2, cloneable);
        this.this$0._g2dPanelSsarr = new RoutingPanel$SsarrRoutingPanel$2(this);
        cloneable = new GridBagConstraints(1, 0, 1, 4, 0.0, 1.0, 17, 0, RmaInsets.insets((int)10, (int)10, (int)10, (int)10), 160, 160);
        RoutingPanel$SsarrRoutingPanel routingPanel$SsarrRoutingPanel2 = this;
        routingPanel$SsarrRoutingPanel2.add((Component)((Object)routingPanel$SsarrRoutingPanel2.this$0._g2dPanelSsarr), cloneable);
        RoutingPanel$SsarrRoutingPanel routingPanel$SsarrRoutingPanel3 = this;
        routingPanel$SsarrRoutingPanel3.configurePlotPanel(routingPanel$SsarrRoutingPanel3.this$0._g2dPanelSsarr);
        this.this$0._ssarrArray = this.getPlotData();
        this.this$0._ssarrArray.setData(this._ssarrTable, 0, 1);
        cloneable = new Vector<SimpleJTableData>();
        ((Vector)cloneable).addElement(this.this$0._ssarrArray);
        this.this$0._g2dPanelSsarr.setPlotObjects((List)((Object)cloneable));
        this.tableRadioButton.addActionListener((ActionListener)this);
        this.equationRadioButton.addActionListener((ActionListener)this);
        this._ssarrTable.setNumRows(10);
    }

    void configurePlotPanel(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Outflow (%S)";
        g2dPlotProp.y1AxisProp.name = "Time Of Storage (hrs)";
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    private SimpleJTableData getPlotData() {
        SimpleJTableData simpleJTableData = new SimpleJTableData();
        new SimpleJTableData().xunits = "Outflow (%S)";
        simpleJTableData.yunits = "Time Of Storage (hrs)";
        simpleJTableData.setXParameterId(Parameter.PARAMID_FLOW);
        simpleJTableData.setData(this._ssarrTable, 0, 1);
        simpleJTableData.addToPairedDataContainerReveresed(false);
        return simpleJTableData;
    }

    private void selectInterpolationTable() {
        this._ssarrTable.setEnabled(true);
        this._ssarrTable.setBackground(Color.white);
        this.kts_df.setEnabled(false);
        this.n_df.setEnabled(false);
    }

    private void selectEquationMethod() {
        this._ssarrTable.setBackground(RoutingPanel.a);
        this._ssarrTable.setEnabled(false);
        this.kts_df.setEnabled(true);
        this.n_df.setEnabled(true);
    }
}

