/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.server;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.model.ParamDoubleTableModel;
import hec.rss.gfx2d.SimpleJTableData;
import hec.rss.model.Function;
import hec.rss.model.PulsRecord;
import hec.rss.model.WorkingRDRouting;
import hec.rss.server.RoutingPanel;
import hec.rss.server.RoutingPanel$IRoutingPanel;
import hec.rss.server.RoutingPanel$MyG2dPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJTable;
import rma.swing.print.PageText;
import rma.util.NumberFormat;
import rma.util.RMAIO;

class RoutingPanel$WorkingRDPanel
extends JPanel
implements RoutingPanel$IRoutingPanel<WorkingRDRouting>,
CellEditorListener {
    private RmaJTable _workingRDTable;
    private RmaJIntegerField _wRDnumberOfReaches;
    private SimpleJTableData _workingRDArray = new SimpleJTableData();
    private RmaJDecimalField _wRDmuskingumX;
    WorkingRDRouting _function;
    final /* synthetic */ RoutingPanel this$0;

    public RoutingPanel$WorkingRDPanel(RoutingPanel routingPanel) {
        this.this$0 = routingPanel;
        this.initComponents();
        this._function = new WorkingRDRouting();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public boolean canHandleFunction(Function function) {
        return function.getClass().equals(WorkingRDRouting.class);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        Object object = new String[]{"Storage\n(%S)", "Outflow\n(%S)"};
        this._workingRDTable = new RmaJTable((Component)this);
        object = new ParamDoubleTableModel((String[])object, new int[]{Parameter.PARAMID_STOR, Parameter.PARAMID_FLOW}, new boolean[]{true, true});
        object.setUnitSystem(ClientApp.Workspace().getUnitSystem());
        this._workingRDTable.setModel((TableModel)object);
        this._workingRDTable.setPrecision(2);
        for (int i = 0; i < 2; ++i) {
            object = this._workingRDTable.setDoubleCellEditor(i, true);
            if (object == null) continue;
            object.setMinValue(0.0);
        }
        this._workingRDTable.addCellEditorListener((CellEditorListener)this);
        this._workingRDTable.setUnitsHeaderRenderer();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        RoutingPanel$WorkingRDPanel routingPanel$WorkingRDPanel = this;
        routingPanel$WorkingRDPanel.add((Component)routingPanel$WorkingRDPanel._workingRDTable.getScrollPane(), gridBagConstraints);
        object = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(2, 0, 1, 2, 1.0, 1.0, 12, 1, RmaInsets.insets((int)0, (int)0, (int)0, (int)0), 0, 0);
        this.add((Component)object, gridBagConstraints);
        this.this$0._g2dpanelWorkingRDFlow = new RoutingPanel$MyG2dPanel(this.this$0);
        ((Container)object).add((Component)((Object)this.this$0._g2dpanelWorkingRDFlow), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, RmaInsets.insets((int)0, (int)0, (int)0, (int)0), 100, 100));
        this.this$0.configurePlotPanel(this.this$0._g2dpanelWorkingRDFlow);
        object = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this.add((Component)object, gridBagConstraints);
        RmaJLabel rmaJLabel = new RmaJLabel("Muskingum X");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0005;
        ((Container)object).add((Component)rmaJLabel, gridBagConstraints);
        this._wRDmuskingumX = new RmaJDecimalField();
        this._wRDmuskingumX.setColumns(15);
        this._wRDmuskingumX.setMinValue(0.0);
        this._wRDmuskingumX.setMaxValue(0.5);
        this._wRDmuskingumX.setMargin(RmaInsets.INSETS0000);
        this._wRDmuskingumX.setSelectionColor(new Color(0));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0005;
        ((Container)object).add((Component)this._wRDmuskingumX, gridBagConstraints);
        rmaJLabel = new RmaJLabel("Number of Subreaches");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0005;
        ((Container)object).add((Component)rmaJLabel, gridBagConstraints);
        int n = this.this$0.getMaxNumberSubReaches();
        this._wRDnumberOfReaches = new RmaJIntegerField();
        this._wRDnumberOfReaches.setColumns(15);
        this._wRDnumberOfReaches.setMinValue(1);
        this._wRDnumberOfReaches.setValue(1);
        this._wRDnumberOfReaches.setMaxValue(n);
        this._wRDnumberOfReaches.setMargin(RmaInsets.INSETS0000);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = RmaInsets.INSETS0005;
        ((Container)object).add((Component)this._wRDnumberOfReaches, gridBagConstraints2);
        this._workingRDArray.xunits = "Storage (%S)";
        this._workingRDArray.yunits = "Outflow (%S)";
        this._workingRDArray.addToPairedDataContainerReveresed(false);
        this._workingRDArray.setData(this._workingRDTable, 0, 1);
        object = new Vector<SimpleJTableData>();
        ((Vector)object).addElement(this._workingRDArray);
        this.this$0._g2dpanelWorkingRDFlow.setPlotObjects((List)object);
        this.this$0._g2dpanelWorkingRDFlow.paintGfx();
        this.initWorkingRDTable(5);
    }

    public void initWorkingRDTable(int n) {
        this.this$0.initParamDoubleTable(n, 2, this._workingRDTable);
        this.plotWorkingRDTable();
    }

    public void plotWorkingRDTable() {
        this._workingRDArray.setData(this._workingRDTable, 0, 1);
    }

    private void setTablePrintHeaders(PageText pageText) {
        this._workingRDTable.setPrintTitle(pageText);
    }

    @Override
    public WorkingRDRouting getFunction() {
        return this._function;
    }

    @Override
    public void fillPanel(WorkingRDRouting workingRDRouting) {
        int n;
        this.initWorkingRDTable(10);
        double d = workingRDRouting.getMuskingumX();
        this._wRDmuskingumX.setText(new NumberFormat("%.4f").form(d));
        this._wRDnumberOfReaches.setValue(workingRDRouting.getnumberReaches());
        Vector vector = workingRDRouting.getPulsVector();
        vector.trimToSize();
        for (n = 0; n < vector.size(); ++n) {
            PulsRecord pulsRecord = (PulsRecord)vector.elementAt(n);
            if (pulsRecord == null) continue;
            ParamDoubleTableModel paramDoubleTableModel = (ParamDoubleTableModel)this._workingRDTable.getModel();
            paramDoubleTableModel.setValueAt((Object)new ParamDouble(pulsRecord.stor, Parameter.PARAMID_STOR, workingRDRouting.getUnitSystem()), n, 0);
            paramDoubleTableModel.setValueAt((Object)new ParamDouble(pulsRecord.outflow, Parameter.PARAMID_FLOW, workingRDRouting.getUnitSystem()), n, 1);
        }
        if (this._workingRDTable.getRowCount() < 10) {
            n = 10 - this._workingRDTable.getRowCount();
            this._workingRDTable.appendRows(n);
        } else {
            this._workingRDTable.appendRows(2);
        }
        this.plotWorkingRDTable();
    }

    @Override
    public void savePanel(WorkingRDRouting workingRDRouting) {
        workingRDRouting.setMuskingumX(RMAIO.parseDouble((String)this._wRDmuskingumX.getText(), (double)0.0));
        workingRDRouting.setnumberReaches(RMAIO.parseInt((String)this._wRDnumberOfReaches.getText(), (int)1));
        Object object = this._workingRDTable.getCellEditor();
        if (object != null) {
            object.stopCellEditing();
        }
        object = this._workingRDTable.getCells();
        ((Vector)object).trimToSize();
        int n = ((Vector)object).size();
        workingRDRouting.emptyPulsVector();
        double d = -1.0;
        double d2 = -1.0;
        for (int i = 0; i < n; ++i) {
            Vector vector = (Vector)((Vector)object).elementAt(i);
            if (vector == null || vector.size() < 2) continue;
            double d3 = RMAIO.parseDouble(vector.elementAt(0));
            double d4 = RMAIO.parseDouble(vector.elementAt(1));
            if (d3 == Double.NEGATIVE_INFINITY) break;
            if (i > 0 && (d3 <= d || d4 <= d2)) {
                JOptionPane.showMessageDialog(this, "Storage and Outflow values of your function must be a continuously increasing sequence.", "Modified Puls Error", 2);
                return;
            }
            d = d3;
            d2 = d4;
            workingRDRouting.addPulsRecord(new PulsRecord(d3, d4, 0.0));
        }
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        this.plotWorkingRDTable();
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    @Override
    public void clearPanel() {
        this.initWorkingRDTable(10);
        this._wRDnumberOfReaches.setText("");
        this._wRDmuskingumX.setText("");
    }
}

