/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.server;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.model.ParamDoubleTableModel;
import hec.rss.gfx2d.SimpleJTableData;
import hec.rss.model.ChannelType;
import hec.rss.model.CircularChannel;
import hec.rss.model.CoefRouting;
import hec.rss.model.EightPointChannel;
import hec.rss.model.Element;
import hec.rss.model.Function;
import hec.rss.model.LagAndKRouting;
import hec.rss.model.MuskingumCunge8ptRouting;
import hec.rss.model.MuskingumCungePrismRouting;
import hec.rss.model.MuskingumCungeRouting;
import hec.rss.model.MuskingumRouting;
import hec.rss.model.NullRouting;
import hec.rss.model.PulsChannelRoutingWithLosses;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.model.SsarrRouting;
import hec.rss.model.TimeStepRoutingElement;
import hec.rss.model.TimeStepUtil;
import hec.rss.model.TrapezoidalChannel;
import hec.rss.model.WorkingRDRouting;
import hec.rss.server.RoutingPanel$1;
import hec.rss.server.RoutingPanel$CoefRoutingPanel;
import hec.rss.server.RoutingPanel$IRoutingPanel;
import hec.rss.server.RoutingPanel$LagKDPanel;
import hec.rss.server.RoutingPanel$ModifiedPulseRoutingPanel;
import hec.rss.server.RoutingPanel$MuskingumCunge8PtRoutingPanel;
import hec.rss.server.RoutingPanel$MuskingumCungePrismPanel;
import hec.rss.server.RoutingPanel$MuskingumRoutingPanel;
import hec.rss.server.RoutingPanel$MyG2dPanel;
import hec.rss.server.RoutingPanel$NullRoutingPanel;
import hec.rss.server.RoutingPanel$SsarrRoutingPanel;
import hec.rss.server.RoutingPanel$WorkingRDPanel;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import rma.services.ServiceLookup;
import rma.services.units.UnitsComponent;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTable;
import rma.swing.RmaValidComponent;
import rma.swing.list.RmaListModel;
import rma.swing.print.PageText;

public class RoutingPanel
extends RmaJPanel
implements ActionListener,
ItemListener,
CellEditorListener,
UnitsComponent,
RmaValidComponent {
    static final Color a = UIManager.getColor("TextField.disabledBackground");
    private int _samePlot = 0;
    public static final String TIME_STEP_PROPERTY = "TimeStepProperty";
    private RmaJComboBox<String> _routingCmb;
    private SimpleJTableData _storoutflowArray = new SimpleJTableData();
    private SimpleJTableData _storelevArray = new SimpleJTableData();
    private SimpleJTableData _ssarrArray = new SimpleJTableData();
    private RoutingPanel$MyG2dPanel _g2dpanel8pt;
    private RoutingPanel$MyG2dPanel _g2dpanelModpulsFlow;
    private RoutingPanel$MyG2dPanel _g2dPanelSsarr;
    private RoutingPanel$MyG2dPanel _g2dpanelWorkingRDFlow;
    private TimeStepRoutingElement _parentElement = null;
    private TimeStepUtil _selectedTimeStep = TimeStepUtil.TIME_STEP_ALL;
    private ParamDouble _undefParamDouble = new ParamDouble(Double.NEGATIVE_INFINITY, Parameter.PARAMID_ELEV, ClientApp.Workspace().getUnitSystem(), 2);
    private ButtonGroup _bGroup2;
    private RssAlt _rssAlt;
    private JPanel _cardpanel1;
    private RmaJComboBox<TimeStepUtil> _timeStepCombo;
    private JTextField _factorTxt;
    String TS_PARAMETER_ITEM = "TS={0}";
    MessageFormat _cardPanelKeyFormat = new MessageFormat(this.TS_PARAMETER_ITEM + ", Routing={1}");
    private static String[] b = new String[]{"1", "2", "3", "4", "5", "6", "8", "10", "12"};
    public static final String TABNAME = "Routing";
    public static final String NULL_ROUTING = "Null Routing";
    public static final String COEF_ROUTING = "Coef. Routing";
    public static final String MUSK_ROUTING = "Muskingum";
    public static final String MUSK8PT_ROUTING = "Muskingum-Cunge 8-pt Channel";
    public static final String MUSKPRISM_ROUTING = "Muskingum-Cunge Prismatic Channel";
    public static final String MODPULS_ROUTING = "Modified Puls";
    public static final String SSARR_ROUTING = "SSARR Routing";
    public static final String WORKINGRD_ROUTING = "Working R&D";
    public static final String VARLAGK_ROUTING = "Variable Lag & K";
    private static String c = "FLOW";
    private static String d = "ELEV";
    boolean ignoreTimeStepChange = false;
    Map<TimeStepUtil, String> _timeStepToPanelNameMap = new HashMap<TimeStepUtil, String>();
    Map<String, RoutingPanel$IRoutingPanel> _tsRoutingMapToPanel = new HashMap<String, RoutingPanel$IRoutingPanel>();

    public RoutingPanel() {
        this.buildGui();
    }

    private void buildGui() {
        this.buildGridBagLayout();
        this.buildTimeStepControls();
        this.buildMethodControls();
        this.buildHorizontalLine();
        this.buildCardPanel();
        this.addListeners();
    }

    private void addListeners() {
        this.addTimeStepComboListener();
    }

    private void addTimeStepComboListener() {
        this._timeStepCombo.addActionListener(actionEvent -> this.timeStepSelected());
    }

    public void deleteRoutingTimeStep(TimeStepUtil timeStepUtil) {
        if (timeStepUtil.equals((Object)this._selectedTimeStep)) {
            this.deleteSelectedTimeStepFromComboBox();
            this.deleteTimeStepFromModel(timeStepUtil);
            ArrayList<Map.Entry> arrayList = new ArrayList<Map.Entry>();
            Iterator iterator = this._tsRoutingMapToPanel.entrySet();
            String string = MessageFormat.format(this.TS_PARAMETER_ITEM, timeStepUtil.toString());
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String string2 = (String)entry.getKey();
                if (!string2.startsWith(string)) continue;
                arrayList.add(entry);
            }
            for (Map.Entry entry : arrayList) {
                this._cardpanel1.remove((JComponent)entry.getValue());
                this._tsRoutingMapToPanel.remove(entry.getKey());
            }
            this._timeStepToPanelNameMap.remove((Object)timeStepUtil);
        }
    }

    public void addRoutingTimeStep(TimeStepUtil timeStepUtil) {
        this._timeStepCombo.addItem((Object)timeStepUtil);
        this._timeStepCombo.setSelectedItem((Object)timeStepUtil);
    }

    public void addRoutingTimeStep(TimeStepUtil timeStepUtil, Function function) {
        int n = this._timeStepCombo.getModel().getSize();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            TimeStepUtil timeStepUtil2 = (TimeStepUtil)((Object)this._timeStepCombo.getModel().getElementAt(i));
            if (!timeStepUtil2.equals((Object)timeStepUtil)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this._timeStepCombo.addItem((Object)timeStepUtil);
        } else {
            String string = "There is already a routing method mapped to the time step: " + timeStepUtil.toString() + ".\nWould you like to overwrite?";
            int n2 = JOptionPane.showConfirmDialog((Component)((Object)this), string, "Warning", 0, 2);
            if (n2 != 0) {
                return;
            }
            this._timeStepToPanelNameMap.put(timeStepUtil, this.getFunctionTypeName(function));
        }
        Function function2 = this._parentElement.getFunction(timeStepUtil.getDuration(), null);
        this._parentElement.putFunction(timeStepUtil.getDuration(), function);
        this._routingCmb.setSelectedIndex(-1);
        this._timeStepCombo.setSelectedItem((Object)timeStepUtil);
        this._parentElement.putFunction(timeStepUtil.getDuration(), function2);
    }

    private void deleteSelectedTimeStepFromComboBox() {
        int n = this._timeStepCombo.getSelectedIndex();
        this._timeStepCombo.removeItemAt(n);
    }

    private void deleteTimeStepFromModel(TimeStepUtil timeStepUtil) {
        this._parentElement.putFunction(timeStepUtil.getDuration(), null);
    }

    private void timeStepSelected() {
        if (this.ignoreTimeStepChange) {
            return;
        }
        Object object = this._timeStepCombo.getSelectedItem();
        if (object != null && object instanceof TimeStepUtil) {
            this._routingCmb.setEnabled(true);
            object = (TimeStepUtil)((Object)object);
            if (!((Enum)object).equals((Object)this._selectedTimeStep)) {
                this.firePropertyChange(TIME_STEP_PROPERTY, (Object)this._selectedTimeStep, object);
                this._selectedTimeStep = object;
                RoutingPanel routingPanel = this;
                routingPanel.fillPanel(routingPanel._selectedTimeStep);
            }
            return;
        }
        if (object == null) {
            this._routingCmb.setSelectedIndex(-1);
            this._routingCmb.setEnabled(false);
        }
    }

    private void fillPanel(TimeStepUtil timeStepUtil) {
        this.setFowardModifiedEvents(false);
        try {
            Object object = this._timeStepToPanelNameMap.get((Object)timeStepUtil);
            if (object != null) {
                this._routingCmb.setSelectedIndex(-1);
                this._routingCmb.setSelectedItem(object);
            } else {
                object = this._parentElement.getFunction(timeStepUtil.getDuration(), null);
                if (object == null) {
                    object = new NullRouting();
                }
                object = this.getFunctionTypeName((Function)object);
                this._routingCmb.setSelectedIndex(-1);
                this._routingCmb.setSelectedItem(object);
                this._timeStepToPanelNameMap.put(timeStepUtil, (String)object);
            }
            return;
        }
        finally {
            this.setFowardModifiedEvents(true);
        }
    }

    private String getFunctionTypeName(Function function) {
        if (function instanceof NullRouting) {
            return NULL_ROUTING;
        }
        if (function instanceof CoefRouting) {
            return COEF_ROUTING;
        }
        if (function instanceof MuskingumRouting) {
            return MUSK_ROUTING;
        }
        if (function instanceof MuskingumCungeRouting) {
            if (((MuskingumCungeRouting)function).getChannelType() == ChannelType.EIGHT_POINT) {
                return MUSK8PT_ROUTING;
            }
            if (((MuskingumCungeRouting)function).getChannelType() == ChannelType.CIRCLE || ((MuskingumCungeRouting)function).getChannelType() == ChannelType.TRAPEZOID) {
                return MUSKPRISM_ROUTING;
            }
            return MUSK_ROUTING;
        }
        if (function instanceof MuskingumCunge8ptRouting) {
            return MUSK8PT_ROUTING;
        }
        if (function instanceof MuskingumCungePrismRouting) {
            return MUSKPRISM_ROUTING;
        }
        if (function instanceof WorkingRDRouting) {
            return WORKINGRD_ROUTING;
        }
        if (function instanceof PulsChannelRoutingWithLosses) {
            return MODPULS_ROUTING;
        }
        if (function instanceof SsarrRouting) {
            return SSARR_ROUTING;
        }
        if (function instanceof LagAndKRouting) {
            return VARLAGK_ROUTING;
        }
        return "";
    }

    public TimeStepUtil getSelectedTimeStep() {
        return this._selectedTimeStep;
    }

    private void buildTimeStepControls() {
        JLabel jLabel = this.buildTimeStepLabel();
        this.buildTimeStepCombo(jLabel);
    }

    private void buildGridBagLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setSize(510, 258);
    }

    private void buildMethodControls() {
        JLabel jLabel = this.buildMethodLabel();
        this.buildRoutingCombo(jLabel);
    }

    private RoutingPanel$IRoutingPanel buildRoutingPanel(String string) {
        int n = -1;
        switch (string.hashCode()) {
            case -1300875475: {
                if (!string.equals(NULL_ROUTING)) break;
                n = 0;
                break;
            }
            case 739280679: {
                if (!string.equals(COEF_ROUTING)) break;
                n = 1;
                break;
            }
            case -1837284390: {
                if (!string.equals(MUSK_ROUTING)) break;
                n = 2;
                break;
            }
            case -489311656: {
                if (!string.equals(MUSKPRISM_ROUTING)) break;
                n = 3;
                break;
            }
            case 1652933301: {
                if (!string.equals(MUSK8PT_ROUTING)) break;
                n = 4;
                break;
            }
            case -1461217981: {
                if (!string.equals(MODPULS_ROUTING)) break;
                n = 5;
                break;
            }
            case 277642087: {
                if (!string.equals(SSARR_ROUTING)) break;
                n = 6;
                break;
            }
            case 1795594017: {
                if (!string.equals(WORKINGRD_ROUTING)) break;
                n = 7;
                break;
            }
            case 255636895: {
                if (!string.equals(VARLAGK_ROUTING)) break;
                n = 8;
            }
        }
        switch (n) {
            case 0: {
                return this.buildNullRoutingPanel();
            }
            case 1: {
                return this.buildCoefRoutingPanel();
            }
            case 2: {
                return this.buildMuskRoutingPanel();
            }
            case 3: {
                return this.buildPrismaticChannelPanel();
            }
            case 4: {
                return this.build8PointChannelPanel();
            }
            case 5: {
                return this.buildModifiedPulsPanel();
            }
            case 6: {
                return this.buildSSARRPanel();
            }
            case 7: {
                return this.buildWorkingRDPanel();
            }
            case 8: {
                return this.buildVarLagKpanel();
            }
        }
        return null;
    }

    private void buildCardPanel() {
        this._cardpanel1 = new JPanel();
        this._cardpanel1.setLayout(new CardLayout(0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        RoutingPanel routingPanel = this;
        routingPanel.add(routingPanel._cardpanel1, gridBagConstraints);
    }

    private void buildHorizontalLine() {
        JSeparator jSeparator = new JSeparator();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)10, (int)10, (int)10, (int)10);
        this.add(jSeparator, gridBagConstraints);
    }

    private void buildTimeStepCombo(JLabel serializable) {
        this._timeStepCombo = new RmaJComboBox();
        this._timeStepCombo.setPreferredSize(new Dimension(100, 20));
        this._timeStepCombo.setMinimumSize(new Dimension(100, 20));
        ComboBoxModel comboBoxModel = this.initTimeStepComboModel();
        this._timeStepCombo.setModel(comboBoxModel);
        serializable.setLabelFor((Component)this._timeStepCombo);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)10, (int)10, (int)0, (int)0);
        RoutingPanel routingPanel = this;
        routingPanel.add((Component)routingPanel._timeStepCombo, serializable);
    }

    private ComboBoxModel initTimeStepComboModel() {
        DefaultComboBoxModel<TimeStepUtil> defaultComboBoxModel = new DefaultComboBoxModel<TimeStepUtil>();
        defaultComboBoxModel.addElement(TimeStepUtil.TIME_STEP_ALL);
        defaultComboBoxModel.addElement(TimeStepUtil.TIME_STEP_1_HR);
        return defaultComboBoxModel;
    }

    private void buildRoutingCombo(JLabel serializable) {
        RmaListModel rmaListModel = new RmaListModel(false);
        rmaListModel.addElement((Object)NULL_ROUTING);
        rmaListModel.addElement((Object)COEF_ROUTING);
        rmaListModel.addElement((Object)MUSK_ROUTING);
        rmaListModel.addElement((Object)MUSK8PT_ROUTING);
        rmaListModel.addElement((Object)MUSKPRISM_ROUTING);
        rmaListModel.addElement((Object)MODPULS_ROUTING);
        rmaListModel.addElement((Object)SSARR_ROUTING);
        if (Boolean.getBoolean("ResSim.HasWorkingRdRouting")) {
            rmaListModel.addElement((Object)WORKINGRD_ROUTING);
        }
        rmaListModel.addElement((Object)VARLAGK_ROUTING);
        this._routingCmb = new RmaJComboBox((ComboBoxModel)rmaListModel);
        this._routingCmb.setModifiable(true);
        serializable.setLabelFor((Component)this._routingCmb);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)serializable).gridy = 1;
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)10, (int)10, (int)0, (int)0);
        RoutingPanel routingPanel = this;
        routingPanel.add((Component)routingPanel._routingCmb, serializable);
        this._routingCmb.addItemListener((ItemListener)this);
    }

    private JLabel buildTimeStepLabel() {
        JLabel jLabel = new JLabel("Time Step:");
        jLabel.setDisplayedMnemonic('T');
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)10, (int)10, (int)0, (int)0);
        this.add(jLabel, gridBagConstraints);
        return jLabel;
    }

    private JLabel buildMethodLabel() {
        JLabel jLabel = new JLabel("Method:");
        jLabel.setDisplayedMnemonic('M');
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)10, (int)10, (int)0, (int)0);
        this.add(jLabel, gridBagConstraints);
        return jLabel;
    }

    public void setTablePrintHeaders(RssSystem object, Element element) {
        Object object2 = new String("Workspace: " + ClientApp.Workspace().getTitleName());
        object2 = (String)object2 + "\n ResSim System: " + object.getName();
        object2 = (String)object2 + "\n Reach: " + element.getName();
        object = new String((String)object2 + "\n Muskingum-Cunge 8-pt Channel Cross Section \n ");
        new PageText((String)object, 0);
        object = new String((String)object2 + "\n Modified Puls \n ");
        new PageText((String)object, 0);
        new String((String)object2 + "\n Coefficient Routing \n ");
        object = new String((String)object2 + "\n Working R&D Routing \n ");
        new PageText((String)object, 0);
    }

    public void setupForRssLp() {
        String[] stringArray = new String[]{COEF_ROUTING, MUSK_ROUTING};
        this.setAvailableRoutingMethods(stringArray);
    }

    public void setAvailableRoutingMethods(String[] stringArray) {
        if (this._routingCmb.getItemCount() > 0) {
            this._routingCmb.removeAllItems();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this._routingCmb.addItem((Object)stringArray[i]);
        }
    }

    public void setDisplayUnitsSystem(int n) {
        ((RmaJDialog)SwingUtilities.windowForComponent((Component)((Object)this))).updateUnitSystem((Container)((Object)this));
    }

    public void setDisplayScaleFactor(int n, double d) {
    }

    public String getTabname() {
        return TABNAME;
    }

    public boolean isValid(boolean bl) {
        String cfr_ignored_0 = (String)this._routingCmb.getSelectedItem();
        bl = true;
        for (Map.Entry<String, RoutingPanel$IRoutingPanel> entry : this._tsRoutingMapToPanel.entrySet()) {
            bl &= this.validatePanel(entry.getValue().getComponent());
        }
        return bl;
    }

    public String getDisplayUnitsString(int n) {
        return "";
    }

    public void savePanel(Element element) {
        Object object = this._timeStepToPanelNameMap.entrySet();
        object = object.iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            Object object2 = this._cardPanelKeyFormat.format(new String[]{((TimeStepUtil)((Object)entry.getKey())).toString(), (String)entry.getValue()});
            object2 = this._tsRoutingMapToPanel.get(object2);
            Object i = object2.getFunction();
            ((Function)i).setElement(this._parentElement);
            object2.savePanel(i);
            ((TimeStepRoutingElement)element).putFunction(((TimeStepUtil)((Object)entry.getKey())).getDuration(), (Function)i);
        }
    }

    public void clearPanel() {
        this._undefParamDouble.setParameterId(Parameter.PARAMID_LENGTH);
        this._cardpanel1.removeAll();
    }

    public void fillPanel(TimeStepRoutingElement timeStepRoutingElement) {
        this.setFowardModifiedEvents(false);
        try {
            Object object;
            this._timeStepToPanelNameMap.clear();
            this._tsRoutingMapToPanel.clear();
            this._cardpanel1.removeAll();
            this.ignoreTimeStepChange = true;
            this._timeStepCombo.removeAllItems();
            this._routingCmb.setSelectedIndex(-1);
            this.ignoreTimeStepChange = false;
            this._selectedTimeStep = null;
            if (timeStepRoutingElement == null) {
                System.out.println("NULL ELEMENT");
                return;
            }
            this._parentElement = timeStepRoutingElement;
            Object object2 = timeStepRoutingElement.getDefinedTimeStepDurations();
            Arrays.sort(object2, new RoutingPanel$1());
            object2 = new ArrayList<Duration>(Arrays.asList(object2));
            this.ignoreTimeStepChange = true;
            RmaListModel rmaListModel = new RmaListModel(false);
            Object object3 = object2.iterator();
            while (object3.hasNext()) {
                object = (Duration)object3.next();
                rmaListModel.addElement((Object)TimeStepUtil.a((Duration)object));
            }
            this._timeStepCombo.setModel((ComboBoxModel)rmaListModel);
            this.ignoreTimeStepChange = false;
            object = object2.iterator();
            while (object.hasNext()) {
                object2 = (Duration)object.next();
                object3 = timeStepRoutingElement.getFunction((Duration)object2, null);
                if (object3 == null) continue;
                this._timeStepCombo.setSelectedItem((Object)TimeStepUtil.a((Duration)object2));
                break;
            }
            if (this._rssAlt != null && (object = RoutingPanel.a(this._rssAlt.getTimestep(), this._rssAlt.getTimestepIncrement())) != null) {
                for (int i = 0; i < rmaListModel.size(); ++i) {
                    object3 = (TimeStepUtil)((Object)rmaListModel.get(i));
                    if (!((String)object).equalsIgnoreCase(((TimeStepUtil)((Object)object3)).toString())) continue;
                    this._timeStepCombo.setSelectedItem(object3);
                    break;
                }
            }
            return;
        }
        finally {
            this.setFowardModifiedEvents(true);
        }
    }

    public static String a(int n, int n2) {
        switch (n2) {
            case 3: {
                String cfr_ignored_0 = String.valueOf(n) + " Day";
            }
            case 1: {
                String cfr_ignored_1 = String.valueOf(n) + " Minute";
            }
        }
        Object object = String.valueOf(n) + " Hour";
        if (n > 1) {
            object = ((String)object).concat("s");
        }
        return object;
    }

    @Override
    public void itemStateChanged(ItemEvent object) {
        Object object2 = ((EventObject)object).getSource();
        if (((ItemEvent)object).getStateChange() == 2) {
            return;
        }
        if (object2 == this._routingCmb) {
            object = (TimeStepUtil)((Object)this._timeStepCombo.getSelectedItem());
            object2 = (String)((JComboBox)object2).getSelectedItem();
            Function function = null;
            if (this._parentElement != null && object != null) {
                function = this._parentElement.getFunction(((TimeStepUtil)((Object)object)).getDuration(), null);
            } else if (this._parentElement != null && object == null) {
                function = this._parentElement.getFunction();
            }
            String string = "";
            if (object2 != null) {
                Object object3;
                Object object4 = object3 = object != null ? ((TimeStepUtil)((Object)object)).toString() : "";
                if (((String)object2).equals(NULL_ROUTING)) {
                    string = this._cardPanelKeyFormat.format(new String[]{object3, NULL_ROUTING});
                } else if (((String)object2).equals(COEF_ROUTING)) {
                    string = this._cardPanelKeyFormat.format(new String[]{object3, COEF_ROUTING});
                } else if (((String)object2).equals(MUSK_ROUTING)) {
                    string = this._cardPanelKeyFormat.format(new String[]{object3, MUSK_ROUTING});
                } else if (((String)object2).equals(MUSK8PT_ROUTING)) {
                    string = this._cardPanelKeyFormat.format(new String[]{object3, MUSK8PT_ROUTING});
                } else if (((String)object2).equals(MUSKPRISM_ROUTING)) {
                    string = this._cardPanelKeyFormat.format(new String[]{object3, MUSKPRISM_ROUTING});
                } else if (((String)object2).equals(MODPULS_ROUTING)) {
                    string = this._cardPanelKeyFormat.format(new String[]{object3, MODPULS_ROUTING});
                } else if (((String)object2).equals(WORKINGRD_ROUTING)) {
                    string = this._cardPanelKeyFormat.format(new String[]{object3, WORKINGRD_ROUTING});
                } else if (((String)object2).equals(SSARR_ROUTING)) {
                    string = this._cardPanelKeyFormat.format(new String[]{object3, SSARR_ROUTING});
                } else if (((String)object2).equals(VARLAGK_ROUTING)) {
                    string = this._cardPanelKeyFormat.format(new String[]{object3, VARLAGK_ROUTING});
                }
                object3 = this._timeStepToPanelNameMap.get(object);
                if (object3 == null || !((String)object3).equals(object2) && this._tsRoutingMapToPanel.get(string) == null) {
                    CardLayout cfr_ignored_0 = (CardLayout)this._cardpanel1.getLayout();
                    this._timeStepToPanelNameMap.put((TimeStepUtil)((Object)object), (String)object2);
                    object3 = this.buildRoutingPanel((String)object2);
                    if (((String)object2).equals(MUSKPRISM_ROUTING) && this._parentElement != null) {
                        if (function instanceof MuskingumCungeRouting && (((MuskingumCungeRouting)function).getChannel() instanceof TrapezoidalChannel || ((MuskingumCungeRouting)function).getChannel() instanceof CircularChannel)) {
                            object3.fillPanel(function);
                        } else {
                            object3.fillPanel(new MuskingumCungeRouting(this._parentElement, ChannelType.TRAPEZOID));
                        }
                    } else if (((String)object2).equals(MUSK8PT_ROUTING) && this._parentElement != null) {
                        if (function instanceof MuskingumCungeRouting && ((MuskingumCungeRouting)function).getChannel() instanceof EightPointChannel) {
                            object3.fillPanel(function);
                        } else {
                            object3.fillPanel(new MuskingumCungeRouting(this._parentElement, ChannelType.EIGHT_POINT));
                        }
                    } else if (function != null && object3.canHandleFunction(function)) {
                        object3.fillPanel(function);
                    }
                    this._cardpanel1.add((Component)object3, string);
                    ServiceLookup.getUnitsDisplayService().updateUnitSystem((Container)this._cardpanel1);
                    this._cardpanel1.revalidate();
                } else if (!((String)object3).equals(object2)) {
                    this._timeStepToPanelNameMap.put((TimeStepUtil)((Object)object), (String)object2);
                }
                ((CardLayout)this._cardpanel1.getLayout()).show(this._cardpanel1, string);
                this._cardpanel1.revalidate();
                this._cardpanel1.requestFocus();
                int n = this._cardpanel1.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    object2 = this._cardpanel1.getComponent(i);
                    if (!((Component)object2).isVisible()) continue;
                    this._tsRoutingMapToPanel.put(string, (RoutingPanel$IRoutingPanel)object2);
                    return;
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    @Override
    public void editingStopped(ChangeEvent object) {
        object = (String)this._routingCmb.getSelectedItem();
        if (object == null) {
            return;
        }
    }

    public boolean validatePanel(Container componentArray) {
        if (componentArray == null) {
            return true;
        }
        componentArray = componentArray.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof RmaValidComponent ? !((RmaValidComponent)componentArray[i]).isValid(true) : componentArray[i] instanceof Container && !this.validatePanel((Container)componentArray[i]))) continue;
            return false;
        }
        return true;
    }

    protected RoutingPanel$NullRoutingPanel buildNullRoutingPanel() {
        return new RoutingPanel$NullRoutingPanel(this);
    }

    protected RoutingPanel$CoefRoutingPanel buildCoefRoutingPanel() {
        return new RoutingPanel$CoefRoutingPanel(this);
    }

    public Function getSelectedFunction() {
        Component[] componentArray = this._cardpanel1.getComponents();
        Object object = componentArray;
        object = componentArray;
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            Component component = object[i];
            if (!component.isVisible()) continue;
            object = ((RoutingPanel$IRoutingPanel)((Object)component)).getFunction();
            if (object == null) {
                return null;
            }
            object = (Function)object.clone();
            object.setElement(this._parentElement);
            ((RoutingPanel$IRoutingPanel)((Object)component)).savePanel(object);
            return object;
        }
        return null;
    }

    public int getMaxNumberSubReaches() {
        return Integer.getInteger("maximumSubreaches", 10000);
    }

    protected RoutingPanel$MuskingumRoutingPanel buildMuskRoutingPanel() {
        return new RoutingPanel$MuskingumRoutingPanel(this);
    }

    protected RoutingPanel$MuskingumCungePrismPanel buildPrismaticChannelPanel() {
        return new RoutingPanel$MuskingumCungePrismPanel(this);
    }

    protected RoutingPanel$MuskingumCunge8PtRoutingPanel build8PointChannelPanel() {
        return new RoutingPanel$MuskingumCunge8PtRoutingPanel(this);
    }

    protected RoutingPanel$ModifiedPulseRoutingPanel buildModifiedPulsPanel() {
        return new RoutingPanel$ModifiedPulseRoutingPanel(this);
    }

    protected RoutingPanel$SsarrRoutingPanel buildSSARRPanel() {
        return new RoutingPanel$SsarrRoutingPanel(this);
    }

    protected RoutingPanel$WorkingRDPanel buildWorkingRDPanel() {
        return new RoutingPanel$WorkingRDPanel(this);
    }

    protected RoutingPanel$LagKDPanel buildVarLagKpanel() {
        return new RoutingPanel$LagKDPanel(this);
    }

    private void configureLagPlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Inflow (%S)";
        g2dPlotProp.y1AxisProp.name = "Lag (hrs.)";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    private void configureKPlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Outflow (%S)";
        g2dPlotProp.y1AxisProp.name = "K (hrs.)";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    protected void finalize() throws Throwable {
    }

    void configurePlotPanel_8pt(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Station (%S)";
        g2dPlotProp.y1AxisProp.name = "Elev (%S)";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    void configurePlotPanel(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Storage (%S)";
        g2dPlotProp.y1AxisProp.name = "Outflow (%S)";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    void configurePlotPanel_modpuls_elev(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Storage (%S)";
        g2dPlotProp.y1AxisProp.name = "Elev (%S)";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    private void initParamDoubleTable(int n, int n2, RmaJTable rmaJTable) {
        Object[][] objectArray = new String[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                objectArray[i][j] = "";
            }
        }
        ((ParamDoubleTableModel)rmaJTable.getModel()).setData(objectArray);
    }

    public List<TimeStepUtil> getRoutingTimeSteps() {
        ArrayList<TimeStepUtil> arrayList = new ArrayList<TimeStepUtil>();
        int n = this._timeStepCombo.getItemCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add((TimeStepUtil)((Object)this._timeStepCombo.getItemAt(i)));
        }
        return arrayList;
    }

    public void setAlternative(RssAlt rssAlt) {
        this._rssAlt = rssAlt;
    }
}

