/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.server;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.model.ComputeInfo;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.rmi.csinterface.RmiDataListContainer;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.clientapp.server.RmiWorkspaceImpl;
import hec.heclib.util.HecTime;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.Logger;
import hec.lang.ModelReference;
import hec.lang.UserId;
import hec.map.MapIdentifier;
import hec.map.WorldRect;
import hec.model.RunTimeWindow;
import hec.rss.RssRmiWorkspace;
import hec.rss.model.ComputeStatus;
import hec.rss.model.ReservoirOp;
import hec.rss.model.ReservoirSysOp;
import hec.rss.model.RssAlt;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.server.RssAdvancedOptions;
import hec.rss.server.RssComputeOptions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.server.PortableRmiObject;
import mil.army.usace.hec.rmi.server.RMIComputeCanceledCallbackImpl;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import rma.lang.NestingException;
import rma.util.RMAIO;

public class RssRmiWorkspaceImpl
extends RmiWorkspaceImpl
implements RssRmiWorkspace {
    HecTime _startOfWaterYear = new HecTime("01JAN");
    String _currentRssLpAltName = "";
    String _currentRssLpRunName = "";
    private RssComputeOptions _computeOptions = new RssComputeOptions();
    private RssAdvancedOptions _advancedOptions = new RssAdvancedOptions();
    private FluentLogger _logger = FluentLogger.forEnclosingClass();

    public RssRmiWorkspaceImpl(int n) throws RemoteException {
        super(n);
        this._typeOfWorkspace = "rss";
    }

    public RssRmiWorkspaceImpl(Integer n) throws RemoteException {
        this((int)n);
    }

    public RssRmiWorkspaceImpl(String string, Identifier identifier) throws RemoteException {
        this(8089);
        this.setIdentifier(string, identifier);
        this._lockedBy = string;
        try {
            this.addUser(string);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace(System.out);
            return;
        }
    }

    @Override
    public RssComputeOptions getDefaultRssComputeOptions() {
        return new RssComputeOptions();
    }

    @Override
    public RssComputeOptions getRssComputeOptions() {
        if (this._computeOptions == null) {
            this._computeOptions = new RssComputeOptions();
        }
        return this._computeOptions;
    }

    @Override
    public void setRssComputeOptions(RssComputeOptions rssComputeOptions) {
        if (rssComputeOptions != null) {
            this._computeOptions = rssComputeOptions;
        }
    }

    public RssAdvancedOptions getDefaultRssAdvancedOptions() {
        return new RssAdvancedOptions();
    }

    @Override
    public RssAdvancedOptions getRssAdvancedOptions() {
        if (this._advancedOptions == null) {
            this._advancedOptions = new RssAdvancedOptions();
        }
        return this._advancedOptions;
    }

    @Override
    public void setRssAdvancedOptions(RssAdvancedOptions rssAdvancedOptions) {
        if (rssAdvancedOptions != null) {
            this._advancedOptions = rssAdvancedOptions;
        }
    }

    protected String getRunClassName() {
        return RssRun.class.getName();
    }

    @Override
    public HecTime getStartOfWaterYear() {
        return this._startOfWaterYear;
    }

    @Override
    public String getStartOfWaterYearString() {
        return this._startOfWaterYear.date(4).substring(0, 5);
    }

    @Override
    public void setStartOfWaterYear(HecTime hecTime) {
        if (hecTime == null || !hecTime.isDefined()) {
            return;
        }
        this._startOfWaterYear = new HecTime(hecTime.date(4).substring(0, 5));
    }

    @Override
    public void setStartOfWaterYear(String string) {
        if (string == null) {
            return;
        }
        if (!(string = new HecTime(string)).isDefined()) {
            return;
        }
        this._startOfWaterYear = new HecTime(string.date(4).substring(0, 5));
    }

    @Override
    public void setRssLpAltName(String string) {
        this._currentRssLpAltName = string;
    }

    @Override
    public void setRssLpRunName(String string) {
        this._currentRssLpRunName = string;
    }

    @Override
    public String getRssLpAltName() {
        return this._currentRssLpAltName;
    }

    @Override
    public String getRssLpRunName() {
        return this._currentRssLpRunName;
    }

    public int computeAlternative(ComputeInfo computeInfo) throws NestingException {
        String string;
        RMIComputeCanceledCallbackImpl rMIComputeCanceledCallbackImpl;
        Object object;
        RssRun rssRun;
        RssAlt rssAlt;
        long l;
        block49: {
            block48: {
                ModelReference modelReference;
                block47: {
                    l = System.currentTimeMillis();
                    RMAIO.getVersionStamp();
                    rssAlt = null;
                    rssRun = null;
                    if (!this.isValidTimeWindown(computeInfo.runTimeWindow, computeInfo.uiWrapper)) {
                        return 2;
                    }
                    object = !RMAIO.isFullPath((String)computeInfo.outputDSSFileName) ? computeInfo.forecastpath + "/" + computeInfo.outputDSSFileName : computeInfo.outputDSSFileName;
                    this.printLogMessage(computeInfo.uiWrapper, "DssFile=" + (String)object);
                    if (!this.checkDSSOutputFile((String)object, computeInfo.uiWrapper)) {
                        return 2;
                    }
                    rMIComputeCanceledCallbackImpl = null;
                    try {
                        modelReference = computeInfo.modelRef;
                        if (modelReference != null) break block47;
                        this.printErrorMessage(computeInfo.uiWrapper, "Failed to find ModelReference for " + computeInfo.altname);
                        ((FluentLogger.Api)this._logger.atSevere()).log("no ModelReference in ComputeInfo");
                    }
                    catch (Throwable throwable) {
                        this.removeComputeCanceler(computeInfo.uiWrapper, rMIComputeCanceledCallbackImpl);
                        try {
                            PortableRmiObject.unexportObject(rMIComputeCanceledCallbackImpl, (boolean)true);
                        }
                        catch (Exception exception) {}
                        if (rssAlt != null) {
                            if (rssAlt.getSystem().isModified()) {
                                this._managerProxys.saveManager(UserId.getUserId(), (Manager)rssAlt.getSystem());
                            }
                            if (rssAlt.isModified()) {
                                this._managerProxys.saveManager(UserId.getUserId(), (Manager)rssAlt);
                            }
                            this._managerProxys.unloadManager(rssAlt.getIdentifier());
                        }
                        if (rssRun != null) {
                            this._managerProxys.unloadManager(rssRun.getIdentifier());
                        }
                        long l2 = System.currentTimeMillis();
                        ((FluentLogger.Api)this._logger.atFine()).log("Compute for " + computeInfo.modelAltname + " took " + (l2 - l) + " ms");
                        throw throwable;
                    }
                    this.removeComputeCanceler(computeInfo.uiWrapper, null);
                    try {
                        PortableRmiObject.unexportObject(null, (boolean)true);
                    }
                    catch (Exception exception) {}
                    long l3 = System.currentTimeMillis();
                    ((FluentLogger.Api)this._logger.atFine()).log("Compute for " + computeInfo.modelAltname + " took " + (l3 - l) + " ms");
                    return 2;
                }
                if (computeInfo.computeType == 2) {
                    ((FluentLogger.Api)this._logger.atInfo()).log("computeAlternative:loading Alternative " + computeInfo.altname);
                    rssAlt = (RssAlt)this._managerProxys.openManager(new Identifier(computeInfo.altname));
                }
                if (rssAlt == null) {
                    try {
                        rssAlt = (RssAlt)this._managerProxys.openManager(modelReference.wkspName, modelReference.className, modelReference.newId);
                    }
                    catch (Exception exception) {
                        ((FluentLogger.Api)((FluentLogger.Api)this._logger.atWarning()).withCause((Throwable)exception)).log("failed to load mgr " + String.valueOf(modelReference));
                    }
                }
                if (rssAlt != null) break block48;
                ((FluentLogger.Api)this._logger.atSevere()).log("Failed to load RSS Alt " + computeInfo.modelAltname);
                this.printErrorMessage(computeInfo.uiWrapper, "Failed to load RSS Alternative " + computeInfo.altname);
                this.removeComputeCanceler(computeInfo.uiWrapper, null);
                try {
                    PortableRmiObject.unexportObject(null, (boolean)true);
                }
                catch (Exception exception) {}
                if (rssAlt != null) {
                    if (rssAlt.getSystem().isModified()) {
                        this._managerProxys.saveManager(UserId.getUserId(), (Manager)rssAlt.getSystem());
                    }
                    if (rssAlt.isModified()) {
                        this._managerProxys.saveManager(UserId.getUserId(), (Manager)rssAlt);
                    }
                    this._managerProxys.unloadManager(rssAlt.getIdentifier());
                }
                long l4 = System.currentTimeMillis();
                ((FluentLogger.Api)this._logger.atFine()).log("Compute for " + computeInfo.modelAltname + " took " + (l4 - l) + " ms");
                return 2;
            }
            if ("Untitled".equals(rssAlt.getName())) {
                rssAlt.reLoadFile();
            }
            ((FluentLogger.Api)this._logger.atInfo()).log("computing " + String.valueOf(rssAlt));
            RssSystem rssSystem = rssAlt.getSystem();
            if (rssSystem != null) {
                rssSystem.setComputeCanceled(false);
                rMIComputeCanceledCallbackImpl = this.setComputeCanceler(computeInfo.uiWrapper, rssSystem);
                if ("Untitled".equals(rssSystem.getName())) {
                    rssSystem.reLoadFile();
                }
            } else {
                this.printErrorMessage(computeInfo.uiWrapper, "Failed to load ResSim Network " + rssAlt.getSystemPath());
            }
            if ((rssRun = this.getRssRun(string = computeInfo.modelAltname.substring(0, computeInfo.modelPosition * computeInfo.nameMultiplier))) != null) break block49;
            this.printErrorMessage(computeInfo.uiWrapper, "Failed to load ResSim Run " + string);
            this.removeComputeCanceler(computeInfo.uiWrapper, rMIComputeCanceledCallbackImpl);
            try {
                PortableRmiObject.unexportObject((Remote)rMIComputeCanceledCallbackImpl, (boolean)true);
            }
            catch (Exception exception) {}
            if (rssAlt != null) {
                if (rssAlt.getSystem().isModified()) {
                    this._managerProxys.saveManager(UserId.getUserId(), (Manager)rssAlt.getSystem());
                }
                if (rssAlt.isModified()) {
                    this._managerProxys.saveManager(UserId.getUserId(), (Manager)rssAlt);
                }
                this._managerProxys.unloadManager(rssAlt.getIdentifier());
            }
            if (rssRun != null) {
                this._managerProxys.unloadManager(rssRun.getIdentifier());
            }
            long l5 = System.currentTimeMillis();
            ((FluentLogger.Api)this._logger.atFine()).log("Compute for " + computeInfo.modelAltname + " took " + (l5 - l) + " ms");
            return 2;
        }
        long l6 = rssRun.getRunModifiedTime();
        rssRun.setRunId(string);
        rssRun.setForecastDir(computeInfo.forecastpath);
        rssRun.setName(string);
        if (computeInfo.variant != null) {
            rssRun.setVariantName(computeInfo.variant);
        }
        RemoteWrapper remoteWrapper = new RemoteWrapper();
        remoteWrapper.setRemote((Remote)((Object)this));
        rssRun.setWorkspace(remoteWrapper);
        rssRun.setProxyList(this._managerProxys);
        rssRun.setAltPath(rssAlt.getIdentifier().getPath());
        rssRun.setDSSOutputFile((String)object);
        rssRun.setLastModifiedTime(l6);
        rssRun.setAdditionalComputeOptions(computeInfo.additionalOptions);
        object = rssAlt.getComputeLauncher();
        object.setComputeInformation(computeInfo, this, rssRun, rssAlt, rMIComputeCanceledCallbackImpl);
        this.printMessage(computeInfo.uiWrapper, "Using Compute Launcher " + String.valueOf(object));
        int n = object.compute();
        switch (n) {
            case 3: {
                rssRun.setLastComputeStatus(ComputeStatus.CANCELED);
                break;
            }
            case 2: {
                rssRun.setLastComputeStatus(ComputeStatus.FAILED);
                break;
            }
            case 1: {
                rssRun.setLastComputeStatus(ComputeStatus.SKIPPED);
                break;
            }
            case 0: {
                rssRun.setLastComputeStatus(ComputeStatus.SUCCESSFUL);
                break;
            }
            default: {
                rssRun.setLastComputeStatus(ComputeStatus.UNKNOWN);
            }
        }
        this._managerProxys.saveManager(UserId.getUserId(), (Manager)rssRun);
        this.removeComputeCanceler(computeInfo.uiWrapper, rMIComputeCanceledCallbackImpl);
        try {
            PortableRmiObject.unexportObject((Remote)rMIComputeCanceledCallbackImpl, (boolean)true);
        }
        catch (Exception exception) {}
        if (rssAlt != null) {
            if (rssAlt.getSystem().isModified()) {
                this._managerProxys.saveManager(UserId.getUserId(), (Manager)rssAlt.getSystem());
            }
            if (rssAlt.isModified()) {
                this._managerProxys.saveManager(UserId.getUserId(), (Manager)rssAlt);
            }
            this._managerProxys.unloadManager(rssAlt.getIdentifier());
        }
        if (rssRun != null) {
            this._managerProxys.unloadManager(rssRun.getIdentifier());
        }
        long l7 = System.currentTimeMillis();
        ((FluentLogger.Api)this._logger.atFine()).log("Compute for " + computeInfo.modelAltname + " took " + (l7 - l) + " ms");
        return n;
    }

    private boolean isValidTimeWindown(RunTimeWindow runTimeWindow, RemoteWrapper remoteWrapper) {
        if (runTimeWindow == null) {
            this.printErrorMessage(remoteWrapper, "Invalid Time Window. The RunTimeWindow is null.");
            return false;
        }
        HecTime hecTime = runTimeWindow.getLookbackTime();
        HecTime hecTime2 = runTimeWindow.getStartTime();
        runTimeWindow = runTimeWindow.getEndTime();
        boolean bl = false;
        if (hecTime == null || !hecTime.isDefined()) {
            this.printErrorMessage(remoteWrapper, "Invalid Time Window. The Lookback Time is null or undefined.");
            bl = true;
        }
        if (hecTime2 == null || !hecTime2.isDefined()) {
            this.printErrorMessage(remoteWrapper, "Invalid Time Window. The Start Time time is null or undefined.");
            bl = true;
        }
        if (runTimeWindow == null || !runTimeWindow.isDefined()) {
            this.printErrorMessage(remoteWrapper, "Invalid Time Window. The End Time time is null or undefined.");
            bl = true;
        }
        if (bl) {
            return false;
        }
        hecTime = (HecTime)hecTime.clone();
        hecTime.showTimeAsBeginningOfDay(true);
        hecTime2 = (HecTime)hecTime2.clone();
        hecTime2.showTimeAsBeginningOfDay(true);
        if (!hecTime.lessThan(hecTime2)) {
            this.printErrorMessage(remoteWrapper, "Invalid Time Window. The Lookback Time (" + hecTime.dateAndTime(7) + ") must be before the Start Time (" + hecTime2.dateAndTime(7) + ")");
            this.printTimeWindow(hecTime, hecTime2, (HecTime)runTimeWindow, remoteWrapper);
            return false;
        }
        if (!hecTime2.lessThan((HecTime)runTimeWindow)) {
            this.printErrorMessage(remoteWrapper, "Invalid Time Window. The Start Time (" + hecTime2.dateAndTime(7) + ") must be before the End Time (" + runTimeWindow.dateAndTime(7) + ")");
            this.printTimeWindow(hecTime, hecTime2, (HecTime)runTimeWindow, remoteWrapper);
            return false;
        }
        return true;
    }

    private void printTimeWindow(HecTime hecTime, HecTime hecTime2, HecTime hecTime3, RemoteWrapper remoteWrapper) {
        this.printMessage(remoteWrapper, "Run Time Window:");
        this.printMessage(remoteWrapper, "  Lookback Time:" + hecTime.dateAndTime(7));
        this.printMessage(remoteWrapper, "  Start Time :" + hecTime2.dateAndTime(7));
        this.printMessage(remoteWrapper, "  End Time :" + hecTime3.dateAndTime(7));
    }

    private boolean checkDSSOutputFile(String string, RemoteWrapper remoteWrapper) {
        DSSManager dSSManager;
        try {
            dSSManager = (DSSManager)this.getDSSFileManager().getRemote();
        }
        catch (RemoteException remoteException) {
            System.out.println("checkDssOutputFile: RemoteException getting DSSFileManager " + String.valueOf(remoteException));
            return true;
        }
        try {
            if (!dSSManager.fileAccessible(string)) {
                this.printErrorMessage(remoteWrapper, "Compute Stopped. Can't write to " + string + ". File is not accessible");
                return false;
            }
            dSSManager = this.getFileManager();
            Identifier identifier = new Identifier(string);
            if ((dSSManager = dSSManager.openFile(UserId.getUserId(), identifier)) != null && (dSSManager = dSSManager.getFile()) != null && !dSSManager.canWrite()) {
                this.printErrorMessage(remoteWrapper, "Compute Stopped. Can't write to " + string + ". File is not writable");
                return false;
            }
            return true;
        }
        catch (RemoteException remoteException) {
            System.out.println("checkDSSOutputFile: RemoteException " + String.valueOf(remoteException));
            return true;
        }
    }

    public RssRun getRssRun(String string, boolean bl) {
        if (bl) {
            return this.getRssRunFromWksp(string);
        }
        return this.getRssRun(string);
    }

    protected RssRun getRssRunFromWksp(String string) {
        Object object;
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() / 2);
        stringBuffer.append(string.charAt(0));
        for (int i = 1; i < string.length(); ++i) {
            if (i % 2 != 0) continue;
            stringBuffer.append(string.charAt(i));
        }
        string = stringBuffer.toString();
        String string2 = this.getWorkspacePath() + "/rss/" + RMAIO.userNameToFileName((String)string) + ".rssrun";
        string2 = new Identifier(string2);
        try {
            object = this.getFileManager();
            stringBuffer = object.openFile(UserId.getUserId(), (Identifier)string2);
            if (stringBuffer == null) {
                stringBuffer = object.newFile(UserId.getUserId(), (Identifier)string2);
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("getRssRunFromWksp:RemoteException opening " + string2.getPath() + " error " + String.valueOf(remoteException));
            return null;
        }
        if (stringBuffer == null) {
            System.out.println("getRssRunFromWksp: failed to open/create RssRun file " + string2.getPath());
            return null;
        }
        object = (RssRun)this.openManager("rss", (Identifier)stringBuffer);
        stringBuffer.setName(string);
        if (object == null) {
            object = (RssRun)this.newManager("rss", this.getRunClassName());
            if (object == null) {
                System.out.println("getRssRunFromWksp:Failed to load ResSim run from " + stringBuffer.getPath());
                return null;
            }
            object.setIdentifier((Identifier)stringBuffer);
            if (stringBuffer.getFile().exists()) {
                ((RssRun)object).readFile((Identifier)stringBuffer);
            }
            object.getProxyList().saveManagerAs("rss", (Manager)object, (Identifier)string2);
        }
        object.setName(string);
        ((RssRun)object).setRunId(string);
        return object;
    }

    protected String getRssRunPath(String string) {
        return this.getRssRunPath(string, true);
    }

    protected String getRssRunPath(String string, boolean bl) {
        if (bl) {
            return this.getWorkspacePath() + "/rss/" + RMAIO.userNameToFileName((String)string) + ".rssrun";
        }
        return this.getWorkspacePath() + "/rss/" + string + ".rssrun";
    }

    protected RssRun getRssRun(String string) {
        boolean bl;
        RmiFileManager rmiFileManager;
        if (string == null) {
            return null;
        }
        String string2 = this.getRssRunPath(string, true);
        String[] stringArray = this.getRssRunPath(string, false);
        stringArray = new String[]{string2, stringArray};
        System.out.println("getRssRun: retrieving RssRun " + string2);
        string2 = null;
        new Identifier();
        Identifier identifier = null;
        try {
            rmiFileManager = this.getFileManager();
        }
        catch (Exception exception) {
            System.out.println("getRssRun: RMI error getting fileManager " + String.valueOf(exception));
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            identifier = new Identifier(stringArray[i]);
            identifier.setName(string);
            identifier.setDescription("ResSim Run for " + string);
            try {
                string2 = rmiFileManager.openFile(UserId.getUserId(), identifier);
            }
            catch (RemoteException remoteException) {
                System.out.println("getRssRun:RemoteException opening " + identifier.getPath() + " error " + String.valueOf(remoteException));
                return null;
            }
            if (string2 != null) break;
        }
        if (string2 == null) {
            identifier.setPath(stringArray[0]);
            try {
                string2 = rmiFileManager.newFile(UserId.getUserId(), identifier);
            }
            catch (RemoteException remoteException) {
                System.out.println("getRssRun:RemoteException creating " + identifier.getPath() + " error " + String.valueOf(remoteException));
                return null;
            }
        }
        if (string2 == null) {
            System.out.println("getRssRun:Failed to open ResSim run file " + identifier.getPath());
            return null;
        }
        RssRun rssRun = (RssRun)this.openManager((Identifier)string2);
        string2.setName(string);
        boolean bl2 = bl = rssRun == null;
        if (rssRun == null) {
            rssRun = (RssRun)this.newManager("rss", this.getRunClassName());
            if (rssRun == null) {
                System.out.println("getRssRun:Failed to load ResSim run from " + string2.getPath());
                return null;
            }
            System.out.println("getRssRun:****RSSRun class is " + rssRun.getClass().getName());
            rssRun.setIdentifier((Identifier)string2);
            rssRun.setName(string);
            if (string2.getFile().exists()) {
                rssRun.readFile((Identifier)string2);
            }
            rssRun.setName(string);
            identifier.setDescription("ResSim Run for " + string);
            rssRun.setRunId(string);
        }
        if (bl) {
            rssRun.getProxyList().saveManagerAs("rss", (Manager)rssRun, identifier);
        }
        return rssRun;
    }

    public boolean load() {
        HecFile hecFile = this.identifier.getFile();
        if (hecFile != null) {
            this.readConfiguration(hecFile);
            return true;
        }
        return false;
    }

    public void saveWorkspace(String string) throws RemoteException {
        string = this.identifier.getFile();
        if (string != null) {
            System.out.println("Save the Workspace " + this.getTitleName());
            this.writeConfiguration((HecFile)string);
            return;
        }
        System.out.println("Workspace " + this.getTitleName() + " not Saved.");
    }

    public void closeWorkspace(String string) throws RemoteException {
        System.out.println("Save and Close the Workspace");
        this.saveWorkspace(string);
        this.removeUser(string);
        if (this._listOfUsers.size() <= 0) {
            if (!this._local) {
                try {
                    Naming.unbind(this.stringUrl + this.getName());
                }
                catch (Throwable throwable) {
                    System.out.println("Exception trying to Close the Workspace");
                    System.out.println(throwable.getMessage() + "...." + throwable.toString());
                    throwable.printStackTrace(System.out);
                }
            }
            System.gc();
        }
    }

    public Vector getRunList() throws RemoteException {
        return new Vector();
    }

    public String computeRun(Identifier identifier) throws RemoteException {
        String string = identifier.getName();
        identifier.getDescription();
        identifier.getPath();
        System.out.println("Run Name : " + string);
        System.out.println(identifier.toString());
        return "This was returned by the Server";
    }

    protected synchronized void readConfiguration(HecFile object) {
        if (object == null) {
            return;
        }
        if (!object.canRead()) {
            return;
        }
        boolean bl = Logger.canDebug((String)"rmiworkspace");
        object = object.getBufferedReader();
        if (this._computeOptions == null) {
            this._computeOptions = new RssComputeOptions();
        }
        if (this._advancedOptions == null) {
            this._advancedOptions = new RssAdvancedOptions();
        }
        try {
            Object object2 = ((BufferedReader)object).readLine();
            while (object2 != null) {
                object2 = ((String)object2).trim();
                if (bl) {
                    System.out.println((String)object2);
                }
                if (((String)object2).indexOf("MapBegin") >= 0) {
                    this.readMap((BufferedReader)object);
                } else if (((String)object2).indexOf("ManagerProxyBegin") >= 0) {
                    this.readManagerProxy((BufferedReader)object);
                } else {
                    String string = RMAIO.getType((String)object2, (String)"=");
                    object2 = RMAIO.getParam((String)object2, (String)"=");
                    if (string.compareTo("WorkspaceName") == 0) {
                        this.setName((String)object2);
                        this.identifier.setName((String)object2);
                    } else if (string.compareTo("WorkspaceDescription") == 0) {
                        this.identifier.setDescription((String)object2);
                    } else if (string.compareTo("Extents") == 0) {
                        object2 = new StringTokenizer((String)object2, ",");
                        string = ((StringTokenizer)object2).nextToken();
                        String string2 = ((StringTokenizer)object2).nextToken();
                        String string3 = ((StringTokenizer)object2).nextToken();
                        object2 = ((StringTokenizer)object2).nextToken();
                        double d = new Double(string);
                        double d2 = new Double(string2);
                        double d3 = new Double(string3);
                        double d4 = new Double((String)object2);
                        this._extents = new WorldRect(d, d4, d2, d3);
                    } else if (string.equals("StartOfWaterYear")) {
                        this.setStartOfWaterYear((String)object2);
                    } else if (string.equals("MinComputePasses")) {
                        this._computeOptions.minComputePasses = Integer.parseInt((String)object2);
                    } else if (string.equals("StorCalcErrTolFac")) {
                        this._computeOptions.storCalcErrTolFac = Double.parseDouble((String)object2);
                    } else if (string.equals("StorCalcSubSteps")) {
                        this._computeOptions.storCalcSubSteps = Integer.parseInt((String)object2);
                    } else if (string.equals("SaveReleaseToGuideCurve")) {
                        this._computeOptions._saveReleaseToGuideCurve = Boolean.parseBoolean((String)object2);
                    } else if (string.equals("NoSysHydroRoutingSteps")) {
                        this._computeOptions._noSysHydroRoutingSteps = Boolean.parseBoolean((String)object2);
                    } else if (string.equals("InvalidGlobalVariableIsError")) {
                        this._computeOptions.setInvalidGlobalVariableIsError(Boolean.parseBoolean((String)object2));
                    } else if (string.equals("ConsiderROC")) {
                        this._computeOptions.setConsiderROC(Boolean.parseBoolean((String)object2));
                    } else if (string.equals("UseLookAhead")) {
                        this._computeOptions.setUseLookAhead(Boolean.parseBoolean((String)object2));
                    } else if (string.equals("IterateNonConstantROC")) {
                        this._computeOptions.setIterateNonConstantROC(Boolean.parseBoolean((String)object2));
                    } else if (string.equals("MinLookAheadDays")) {
                        this._computeOptions.setMinLookAheadDays(Double.parseDouble((String)object2));
                    } else if (string.equals("MaxLookAheadDays")) {
                        this._computeOptions.setMaxLookAheadDays(Double.parseDouble((String)object2));
                    } else if (string.equals("MaxIterNonConstROC")) {
                        this._computeOptions.setMaxIterNonConstROC(Integer.parseInt((String)object2));
                    } else if (string.equals("FlowTol")) {
                        this._computeOptions.setFlowTol(Double.parseDouble((String)object2));
                    } else if (string.equals("StorTol")) {
                        this._computeOptions.setStorTol(Double.parseDouble((String)object2));
                    } else if (string.equals("InducedSurchargeMaxIter")) {
                        this._computeOptions.setInducedSurchargeMaxIterations(Integer.parseInt((String)object2));
                    } else if (string.equals("RssLpAltName")) {
                        this.setRssLpAltName((String)object2);
                    } else if (string.equals("RssLpRunName")) {
                        this.setRssLpRunName((String)object2);
                    } else if (string.equals("AllowStateVarsAsJavaClasses")) {
                        this._advancedOptions.setAllowStateVarsAsJavaClasses(Boolean.parseBoolean((String)object2));
                    } else if (string.equals("AllowScriptedRulesAsJavaClasses")) {
                        this._advancedOptions.setAllowScriptedRulesAsJavaClasses(Boolean.parseBoolean((String)object2));
                    } else if (string.equals("HasWaterQualityModule")) {
                        this._advancedOptions.setHasWaterQuality(Boolean.parseBoolean((String)object2));
                    }
                }
                object2 = ((BufferedReader)object).readLine();
            }
            ((BufferedReader)object).close();
        }
        catch (Exception exception) {
            System.out.println("Error reading in RSS data file  " + String.valueOf(exception));
        }
        RssRmiWorkspaceImpl rssRmiWorkspaceImpl = this;
        rssRmiWorkspaceImpl.createDefaultDataLists((RmiDataListContainer)rssRmiWorkspaceImpl.getDataListContainer());
    }

    protected synchronized void writeConfiguration(HecFile hecFile) {
        if (this._computeOptions == null) {
            this._computeOptions = new RssComputeOptions();
        }
        if (this._advancedOptions == null) {
            this._advancedOptions = new RssAdvancedOptions();
        }
        try {
            int n;
            BufferedWriter bufferedWriter = hecFile.getBufferedWriter();
            this.lineWrite(bufferedWriter, "WorkspaceName=" + this.identifier.getName());
            this.lineWrite(bufferedWriter, "WorkspaceDescription=" + this.identifier.getDescription());
            this.lineWrite(bufferedWriter, "StartOfWaterYear=" + this.getStartOfWaterYearString());
            this.lineWrite(bufferedWriter, "MinComputePasses=" + this._computeOptions.minComputePasses);
            this.lineWrite(bufferedWriter, "StorCalcErrTolFac=" + this._computeOptions.storCalcErrTolFac);
            this.lineWrite(bufferedWriter, "StorCalcSubSteps=" + this._computeOptions.storCalcSubSteps);
            this.lineWrite(bufferedWriter, "ConsiderROC=" + this._computeOptions.getConsiderROC());
            this.lineWrite(bufferedWriter, "UseLookAhead=" + Boolean.toString(this._computeOptions.getUseLookAhead()));
            this.lineWrite(bufferedWriter, "IterateNonConstantROC=" + Boolean.toString(this._computeOptions.getIterateNonConstantROC()));
            this.lineWrite(bufferedWriter, "MinLookAheadDays=" + Double.toString(this._computeOptions.getMinLookAheadDays()));
            this.lineWrite(bufferedWriter, "MaxLookAheadDays=" + Double.toString(this._computeOptions.getMaxLookAheadDays()));
            this.lineWrite(bufferedWriter, "MaxIterNonConstROC=" + Integer.toString(this._computeOptions.getMaxIterNonConstROC()));
            this.lineWrite(bufferedWriter, "FlowTol=" + Double.toString(this._computeOptions.getFlowTol()));
            this.lineWrite(bufferedWriter, "StorTol=" + Double.toString(this._computeOptions.getStorTol()));
            this.lineWrite(bufferedWriter, "InducedSurchargeMaxIter=" + Integer.toString(this._computeOptions.getInducedSurchargeMaxIterations()));
            this.lineWrite(bufferedWriter, "SaveReleaseToGuideCurve=" + this._computeOptions.saveReleaseToGuideCurve());
            this.lineWrite(bufferedWriter, "NoSysHydroRoutingSteps=" + this._computeOptions.noSysHydroRoutingSteps());
            this.lineWrite(bufferedWriter, "InvalidGlobalVariableIsError=" + this._computeOptions.invalidGlobalVariableIsError());
            Object object = Double.toString(this._extents.w);
            String string = Double.toString(this._extents.e);
            String string2 = Double.toString(this._extents.s);
            String string3 = Double.toString(this._extents.n);
            if (!(((String)object).equalsIgnoreCase("-infinity") && string.equalsIgnoreCase("-infinity") && string2.equalsIgnoreCase("-infinity") && string3.equalsIgnoreCase("-infinity"))) {
                object = "Extents=" + (String)object + "," + string + "," + string2 + "," + string3;
                this.lineWrite(bufferedWriter, (String)object);
            }
            if (this.getRssLpAltName().length() > 0 || this.getRssLpRunName().length() > 0) {
                this.lineWrite(bufferedWriter, "");
                this.lineWrite(bufferedWriter, "RssLpAltName=" + this.getRssLpAltName());
                this.lineWrite(bufferedWriter, "RssLpRunName=" + this.getRssLpRunName());
            }
            for (n = 0; n < this._mapIdentifiers.size(); ++n) {
                string = (MapIdentifier)this._mapIdentifiers.elementAt(n);
                this.lineWrite(bufferedWriter, "");
                this.lineWrite(bufferedWriter, "MapBegin");
                this.lineWrite(bufferedWriter, "Name=" + string.getName());
                this.lineWrite(bufferedWriter, "Description=" + string.getDescription());
                this.writePath(bufferedWriter, string.getFile().getPath(), "Path=");
                this.lineWrite(bufferedWriter, "Shown=" + string.getMapShown());
                this.lineWrite(bufferedWriter, "Class=" + string.getClassName());
                string = string.getGlyphDataRecord();
                if (string != null) {
                    this.lineWrite(bufferedWriter, "GlyphDataRecordBegin");
                    string.write(bufferedWriter);
                    this.lineWrite(bufferedWriter, "GlyphDataRecordEnd");
                }
                this.lineWrite(bufferedWriter, "MapEnd");
            }
            for (n = 0; n < this._managerProxys.size(); ++n) {
                string = (ManagerProxy)this._managerProxys.elementAt(n);
                string.write(bufferedWriter);
            }
            this.lineWrite(bufferedWriter, "AllowStateVarsAsJavaClasses=" + Boolean.toString(this._advancedOptions._allowStateVarAsJavaClass));
            this.lineWrite(bufferedWriter, "AllowScriptedRulesAsJavaClasses=" + Boolean.toString(this._advancedOptions._allowScriptedRuleAsJavaClass));
            this.lineWrite(bufferedWriter, "HasWaterQualityModule=" + this._advancedOptions.hasWaterQuality());
            bufferedWriter.flush();
            bufferedWriter.close();
            hecFile.save();
            return;
        }
        catch (Exception exception) {
            System.out.println("Exception trying to write configuration");
            System.out.println(exception.getMessage() + "...." + exception.toString());
            exception.printStackTrace(System.out);
            return;
        }
    }

    public void createDefaultDataLists() {
        RssRmiWorkspaceImpl rssRmiWorkspaceImpl = this;
        rssRmiWorkspaceImpl.createDefaultDataLists((RmiDataListContainer)rssRmiWorkspaceImpl.getDataListContainer());
    }

    public void createDefaultDataLists(RmiDataListContainer rmiDataListContainer) {
        String[] stringArray = new String[]{ReservoirOp.class.getName(), ReservoirSysOp.class.getName()};
        this.createDefaultDataLists(rmiDataListContainer, stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean copyRssRun(String string, String string2, int n, int n2, int n3, RunTimeWindow runTimeWindow) throws IllegalArgumentException {
        RssRmiWorkspaceImpl rssRmiWorkspaceImpl;
        RssRun rssRun;
        RssRun rssRun2;
        RssAlt rssAlt;
        RssAlt rssAlt2;
        block30: {
            block31: {
                block28: {
                    block29: {
                        block27: {
                            rssAlt2 = null;
                            rssAlt = null;
                            rssRun2 = null;
                            rssRun = null;
                            rssRmiWorkspaceImpl = null;
                            try {
                                if (string2 == null) {
                                    System.out.println("copyRssRun: invalid arguments recieved wkspPath=null");
                                    throw new IllegalArgumentException("Invalid arguments recievied wkspPath=null");
                                }
                                if (runTimeWindow == null) {
                                    System.out.println("copyRssRun: invalid arguments recieved RuntimeWindow=null");
                                    throw new IllegalArgumentException("Invalid arguments recievied RunTimeWIndow=null");
                                }
                                if (runTimeWindow.getEndTime() == null) {
                                    System.out.println("copyRssRun: invalid arguments recieved RuntimeWindow.endTime=null");
                                    throw new IllegalArgumentException("Invalid arguments recievied RunTimeWindow.EndTime=null");
                                }
                                if (runTimeWindow.getStartTime() == null) {
                                    System.out.println("copyRssRun: invalid arguments recieved RuntimeWindow.StartTime=null");
                                    throw new IllegalArgumentException("Invalid arguments recievied RunTimeWIndow.StartTime=null");
                                }
                                RssRmiWorkspace rssRmiWorkspace = null;
                                try {
                                    RmiWorkspace rmiWorkspace = this.getRmiApp().getRmiWkspByPath(string2);
                                    if (rmiWorkspace != null) {
                                        rssRmiWorkspace = (RssRmiWorkspace)rmiWorkspace.getChildWorkspace("rss");
                                    }
                                }
                                catch (RemoteException remoteException) {
                                    System.out.println("------------------------------------------------");
                                    System.out.println("copyRssRun: RMI Error getting workspace named " + string2 + " Error " + String.valueOf(remoteException));
                                    System.out.println("------------------------------------------------");
                                    return false;
                                }
                                if (!(rssRmiWorkspace instanceof RssRmiWorkspaceImpl)) {
                                    System.out.println("------------------------------------------------");
                                    System.out.println("copyRssRun: failed to get RmiWorkspaceImpl for " + string2);
                                    System.out.println("------------------------------------------------");
                                    return false;
                                }
                                rssRmiWorkspaceImpl = (RssRmiWorkspaceImpl)rssRmiWorkspace;
                                rssAlt = (RssAlt)rssRmiWorkspaceImpl.openManager("rss", RssAlt.class.getName(), n2);
                                if (rssAlt == null) {
                                    System.out.println("------------------------------------------------");
                                    System.out.println("copyRssRun: failed to get Forecast RSS Alternative for index=" + n2);
                                    System.out.println("------------------------------------------------");
                                    if (rssAlt == null) return false;
                                    break block27;
                                }
                                rssAlt2 = (RssAlt)this.openManager("rss", RssAlt.class.getName(), n);
                                if (rssAlt2 == null) {
                                    System.out.println("------------------------------------------------");
                                    System.out.println("copyRssRun: failed to get RSS Alternative for index=" + n);
                                    System.out.println("------------------------------------------------");
                                    if (rssAlt2 == null) break block28;
                                    break block29;
                                }
                                if (n3 != -1) {
                                    string = string.substring(0, (n3 << 1) + 2);
                                }
                                if ((rssRun2 = rssRmiWorkspaceImpl.getRssRunFromWksp(string)) == null) {
                                    System.out.println("copyRssRun:failed to get Destination RssRun");
                                    if (rssAlt2 == null) break block30;
                                    break block31;
                                }
                                rssRun2.setAltPath(rssAlt.getIdentifier().getPath());
                                rssRun2.setTimeWindow(runTimeWindow);
                                rssRun = this.getRssRun(string);
                                if (rssRun == null) {
                                    System.out.println("copyRssRun:failed to get Source RssRun");
                                    return false;
                                }
                                rssRun.setAltPath(rssAlt2.getIdentifier().getPath());
                                rssRun.setTimeWindow(runTimeWindow);
                                rssRun.updateReleaseOverrides();
                                rssRun.readReleaseOverrides();
                                if (!rssRun2.refreshData(rssRun)) return true;
                                rssRmiWorkspaceImpl.saveManager("rss", rssRun2);
                                return true;
                            }
                            catch (Exception exception) {
                                System.out.println("copyRssRun: Exception " + String.valueOf(exception));
                                exception.printStackTrace(System.out);
                                return false;
                            }
                        }
                        rssRmiWorkspaceImpl.unloadManager("rss", rssAlt.getIdentifier());
                        return false;
                    }
                    this.unloadManager("rss", rssAlt2.getIdentifier());
                }
                if (rssAlt == null) return false;
                rssRmiWorkspaceImpl.unloadManager("rss", rssAlt.getIdentifier());
                return false;
            }
            this.unloadManager("rss", rssAlt2.getIdentifier());
        }
        if (rssAlt != null) {
            rssRmiWorkspaceImpl.unloadManager("rss", rssAlt.getIdentifier());
        }
        if (rssRun2 == null) return false;
        rssRmiWorkspaceImpl.unloadManager("rss", rssRun2.getIdentifier());
        return false;
        finally {
            if (rssAlt2 != null) {
                this.unloadManager("rss", rssAlt2.getIdentifier());
            }
            if (rssRun != null) {
                this.unloadManager("rss", rssRun.getIdentifier());
            }
            if (rssAlt != null) {
                rssRmiWorkspaceImpl.unloadManager("rss", rssAlt.getIdentifier());
            }
            if (rssRun2 != null) {
                rssRmiWorkspaceImpl.unloadManager("rss", rssRun2.getIdentifier());
            }
        }
    }
}

