/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.server;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.Manager;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.dssgui.BrowseDSS;
import hec.gfx2d.G2dDialog;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.heclib.dss.DataReference;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.io.DSSIdentifier;
import hec.rss.gfx2d.SimpleJTableData;
import hec.rss.model.ReleaseOverrides;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.server.RssSpecifyReleaseDialog$1;
import hec.rss.server.RssSpecifyReleaseDialog$2;
import hec.ui.browser.IBrowseDSSParent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import mil.army.usace.hec.rmi.csinterface.BaseDSSManager;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSTimeSeries;
import mil.army.usace.hec.rmi.server.RmiFileCallBackImpl;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.event.ReflectMultiListener;
import rma.swing.event.TableChangeListener;
import rma.swing.event.TableUpdateEvent;
import rma.swing.list.RmaListModel;
import rma.swing.table.CellLocation;
import rma.swing.table.RmaCellEditor;
import rma.swing.table.RmaDateTimeRenderer;
import rma.util.RMAIO;

public class RssSpecifyReleaseDialog
extends RmaJDialog
implements IBrowseDSSParent,
CellEditorListener,
TableChangeListener {
    public static final Color NEW_EDIT_COLOR = Color.blue;
    public static final Color PREV_EDIT_COLOR = Color.green;
    public static final Color MODEL_COLOR = Color.black;
    public static final String DEF_TITLE = "Release Overrides ";
    Frame _parent;
    RssRun _rssRun;
    boolean _first = true;
    Hashtable _dssTsDataTable;
    BrowseDSS _browseDSS = null;
    DSSManager _dssManager = null;
    ReflectMultiListener _listener;
    JPanel tablePanel;
    JPanel specifyButtonPanel;
    JPanel plotPanel;
    ButtonCmdPanel cmdButtonPanel;
    JButton unspecifyButton;
    JButton unspecifyAllButton;
    JButton importButton;
    JButton plotButton;
    JSplitPane splitPane;
    RmaJTable releaseTable;
    G2dPanel outputPlot;
    RmaJComboBox selectorCombo;
    int _wkspUnitSys;
    RmiFileCallBackImpl _lockCallback;
    String[] _releaseNames;
    String _keyString;

    public RssSpecifyReleaseDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this._parent = frame;
        this.buildControls();
    }

    private void buildControls() {
        ClientApp.app();
        this._wkspUnitSys = ClientApp.Workspace().getUnitSystem();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setVisible(false);
        this.setSize(540, 430);
        this.setLocation();
        this.setTitle(DEF_TITLE);
        this._listener = new ReflectMultiListener();
        Serializable serializable = new JLabel("Reservoir");
        serializable.setDisplayedMnemonic('R');
        Object object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.weightx = 0.0;
        object.fill = 2;
        object.anchor = 11;
        object.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)serializable, object);
        this.selectorCombo = new RmaJComboBox((ComboBoxModel)new RmaListModel(true));
        serializable.setLabelFor((Component)this.selectorCombo);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        object.gridy = 0;
        object.weightx = 1.0;
        object.fill = 2;
        object.anchor = 11;
        object.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.selectorCombo, object);
        this.tablePanel = new JPanel(new GridBagLayout());
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 1;
        object.gridheight = 2;
        object.gridwidth = 2;
        object.weightx = 2.0;
        object.weighty = 4.0;
        object.fill = 1;
        object.anchor = 11;
        object.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this.getContentPane().add((Component)this.tablePanel, object);
        object = new String[]{"HecTime", "Date", "Time", "Release (%S)"};
        this.releaseTable = new RmaJTable((Component)((Object)this), object);
        this.releaseTable.setColumnEnabled(false, 0);
        this.releaseTable.setColumnEnabled(false, 1);
        this.releaseTable.setColumnEnabled(false, 2);
        this.releaseTable.setColumnBackground(0, Color.lightGray);
        this.releaseTable.setColumnBackground(1, Color.lightGray);
        this.releaseTable.setColumnWidth(1, 50);
        this.releaseTable.setColumnWidth(2, 50);
        this.releaseTable.setAddRemoveEnabled(false);
        this.releaseTable.setPasteForeground(NEW_EDIT_COLOR);
        this.releaseTable.setDoubleCellEditor(3);
        this.releaseTable.setUnitsHeaderRenderer();
        this.releaseTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new RmaDateTimeRenderer(0, "ddMMMyyyy"));
        this.releaseTable.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)new RmaDateTimeRenderer(1));
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.weightx = 1.0;
        object.weighty = 10.0;
        object.fill = 1;
        object.anchor = 11;
        object.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this.tablePanel.add((Component)this.releaseTable.getScrollPane(), object);
        this.specifyButtonPanel = new JPanel(new GridBagLayout());
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        object.gridy = 1;
        object.weightx = 1.0;
        object.gridheight = 2;
        object.fill = 1;
        object.anchor = 11;
        object.insets = RmaInsets.insets((int)5, (int)0, (int)0, (int)0);
        this.getContentPane().add((Component)this.specifyButtonPanel, object);
        this.unspecifyButton = new JButton("Unspecify");
        this.unspecifyButton.setMnemonic('U');
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.weightx = 1.0;
        object.fill = 2;
        object.anchor = 11;
        object.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.specifyButtonPanel.add((Component)this.unspecifyButton, object);
        this.unspecifyAllButton = new JButton("Unspecify All");
        this.unspecifyAllButton.setMnemonic('A');
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 1;
        object.weightx = 1.0;
        object.fill = 2;
        object.anchor = 11;
        object.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.specifyButtonPanel.add((Component)this.unspecifyAllButton, object);
        this.importButton = new JButton("Import...");
        this.importButton.setMnemonic('I');
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 2;
        object.weightx = 1.0;
        object.fill = 2;
        object.anchor = 11;
        object.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.specifyButtonPanel.add((Component)this.importButton, object);
        this.plotPanel = new JPanel(new GridBagLayout());
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 3;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.fill = 1;
        object.anchor = 15;
        object.insets = RmaInsets.insets((int)5, (int)0, (int)0, (int)0);
        this.specifyButtonPanel.add((Component)this.plotPanel, object);
        this.outputPlot = new G2dPanel();
        RssSpecifyReleaseDialog rssSpecifyReleaseDialog = this;
        rssSpecifyReleaseDialog.configurePlotPanel(rssSpecifyReleaseDialog.outputPlot);
        object = this.getPlotArray();
        serializable = new Vector<Object[]>();
        ((Vector)serializable).addElement(object);
        this.outputPlot.setPlotObjects((List)((Object)serializable));
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.gridheight = 2;
        object.weightx = 1.0;
        object.weighty = 2.0;
        object.fill = 1;
        object.anchor = 15;
        object.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.plotPanel.add((Component)this.outputPlot, object);
        this.plotButton = new JButton("Plot");
        this.plotButton.setMnemonic('P');
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 2;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.fill = 2;
        object.anchor = 15;
        object.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.plotPanel.add((Component)this.plotButton, object);
        this.cmdButtonPanel = new ButtonCmdPanel(14);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        object.gridy = 3;
        object.gridwidth = 2;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.fill = 2;
        object.anchor = 10;
        object.insets = RmaInsets.insets((int)0, (int)0, (int)5, (int)0);
        this.getContentPane().add((Component)this.cmdButtonPanel, object);
        RssSpecifyReleaseDialog rssSpecifyReleaseDialog2 = this;
        this.unspecifyButton.addActionListener((ActionListener)this._listener.add((Object)rssSpecifyReleaseDialog2, (Object)rssSpecifyReleaseDialog2.unspecifyButton, "unspecify_Action"));
        RssSpecifyReleaseDialog rssSpecifyReleaseDialog3 = this;
        this.unspecifyAllButton.addActionListener((ActionListener)this._listener.add((Object)rssSpecifyReleaseDialog3, (Object)rssSpecifyReleaseDialog3.unspecifyAllButton, "unspecifyAll_Action"));
        RssSpecifyReleaseDialog rssSpecifyReleaseDialog4 = this;
        this.importButton.addActionListener((ActionListener)this._listener.add((Object)rssSpecifyReleaseDialog4, (Object)rssSpecifyReleaseDialog4.importButton, "import_Action"));
        RssSpecifyReleaseDialog rssSpecifyReleaseDialog5 = this;
        this.selectorCombo.addItemListener((ItemListener)this._listener.add((Object)rssSpecifyReleaseDialog5, (Object)rssSpecifyReleaseDialog5.selectorCombo, "fillTable"));
        this.cmdButtonPanel.addCmdPanelListener((ButtonCmdPanelListener)new RssSpecifyReleaseDialog$1(this));
        this.plotButton.addActionListener(new RssSpecifyReleaseDialog$2(this));
        this.releaseTable.addCellEditorListener((CellEditorListener)this);
        this.releaseTable.addTableChangeListener((TableChangeListener)this);
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
    }

    public RssSpecifyReleaseDialog(Frame frame, boolean bl, String string) {
        this(frame, bl);
        this.setTitle(string);
    }

    public void setLockCallback(RmiFileCallBackImpl rmiFileCallBackImpl) {
        this._lockCallback = rmiFileCallBackImpl;
    }

    public void setVisible(boolean bl) {
        if (!bl && this._lockCallback != null) {
            ClientApp.app();
            ClientApp.frame().getCurrentMode().unlockManager((Manager)this._rssRun, "Failed to unlock ResSim Run " + this._rssRun.getName(), this._lockCallback, null);
        }
        super.setVisible(bl);
    }

    public void setRun(RssRun rssRun) {
        this._rssRun = rssRun;
        if (this._rssRun != null) {
            this.setDssManager();
            this.fillForm();
        }
    }

    public void fillForm() {
        this._releaseNames = null;
        this._rssRun.getDSSOutputFile();
        new HecTime();
        this._dssTsDataTable = new Hashtable();
        RssSpecifyReleaseDialog rssSpecifyReleaseDialog = this;
        rssSpecifyReleaseDialog.setTitle(DEF_TITLE + rssSpecifyReleaseDialog._rssRun.getName());
        this._rssRun.updateReleaseOverrides();
        ReleaseOverrides releaseOverrides = this._rssRun.getReleaseOverrides();
        RssSystem rssSystem = this._rssRun.getAlternative().getSystem();
        this.releaseTable.clearCells();
        this.releaseTable.deleteCells();
        if (releaseOverrides != null) {
            int n;
            this._releaseNames = releaseOverrides.getReleaseNames();
            for (n = 0; n < this._releaseNames.length; ++n) {
                String string = rssSystem.getNameForKeyString(this._releaseNames[n]);
                ((RmaListModel)this.selectorCombo.getModel()).addElement((Object)string);
            }
            this.isVisible();
            n = releaseOverrides.getStartTime();
            int n2 = releaseOverrides.getTimeStep();
            int n3 = releaseOverrides.getNumberOfSteps();
            int n4 = n;
            ClientApp.app();
            TimeZone timeZone = ClientApp.Workspace().getTimeZone();
            for (n = 0; n < n3; ++n) {
                HecTime hecTime = new HecTime();
                hecTime.set(n4);
                this.releaseTable.setCell((Object)new Integer(hecTime.value()), n, 0);
                HecTimeArray hecTimeArray = new HecTimeArray(1);
                hecTimeArray.setElementAt(hecTime, 0);
                hecTimeArray.setTimeZone(timeZone);
                this.releaseTable.setCell((Object)hecTimeArray, n, 1);
                this.releaseTable.setCell((Object)hecTimeArray, n, 2);
                n4 += n2;
            }
        }
        this.releaseTable.setColumnVisible(0, false, 0);
        if (this.selectorCombo.getItemCount() > 0) {
            this.selectorCombo.setSelectedIndex(0);
            return;
        }
        JOptionPane.showMessageDialog((Component)((Object)this), "No Reservoir Releases to Override");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            if (this.isModified()) {
                int n = JOptionPane.showConfirmDialog((Component)((Object)this), "Release Overrides have changed for " + String.valueOf(itemEvent.getItem()) + ".\n Do you want to save the changes?", "Save Changes", 0);
                if (n == 0) {
                    this.saveTable((String)itemEvent.getItem());
                }
                return;
            }
        } else {
            this.fillTable();
        }
    }

    protected void fillTable() {
        Object object = this._rssRun.getDSSOutputFile();
        Serializable serializable = this._rssRun.getReleaseOverrides();
        Object object2 = this._rssRun.getAlternative().getSystem();
        if (object2 == null) {
            return;
        }
        String string = (String)this.selectorCombo.getSelectedItem();
        String string2 = null;
        for (int i = 0; i < this._releaseNames.length; ++i) {
            if (!string.equals(((RssSystem)object2).getNameForKeyString(this._releaseNames[i]))) continue;
            string2 = this._releaseNames[i];
            break;
        }
        if (string2 == null) {
            return;
        }
        Object object3 = serializable.getReleaseDssPath(string2);
        if (object3 == null) {
            return;
        }
        object3 = new DSSIdentifier((String)object, (String)object3);
        object2 = this._rssRun.getRunTimeWindow();
        object3.setTimeWindow(object2.getStartTime(), object2.getEndTime());
        this.fillDssData((DSSIdentifier)object3, (ReleaseOverrides)serializable, string2, 0);
        serializable.setRun(this._rssRun);
        object3 = serializable.getReleaseValues(string2);
        object2 = ((Hashtable)object3).keys();
        while (object2.hasMoreElements()) {
            object = (Integer)object2.nextElement();
            serializable = (Double)((Hashtable)object3).get(object);
            this.setCell(3, (Integer)object, (Double)serializable, PREV_EDIT_COLOR);
        }
        this.isVisible();
        this.releaseTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new RmaDateTimeRenderer(0, "ddMMMyyyy"));
        this.releaseTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new RmaDateTimeRenderer(1));
        this.plot();
        this.setModified(false);
    }

    void fillDssData(DSSIdentifier dSSIdentifier, ReleaseOverrides object, String string, int n) {
        int n2 = ((ReleaseOverrides)object).getStartTime();
        int n3 = ((ReleaseOverrides)object).getTimeStep();
        ((ReleaseOverrides)object).getNumberOfSteps();
        object = ((ReleaseOverrides)object).getReleaseDssPath(string);
        if (object == null) {
            return;
        }
        dSSIdentifier = new SimpleDSSTimeSeries((BaseDSSManager)this._dssManager, dSSIdentifier);
        v0.xunits = "Date";
        dSSIdentifier.yunits = "CFS";
        dSSIdentifier.setXAxisType(1);
        dSSIdentifier.name = string + " Computed";
        dSSIdentifier.load();
        if (this._dssTsDataTable.get(string) == null) {
            this._dssTsDataTable.put(string, dSSIdentifier);
        }
        this.releaseTable.setColumnForeground(n + 2, MODEL_COLOR);
        for (int i = 0; i < dSSIdentifier.tdata.length; ++i) {
            int n4 = (dSSIdentifier.tdata[i] - n2) / n3;
            if (n4 < 0) continue;
            try {
                string = new ParamDouble(dSSIdentifier.ydata[i], Parameter.PARAMID_FLOW, this._wkspUnitSys, 1);
                this.releaseTable.setCell((Object)string, n4, n + 3);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                this.releaseTable.setCell((Object)"", n4, n + 3);
            }
        }
    }

    private void setCell(int n, Integer n2, Double d, Color color) {
        System.out.println("setting col " + n + " key " + n2 + " value " + d);
        for (int i = 0; i < this.releaseTable.getNumRows(); ++i) {
            if (!this.releaseTable.getCell(i, 0).equals(n2)) continue;
            n2 = new ParamDouble(d.doubleValue(), Parameter.PARAMID_FLOW, this._wkspUnitSys, 1);
            this.releaseTable.setCell((Object)n2, i, n);
            this.releaseTable.setCellForeground(i, n - 1, color);
            return;
        }
        System.out.println("No match for col " + n + " key " + n2 + " value " + d);
    }

    String getKeyStringForName(String string) {
        RssSystem rssSystem = this._rssRun.getAlternative().getSystem();
        if (rssSystem == null) {
            return string;
        }
        String string2 = null;
        for (int i = 0; i < this._releaseNames.length; ++i) {
            if (!string.equals(rssSystem.getNameForKeyString(this._releaseNames[i]))) continue;
            string2 = this._releaseNames[i];
            break;
        }
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    private void saveTable(String string) {
        if (string == null) {
            return;
        }
        string = this.getKeyStringForName(string);
        ReleaseOverrides releaseOverrides = this._rssRun.getReleaseOverrides();
        Object object = this.releaseTable.getColumnModel().getColumn(2);
        if (object == null) {
            this._rssRun.setModified(true);
            return;
        }
        object = ((TableColumn)object).getCellRenderer();
        Hashtable<Integer, Double> hashtable = new Hashtable<Integer, Double>();
        for (int i = 0; i < this.releaseTable.getRowCount(); ++i) {
            Object object2 = object.getTableCellRendererComponent((JTable)this.releaseTable, this.releaseTable.getValueAt(i, 2), false, false, i, 2);
            if (object2 == null || !((Component)object2).getForeground().equals(NEW_EDIT_COLOR) && !((Component)object2).getForeground().equals(PREV_EDIT_COLOR) || "".equals(object2 = this.releaseTable.getValueAt(i, 2).toString())) continue;
            hashtable.put(new Integer(this.releaseTable.getCell(i, 0).toString()), new Double((String)object2));
        }
        releaseOverrides.setReleaseValues(string, hashtable);
        this._rssRun.setModified(true);
    }

    private void unspecify_Action() {
        this.releaseTable.commitEdit(true);
        Vector vector = this.releaseTable.getSelectedCellRange();
        if (vector.size() <= 0) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            CellLocation cellLocation = (CellLocation)vector.elementAt(i);
            if (cellLocation == null) continue;
            int n = cellLocation.getRow();
            int n2 = cellLocation.getCol();
            this.resetCellColor(n, n2);
        }
        this.releaseTable.repaint();
        this.plot();
    }

    private void unspecifyAll_Action() {
        this.releaseTable.commitEdit(true);
        for (int i = 2; i < this.releaseTable.getColumnCount(); ++i) {
            for (int j = 0; j < this.releaseTable.getRowCount(); ++j) {
                this.resetCellColor(j, i);
            }
        }
        this.releaseTable.repaint();
        this.plot();
    }

    private void import_Action() {
        Object object = this.selectorCombo.getSelectedItem();
        if (object == null) {
            JOptionPane.showMessageDialog(this._parent, "Please select a reservoir to import into", "No Reservoir", 1);
            return;
        }
        object = new BrowseDSS((Object)this._parent, "Import Release Time Series", true);
        String string = ClientApp.app().getDssListDefaultDir();
        if (string != null && string.length() > 5) {
            object.setDirectory(string);
        }
        object.setVisible(true);
    }

    public void setDSSPathname(Vector object) {
        if (this._browseDSS == null) {
            return;
        }
        if (((Vector)object).size() == 0) {
            return;
        }
        object = ((DataReference)((Vector)object).elementAt(0)).pathname();
        String string = this._browseDSS.getDSSFilename();
        CellLocation cellLocation = this.releaseTable.getFirstSelectedCell();
        int n = cellLocation.getCol();
        ReleaseOverrides releaseOverrides = this._rssRun.getReleaseOverrides();
        String[] stringArray = releaseOverrides.getReleaseNames();
        object = new DSSIdentifier(string, (String)object);
        string = this._rssRun.getRunTimeWindow();
        object.setTimeWindow(string.getStartTime(), string.getEndTime());
        this.fillDssData((DSSIdentifier)object, releaseOverrides, stringArray[n - 2], n - 2);
        this.releaseTable.setColumnForeground(n, NEW_EDIT_COLOR);
    }

    private void plot_Action() {
        G2dDialog g2dDialog = this.plot();
        g2dDialog = new G2dDialog(this._parent, "Specified Releases", false, g2dDialog[0], g2dDialog[1]);
        g2dDialog.setTabulate(false);
        g2dDialog.setVisible(true);
    }

    private void ok_Action() {
        this.apply_Action();
        if (this._browseDSS != null) {
            this._browseDSS.setVisible(false);
            this._browseDSS = null;
        }
        this.setVisible(false);
    }

    public void apply_Action() {
        this.releaseTable.commitEdit(true);
        RssSpecifyReleaseDialog rssSpecifyReleaseDialog = this;
        rssSpecifyReleaseDialog.saveTable((String)rssSpecifyReleaseDialog.selectorCombo.getSelectedItem());
        if (this._rssRun.isModified()) {
            this._rssRun.writeFile(this._rssRun.getIdentifier());
        }
    }

    private void cancel_Action() {
        if (this._browseDSS != null) {
            this._browseDSS.setVisible(false);
            this._browseDSS = null;
        }
        this.setVisible(false);
    }

    private void resetCellColor(int n, int n2) {
        Object object = this.releaseTable.getColumnModel().getColumn(n2);
        ReleaseOverrides releaseOverrides = this._rssRun.getReleaseOverrides();
        int n3 = releaseOverrides.getStartTime();
        releaseOverrides.getTimeStep();
        int n4 = releaseOverrides.getNumberOfSteps();
        if (object == null) {
            return;
        }
        String string = (String)((TableColumn)object).getHeaderValue();
        if ((object = ((TableColumn)object).getCellRenderer()) == null) {
            object = this.releaseTable.getColumnClass(n2);
            object = this.releaseTable.getDefaultRenderer((Class)object);
        }
        if ((object = object.getTableCellRendererComponent((JTable)this.releaseTable, this.releaseTable.getCell(n, n2), false, false, n, n2)) != null && (((Color)(object = ((Component)object).getForeground())).equals(NEW_EDIT_COLOR) || ((Color)object).equals(PREV_EDIT_COLOR))) {
            int n5;
            this.releaseTable.setCellForeground(n, n2, MODEL_COLOR);
            object = (SimpleDSSTimeSeries)this._dssTsDataTable.get(string);
            if (object == null) {
                this.releaseTable.setValueAt((Object)0.0, n, n2);
                return;
            }
            try {
                n5 = (Integer)this.releaseTable.getCell(n, 0);
            }
            catch (Exception exception) {
                return;
            }
            n4 = (n5 - n3) / (n4 - 1);
            while (n4 < ((SimpleDSSTimeSeries)object).tdata.length) {
                if (((SimpleDSSTimeSeries)object).tdata[n4] == n5) {
                    this.releaseTable.setValueAt((Object)new Double(RMAIO.setPrecision2((double)((SimpleDSSTimeSeries)object).ydata[n4], (int)1)), n, n2);
                    return;
                }
                if (((SimpleDSSTimeSeries)object).tdata[n4] > n5) {
                    System.out.println("whoa there. past time " + n5 + " now at " + ((SimpleDSSTimeSeries)object).ydata[n4]);
                    break;
                }
                ++n4;
            }
            this.releaseTable.setValueAt((Object)0.0, n, n2);
        }
    }

    public void tableDataChanged(TableUpdateEvent tableUpdateEvent) {
        this.plot();
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    @Override
    public void editingStopped(ChangeEvent object) {
        int n = -1;
        int n2 = 0;
        if ((object = ((EventObject)object).getSource()) instanceof RmaCellEditor) {
            object = (RmaCellEditor)object;
            object = object.getComponent();
            object = ((Component)object).getLocation();
            n = this.releaseTable.rowAtPoint((Point)object);
            n2 = this.releaseTable.columnAtPoint((Point)object);
        }
        if (n >= 0 && n2 >= 0 && !this.releaseTable.getCell(n, n2).toString().equals("")) {
            this.releaseTable.setCellForeground(n, n2, NEW_EDIT_COLOR);
        }
        this.plot();
    }

    private Vector[] plot() {
        Vector<Object> vector = new Vector<Object>();
        Vector[] vectorArray = new Vector[2];
        if (this.selectorCombo.getSelectedIndex() < 0) {
            System.out.println("no reservoir selected");
            return vectorArray;
        }
        Vector<Color> vector2 = new Vector<Color>();
        Color color = Color.blue;
        Object object = Color.red;
        SimpleJTableData simpleJTableData = this.getPlotArray();
        this.getPlotArray().name = this.selectorCombo.getSelectedItem().toString();
        simpleJTableData.setData(this.releaseTable, 0, 3);
        ClientApp.app();
        simpleJTableData.setGmtOffset(ClientApp.Workspace().getGmtOffset());
        vector.addElement((Object)simpleJTableData);
        vector2.addElement((Color)object);
        object = this.getKeyStringForName(simpleJTableData.name);
        object = (SimpleDSSTimeSeries)this._dssTsDataTable.get(object);
        if (object != null) {
            vector.addElement(object);
            vector2.addElement(color);
        } else {
            System.out.println("No computed release for " + simpleJTableData.name);
        }
        simpleJTableData.name = simpleJTableData.name + " Specified";
        this.outputPlot.setPlotObjects(vector, vector2);
        this.outputPlot.paintGfx();
        vectorArray[0] = vector;
        vectorArray[1] = vector2;
        return vectorArray;
    }

    private void configurePlotPanel(G2dPanel g2dPanel) {
        G2dPanelProp g2dPanelProp = this.getPlotProp();
        g2dPanel.configurePanel(g2dPanelProp);
    }

    private G2dPanelProp getPlotProp() {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Minutes";
        g2dPlotProp.x1AxisProp.type = 1;
        g2dPlotProp.hasX1Label = false;
        g2dPlotProp.y1AxisProp.name = "CFS";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPlotProp.x1AxisProp.numTicLabelLayers = 2;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
        return g2dPanelProp;
    }

    private SimpleJTableData getPlotArray() {
        SimpleJTableData simpleJTableData = new SimpleJTableData();
        new SimpleJTableData().xunits = "Minutes";
        simpleJTableData.yunits = "CFS";
        simpleJTableData.setXAxisType(1);
        simpleJTableData.setStartRow(0);
        simpleJTableData.setData(null, -1, -1);
        return simpleJTableData;
    }

    void setTableColumnWidths(int n) {
        if (n <= 0) {
            n = 1;
        }
        int[] nArray = new int[n + 3];
        int[] nArray2 = nArray;
        nArray[0] = 0;
        nArray2[1] = 80;
        nArray2[2] = 50;
        int n2 = 380;
        if (this.isVisible()) {
            Dimension dimension = this.releaseTable.getScrollPane().getViewport().getExtentSize();
            n2 = dimension.width;
        }
        n2 = (n2 - 130) / n;
        for (n = 3; n < nArray2.length; ++n) {
            nArray2[n] = n2;
        }
        this.releaseTable.setColumnWidths(nArray2);
    }

    public void enterPressed() {
        JButton jButton = this.getRootPane().getDefaultButton();
        if (jButton == null) {
            return;
        }
        jButton.doClick();
    }

    void setDssManager() {
        if (this._dssManager == null) {
            try {
                ClientApp.app();
                this._dssManager = (DSSManager)ClientApp.Workspace().getData().getDSSFileManager().getRemote();
                return;
            }
            catch (RemoteException remoteException) {
                System.out.println("setDssManager(): failed to DSSManager from workspace " + String.valueOf(remoteException));
                this._dssManager = null;
            }
        }
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.unspecifyButton.setEnabled(bl);
        this.unspecifyAllButton.setEnabled(bl);
        this.importButton.setEnabled(bl);
    }

    public void addPathnames(Vector vector) {
        this.setDSSPathname(vector);
    }

    public void replacePathnames(Vector vector) {
        this.setDSSPathname(vector);
    }
}

