/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.server.routing;

import hec.rss.model.TimeStepUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import rma.swing.ButtonCmdPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJPanel;

public class AddRoutingDialog
extends RmaJDialog {
    public static final String ADD_ROUTING_PROPERTY = "AddRouting";
    private RmaJPanel _panel;
    private RmaJComboBox<TimeStepUtil> _timeStepCombo;
    private ButtonCmdPanel _commandPanel;
    private boolean _okPressed = false;

    public AddRoutingDialog(Window window, String string, boolean bl, List<TimeStepUtil> list) {
        super(window, string != null ? string : "New Routing", bl);
        this.buildGui(list);
        this.addListeners();
    }

    private void addListeners() {
        this._commandPanel.addCmdPanelListener(actionEvent -> {
            int n = actionEvent.getID();
            switch (n) {
                case 8: {
                    this.okAction();
                    return;
                }
                case 4: {
                    this.closeDialog();
                }
            }
        });
    }

    private void okAction() {
        TimeStepUtil timeStepUtil = (TimeStepUtil)((Object)this._timeStepCombo.getSelectedItem());
        this.firePropertyChange(ADD_ROUTING_PROPERTY, null, (Object)timeStepUtil);
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void buildGui(List<TimeStepUtil> list) {
        this.setMinimumSize(new Dimension(200, 100));
        this.buildGridBagLayout();
        this.buildPanel();
        this.buildEmptyPanel();
        this.buildTimeStepControls(list);
        this.buildButtonCommandPanel();
    }

    private void buildPanel() {
        this._panel = new RmaJPanel();
        this._panel.setLayout((LayoutManager)new GridBagLayout());
        this._panel.setBorder((Border)new TitledBorder("Routing Options"));
        this._panel.setSize(new Dimension(200, 100));
        this._panel.setMinimumSize(new Dimension(200, 100));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        AddRoutingDialog addRoutingDialog = this;
        addRoutingDialog.add((Component)addRoutingDialog._panel, gridBagConstraints);
    }

    private void buildEmptyPanel() {
        RmaJPanel rmaJPanel = new RmaJPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this._panel.add((Component)rmaJPanel, (Object)gridBagConstraints);
    }

    private void buildTimeStepControls(List<TimeStepUtil> list) {
        JLabel jLabel = this.buildTimeStepLabel();
        this.buildTimeStepCombo(jLabel, list);
    }

    private JLabel buildTimeStepLabel() {
        JLabel jLabel = new JLabel("Time Step:");
        jLabel.setDisplayedMnemonic('T');
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)10, (int)0, (int)0);
        this._panel.add((Component)jLabel, (Object)gridBagConstraints);
        return jLabel;
    }

    private void buildTimeStepCombo(JLabel serializable, List<TimeStepUtil> list) {
        this._timeStepCombo = new RmaJComboBox((Object[])this.getAvailableTimeSteps(list));
        this._timeStepCombo.setModifiable(true);
        serializable.setLabelFor((Component)this._timeStepCombo);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this._panel.add(this._timeStepCombo, (Object)serializable);
    }

    private TimeStepUtil[] getAvailableTimeSteps(List<TimeStepUtil> timeStepUtilArray) {
        ArrayList<TimeStepUtil> arrayList = new ArrayList<TimeStepUtil>(Arrays.asList(TimeStepUtil.a()));
        arrayList.removeAll((Collection<?>)timeStepUtilArray);
        timeStepUtilArray = arrayList.toArray(new TimeStepUtil[0]);
        return timeStepUtilArray;
    }

    private void buildButtonCommandPanel() {
        this._commandPanel = new ButtonCmdPanel(12);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this._commandPanel, gridBagConstraints);
    }

    private void buildGridBagLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
    }

    public boolean isOkPressed() {
        return this._okPressed;
    }
}

