/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.supplemental.server;

import hec.clientapp.model.ComputeInfo;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.server.RmiWorkspaceImpl;
import hec.clientapp.supplemental.SupplementalRmiWorkspace;
import hec.clientapp.supplemental.model.SupplementalProgramAlt;
import hec.heclib.util.intContainer;
import hec.io.DSSIdentifier;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.ModelReference;
import hec.lang.UserId;
import hec.model.ModelConstants;
import hec.supplemental.model.ProgramOrderItem;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.io.HecAsciiDeserializer;
import mil.army.usace.hec.rmi.io.HecAsciiSerializer;
import rma.util.RMAIO;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.RmiWorkspacePropLoggingMarker;

public class SupplementalRmiWorkspaceImpl
extends RmiWorkspaceImpl
implements SupplementalRmiWorkspace,
ModelConstants {
    private static final MarkingClassLogger a = MarkingClassLogger.forMarkingClass(RmiWorkspacePropLoggingMarker.class);
    protected Vector _models = new Vector();
    protected Hashtable _modelsTable = new Hashtable();
    protected Identifier _modelsId;
    protected Identifier _allModelsId;
    private Hashtable _modelIndexes = new Hashtable();
    private Hashtable _allModelsTable = new Hashtable();
    public static final String NO_MESSAGE = "[No Message]";
    public static final String LOG_MESSAGE = "[Log Message]";
    public static final String ERROR_MESSAGE = "[Error Message]";

    public SupplementalRmiWorkspaceImpl(int n) throws RemoteException {
        super(n);
        this._typeOfWorkspace = "supplemental";
    }

    public SupplementalRmiWorkspaceImpl(Integer n) throws RemoteException {
        this((int)n);
    }

    public SupplementalRmiWorkspaceImpl(String string, Identifier identifier) throws RemoteException {
        this(8089);
        this.setIdentifier(string, identifier);
        this._lockedBy = string;
        try {
            this.addUser(string);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            return;
        }
    }

    public boolean load() {
        HecFile hecFile = this.identifier.getFile();
        if (hecFile != null) {
            this.readConfiguration();
            return true;
        }
        return false;
    }

    private synchronized void readConfiguration() {
        Object object = this.identifier.getFile();
        if (object == null) {
            return;
        }
        if (!object.canRead()) {
            return;
        }
        boolean bl = false;
        try {
            BufferedReader bufferedReader = object.getBufferedReader();
            object = bufferedReader.readLine();
            while (object != null) {
                object = ((String)object).trim();
                ((MarkingClassLogger.Api)a.atFine()).log((String)object);
                String string = RMAIO.getType((String)object, (String)"=");
                String string2 = RMAIO.getParam((String)object, (String)"=");
                if (((String)object).indexOf("ManagerProxyBegin") >= 0) {
                    this.readManagerProxy(bufferedReader);
                } else if (string.equals("ModelIndex")) {
                    if (string2.indexOf(",") >= 0) {
                        string = RMAIO.getType((String)string2, (String)",");
                        string2 = RMAIO.getParam((String)string2, (String)",");
                        object = new intContainer(RMAIO.parseInt((String)string2));
                        this._modelIndexes.put(string, object);
                    } else {
                        bl = true;
                    }
                }
                object = bufferedReader.readLine();
            }
            this.loadModels();
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("Remote Exception.");
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
        if (bl) {
            this.fixupModelIndexs();
        }
        if (this._allModelsTable.size() == 0) {
            this.fixupAllModelsTable();
        }
    }

    private void fixupAllModelsTable() {
        Enumeration enumeration = this._modelsTable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = this._modelsTable.get(k);
            this._allModelsTable.put(k, ((Vector)v).clone());
        }
    }

    private void fixupModelIndexs() {
        System.out.println("SupplementalRmiWorkspace: found old style ModelIndex entry. fixing");
        Enumeration enumeration = this._modelsTable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Vector vector = (Vector)this._modelsTable.get(k);
            if (vector == null) continue;
            int n = -1;
            for (int i = 0; i < vector.size(); ++i) {
                ProgramOrderItem programOrderItem = (ProgramOrderItem)vector.get(i);
                int n2 = programOrderItem.getIndex();
                n = Math.max(n, n2);
            }
            if (n <= 0) continue;
            this._modelIndexes.put(k, new intContainer(n));
        }
    }

    public void saveWorkspace(String string) throws RemoteException {
        string = this.identifier.getFile();
        if (string != null) {
            System.out.println("Save the Workspace " + this.getTitleName());
            this.writeConfiguration((HecFile)string);
            return;
        }
        System.out.println("Workspace " + this.getName() + " not Saved.");
    }

    private synchronized void writeConfiguration(HecFile object) {
        try {
            Object object2;
            object = object.getBufferedWriter();
            Enumeration enumeration = this._modelIndexes.keys();
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                intContainer intContainer2 = (intContainer)this._modelIndexes.get(object2);
                RMAIO.fout((BufferedWriter)object, (String)("ModelIndex=" + String.valueOf(object2) + "," + intContainer2.value));
            }
            RMAIO.fout((BufferedWriter)object, (String)"");
            for (int i = 0; i < this._managerProxys.size(); ++i) {
                object2 = (ManagerProxy)this._managerProxys.elementAt(i);
                object2.write((BufferedWriter)object);
            }
            RMAIO.fout((BufferedWriter)object, (String)"");
            ((BufferedWriter)object).close();
            this.saveModels();
            return;
        }
        catch (Exception exception) {
            System.out.println("Exception trying to write configuration");
            System.out.println(exception.getMessage() + "...." + exception.toString());
            exception.printStackTrace();
            return;
        }
    }

    public synchronized boolean setModels(Vector vector, String string) throws RemoteException {
        return this.setModels(vector, "cavi", string);
    }

    public synchronized boolean setModels(Vector vector, String string, String vector2) throws RemoteException {
        intContainer intContainer2;
        if (vector == null || vector2 == null) {
            return false;
        }
        vector2 = (Vector)this._modelsTable.get(string);
        if (vector2 == null) {
            vector2 = new Vector();
            this._modelsTable.put(string, vector2);
        } else {
            vector2.clear();
        }
        vector2.addAll(vector);
        Hashtable hashtable = this._modelIndexes;
        synchronized (hashtable) {
            intContainer2 = (intContainer)this._modelIndexes.get(string);
            if (intContainer2 == null) {
                intContainer2 = new intContainer(1);
                this._modelIndexes.put(string, intContainer2);
            }
        }
        for (int i = vector2.size() - 1; i >= 0; --i) {
            vector = vector2.get(i);
            if (!(vector instanceof ProgramOrderItem)) {
                vector2.remove(i);
                continue;
            }
            if ((vector = (ProgramOrderItem)vector).getIndex() <= intContainer2.value) continue;
            intContainer2.value = vector.getIndex();
        }
        return true;
    }

    public Vector getModels() throws RemoteException {
        return this.getModels("cavi");
    }

    public Vector getModels(String string) {
        if (string == null) {
            return null;
        }
        Vector vector = (Vector)this._modelsTable.get(string);
        if (vector == null || vector.size() == 0) {
            this.createDefaultModels(string);
        }
        return (Vector)this._modelsTable.get(string);
    }

    public Vector getOrderedModels(String string) throws RemoteException {
        return this.getModels(string);
    }

    public Vector getOrderedModels() throws RemoteException {
        return this.getModels();
    }

    protected boolean saveModels() throws RemoteException {
        HecAsciiSerializer hecAsciiSerializer;
        Object object;
        if (this._modelsTable != null) {
            this.setModelsId();
            try {
                object = this._modelsId.getFile();
                object = object.getBufferedWriter();
                hecAsciiSerializer = new HecAsciiSerializer((BufferedWriter)object);
                hecAsciiSerializer.serializeObject((Object)this._modelsTable);
                ((BufferedWriter)object).close();
            }
            catch (Exception exception) {
                System.out.println("saveModels: error writing file " + this._modelsId.getPath() + " Error " + String.valueOf(exception));
            }
        }
        if (this.setAllModelsId()) {
            try {
                object = this._allModelsId.getFile();
                object = object.getBufferedWriter();
                hecAsciiSerializer = new HecAsciiSerializer((BufferedWriter)object);
                hecAsciiSerializer.serializeObject((Object)this._allModelsTable);
                ((BufferedWriter)object).close();
                return true;
            }
            catch (Exception exception) {
                System.out.println("saveModels: error writing file " + this._allModelsId.getPath() + " Error " + String.valueOf(exception));
            }
        }
        return false;
    }

    protected void loadModels() throws RemoteException {
        HecAsciiDeserializer hecAsciiDeserializer;
        BufferedReader bufferedReader;
        Serializable serializable;
        try {
            serializable = new File(this.getWorkspacePath() + "/supplemental/models.conf");
            if (((File)serializable).exists()) {
                FileReader fileReader = new FileReader((File)serializable);
                BufferedReader bufferedReader2 = new BufferedReader(fileReader);
                fileReader = new HecAsciiDeserializer(bufferedReader2);
                fileReader.deserializeObject(this._models);
                bufferedReader2.close();
                this._modelsTable.put("cavi", this._models.clone());
                this._models.clear();
                this.saveModels();
                ((File)serializable).delete();
                return;
            }
        }
        catch (Exception exception) {
            serializable = exception;
            exception.printStackTrace();
        }
        if (this.setAllModelsId()) {
            try {
                serializable = this._allModelsId.getFile();
                bufferedReader = serializable.getBufferedReader();
                hecAsciiDeserializer = new HecAsciiDeserializer(bufferedReader);
                hecAsciiDeserializer.deserializeObject((Object)this._allModelsTable);
                bufferedReader.close();
            }
            catch (Exception exception) {
                System.out.println("loadModelOrder: error reading file " + this._allModelsId.getPath() + " Error " + String.valueOf(exception));
            }
        }
        if (this.setModelsId()) {
            try {
                serializable = this._modelsId.getFile();
                bufferedReader = serializable.getBufferedReader();
                hecAsciiDeserializer = new HecAsciiDeserializer(bufferedReader);
                hecAsciiDeserializer.deserializeObject((Object)this._modelsTable);
                bufferedReader.close();
                return;
            }
            catch (Exception exception) {
                System.out.println("loadModelOrder: error reading file " + this._modelsId.getPath() + " Error " + String.valueOf(exception));
                return;
            }
        }
        this.createDefaultModels();
    }

    private boolean setAllModelsId() {
        if (this._allModelsId != null) {
            return true;
        }
        Identifier identifier = new Identifier(this.getWorkspacePath() + "/supplemental/allPrograms.conf");
        try {
            RmiFileManager rmiFileManager = this.getFileManager();
            Identifier identifier2 = rmiFileManager.openFile(UserId.getUserId(), identifier);
            if (identifier2 != null) {
                this._allModelsId = identifier2;
                return true;
            }
            identifier2 = rmiFileManager.newFile(UserId.getUserId(), identifier);
            if (identifier2 != null) {
                this._allModelsId = identifier2;
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("setAllModelsId: rmi error opening file " + identifier.getPath() + " error " + String.valueOf(remoteException));
        }
        return false;
    }

    private boolean setModelsId() {
        if (this._modelsId != null) {
            return true;
        }
        Identifier identifier = new Identifier(this.getWorkspacePath() + "/supplemental/programs.conf");
        try {
            RmiFileManager rmiFileManager = this.getFileManager();
            Identifier identifier2 = rmiFileManager.openFile(UserId.getUserId(), identifier);
            if (identifier2 != null) {
                this._modelsId = identifier2;
                return true;
            }
            identifier2 = rmiFileManager.newFile(UserId.getUserId(), identifier);
            if (identifier2 != null) {
                this._modelsId = identifier2;
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("setModelOrderId: rmi error opening file " + identifier.getPath() + " error " + String.valueOf(remoteException));
        }
        return false;
    }

    public int getNextModelIndex(String string) {
        if (string == null) {
            System.out.println("getNextModelIndex: error null model");
            return -1;
        }
        intContainer intContainer2 = (intContainer)this._modelIndexes.get(string);
        Hashtable hashtable = this._modelIndexes;
        synchronized (hashtable) {
            if (intContainer2 == null) {
                intContainer2 = new intContainer(1);
                this._modelIndexes.put(string, intContainer2);
                return intContainer2.value;
            }
            return ++intContainer2.value;
        }
    }

    protected void createDefaultModels() {
        this.createDefaultModels("cavi");
    }

    protected void createDefaultModels(String string) {
        if (string.equalsIgnoreCase("cavi")) {
            this.createDefaultCAVIModels();
            return;
        }
        if (string.equalsIgnoreCase("rss")) {
            this.createDefaultRSSModels();
            return;
        }
        if (string.equalsIgnoreCase("fia")) {
            this.createDefaultFIAModels();
            return;
        }
        if ("resprm".equalsIgnoreCase(string)) {
            this.createDefaultResPrmModels();
            return;
        }
        if (string.equalsIgnoreCase("rma")) {
            this.createDefaultRMAModels();
            return;
        }
        this.createEmptyModels(string);
    }

    private void createEmptyModels(String string) {
        Vector vector = new Vector();
        this._modelsTable.put(string, vector);
    }

    private void createDefaultResPrmModels() {
        Vector<ProgramOrderItem> vector = new Vector<ProgramOrderItem>();
        ProgramOrderItem programOrderItem = new ProgramOrderItem("ResPRM", "Reservoir Op.", true, -1);
        programOrderItem.setIndex(this.getNextModelIndex("resprm"));
        vector.addElement(programOrderItem);
        this._modelsTable.put("resprm", vector);
        this._allModelsTable.put("resprm", vector.clone());
    }

    private void createDefaultRSSModels() {
        Vector<ProgramOrderItem> vector = new Vector<ProgramOrderItem>();
        ProgramOrderItem programOrderItem = new ProgramOrderItem("RSS", "Reservoir Op.", true, -1);
        programOrderItem.setIndex(this.getNextModelIndex("rss"));
        vector.addElement(programOrderItem);
        this._modelsTable.put("rss", vector);
        this._allModelsTable.put("rss", vector.clone());
    }

    private void createDefaultFIAModels() {
        Vector<ProgramOrderItem> vector = new Vector<ProgramOrderItem>();
        ProgramOrderItem programOrderItem = ProgramOrderItem.FIA_MODEL;
        programOrderItem.setIndex(this.getNextModelIndex("fia"));
        vector.addElement(programOrderItem);
        this._modelsTable.put("fia", vector);
        this._allModelsTable.put("fia", vector.clone());
    }

    private void createDefaultRMAModels() {
        Vector<ProgramOrderItem> vector = new Vector<ProgramOrderItem>();
        ProgramOrderItem programOrderItem = new ProgramOrderItem(ProgramOrderItem.HEC5Q_MODEL.getName(), "Water Quality", true, -1);
        programOrderItem.setIndex(this.getNextModelIndex("rma"));
        ProgramOrderItem programOrderItem2 = new ProgramOrderItem(ProgramOrderItem.RMA2_MODEL.getName(), "", true, programOrderItem.getIndex());
        programOrderItem2.setIndex(this.getNextModelIndex("rma"));
        ProgramOrderItem programOrderItem3 = new ProgramOrderItem(ProgramOrderItem.RMA11_MODEL.getName(), "", true, programOrderItem2.getIndex());
        programOrderItem3.setIndex(this.getNextModelIndex("rma"));
        vector.add(programOrderItem);
        vector.add(programOrderItem2);
        vector.add(programOrderItem3);
        this._modelsTable.put("rma", vector);
        this._allModelsTable.put("rma", vector.clone());
    }

    private void createDefaultCAVIModels() {
        List list = ProgramOrderItem.getProgramOrderItems();
        for (int i = 0; i < list.size(); ++i) {
            ProgramOrderItem programOrderItem = (ProgramOrderItem)list.get(i);
            programOrderItem.setIndex(this.getNextModelIndex("cavi"));
        }
        this._modelsTable.put("cavi", list);
        Vector vector = new Vector(list.size());
        vector.addAll(list);
        this._allModelsTable.put("cavi", vector);
    }

    public int computeAlternative(ComputeInfo computeInfo) throws RemoteException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (computeInfo == null) {
            System.out.println(this.getWorkspaceType() + ".computeAlternative: no ComputeInfo supplied");
            return 2;
        }
        Object object6 = null;
        try {
            object5 = computeInfo.modelRef;
            if (object5 == null) {
                this.printErrorMessage(computeInfo.uiWrapper, "Failed to find ModelReference for " + computeInfo.modelAltname);
                System.out.println("supplemental.computeAlternative: no ModelReference in ComputeInfo");
                return 2;
            }
            try {
                object6 = (SupplementalProgramAlt)this._managerProxys.openManager("supplemental", ((ModelReference)object5).className, ((ModelReference)object5).newId);
            }
            catch (Exception exception) {
                object4 = exception;
                exception.printStackTrace();
            }
            if (object6 == null) {
                System.out.println("Failed to load Supplemental Alt " + computeInfo.modelAltname);
                this.printErrorMessage(computeInfo.uiWrapper, "Failed to load Supplemental Alternative " + computeInfo.modelAltname);
                return 2;
            }
        }
        catch (Exception exception) {
            System.out.println("supplemental.computeAlternative: Exception getting SupplementalAlternative " + String.valueOf(exception));
            this.printErrorMessage(computeInfo.uiWrapper, "Exception retrieving SupplementalAlternative");
            return 2;
        }
        object5 = computeInfo.programName;
        object4 = this.findProgram((String)object5);
        if (object4 == null) {
            this.printErrorMessage(computeInfo.uiWrapper, "Unable to find Supplemental Program " + (String)object5);
            this.printErrorMessage(computeInfo.uiWrapper, "Compute Failed");
            return 2;
        }
        if ((object4 = object4.getScript()) == null) {
            this.printErrorMessage(computeInfo.uiWrapper, "No Executable for " + (String)object5 + " specified");
            return 2;
        }
        Runtime.getRuntime();
        String string = File.separator;
        object5 = computeInfo.forecastpath + string + "supplemental" + string + RMAIO.userNameToFileName((String)computeInfo.programName) + "-" + RMAIO.userNameToFileName((String)(object6.getName() + ".args"));
        this.printMessage(computeInfo.uiWrapper, "Argument File is " + (String)object5);
        try {
            object3 = object6.getName().split(":", 3)[2];
        }
        catch (Exception exception) {
            object3 = object6.getName();
        }
        try {
            object2 = new PrintWriter(new FileWriter((String)object5));
            ((PrintWriter)object2).println("ComputeType=" + (computeInfo.computeType == 0 ? "Forecast" : (computeInfo.computeType == 1 ? "Simulation" : (computeInfo.computeType == 2 ? "WAT" : "Invalid Compute Type"))));
            ((PrintWriter)object2).println("ProgramName=" + computeInfo.programName);
            ((PrintWriter)object2).println("ProgramAlternative=" + (String)object3);
            ((PrintWriter)object2).println("ModelAlternative=" + computeInfo.modelAltname);
            ((PrintWriter)object2).println("Alternative=" + computeInfo.altname);
            ((PrintWriter)object2).println("RunTimeWindow=" + computeInfo.runTimeWindow.toString());
            ((PrintWriter)object2).println("IOTimeStep=" + computeInfo.ioTimeStep + " " + (computeInfo.ioTimeIncrement == 3 ? "Days(s)" : (computeInfo.ioTimeIncrement == 2 ? "Hour(s)" : (computeInfo.ioTimeIncrement == 1 ? "Minute(s)" : (computeInfo.ioTimeIncrement == 0 ? "Second(s)" : "Invalid Time Increment")))));
            ((PrintWriter)object2).println("TimeZoneOffset=" + computeInfo.timeZoneOffset + " Hour(s)");
            ((PrintWriter)object2).println("InputPosition=" + computeInfo.inputPosition * computeInfo.nameMultiplier);
            ((PrintWriter)object2).println("ModelPosition=" + computeInfo.modelPosition * computeInfo.nameMultiplier);
            ((PrintWriter)object2).println("ForecastPath=" + computeInfo.forecastpath);
            ((PrintWriter)object2).println("ForecastDSSFile=" + computeInfo.forecastpath + "/forecast.dss");
            ((PrintWriter)object2).println("InputFPart=" + computeInfo.modelAltname.substring(0, computeInfo.inputPosition * computeInfo.nameMultiplier));
            ((PrintWriter)object2).println("OutputFPart=" + computeInfo.modelAltname.substring(0, computeInfo.modelPosition * computeInfo.nameMultiplier));
            ((PrintWriter)object2).println("User=" + computeInfo.user);
            ((PrintWriter)object2).println("ClientDisplay=" + computeInfo.clientDisplay);
            ((PrintWriter)object2).println("ForceRecompute=" + computeInfo.doCompute);
            if (object6.getUserSpecifiedProgramArgs() != null) {
                ((PrintWriter)object2).println(object6.getUserSpecifiedProgramArgs());
            }
            ((PrintWriter)object2).close();
        }
        catch (IOException iOException) {
            System.out.println("supplemental.computeAlternative: IO Error opening/writing compute file " + (String)object5 + "Error " + String.valueOf(iOException));
            this.printErrorMessage(computeInfo.uiWrapper, "IO Error creating/writing compute file " + String.valueOf(iOException));
            return 2;
        }
        object2 = new StringBuffer((String)object4);
        ((StringBuffer)object2).append(" ");
        ((StringBuffer)object2).append((String)object5);
        object6 = ((StringBuffer)object2).toString();
        System.out.println("computeAlternative: cmd is [" + (String)object6 + "]");
        this.printMessage(computeInfo.uiWrapper, "Running " + (String)object4);
        object6 = ((String)object5).replaceFirst("\\.args$", ".log");
        object6 = new File((String)object6);
        object5 = ((File)object6).exists() ? new Long(((File)object6).lastModified()) : null;
        try {
            object3 = computeInfo.forecastpath + "/forecast.dss";
            System.out.println("computeAlternative:cataloging forecast dss file " + (String)object3);
            object2 = new DSSIdentifier((String)object3);
            object = ((DSSManager)this.getDSSFileManager().getRemote()).getPathnameList((DSSIdentifier)object2, true);
            if (object != null) {
                System.out.println("computeAlternative:found " + ((String[])object).length + " in dss file " + (String)object3);
            } else {
                System.out.println("computeAlternative:no paths returned for dss file " + (String)object3);
            }
            ((DSSManager)this.getDSSFileManager().getRemote()).close((String)object3);
        }
        catch (Exception exception) {
            System.out.println("computeAlternative: error running " + (String)object4 + " error " + String.valueOf(exception));
            this.printErrorMessage(computeInfo.uiWrapper, "Error running " + (String)object4);
            this.printErrorMessage(computeInfo.uiWrapper, "Compute Failed");
            return 2;
        }
        try {
            if (((File)object6).exists() && (object5 == null || ((File)object6).lastModified() > (Long)object5)) {
                object3 = new BufferedReader(new FileReader((File)object6));
                object2 = NO_MESSAGE;
                object = new StringBuffer("");
                object6 = ((BufferedReader)object3).readLine();
                while (object6 != null) {
                    object5 = ((String)object6).trim();
                    if (((String)object5).equalsIgnoreCase(NO_MESSAGE) || ((String)object5).equalsIgnoreCase(LOG_MESSAGE) || ((String)object5).equalsIgnoreCase(ERROR_MESSAGE)) {
                        if (((StringBuffer)object).length() > 0) {
                            if (((String)object2).equalsIgnoreCase(LOG_MESSAGE)) {
                                this.printMessage(computeInfo.uiWrapper, ((StringBuffer)object).toString());
                            } else if (((String)object2).equalsIgnoreCase(ERROR_MESSAGE)) {
                                this.printErrorMessage(computeInfo.uiWrapper, ((StringBuffer)object).toString());
                            }
                        }
                        object2 = object5;
                        ((StringBuffer)object).setLength(0);
                    } else {
                        ((StringBuffer)object).append((String)object6).append("\n");
                    }
                    object6 = ((BufferedReader)object3).readLine();
                }
                ((BufferedReader)object3).close();
                if (((StringBuffer)object).length() > 0) {
                    if (((String)object2).equalsIgnoreCase(LOG_MESSAGE)) {
                        this.printMessage(computeInfo.uiWrapper, ((StringBuffer)object).toString());
                    } else if (((String)object2).equalsIgnoreCase(ERROR_MESSAGE)) {
                        this.printErrorMessage(computeInfo.uiWrapper, ((StringBuffer)object).toString());
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("computeAlternative: error processing log file " + String.valueOf(exception));
        }
        System.out.println("computeAlternative: exit value for " + (String)object4 + " is " + -1);
        this.printErrorMessage(computeInfo.uiWrapper, (String)object4 + " returned " + -1);
        this.printErrorMessage(computeInfo.uiWrapper, "Compute Failed");
        return 2;
    }

    public ProgramOrderItem findProgram(String string) {
        return this.findProgram("cavi", string);
    }

    public boolean updateProgram(ProgramOrderItem programOrderItem) {
        if (programOrderItem == null) {
            return false;
        }
        ProgramOrderItem programOrderItem2 = this.findProgram(programOrderItem.getName());
        if (programOrderItem2 == null) {
            System.out.println("findProgram:failed to find ProgramOrderItem " + String.valueOf(programOrderItem));
            return false;
        }
        programOrderItem2.setScript(programOrderItem.getScript());
        this.setModified(true);
        return true;
    }

    public ProgramOrderItem findProgram(String string, String string2) {
        if (string == null || string.length() <= 0) {
            System.out.println("findProgram: null or empty key recieved");
            return null;
        }
        if (string2 == null || string2.length() <= 0) {
            System.out.println("findProgram: null or empty program recieved");
            return null;
        }
        Vector vector = (Vector)this._modelsTable.get(string);
        if (vector == null) {
            this.createDefaultModels(string);
            vector = (Vector)this._modelsTable.get(string);
            if (vector == null) {
                return null;
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            string = (ProgramOrderItem)vector.elementAt(i);
            if (string == null || !string.getName().equals(string2)) continue;
            return string;
        }
        return null;
    }

    public Vector getAllPrograms(String string) {
        if (string == null) {
            return null;
        }
        return (Vector)this._allModelsTable.get(string);
    }

    public boolean addProgram(String string, ProgramOrderItem programOrderItem) {
        if (string == null || programOrderItem == null) {
            return false;
        }
        Hashtable hashtable = this._allModelsTable;
        synchronized (hashtable) {
            Vector<ProgramOrderItem> vector = (Vector<ProgramOrderItem>)this._allModelsTable.get(string);
            if (vector == null) {
                vector = new Vector<ProgramOrderItem>();
                this._allModelsTable.put(string, vector);
            }
            if (vector.contains(programOrderItem)) {
                return false;
            }
            vector.add(programOrderItem);
            return true;
        }
    }

    public boolean deleteProgram(String object, ProgramOrderItem programOrderItem) {
        if (object == null || programOrderItem == null) {
            return false;
        }
        Hashtable hashtable = this._allModelsTable;
        synchronized (hashtable) {
            object = (Vector)this._allModelsTable.get(object);
            if (object == null) {
                return false;
            }
            if (!((Vector)object).contains(programOrderItem)) {
                return false;
            }
            return ((Vector)object).remove(programOrderItem);
        }
    }
}

