/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.util;

import hec.client.FileChooserFld;
import hec.client.LookAndFeel;
import hec.rss.util.ComputeConfigFileEditor$1;
import hec.rss.util.ComputeConfigFileEditor$2;
import hec.rss.util.ComputeConfigFileEditor$3;
import hec.rss.util.ComputeConfigFileEditor$4;
import hec.rss.util.ComputeConfigFileEditor$5;
import hec.rss.util.ComputeConfigFileEditor$6;
import hec.rss.util.ComputeConfigFileEditor$ConfigFilePanel;
import hec.rss.util.ComputeConfigFileEditor$ConfigFilePanel$18;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.prefs.Preferences;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import rma.swing.RmaInsets;
import rma.swing.RmaJFrame;
import rma.swing.RmaJTabbedPane;
import rma.util.RMAIO;

public class ComputeConfigFileEditor
extends RmaJFrame {
    private String _title;
    private JMenuItem _openMenu;
    private JMenuItem _saveMenu;
    private JMenuItem _saveAsMenu;
    private JMenu _reloadMenu;
    private JMenuItem _exitMenu;
    private String _lastDir;
    private RmaJTabbedPane _tabbedPane;
    public static final String SUN_JAVA_COMMAND = "sun.java.command";

    public ComputeConfigFileEditor() {
        this.buildControls();
        this.addListeners();
        this.loadPreferences();
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void addListeners() {
        this._saveMenu.addActionListener(new ComputeConfigFileEditor$1(this));
        this._saveAsMenu.addActionListener(new ComputeConfigFileEditor$2(this));
        this._exitMenu.addActionListener(new ComputeConfigFileEditor$3(this));
        this.addWindowListener(new ComputeConfigFileEditor$4(this));
    }

    protected void saveFormAs() {
        ComputeConfigFileEditor$ConfigFilePanel computeConfigFileEditor$ConfigFilePanel = (ComputeConfigFileEditor$ConfigFilePanel)((Object)this._tabbedPane.getSelectedComponent());
        computeConfigFileEditor$ConfigFilePanel.saveFormAs();
    }

    protected void saveForm() {
        for (int i = 0; i < this._tabbedPane.getTabCount(); ++i) {
            ComputeConfigFileEditor$ConfigFilePanel computeConfigFileEditor$ConfigFilePanel = (ComputeConfigFileEditor$ConfigFilePanel)((Object)this._tabbedPane.getComponent(i));
            computeConfigFileEditor$ConfigFilePanel.saveForm();
        }
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this._title = "Compute Testing Configuration Editor";
        ComputeConfigFileEditor computeConfigFileEditor = this;
        computeConfigFileEditor.setTitle(computeConfigFileEditor._title);
        this.buildMenus();
        this._tabbedPane = new RmaJTabbedPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._tabbedPane, gridBagConstraints);
        this._tabbedPane.addTab("", (Component)((Object)new ComputeConfigFileEditor$ConfigFilePanel(this)));
    }

    private void savePreferences() {
        int n = this._reloadMenu.getMenuComponentCount();
        Preferences preferences = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
        for (int i = 0; i < n; ++i) {
            preferences.put("file" + i, this._reloadMenu.getMenuComponent(i).getName());
        }
    }

    private void loadPreferences() {
        Preferences preferences = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
        String string = null;
        for (int i = 4; i >= 0; --i) {
            string = preferences.get("file" + i, null);
            if (string == null) continue;
            this.addReloadMenuItem(string);
        }
        if (string != null) {
            this.loadFile(string);
        }
    }

    private void addReloadMenuItem(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        int n = this._reloadMenu.getMenuComponentCount();
        if (n == 5) {
            this._reloadMenu.remove(4);
        }
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem = (JMenuItem)this._reloadMenu.getMenuComponent(i);
            if (!RMAIO.pathsEqual((String)string, (String)jMenuItem.getName())) continue;
            this._reloadMenu.remove(i);
            this._reloadMenu.insert(jMenuItem, 0);
            return;
        }
        JMenuItem jMenuItem = new JMenuItem(RMAIO.getFileFromPath((String)string));
        jMenuItem.setActionCommand("loadFile");
        jMenuItem.setToolTipText(string);
        jMenuItem.setName(string);
        this._reloadMenu.insert(jMenuItem, 0);
        jMenuItem.addActionListener(new ComputeConfigFileEditor$5(this));
    }

    protected void loadFile(String string) {
        Object object = this._tabbedPane.getTitleAt(0);
        if ("".equals(object)) {
            object = (ComputeConfigFileEditor$ConfigFilePanel)((Object)this._tabbedPane.getComponentAt(0));
            if (object.isModified()) {
                object = new ComputeConfigFileEditor$ConfigFilePanel(this);
                this._tabbedPane.add(RMAIO.getFileFromPath((String)string), (Component)object);
            }
        } else {
            object = new ComputeConfigFileEditor$ConfigFilePanel(this);
            this._tabbedPane.add(RMAIO.getFileFromPath((String)string), (Component)object);
        }
        ((ComputeConfigFileEditor$ConfigFilePanel)((Object)object)).loadFile(string);
        int n = this._tabbedPane.indexOfComponent((Component)object);
        this._tabbedPane.setSelectedIndex(n);
    }

    private void buildMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        jMenuBar.add(jMenu);
        this._openMenu = new JMenuItem("Open...");
        this._openMenu.setMnemonic('O');
        this._openMenu.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jMenu.add(this._openMenu);
        this._saveMenu = new JMenuItem("Save");
        this._saveMenu.setMnemonic('S');
        this._saveMenu.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenu.add(this._saveMenu);
        this._saveAsMenu = new JMenuItem("Save As...");
        this._saveAsMenu.setMnemonic('a');
        jMenu.add(this._saveAsMenu);
        jMenu.addSeparator();
        this._reloadMenu = new JMenu("Reload");
        this._reloadMenu.setMnemonic('R');
        jMenu.add(this._reloadMenu);
        jMenu.addSeparator();
        this._exitMenu = new JMenuItem("Exit");
        this._exitMenu.setMnemonic('E');
        jMenu.add(this._exitMenu);
        this.setJMenuBar(jMenuBar);
    }

    protected void exitAppAction() {
        if (this.isModified()) {
            this.askToSave();
        }
        this.savePreferences();
        System.exit(0);
    }

    protected void askToSave() {
        int n;
        if (this.isModified() && (n = JOptionPane.showConfirmDialog((Component)((Object)this), "File has changed.Save changes?", "Confirm Save", 0)) == 0) {
            for (n = 0; n < this._tabbedPane.getTabCount(); ++n) {
                ComputeConfigFileEditor$ConfigFilePanel computeConfigFileEditor$ConfigFilePanel = (ComputeConfigFileEditor$ConfigFilePanel)((Object)this._tabbedPane.getComponent(n));
                if (!computeConfigFileEditor$ConfigFilePanel.isModified()) continue;
                computeConfigFileEditor$ConfigFilePanel.saveForm();
            }
        }
    }

    private static void a(ComputeConfigFileEditor$ConfigFilePanel$18 computeConfigFileEditor$ConfigFilePanel$18, FileChooserFld fileChooserFld) throws IOException {
        try {
            String[] stringArray;
            String string = System.getProperty("java.home") + "/bin/java";
            Object object = ManagementFactory.getRuntimeMXBean().getInputArguments();
            StringBuffer stringBuffer = new StringBuffer();
            object = object.iterator();
            while (object.hasNext()) {
                stringArray = (String[])object.next();
                if (stringArray.contains("-agentlib")) continue;
                stringBuffer.append((String)stringArray);
                stringBuffer.append(" ");
            }
            object = new StringBuffer("\"" + string + "\" " + String.valueOf(stringBuffer));
            stringArray = System.getProperty(SUN_JAVA_COMMAND).split(" ");
            if (stringArray[0].endsWith(".jar")) {
                ((StringBuffer)object).append("-jar " + new File(stringArray[0]).getPath());
            } else {
                ((StringBuffer)object).append("-cp \"" + System.getProperty("java.class.path") + "\" " + stringArray[0]);
            }
            for (int i = 1; i < stringArray.length; ++i) {
                ((StringBuffer)object).append(" ");
                ((StringBuffer)object).append(stringArray[i]);
            }
            String string2 = ((StringBuffer)object).toString().replaceFirst("hec.util.ComputeConfigFileEditor", "hec.rss.server.RssRMIServer computeSimulations.py " + RMAIO.getFilePathFromUrl((String)fileChooserFld.getPath()).replace('\\', '/'));
            Runtime.getRuntime().addShutdownHook(new ComputeConfigFileEditor$6(string2));
            computeConfigFileEditor$ConfigFilePanel$18.run();
            System.exit(0);
            return;
        }
        catch (Exception exception) {
            throw new IOException("Error while trying to restart the application", exception);
        }
    }

    public static void a(String[] object) {
        LookAndFeel.setLookAndFeel();
        object = new ComputeConfigFileEditor();
        object.setDefaultCloseOperation(0);
        object.setVisible(true);
    }
}

