/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client;

import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.AlternativePanel;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.model.TimeStepUtil;
import hec.rss.wq.client.AltWqComputeOptionsPanel$1;
import hec.rss.wq.client.AltWqComputeOptionsPanel$2;
import hec.rss.wq.model.AltWaterQualityOptions;
import hec.rss.wq.util.WqI18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.time.Duration;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJIntegerField;
import rma.util.RMAIO;

public class AltWqComputeOptionsPanel
extends AbstractEditorPanel
implements AlternativePanel {
    private static final String a = WqI18n.a("Alt.ComputeOptionsPanel.Tabname").getText();
    private EnabledJPanel _continunityErroPanel;
    private JRadioButton _preserveConcentrationRadio;
    private JRadioButton _conserveMassRadio;
    private EnabledJPanel _solutionSchemePanel;
    private JRadioButton _firstOrderRadio;
    private JRadioButton _secondOrderRadio;
    private EnabledJPanel _outputSelectedPanel;
    private RmaJIntegerField _outputSelectedFld;
    private EnabledJPanel _coupleComputePanel;
    private JRadioButton _coupledFlowWQComputeRadio;
    private JRadioButton _uncoupledFlowWQComputeRadio;
    private EnabledJPanel _threadPanel;
    private RmaJIntegerField _numThreadsFld;
    private RssAlt _alternative;
    private RmaJComboBox<TimeStepUtil> _timeStepCombo;
    private AlternativeEditor _editor;

    public AltWqComputeOptionsPanel(AlternativeEditor alternativeEditor) {
        super((LayoutManager)new GridBagLayout());
        this._editor = alternativeEditor;
        this.buildControls();
        this.addListeners();
    }

    protected void buildControls() {
        Object object = WqI18n.a("Alt.ComputeOptionsPanel.Label.TimeStep").createJLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add((Component)object, gridBagConstraints);
        this._timeStepCombo = new RmaJComboBox((Object[])TimeStepUtil.a(new AltWqComputeOptionsPanel$1()));
        this._timeStepCombo.setModifiable(true);
        ((JLabel)object).setLabelFor((Component)this._timeStepCombo);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        AltWqComputeOptionsPanel altWqComputeOptionsPanel = this;
        altWqComputeOptionsPanel.add((Component)altWqComputeOptionsPanel._timeStepCombo, gridBagConstraints);
        this._coupleComputePanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        object = WqI18n.a("Alt.ComputeOptionsPanel.Panel.Couple.Title").getText();
        this._coupleComputePanel.setBorder((Border)BorderFactory.createTitledBorder((String)object));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        AltWqComputeOptionsPanel altWqComputeOptionsPanel2 = this;
        altWqComputeOptionsPanel2.add((Component)altWqComputeOptionsPanel2._coupleComputePanel, gridBagConstraints);
        this._uncoupledFlowWQComputeRadio = WqI18n.a("Alt.ComputeOptionsPanel.Radio.UncoupleCompute").createJRadioButton();
        this._uncoupledFlowWQComputeRadio.setSelected(true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._coupleComputePanel.add((Component)this._uncoupledFlowWQComputeRadio, (Object)gridBagConstraints);
        this._coupledFlowWQComputeRadio = WqI18n.a("Alt.ComputeOptionsPanel.Radio.CoupleCompute").createJRadioButton();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 1.0E-4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._coupleComputePanel.add((Component)this._coupledFlowWQComputeRadio, (Object)gridBagConstraints);
        this._continunityErroPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        object = WqI18n.a("Alt.ComputeOptionsPanel.Panel.ContErr.Title").getText();
        this._continunityErroPanel.setBorder((Border)BorderFactory.createTitledBorder((String)object));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        AltWqComputeOptionsPanel altWqComputeOptionsPanel3 = this;
        altWqComputeOptionsPanel3.add((Component)altWqComputeOptionsPanel3._continunityErroPanel, gridBagConstraints);
        this._preserveConcentrationRadio = WqI18n.a("Alt.ComputeOptionsPanel.Radio.PreserveConcentration").createJRadioButton();
        this._preserveConcentrationRadio.setSelected(true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._continunityErroPanel.add((Component)this._preserveConcentrationRadio, (Object)gridBagConstraints);
        this._conserveMassRadio = WqI18n.a("Alt.ComputeOptionsPanel.Radio.ConserveMass").createJRadioButton();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 1.0E-4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._continunityErroPanel.add((Component)this._conserveMassRadio, (Object)gridBagConstraints);
        this._solutionSchemePanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        object = WqI18n.a("Alt.ComputeOptionsPanel.Panel.UltimateLimiter.Title").getText();
        this._solutionSchemePanel.setBorder((Border)BorderFactory.createTitledBorder((String)object));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        AltWqComputeOptionsPanel altWqComputeOptionsPanel4 = this;
        altWqComputeOptionsPanel4.add((Component)altWqComputeOptionsPanel4._solutionSchemePanel, gridBagConstraints);
        this._firstOrderRadio = WqI18n.a("Alt.ComputeOptionsPanel.Radio.UlimitOn").createJRadioButton();
        this._firstOrderRadio.setSelected(true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._solutionSchemePanel.add((Component)this._firstOrderRadio, (Object)gridBagConstraints);
        object = WqI18n.a("Alt.ComputeOptionsPanel.Label.UllimitOn").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._solutionSchemePanel.add((Component)object, (Object)gridBagConstraints);
        this._secondOrderRadio = WqI18n.a("Alt.ComputeOptionsPanel.Radio.UlimitOff").createJRadioButton();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._solutionSchemePanel.add((Component)this._secondOrderRadio, (Object)gridBagConstraints);
        object = WqI18n.a("Alt.ComputeOptionsPanel.Label.UllimitOff").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._solutionSchemePanel.add((Component)object, (Object)gridBagConstraints);
        this._outputSelectedPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        AltWqComputeOptionsPanel altWqComputeOptionsPanel5 = this;
        altWqComputeOptionsPanel5.add((Component)altWqComputeOptionsPanel5._outputSelectedPanel, gridBagConstraints);
        object = WqI18n.a("Alt.OutputOptionsPanel.Label.StepsBetweenOutput").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._outputSelectedPanel.add((Component)object, (Object)gridBagConstraints);
        this._outputSelectedFld = new RmaJIntegerField(1, 10);
        this._outputSelectedFld.setMinValue(1);
        this._outputSelectedFld.setEmptyOk(false);
        ((JLabel)object).setLabelFor((Component)this._outputSelectedFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0E-4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._outputSelectedPanel.add((Component)this._outputSelectedFld, (Object)gridBagConstraints);
        this._threadPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        AltWqComputeOptionsPanel altWqComputeOptionsPanel6 = this;
        altWqComputeOptionsPanel6.add((Component)altWqComputeOptionsPanel6._threadPanel, gridBagConstraints);
        object = WqI18n.a("Alt.ComputeOptionsPanel.Label.NumThreads").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._threadPanel.add((Component)object, (Object)gridBagConstraints);
        this._numThreadsFld = new RmaJIntegerField(1, 10);
        this._numThreadsFld.setMinValue(1);
        this._numThreadsFld.setMaxValue(this.getMaxNumberThreads());
        this._numThreadsFld.setEmptyOk(false);
        ((JLabel)object).setLabelFor((Component)this._numThreadsFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0E-4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._threadPanel.add((Component)this._numThreadsFld, (Object)gridBagConstraints);
        object = new ButtonGroup();
        ((ButtonGroup)object).add(this._uncoupledFlowWQComputeRadio);
        ((ButtonGroup)object).add(this._coupledFlowWQComputeRadio);
        object = new ButtonGroup();
        ((ButtonGroup)object).add(this._preserveConcentrationRadio);
        ((ButtonGroup)object).add(this._conserveMassRadio);
        object = new ButtonGroup();
        ((ButtonGroup)object).add(this._firstOrderRadio);
        ((ButtonGroup)object).add(this._secondOrderRadio);
    }

    private void addListeners() {
        this._timeStepCombo.addItemListener((ItemListener)new AltWqComputeOptionsPanel$2(this));
    }

    protected void timeStepComboAction() {
        this.resetTimeStepComboBackground();
    }

    protected void resetTimeStepComboBackground() {
        this._timeStepCombo.setBackground(UIManager.getColor("ComboBox.background"));
    }

    private int getMaxNumberThreads() {
        int n = Integer.getInteger("WQ.MaxThreadCount", -1);
        if (n < 0) {
            n = Runtime.getRuntime().availableProcessors();
            n <<= 1;
        }
        return n;
    }

    @Override
    public String getTabname() {
        return a;
    }

    @Override
    public void fillPanel(NamedType object) {
        if (!(object instanceof RssAlt)) {
            return;
        }
        this._alternative = (RssAlt)object;
        if (this._alternative.hasWaterQualityOptions()) {
            object = this._alternative.getWaterQualityOptions();
            int n = ((AltWaterQualityOptions)object).getTimestep();
            int n2 = ((AltWaterQualityOptions)object).getTimestepIncrement();
            if (n == -1 || n2 == -1) {
                n = this._editor.getRunControlPanel().getTimestep();
                n2 = this._editor.getRunControlPanel().getTimeStepIncrement();
            }
            Duration duration = switch (n2) {
                case 3 -> Duration.ofDays(n);
                case 2 -> Duration.ofHours(n);
                case 1 -> Duration.ofMinutes(n);
                default -> TimeStepUtil.TIME_STEP_ALL.getDuration();
            };
            if (n != -1) {
                this._timeStepCombo.setSelectedItem((Object)TimeStepUtil.a(duration));
                this.resetTimeStepComboBackground();
            } else {
                this._timeStepCombo.setBackground(Color.YELLOW);
                this._timeStepCombo.setSelectedIndex(-1);
            }
            n = ((AltWaterQualityOptions)object).getNumberThreads();
            this._numThreadsFld.setValue(n);
            this._outputSelectedFld.setValue(((AltWaterQualityOptions)object).getNumberOutputTimeSteps());
            boolean bl = ((AltWaterQualityOptions)object).getPreserveConcentration();
            n = bl ? 1 : 0;
            if (bl) {
                this._preserveConcentrationRadio.setSelected(true);
            } else {
                this._conserveMassRadio.setSelected(true);
            }
            boolean bl2 = ((AltWaterQualityOptions)object).getFirstOrderSolution();
            n = bl2 ? 1 : 0;
            if (bl2) {
                this._firstOrderRadio.setSelected(true);
            } else {
                this._secondOrderRadio.setSelected(true);
            }
            boolean bl3 = ((AltWaterQualityOptions)object).getCoupledFlowWQCompute();
            if (bl3) {
                this._coupledFlowWQComputeRadio.setSelected(true);
                return;
            }
            this._uncoupledFlowWQComputeRadio.setSelected(true);
        }
    }

    public boolean savePanel(NamedType namedType) {
        if (namedType instanceof RssAlt) {
            return this.savePanel((RssAlt)namedType);
        }
        return true;
    }

    @Override
    public void setSystem(RssSystem rssSystem) {
    }

    @Override
    public boolean savePanel(RssAlt cloneable) {
        if (cloneable == null) {
            cloneable = this._alternative;
        }
        if (cloneable != null && ((RssAlt)cloneable).hasWaterQualityOptions()) {
            if (!this.checkTimeStepCombo()) {
                return false;
            }
            cloneable = ((RssAlt)cloneable).getWaterQualityOptions();
            ((AltWaterQualityOptions)cloneable).setTimestep(this.getTimestep());
            ((AltWaterQualityOptions)cloneable).setTimestepIncrement(this.getTimeStepIncrement());
            ((AltWaterQualityOptions)cloneable).setNumberThreads(this._numThreadsFld.getValue());
            ((AltWaterQualityOptions)cloneable).setNumberOutputTimeSteps(this._outputSelectedFld.getValue());
            ((AltWaterQualityOptions)cloneable).setPreserveConcentration(this._preserveConcentrationRadio.isSelected());
            ((AltWaterQualityOptions)cloneable).setFirstOrderSolution(this._firstOrderRadio.isSelected());
            ((AltWaterQualityOptions)cloneable).setCoupledFlowWQCompute(this._coupledFlowWQComputeRadio.isSelected());
        }
        return true;
    }

    private boolean checkTimeStepCombo() {
        boolean bl;
        Object object = (TimeStepUtil)((Object)this._timeStepCombo.getSelectedItem());
        if (object == null) {
            String string = WqI18n.a("Alt.ComputeOptionsPanel.Msg.NoTimeStepSelected").getText();
            String string2 = WqI18n.a("Alt.ComputeOptionsPanel.Msg.NoTimeStepSelected.Title").getText();
            JOptionPane.showMessageDialog((Component)((Object)this), string, string2, 1);
            return false;
        }
        Duration duration = object.getDuration();
        TimeStepUtil timeStepUtil = this._editor.getRunControlPanel().getSelectedTimeStep();
        Duration duration2 = timeStepUtil.getDuration();
        int n = duration.compareTo(duration2);
        boolean bl2 = bl = duration2.getSeconds() % duration.getSeconds() == 0L;
        if (n > 0 || !bl) {
            object = WqI18n.a("Alt.ComputeOptionsPanel.Msg.InvalidTimeStep").format(new Object[]{object.toString(), timeStepUtil.toString()});
            String string = WqI18n.a("Alt.ComputeOptionsPanel.Msg.InvalidTimeStep.Title").getText();
            JOptionPane.showMessageDialog((Component)((Object)this), object, string, 1);
            return false;
        }
        return true;
    }

    public int getTimestep() {
        int n;
        int n2 = this._timeStepCombo.getSelectedIndex();
        Object object = n2 >= 0 ? (TimeStepUtil)((Object)this._timeStepCombo.getItemAt(n2)) : null;
        int n3 = 1;
        if (object != null && (n = ((String)(object = ((TimeStepUtil)((Object)object)).toString())).indexOf(32)) >= 0) {
            object = ((String)object).substring(0, n);
            n3 = RMAIO.parseInt((String)object, (int)1);
        }
        return n3;
    }

    public int getTimeStepIncrement() {
        int n;
        int n2 = this._timeStepCombo.getSelectedIndex();
        Object object = n2 >= 0 ? (TimeStepUtil)((Object)this._timeStepCombo.getItemAt(n2)) : null;
        int n3 = 2;
        if (object != null && (n = ((String)(object = ((TimeStepUtil)((Object)object)).toString())).indexOf(32)) >= 0) {
            if ("Hour".equalsIgnoreCase((String)(object = ((String)object).substring(n).trim())) || "Hours".equalsIgnoreCase((String)object)) {
                n3 = 2;
            } else if ("Minute".equalsIgnoreCase((String)object) || "Minutes".equalsIgnoreCase((String)object)) {
                n3 = 1;
            } else if (((String)object).equalsIgnoreCase("Day")) {
                n3 = 3;
            } else if (((String)object).equalsIgnoreCase("Second")) {
                n3 = 0;
            }
        }
        return n3;
    }

    @Override
    public void clearPanel() {
        this._timeStepCombo.setSelectedIndex(-1);
        this._preserveConcentrationRadio.setSelected(true);
        this._firstOrderRadio.setSelected(true);
        this._numThreadsFld.setValue(1);
        this._outputSelectedFld.setValue(1);
        this._uncoupledFlowWQComputeRadio.setSelected(true);
    }
}

