/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyList;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.SimulationPeriod;
import hec.gui.AbstractEditorPanel;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.model.RunTimeWindow;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.AlternativePanel;
import hec.rss.client.RSimSimulationMode;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.wq.client.AltWqDataSetsPanel$1;
import hec.rss.wq.client.AltWqDataSetsPanel$DataSetType;
import hec.rss.wq.client.WaterQualityEditors;
import hec.rss.wq.client.WqClientMode;
import hec.rss.wq.client.geometry.GeometryEditor;
import hec.rss.wq.client.wqParameters.ParameterSetEditor;
import hec.rss.wq.model.AltWaterQualityOptions;
import hec.rss.wq.model.BoundaryConditionSetManager;
import hec.rss.wq.model.ConstituentSetManager;
import hec.rss.wq.model.InitialConditionSetManager;
import hec.rss.wq.model.MetData;
import hec.rss.wq.model.ObsDatasetManager;
import hec.rss.wq.model.WQInputDataSetCollection;
import hec.rss.wq.model.WQInputsChecker;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.model.dispersionCoeff.DispersionSetManager;
import hec.rss.wq.model.massinjection.MassInjectionSetManager;
import hec.rss.wq.model.wqParameters.ParameterSetManager;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.BoundaryConditionSet;
import hec.wqenginecore.ConstituentSet;
import hec.wqenginecore.InitialConditionSet;
import hec.wqenginecore.dispersion.DispersionCoefSettings;
import hec.wqenginecore.massinjection.MassInjectionSet;
import hec.wqenginecore.massinjection.MassInjectionSite;
import hec.wqenginecore.metstation.MetStationSet;
import hec.wqenginecore.observed.ObsStationSet;
import hec.wqenginecore.parameter.ParameterSet;
import hec.wqengineimpl.dispersion.WQDispersionCoefSettings;
import hec.wqengineimpl.metstation.WQMetStationSet;
import hec.wqengineimpl.observed.WQObsStationSet;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJTable;
import rma.swing.table.RmaTableModel;

public class AltWqDataSetsPanel
extends AbstractEditorPanel
implements AlternativePanel {
    private static final String a = WqI18n.a("Alt.DataSetsPanel.Tabname").getText();
    private boolean _inWQMode;
    private JButton _editBtn;
    private RmaJTable _dataSetsTable;
    private RssSystem _system;
    private RssAlt _alternative;
    private Map<AltWqDataSetsPanel$DataSetType, List<ManagerProxy>> _typesToManagerProxiesMap = new HashMap<AltWqDataSetsPanel$DataSetType, List<ManagerProxy>>();
    private AlternativeEditor _editor;
    private ManagerProxyListContainer _wksp;
    private JButton _checkConstitencyBtn;
    private ManagerProxy _emptyProxy;

    public AltWqDataSetsPanel(AlternativeEditor alternativeEditor) {
        super((LayoutManager)new GridBagLayout());
        this._editor = alternativeEditor;
        this.buildControls();
        this.fillTable();
        this.addListeners();
    }

    protected void buildControls() {
        Object object;
        if (ClientApp.frame().getCurrentMode() instanceof WqClientMode) {
            object = new String[]{WqI18n.a("Alt.DataSetsPanel.Header.DataSet").getText(), WqI18n.a("Alt.DataSetsPanel.Header.Selection").getText(), WqI18n.a("Alt.DataSetsPanel.Header.Edit").getText()};
            this._inWQMode = true;
        } else {
            object = new String[]{WqI18n.a("Alt.DataSetsPanel.Header.DataSet").getText(), WqI18n.a("Alt.DataSetsPanel.Header.Selection").getText()};
            this._inWQMode = false;
        }
        AltWqDataSetsPanel altWqDataSetsPanel = this;
        this._dataSetsTable = new AltWqDataSetsPanel$1(altWqDataSetsPanel, (Component)((Object)altWqDataSetsPanel), (Object[])object);
        this._dataSetsTable.setColumnEnabled(false, 0);
        this._dataSetsTable.setRowHeight(this._dataSetsTable.getRowHeight() + 5);
        this._dataSetsTable.setComboBoxEditor(1, new Object[0]);
        if (this._inWQMode) {
            this._editBtn = this._dataSetsTable.setButtonCellEditor(2);
            this._editBtn.setText(WqI18n.a("Alt.DataSetsPanel.Btn.Edit").getText());
            this._dataSetsTable.setColumnWidths(new int[]{225, 330, 125});
        }
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        object.gridy = -1;
        object.gridwidth = 0;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.anchor = 18;
        object.fill = 1;
        object.insets = RmaInsets.INSETS5505;
        AltWqDataSetsPanel altWqDataSetsPanel2 = this;
        altWqDataSetsPanel2.add(altWqDataSetsPanel2._dataSetsTable.getScrollPane(), object);
        this._checkConstitencyBtn = WqI18n.a("Alt.DataSetsPanel.Btn.CheckConstitency").createJButton();
        object.gridx = -1;
        object.gridy = -1;
        object.gridwidth = 0;
        object.weightx = 0.0;
        object.weighty = 0.0;
        object.anchor = 18;
        object.fill = 0;
        object.insets = RmaInsets.INSETS5505;
        AltWqDataSetsPanel altWqDataSetsPanel3 = this;
        altWqDataSetsPanel3.add(altWqDataSetsPanel3._checkConstitencyBtn, object);
    }

    private void addListeners() {
        this._dataSetsTable.getModel().addTableModelListener(tableModelEvent -> this.dataSetsTableChanged(tableModelEvent));
        this._checkConstitencyBtn.addActionListener(actionEvent -> this.checkConsistency());
        if (this._editBtn != null) {
            this._editBtn.addActionListener(actionEvent -> this.editDataSet());
        }
    }

    private void editDataSet() {
        int n = this._dataSetsTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        Object object = this._dataSetsTable.getValueAt(n, 1);
        if (!(object instanceof ManagerProxy)) {
            return;
        }
        object = (ManagerProxy)object;
        Object object2 = (WqClientMode)ClientApp.frame().getCurrentMode();
        Object object3 = (AltWqDataSetsPanel$DataSetType)((Object)this._dataSetsTable.getValueAt(n, 0));
        object2 = object2.getEditorLaucher();
        switch (((Enum)object3).ordinal()) {
            case 4: {
                ((WaterQualityEditors)object2).displayBoundaryConditionEditor((BoundaryConditionSetManager)object.loadManager(null, null));
                return;
            }
            case 6: {
                ((WaterQualityEditors)object2).displayDispersionCoeffEditor((DispersionSetManager)object.loadManager(null, null));
                return;
            }
            case 0: {
                object3 = ((WaterQualityEditors)object2).displayGeometryEditor((WqGeometry)object.loadManager(null, null));
                object = this.getManagerProxy(AltWqDataSetsPanel$DataSetType.MetData);
                if (object == null) break;
                ((GeometryEditor)((Object)object3)).selectMetDataSet((ManagerProxy)object);
                return;
            }
            case 3: {
                ((WaterQualityEditors)object2).displayInitialConditionsEditor((InitialConditionSetManager)object.loadManager(null, null));
                return;
            }
            case 8: {
                ((WaterQualityEditors)object2).displayMassInjectionEditor((MassInjectionSetManager)object.loadManager(null, null));
                return;
            }
            case 5: {
                ((WaterQualityEditors)object2).displayMetDataSetEditor((MetData)object.loadManager(null, null));
                return;
            }
            case 7: {
                ((WaterQualityEditors)object2).displayObservedDataSetEditor((ObsDatasetManager)object.loadManager(null, null));
                return;
            }
            case 2: {
                object3 = ((WaterQualityEditors)object2).displayWqParameterEditor((ParameterSetManager)object.loadManager(null, null));
                object = this.getManagerProxy(AltWqDataSetsPanel$DataSetType.WqConstituent);
                if (object == null) break;
                ((ParameterSetEditor)((Object)object3)).setSelectedConstitientSet((ManagerProxy)object);
                return;
            }
            case 1: {
                ((WaterQualityEditors)object2).displayWqConstituentsEditor((ConstituentSetManager)object.loadManager(null, null));
            }
        }
    }

    private ManagerProxy getManagerProxy(AltWqDataSetsPanel$DataSetType altWqDataSetsPanel$DataSetType) {
        for (int i = 0; i < this._dataSetsTable.getRowCount(); ++i) {
            if (this._dataSetsTable.getValueAt(i, 0) != altWqDataSetsPanel$DataSetType) continue;
            return (ManagerProxy)this._dataSetsTable.getValueAt(i, 1);
        }
        return null;
    }

    private void checkConsistency() {
        AltWqDataSetsPanel altWqDataSetsPanel = this;
        altWqDataSetsPanel.savePanel(altWqDataSetsPanel._alternative);
        this._system = this._alternative.getSystem();
        Object object = null;
        ConstituentSet constituentSet = null;
        ParameterSet parameterSet = null;
        WQMetStationSet wQMetStationSet = null;
        InitialConditionSet initialConditionSet = null;
        BoundaryConditionSet boundaryConditionSet = null;
        WQDispersionCoefSettings wQDispersionCoefSettings = null;
        WQObsStationSet wQObsStationSet = null;
        MassInjectionSet massInjectionSet = null;
        int n = this._dataSetsTable.getRowCount();
        int n2 = -1;
        ManagerProxy managerProxy = null;
        block11: for (int i = 0; i < n; ++i) {
            AltWqDataSetsPanel$DataSetType altWqDataSetsPanel$DataSetType = (AltWqDataSetsPanel$DataSetType)((Object)this._dataSetsTable.getValueAt(i, 0));
            Object object2 = this._dataSetsTable.getValueAt(i, 1);
            Manager manager = null;
            if (object2 instanceof ManagerProxy && (manager = (managerProxy = (ManagerProxy)object2).getManager()) == null && managerProxy.getIndex() >= 0) {
                manager = managerProxy.loadManager(null, null);
            }
            switch (altWqDataSetsPanel$DataSetType.ordinal()) {
                case 0: {
                    if (!(manager instanceof WqGeometry)) continue block11;
                    object = ((WqGeometry)manager).getRssWqGeometry();
                    continue block11;
                }
                case 1: {
                    if (!(manager instanceof ConstituentSetManager)) continue block11;
                    constituentSet = ((ConstituentSetManager)manager).getSet();
                    n2 = managerProxy.getIndex();
                    continue block11;
                }
                case 2: {
                    if (!(manager instanceof ParameterSetManager)) continue block11;
                    parameterSet = ((ParameterSetManager)manager).getSet(n2);
                    continue block11;
                }
                case 5: {
                    if (!(manager instanceof MetData)) continue block11;
                    wQMetStationSet = ((MetData)manager).getMetStationSet();
                    continue block11;
                }
                case 4: {
                    if (!(manager instanceof BoundaryConditionSetManager)) continue block11;
                    boundaryConditionSet = ((BoundaryConditionSetManager)manager).getSet();
                    continue block11;
                }
                case 3: {
                    if (!(manager instanceof InitialConditionSetManager)) continue block11;
                    initialConditionSet = ((InitialConditionSetManager)manager).getSet();
                    continue block11;
                }
                case 6: {
                    if (!(manager instanceof DispersionSetManager)) continue block11;
                    wQDispersionCoefSettings = ((DispersionSetManager)manager).getSet();
                    continue block11;
                }
                case 7: {
                    if (!(manager instanceof ObsDatasetManager)) continue block11;
                    wQObsStationSet = ((ObsDatasetManager)manager).getObsStationSet();
                    continue block11;
                }
                case 8: {
                    if (!(manager instanceof MassInjectionSetManager)) continue block11;
                    massInjectionSet = ((MassInjectionSetManager)manager).getSet();
                }
            }
        }
        Object object3 = this.getWqGeometry();
        WQInputDataSetCollection wQInputDataSetCollection = new WQInputDataSetCollection();
        wQInputDataSetCollection.a(this._system);
        wQInputDataSetCollection.a(this._alternative);
        wQInputDataSetCollection.a((RssWQGeometry)object);
        wQInputDataSetCollection.a((WqGeometry)((Object)object3));
        wQInputDataSetCollection.a(constituentSet);
        wQInputDataSetCollection.a(parameterSet);
        wQInputDataSetCollection.a(initialConditionSet);
        wQInputDataSetCollection.a(boundaryConditionSet);
        wQInputDataSetCollection.a((MetStationSet)wQMetStationSet);
        wQInputDataSetCollection.a((DispersionCoefSettings)wQDispersionCoefSettings);
        wQInputDataSetCollection.a((ObsStationSet)wQObsStationSet);
        wQInputDataSetCollection.a(massInjectionSet);
        if (massInjectionSet != null) {
            object = this.getMassInjectionSites(massInjectionSet.getName());
            wQInputDataSetCollection.a((List<MassInjectionSite>)object);
        }
        object = ClientApp.frame().getCurrentMode();
        object3 = null;
        if (object instanceof RSimSimulationMode) {
            object3 = (RSimSimulationMode)object;
        }
        object = (object = object3) != null ? object.getSimulation() : null;
        object3 = null;
        if (object != null) {
            object3 = object.getRunTimeWindow();
        }
        object = object3;
        wQInputDataSetCollection.a((RunTimeWindow)object);
        object = new WQInputsChecker(wQInputDataSetCollection);
        ((WQInputsChecker)object).b(true);
        object = ((WQInputsChecker)object).f();
        EventQueue.invokeLater(() -> this.lambda$checkConsistency$3((String)object));
    }

    private WqGeometry getWqGeometry() {
        Object object = this._alternative.getProxyList();
        String string = this._alternative.getWaterQualityOptions().getGeometryName();
        object = this.getManager((ManagerProxyList)object, (Class)WqGeometry.class, string);
        return object;
    }

    private List<MassInjectionSite> getMassInjectionSites(String object) {
        Object object2 = this._alternative.getProxyList();
        object = this.getManager((ManagerProxyList)object2, (Class)MassInjectionSetManager.class, (String)object);
        if (object != null) {
            object2 = null;
            ClientMode clientMode = ClientApp.frame().getCurrentMode();
            if (clientMode instanceof RSimSimulationMode) {
                object2 = (RSimSimulationMode)clientMode;
                object2 = object2.getMassInjectionMgr();
            }
            if (object2 != null) {
                object2 = object2.getMassInjectionSites();
                object2 = new ArrayList(object2);
                object = ((MassInjectionSetManager)object).getSet().getMassInjectionSiteList((List)object2);
                return object;
            }
        }
        return null;
    }

    private <T extends Manager> T getManager(ManagerProxyList object, Class<T> clazz, String string) {
        object = this.getProxies((ManagerProxyList)object, clazz);
        object = object.stream().filter(managerProxy -> Objects.equals(string, managerProxy.getName())).map(managerProxy -> managerProxy.loadManager(null, null)).findFirst().orElse(null);
        return (T)object;
    }

    private List<ManagerProxy> getProxies(ManagerProxyList managerProxyList, Class clazz) {
        List<Object> list = Collections.emptyList();
        Collection collection = null;
        if (managerProxyList != null) {
            collection = managerProxyList.getManagerIDList(clazz.getName());
        }
        if (collection != null) {
            list = collection.stream().map(arg_0 -> ((ManagerProxyList)managerProxyList).getManagerProxy(arg_0)).collect(Collectors.toList());
        }
        return list;
    }

    protected void dataSetsTableChanged(TableModelEvent tableModelEvent) {
    }

    protected String getTableToolTipText(MouseEvent mouseEvent) {
        Object object;
        int n = this._dataSetsTable.rowAtPoint(mouseEvent.getPoint());
        if (n == -1) {
            return null;
        }
        int n2 = this._dataSetsTable.columnAtPoint(mouseEvent.getPoint());
        if (n2 == -1) {
            return null;
        }
        if (n2 == 1 && (object = this._dataSetsTable.getValueAt(n, n2)) instanceof ManagerProxy) {
            object = (ManagerProxy)object;
            return "<html>Object is a ManagerProxy.<br>Name=" + object.getName() + "<br>Index=" + object.getIndex() + "</html>";
        }
        return null;
    }

    @Override
    public String getTabname() {
        return a;
    }

    @Override
    public void fillPanel(NamedType namedType) {
        if (!(namedType instanceof RssAlt)) {
            return;
        }
        this._alternative = (RssAlt)namedType;
        if (this._alternative.hasWaterQualityOptions()) {
            boolean bl = this._wksp instanceof SimulationPeriod;
            AltWaterQualityOptions altWaterQualityOptions = this._alternative.getWaterQualityOptions();
            String string = altWaterQualityOptions.getGeometryName();
            int n = altWaterQualityOptions.getGeometryId();
            this.addDataSetToTable(AltWqDataSetsPanel$DataSetType.Geometry, WqGeometry.class, true, false);
            ((RmaTableModel)this._dataSetsTable.getModel()).fireTableCellUpdated(this.getRowFor(AltWqDataSetsPanel$DataSetType.Geometry), 0);
            this._dataSetsTable.revalidate();
            this.setTableValue(AltWqDataSetsPanel$DataSetType.Geometry, string, n, bl);
            string = altWaterQualityOptions.getParametersName();
            n = altWaterQualityOptions.getParametersId();
            this.setTableValue(AltWqDataSetsPanel$DataSetType.Parameters, string, n, bl);
            string = altWaterQualityOptions.getIcName();
            n = altWaterQualityOptions.getIcId();
            this.setTableValue(AltWqDataSetsPanel$DataSetType.InitialConditions, string, n, bl);
            string = altWaterQualityOptions.getBcName();
            n = altWaterQualityOptions.getBcId();
            this.setTableValue(AltWqDataSetsPanel$DataSetType.BoundaryConditions, string, n, bl);
            string = altWaterQualityOptions.getDispersionCoefName();
            n = altWaterQualityOptions.getDispersionCoefId();
            this.setTableValue(AltWqDataSetsPanel$DataSetType.DispersionCoef, string, n, bl);
            string = altWaterQualityOptions.getMassInjectionName();
            n = altWaterQualityOptions.getMassInjectionId();
            this.setTableValue(AltWqDataSetsPanel$DataSetType.MassInjection, string, n, bl);
            string = altWaterQualityOptions.getMetDataName();
            n = altWaterQualityOptions.getMetDataId();
            this.setTableValue(AltWqDataSetsPanel$DataSetType.MetData, string, n, bl);
            string = altWaterQualityOptions.getObservedDataName();
            n = altWaterQualityOptions.getObservedDataId();
            this.setTableValue(AltWqDataSetsPanel$DataSetType.ObsData, string, n, bl);
            string = altWaterQualityOptions.getConstituentName();
            int n2 = altWaterQualityOptions.getConstituentId();
            this.setTableValue(AltWqDataSetsPanel$DataSetType.WqConstituent, string, n2, bl);
        }
    }

    private void setTableValue(AltWqDataSetsPanel$DataSetType altWqDataSetsPanel$DataSetType, String string, int n, boolean bl) {
        int n2 = this._dataSetsTable.getRowCount();
        for (int i = 0; i < n2; ++i) {
            if (this._dataSetsTable.getValueAt(i, 0) != altWqDataSetsPanel$DataSetType) continue;
            ManagerProxy managerProxy = this.findManagerProxy(altWqDataSetsPanel$DataSetType, string, n);
            if (managerProxy != null) {
                this._dataSetsTable.setValueAt((Object)managerProxy, i, 1);
                if (!bl) continue;
                this.filterTableComboByName(managerProxy, altWqDataSetsPanel$DataSetType);
                continue;
            }
            this._dataSetsTable.setValueAt(null, i, 1);
        }
    }

    private void filterTableComboByName(ManagerProxy object, AltWqDataSetsPanel$DataSetType altWqDataSetsPanel$DataSetType) {
        int n;
        if (object == null) {
            return;
        }
        int n2 = ((String)(object = object.getName())).lastIndexOf(":");
        if (n2 == -1) {
            return;
        }
        object = ((String)object).substring(0, n2);
        Vector<ManagerProxy> vector = new Vector<ManagerProxy>();
        List<ManagerProxy> list = this._typesToManagerProxiesMap.get((Object)altWqDataSetsPanel$DataSetType);
        for (n = 0; n < list.size(); ++n) {
            ManagerProxy managerProxy = list.get(n);
            if (!managerProxy.getName().startsWith((String)object)) continue;
            vector.add(managerProxy);
        }
        n = this.getRowFor(altWqDataSetsPanel$DataSetType);
        this._dataSetsTable.setComboBoxRowEditor(n, 1, vector);
    }

    private ManagerProxy findManagerProxy(AltWqDataSetsPanel$DataSetType object, String string, int n) {
        if (string != null && (object = this._typesToManagerProxiesMap.get(object)) != null) {
            object = object.iterator();
            while (object.hasNext()) {
                ManagerProxy managerProxy = (ManagerProxy)object.next();
                if (managerProxy.getIndex() != n && !string.equals(managerProxy.getName())) continue;
                return managerProxy;
            }
        }
        return null;
    }

    public boolean savePanel(NamedType namedType) {
        if (namedType instanceof RssAlt) {
            return this.savePanel((RssAlt)namedType);
        }
        return true;
    }

    @Override
    public void setSystem(RssSystem rssSystem) {
        this._system = rssSystem;
    }

    @Override
    public boolean savePanel(RssAlt cloneable) {
        if (cloneable == null) {
            cloneable = this._alternative;
        }
        if (cloneable == null) {
            return true;
        }
        if (((RssAlt)cloneable).hasWaterQualityOptions()) {
            cloneable = ((RssAlt)cloneable).getWaterQualityOptions();
            this._dataSetsTable.commitEdit(true);
            int n = this._dataSetsTable.getRowCount();
            block11: for (int i = 0; i < n; ++i) {
                int n2;
                String string;
                AltWqDataSetsPanel$DataSetType altWqDataSetsPanel$DataSetType = (AltWqDataSetsPanel$DataSetType)((Object)this._dataSetsTable.getValueAt(i, 0));
                Object object = this._dataSetsTable.getValueAt(i, 1);
                if (object instanceof ManagerProxy && object != this._emptyProxy) {
                    string = ((ManagerProxy)object).getName();
                    n2 = ((ManagerProxy)object).getIndex();
                } else {
                    string = null;
                    n2 = -1;
                }
                switch (altWqDataSetsPanel$DataSetType.ordinal()) {
                    case 4: {
                        ((AltWaterQualityOptions)cloneable).setBcName(string);
                        ((AltWaterQualityOptions)cloneable).setBcId(n2);
                        continue block11;
                    }
                    case 6: {
                        ((AltWaterQualityOptions)cloneable).setDispersionCoefName(string);
                        ((AltWaterQualityOptions)cloneable).setDispersionCoefId(n2);
                        continue block11;
                    }
                    case 0: {
                        ((AltWaterQualityOptions)cloneable).setGeometryName(string);
                        ((AltWaterQualityOptions)cloneable).setGeometryId(n2);
                        continue block11;
                    }
                    case 3: {
                        ((AltWaterQualityOptions)cloneable).setIcName(string);
                        ((AltWaterQualityOptions)cloneable).setIcId(n2);
                        continue block11;
                    }
                    case 8: {
                        ((AltWaterQualityOptions)cloneable).setMassInjectionName(string);
                        ((AltWaterQualityOptions)cloneable).setMassInjectionId(n2);
                        continue block11;
                    }
                    case 5: {
                        ((AltWaterQualityOptions)cloneable).setMetDataName(string);
                        ((AltWaterQualityOptions)cloneable).setMetDataId(n2);
                        continue block11;
                    }
                    case 7: {
                        ((AltWaterQualityOptions)cloneable).setObservedDataName(string);
                        ((AltWaterQualityOptions)cloneable).setObservedDataId(n2);
                        continue block11;
                    }
                    case 2: {
                        ((AltWaterQualityOptions)cloneable).setParametersName(string);
                        ((AltWaterQualityOptions)cloneable).setParametersId(n2);
                        continue block11;
                    }
                    case 1: {
                        ((AltWaterQualityOptions)cloneable).setConstituentName(string);
                        ((AltWaterQualityOptions)cloneable).setConstituentId(n2);
                    }
                }
            }
        }
        return true;
    }

    @Override
    public void clearPanel() {
        this._dataSetsTable.commitEdit(true);
        this._dataSetsTable.clearPerformed();
    }

    public void fillPanel(ManagerProxyListContainer managerProxyListContainer) {
        this._wksp = managerProxyListContainer;
        this._dataSetsTable.deleteCells();
        this.fillTable();
    }

    private void fillTable() {
        this.addTypesToTable();
        this.addDataSetsToTable();
    }

    private void addDataSetsToTable() {
        this.addDataSetToTable(AltWqDataSetsPanel$DataSetType.MetData, MetData.class, false, true);
        this.addDataSetToTable(AltWqDataSetsPanel$DataSetType.WqConstituent, ConstituentSetManager.class, false, false);
        this.addDataSetToTable(AltWqDataSetsPanel$DataSetType.Geometry, WqGeometry.class, true, false);
        this.addDataSetToTable(AltWqDataSetsPanel$DataSetType.BoundaryConditions, BoundaryConditionSetManager.class, false, false);
        this.addDataSetToTable(AltWqDataSetsPanel$DataSetType.DispersionCoef, DispersionSetManager.class, false, false);
        this.addDataSetToTable(AltWqDataSetsPanel$DataSetType.Parameters, ParameterSetManager.class, false, false);
        this.addDataSetToTable(AltWqDataSetsPanel$DataSetType.InitialConditions, InitialConditionSetManager.class, false, false);
        this.addDataSetToTable(AltWqDataSetsPanel$DataSetType.MassInjection, MassInjectionSetManager.class, false, true);
        this.addDataSetToTable(AltWqDataSetsPanel$DataSetType.ObsData, ObsDatasetManager.class, false, true);
    }

    private int getRowFor(AltWqDataSetsPanel$DataSetType altWqDataSetsPanel$DataSetType) {
        int n = this._dataSetsTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object object = this._dataSetsTable.getValueAt(i, 0);
            if (object != altWqDataSetsPanel$DataSetType) continue;
            return i;
        }
        return 0;
    }

    private void filterGeometriesByNetwork(List<ManagerProxy> object) {
        if (this._alternative == null) {
            return;
        }
        Object object2 = this._alternative.getSystem();
        if (object2 == null) {
            return;
        }
        Iterator<ManagerProxy> iterator = object.iterator();
        while (iterator.hasNext()) {
            Object object3 = iterator.next();
            if ((object3 = (WqGeometry)object3.loadManager(null, null)) == null || ((WqGeometry)((Object)object3)).getNetworkId() == object2.getIndex()) continue;
            iterator.remove();
        }
        if (object.isEmpty()) {
            object = WqI18n.a("Alt.DataSetsPanel.Msg.NoCompatibleGeometries").format(object2);
            object2 = WqI18n.a("Alt.DataSetsPanel.Msg.NoCompatibleGeometries.Title").getText();
            EventQueue.invokeLater(() -> this.lambda$filterGeometriesByNetwork$6((String)object, (String)object2));
        }
    }

    private RmaJComboBox addDataSetToTable(AltWqDataSetsPanel$DataSetType altWqDataSetsPanel$DataSetType, Class serializable, boolean bl, boolean bl2) {
        ManagerProxyListContainer managerProxyListContainer = this._wksp;
        if (managerProxyListContainer == null) {
            managerProxyListContainer = ClientApp.Workspace();
        }
        if ((serializable = managerProxyListContainer.getManagerProxyList("rss", ((Class)serializable).getName())) != null) {
            if (bl) {
                this.filterGeometriesByNetwork((List<ManagerProxy>)((Object)serializable));
            }
            if (bl2) {
                if (this._emptyProxy == null) {
                    Identifier identifier = new Identifier();
                    identifier.setName("");
                    this._emptyProxy = new ManagerProxy(identifier);
                    this._emptyProxy.setIndex(-1);
                }
                ((Vector)serializable).add(0, this._emptyProxy);
            }
            RmaJComboBox rmaJComboBox = this.setComboBoxInTable((Vector<ManagerProxy>)serializable, altWqDataSetsPanel$DataSetType);
            this._typesToManagerProxiesMap.put(altWqDataSetsPanel$DataSetType, (List<ManagerProxy>)((Object)serializable));
            return rmaJComboBox;
        }
        return null;
    }

    private RmaJComboBox setComboBoxInTable(Vector<ManagerProxy> rmaJComboBox, AltWqDataSetsPanel$DataSetType altWqDataSetsPanel$DataSetType) {
        this._dataSetsTable.commitEdit(false);
        int n = this._dataSetsTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (this._dataSetsTable.getValueAt(i, 0) != altWqDataSetsPanel$DataSetType) continue;
            rmaJComboBox = this._dataSetsTable.setComboBoxRowEditor(i, 1, rmaJComboBox);
            rmaJComboBox.setModifiable(true);
            return rmaJComboBox;
        }
        return null;
    }

    private void addTypesToTable() {
        this._dataSetsTable.deleteCells();
        AltWqDataSetsPanel$DataSetType[] altWqDataSetsPanel$DataSetTypeArray = AltWqDataSetsPanel$DataSetType.values();
        AltWqDataSetsPanel$DataSetType[] altWqDataSetsPanel$DataSetTypeArray2 = altWqDataSetsPanel$DataSetTypeArray;
        altWqDataSetsPanel$DataSetTypeArray2 = altWqDataSetsPanel$DataSetTypeArray;
        int n = altWqDataSetsPanel$DataSetTypeArray.length;
        for (int i = 0; i < n; ++i) {
            AltWqDataSetsPanel$DataSetType altWqDataSetsPanel$DataSetType = altWqDataSetsPanel$DataSetTypeArray2[i];
            Vector<Object> vector = new Vector<Object>(3);
            vector.add((Object)altWqDataSetsPanel$DataSetType);
            vector.add(null);
            if (this._inWQMode) {
                vector.add(WqI18n.a("Alt.DataSetsPanel.Btn.Edit").getText());
            }
            this._dataSetsTable.appendRow(vector);
        }
    }

    private /* synthetic */ void lambda$filterGeometriesByNetwork$6(String string, String string2) {
        if (this._editor.getRunControlPanel().isWqSelected()) {
            JOptionPane.showMessageDialog((Component)((Object)this), string, string2, 1);
        }
    }

    private /* synthetic */ void lambda$checkConsistency$3(String string) {
        JOptionPane.showMessageDialog((Component)((Object)this), string, WqI18n.a("ConsistencyCheck.Title").getText(), -1);
    }
}

