/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client;

import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.rss.client.AlternativePanel;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.wq.model.AltWaterQualityOptions;
import hec.rss.wq.util.WqI18n;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.border.Border;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;

public class AltWqOutputVariablesPanel
extends AbstractEditorPanel
implements AlternativePanel {
    private EnabledJPanel _outputPanel;
    private EnabledJPanel _leftPanel;
    private EnabledJPanel _rightPanel;
    private JCheckBox _cellVolumeCheck;
    private JCheckBox _cellFlowCheck;
    private JCheckBox _cellVelocityCheck;
    private JCheckBox _cellMassCheck;
    private JCheckBox _heatBudgetTermsCheck;
    private JCheckBox _nsmPathwaysCheck;
    private JCheckBox _nsmDerivedCheck;
    private JCheckBox _generalPathwaysCheck;
    private RssAlt _alternative;

    public AltWqOutputVariablesPanel() {
        super((LayoutManager)new GridBagLayout());
        this.buildControls();
    }

    private void buildControls() {
        this._outputPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        Object object = WqI18n.a("Alt.OutputVarPanel.Title").getText();
        this._outputPanel.setBorder((Border)BorderFactory.createTitledBorder((String)object));
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        ((GridBagConstraints)object).gridy = -1;
        ((GridBagConstraints)object).gridwidth = 0;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS5505;
        AltWqOutputVariablesPanel altWqOutputVariablesPanel = this;
        altWqOutputVariablesPanel.add((Component)altWqOutputVariablesPanel._outputPanel, object);
        this._leftPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        ((GridBagConstraints)object).gridx = -1;
        ((GridBagConstraints)object).gridy = -1;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).weighty = 1.0E-4;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS5505;
        this._outputPanel.add((Component)this._leftPanel, object);
        this._rightPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        ((GridBagConstraints)object).gridx = -1;
        ((GridBagConstraints)object).gridy = -1;
        ((GridBagConstraints)object).gridwidth = 0;
        ((GridBagConstraints)object).weightx = 1.0E-4;
        ((GridBagConstraints)object).weighty = 1.0E-4;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS5505;
        this._outputPanel.add((Component)this._rightPanel, object);
        this.buildLeftPanel();
        this.buildRightPanel();
    }

    private void buildLeftPanel() {
        JLabel jLabel = WqI18n.a("Alt.OutputVarPanel.Label.HydroVariables").createJLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._leftPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._cellVolumeCheck = WqI18n.a("Alt.OutputVarPanel.Check.CellVolume").createJCheckBox();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._leftPanel.add((Component)this._cellVolumeCheck, (Object)gridBagConstraints);
        this._cellFlowCheck = WqI18n.a("Alt.OutputVarPanel.Check.CellFlow").createJCheckBox();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._leftPanel.add((Component)this._cellFlowCheck, (Object)gridBagConstraints);
        this._cellVelocityCheck = WqI18n.a("Alt.OutputVarPanel.Check.CellVelocity").createJCheckBox();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._leftPanel.add((Component)this._cellVelocityCheck, (Object)gridBagConstraints);
    }

    protected void buildRightPanel() {
        JLabel jLabel = WqI18n.a("Alt.OutputVarPanel.Label.ConstituentVariables").createJLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._rightPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._cellMassCheck = WqI18n.a("Alt.OutputVarPanel.Check.CellMass").createJCheckBox();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._rightPanel.add((Component)this._cellMassCheck, (Object)gridBagConstraints);
        this._heatBudgetTermsCheck = WqI18n.a("Alt.OutputVarPanel.Check.HeatBudget").createJCheckBox();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._rightPanel.add((Component)this._heatBudgetTermsCheck, (Object)gridBagConstraints);
        this._nsmPathwaysCheck = WqI18n.a("Alt.OutputVarPanel.Check.NsmPathways").createJCheckBox();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._rightPanel.add((Component)this._nsmPathwaysCheck, (Object)gridBagConstraints);
        this._nsmDerivedCheck = WqI18n.a("Alt.OutputVarPanel.Check.NsmVariables").createJCheckBox();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._rightPanel.add((Component)this._nsmDerivedCheck, (Object)gridBagConstraints);
        this._generalPathwaysCheck = WqI18n.a("Alt.OutputVarPanel.Check.GeneralPathways").createJCheckBox();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0E-4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._rightPanel.add((Component)this._generalPathwaysCheck, (Object)gridBagConstraints);
    }

    @Override
    public String getTabname() {
        return "Output Variables";
    }

    @Override
    public void fillPanel(NamedType object) {
        if (!(object instanceof RssAlt)) {
            return;
        }
        this._alternative = (RssAlt)object;
        if (this._alternative.hasWaterQualityOptions()) {
            object = this._alternative.getWaterQualityOptions();
            object = object.getOutputVariableOptions();
            this._cellVolumeCheck.setSelected(object.shouldOutputCellVolume());
            this._cellFlowCheck.setSelected(object.shouldOutputCellFlow());
            this._cellVelocityCheck.setSelected(object.shouldOutputCellVelocity());
            this._cellMassCheck.setSelected(object.shouldOutputCellMass());
            this._heatBudgetTermsCheck.setSelected(object.shouldOutputHeatBudget());
            this._nsmPathwaysCheck.setSelected(object.shouldOutputNsmPathways());
            this._nsmDerivedCheck.setSelected(object.shouldOutputNsmVaribles());
            this._generalPathwaysCheck.setSelected(object.shouldOutputGeneralPathways());
        }
    }

    public boolean savePanel(NamedType namedType) {
        if (namedType instanceof RssAlt) {
            return this.savePanel((RssAlt)namedType);
        }
        return true;
    }

    @Override
    public void setSystem(RssSystem rssSystem) {
    }

    @Override
    public boolean savePanel(RssAlt cloneable) {
        if (cloneable == null) {
            cloneable = this._alternative;
        }
        if (cloneable != null && cloneable.hasWaterQualityOptions()) {
            cloneable = cloneable.getWaterQualityOptions();
            cloneable = ((AltWaterQualityOptions)cloneable).getOutputVariableOptions();
            cloneable.setOutputCellVolume(this._cellVolumeCheck.isSelected());
            cloneable.setOutputCellFlow(this._cellFlowCheck.isSelected());
            cloneable.setOutputCellVelocity(this._cellVelocityCheck.isSelected());
            cloneable.setOutputCellMass(this._cellMassCheck.isSelected());
            cloneable.setOutputHeatBudget(this._heatBudgetTermsCheck.isSelected());
            cloneable.setOutputNsmPathways(this._nsmPathwaysCheck.isSelected());
            cloneable.setOutputNsmVaribles(this._nsmDerivedCheck.isSelected());
            cloneable.setOutputGeneralPathways(this._generalPathwaysCheck.isSelected());
        }
        return true;
    }

    @Override
    public void clearPanel() {
        this._cellVolumeCheck.setSelected(false);
        this._cellFlowCheck.setSelected(false);
        this._cellVelocityCheck.setSelected(false);
        this._cellMassCheck.setSelected(false);
        this._heatBudgetTermsCheck.setSelected(false);
        this._nsmPathwaysCheck.setSelected(false);
        this._nsmDerivedCheck.setSelected(false);
        this._generalPathwaysCheck.setSelected(false);
    }
}

