/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client;

import hec.clientapp.model.ManagerProxyListContainer;
import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.AlternativePanel;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.wq.client.AltWqComputeOptionsPanel;
import hec.rss.wq.client.AltWqDataSetsPanel;
import hec.rss.wq.client.AltWqOutputVariablesPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import javax.swing.JTabbedPane;
import rma.swing.RmaInsets;

public class AltWqPanel
extends AbstractEditorPanel
implements AlternativePanel {
    private JTabbedPane _tabbedPane;
    private AltWqComputeOptionsPanel _computeTab;
    private AltWqDataSetsPanel _dataSetsTab;
    private AltWqOutputVariablesPanel _outputVariablesTab;
    private AlternativeEditor _editor;
    private RssAlt _alternative;

    public AltWqPanel(AlternativeEditor alternativeEditor) {
        super((LayoutManager)new GridBagLayout());
        this._editor = alternativeEditor;
        this.buildControls();
    }

    protected void buildControls() {
        this._tabbedPane = new JTabbedPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        AltWqPanel altWqPanel = this;
        altWqPanel.add(altWqPanel._tabbedPane, gridBagConstraints);
        this._dataSetsTab = new AltWqDataSetsPanel(this._editor);
        this._tabbedPane.addTab(this._dataSetsTab.getTabname(), (Component)((Object)this._dataSetsTab));
        this._computeTab = new AltWqComputeOptionsPanel(this._editor);
        this._tabbedPane.addTab(this._computeTab.getTabname(), (Component)((Object)this._computeTab));
        this._outputVariablesTab = new AltWqOutputVariablesPanel();
        this._tabbedPane.addTab(this._outputVariablesTab.getTabname(), (Component)((Object)this._outputVariablesTab));
    }

    @Override
    public boolean savePanel(RssAlt rssAlt) {
        if (rssAlt == null) {
        }
        boolean bl = this._computeTab.savePanel(rssAlt);
        bl &= this._dataSetsTab.savePanel(rssAlt);
        return bl &= this._outputVariablesTab.savePanel(rssAlt);
    }

    @Override
    public void setSystem(RssSystem rssSystem) {
        this._computeTab.setSystem(rssSystem);
        this._dataSetsTab.setSystem(rssSystem);
        this._outputVariablesTab.setSystem(rssSystem);
    }

    @Override
    public void clearPanel() {
        this._computeTab.clearPanel();
        this._dataSetsTab.clearPanel();
        this._outputVariablesTab.clearPanel();
    }

    @Override
    public String getTabname() {
        return "Water Quality";
    }

    @Override
    public void fillPanel(NamedType namedType) {
        if (!(namedType instanceof RssAlt)) {
            return;
        }
        this._alternative = (RssAlt)namedType;
        this._computeTab.fillPanel(namedType);
        this._dataSetsTab.fillPanel(namedType);
        this._outputVariablesTab.fillPanel(namedType);
    }

    public boolean savePanel(NamedType namedType) {
        if (!(namedType instanceof RssAlt)) {
            return false;
        }
        return this.savePanel((RssAlt)namedType);
    }

    public void fillPanel(ManagerProxyListContainer managerProxyListContainer) {
        this._dataSetsTab.fillPanel(managerProxyListContainer);
    }
}

