/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.data.TimeWindow;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.PlotLayout;
import hec.io.DataContainer;
import hec.rss.client.RSimSimulationMode;
import hec.rss.wq.client.DataEditorPanel$1;
import hec.rss.wq.client.DataEditorPanel$2;
import hec.rss.wq.client.DataEditorPanel$3;
import hec.rss.wq.client.DataEditorPanel$4;
import hec.rss.wq.client.DataEditorPanel$DataSourceCellRenderer;
import hec.rss.wq.client.DataEditorPanel$TimeSeriesPropertyListener;
import hec.rss.wq.client.TimeSeriesDataSourcePlotUtil;
import hec.rss.wq.client.metstation.MetVariableDataSource;
import hec.rss.wq.dataSources.DataSourceFactory;
import hec.rss.wq.dataSources.constant.ConstantDataSource;
import hec.rss.wq.dataSources.dss.BaseDssPanel;
import hec.rss.wq.dataSources.elevation.ElevationDataSource;
import hec.rss.wq.dataSources.excel.ExcelDataSource;
import hec.rss.wq.dataSources.latlong.LatLongDataSource;
import hec.rss.wq.dataSources.obs.ComputedCloudinessDataSource;
import hec.rss.wq.dataSources.table.TableDataSource;
import hec.rss.wq.dataSources.timeSeries.DssDataSource;
import hec.rss.wq.model.CloudinessUtils;
import hec.rss.wq.ui.DataSource;
import hec.rss.wq.ui.ParameterMap;
import hec.rss.wq.ui.TimeSeriesDataSource;
import hec.wqenginecore.BoundaryCondition;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.ambient.AmbientData;
import hec.wqenginecore.dataSource.constant.ConstantData;
import hec.wqenginecore.dataSource.elevation.ElevationData;
import hec.wqenginecore.dataSource.excel.ExcelData;
import hec.wqenginecore.dataSource.latlong.LatLongData;
import hec.wqenginecore.dataSource.obs.ObservedData;
import hec.wqenginecore.dataSource.table.TableData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.metstation.MetStation;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJPanel;
import rma.swing.list.RmaListModel;

public class DataEditorPanel
extends RmaJPanel {
    private static final JPanel a = new JPanel();
    private ButtonGroup buttonGroup1;
    private RmaJComboBox<TimeSeriesDataSource<?>> jComboBox1;
    private JLabel jLabel1;
    private JRadioButton jRadioButton1;
    private JPanel mDataSourceEditorPanel;
    private JRadioButton mPlotAllDataSourcesRadioButton;
    private JPanel mPlotAreaPanel;
    private DataEditorPanel$TimeSeriesPropertyListener tsPropertyListener = new DataEditorPanel$TimeSeriesPropertyListener(this);
    G2dPanel mPlotPanel = new G2dPanel();
    ComboBoxModel<TimeSeriesDataSource<?>> mDataSourceListModel;
    TimeSeriesDataSource<?> _selectedDataSource = null;
    String _parameterLabel = "";
    private DataSource _parentDataSource;
    Map<DataSource, JComponent> componentMap = new HashMap<DataSource, JComponent>();

    public DataEditorPanel(List<TimeSeriesDataSource<?>> list) {
        Objects.requireNonNull(list, "Null Data Source List in MetDataEditorPanel. Please use an empty list if there are no data sources.");
        this.initComponents();
        this.mDataSourceListModel = new RmaListModel(false, list);
        this.jComboBox1.setModel(this.mDataSourceListModel);
        if (!list.isEmpty()) {
            this.jComboBox1.setSelectedIndex(0);
        }
        this.jComboBox1.setRenderer((ListCellRenderer)new DataEditorPanel$DataSourceCellRenderer());
        this.mDataSourceEditorPanel.add((Component)a, "NoEditorPanel");
        this.jComboBox1.setModifiable(true);
        this.mPlotPanel = new G2dPanel();
        this.mPlotAreaPanel.setLayout(new BorderLayout());
        this.mPlotAreaPanel.add((Component)this.mPlotPanel, "Center");
        this.jRadioButton1.setSelected(true);
    }

    public DataEditorPanel(List<TimeSeriesDataSource<?>> list, DataSource dataSource) {
        this(list);
        this._parentDataSource = dataSource;
    }

    public void validateData() throws IOException {
        Object object = this.componentMap.keySet();
        object = object.iterator();
        while (object.hasNext()) {
            DataSource dataSource = (DataSource)object.next();
            dataSource.validateData();
        }
    }

    public void savePanel() throws IOException {
        Object object = this.componentMap.keySet();
        object = object.iterator();
        while (object.hasNext()) {
            DataSource dataSource = (DataSource)object.next();
            dataSource.save();
        }
    }

    public String getSelectedDataSourceName() {
        TimeSeriesDataSource timeSeriesDataSource = (TimeSeriesDataSource)this.jComboBox1.getSelectedItem();
        if (timeSeriesDataSource != null) {
            return timeSeriesDataSource.getName();
        }
        return "";
    }

    public void setSelectedDataSourceName(String string) {
        for (int i = 0; i < this.mDataSourceListModel.getSize(); ++i) {
            TimeSeriesDataSource timeSeriesDataSource = (TimeSeriesDataSource)this.mDataSourceListModel.getElementAt(i);
            if (timeSeriesDataSource == null || !string.equalsIgnoreCase(timeSeriesDataSource.getName())) continue;
            this.jComboBox1.setSelectedItem((Object)timeSeriesDataSource);
            return;
        }
    }

    public void setParameterLabel(String string) {
        this._parameterLabel = string != null ? string : "";
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jComboBox1 = new RmaJComboBox();
        this.jRadioButton1 = new JRadioButton();
        this.mPlotAllDataSourcesRadioButton = new JRadioButton();
        this.mDataSourceEditorPanel = new JPanel();
        this.mPlotAreaPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBox1.addItemListener((ItemListener)new DataEditorPanel$1(this));
        this.jComboBox1.addActionListener((ActionListener)new DataEditorPanel$2(this));
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setText("Plot only the selected Data Source");
        this.jRadioButton1.addActionListener(new DataEditorPanel$3(this));
        this.buttonGroup1.add(this.mPlotAllDataSourcesRadioButton);
        this.mPlotAllDataSourcesRadioButton.setText("Plot All defined Data Sources");
        this.mPlotAllDataSourcesRadioButton.addActionListener(new DataEditorPanel$4(this));
        this.mDataSourceEditorPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.mDataSourceEditorPanel.setLayout(new CardLayout());
        this.mPlotAreaPanel.setMinimumSize(new Dimension(600, 375));
        this.mPlotAreaPanel.setPreferredSize(new Dimension(600, 375));
        GroupLayout groupLayout = new GroupLayout(this.mPlotAreaPanel);
        this.mPlotAreaPanel.setLayout(groupLayout);
        GroupLayout groupLayout2 = groupLayout;
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout groupLayout3 = groupLayout;
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jLabel1.setText("Data Source:");
        groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        GroupLayout groupLayout4 = groupLayout;
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mPlotAreaPanel, -1, 675, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jComboBox1, -1, 219, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mPlotAllDataSourcesRadioButton)).addComponent(this.mDataSourceEditorPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout groupLayout5 = groupLayout;
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.jComboBox1, -2, -1, -2).addComponent(this.jRadioButton1).addComponent(this.mPlotAllDataSourcesRadioButton).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mDataSourceEditorPanel, -2, 170, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mPlotAreaPanel, -2, 330, -2).addContainerGap()));
    }

    private void mPlotAllDataSourcesRadioButtonActionPerformed(ActionEvent actionEvent) {
        DataEditorPanel dataEditorPanel = this;
        dataEditorPanel.plotSelectedDataSource(dataEditorPanel._selectedDataSource);
    }

    private void jComboBox1ActionPerformed(ActionEvent object) {
        List<Component> list;
        object = (TimeSeriesDataSource)this.mDataSourceListModel.getSelectedItem();
        String string = "NoEditorPanel";
        if (object != null) {
            JComponent jComponent;
            string = object.getName();
            list = Arrays.asList(this.mDataSourceEditorPanel.getComponents());
            if (!list.contains(jComponent = object.getComponent())) {
                this.mDataSourceEditorPanel.add((Component)jComponent, string);
                this.componentMap.put((DataSource)object, jComponent);
            }
            if (jComponent.getName() != null && !jComponent.getName().isEmpty()) {
                this.mDataSourceEditorPanel.setBorder(new TitledBorder(jComponent.getName()));
            } else {
                this.mDataSourceEditorPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
            }
        }
        this._selectedDataSource = object;
        list = (CardLayout)this.mDataSourceEditorPanel.getLayout();
        ((CardLayout)((Object)list)).show(this.mDataSourceEditorPanel, string);
        this.plotSelectedDataSource((TimeSeriesDataSource)object);
    }

    private void jComboBox1ItemStateChanged(ItemEvent serializable) {
        TimeSeriesDataSource timeSeriesDataSource = (TimeSeriesDataSource)serializable.getItem();
        if (serializable.getStateChange() == 2) {
            timeSeriesDataSource.removePropertyChangeListener(this.tsPropertyListener);
            return;
        }
        timeSeriesDataSource.addPropertyChangeListener(this.tsPropertyListener);
        serializable = timeSeriesDataSource.getComponent();
        if (serializable instanceof BaseDssPanel) {
            ((BaseDssPanel)((Object)serializable)).setDssChangeListener(() -> this.plotSelectedDataSource(timeSeriesDataSource));
        }
    }

    private void jRadioButton1ActionPerformed(ActionEvent actionEvent) {
        DataEditorPanel dataEditorPanel = this;
        dataEditorPanel.plotSelectedDataSource(dataEditorPanel._selectedDataSource);
    }

    private void plotSelectedDataSource(TimeSeriesDataSource timeSeriesDataSource) {
        TimeWindow timeWindow;
        ClientMode clientMode;
        ParameterMap parameterMap;
        if (timeSeriesDataSource == null) {
            return;
        }
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        this.mPlotPanel.setVisible(false);
        this.mPlotPanel.clearPanel();
        PlotLayout plotLayout = new PlotLayout();
        List<TimeSeriesDataSource<?>> list = this.getPlotSources(timeSeriesDataSource);
        LinkedHashMap<String, List<DataContainer>> linkedHashMap = new LinkedHashMap<String, List<DataContainer>>();
        Object object = timeSeriesDataSource.getTimeWindow();
        if (this.mPlotAllDataSourcesRadioButton.isSelected()) {
            int n = this.mDataSourceListModel.getSize();
            for (int i = 0; i < n; ++i) {
                TimeSeriesDataSource<?> timeSeriesDataSource2 = (TimeSeriesDataSource<?>)this.mDataSourceListModel.getElementAt(i);
                if (timeSeriesDataSource2 == timeSeriesDataSource) continue;
                list.add(timeSeriesDataSource2);
                parameterMap = timeSeriesDataSource2.getTimeWindow();
                if (parameterMap == null) continue;
                if (object == null) {
                    object = parameterMap;
                }
                if (parameterMap.getStartDate().before(object.getStartDate())) {
                    object.setStartDate(parameterMap.getStartDate());
                }
                if (!parameterMap.getEndDate().after(object.getEndDate())) continue;
                object.setEndDate(parameterMap.getEndDate());
            }
        }
        if ((clientMode = ClientApp.frame().getCurrentMode()) instanceof RSimSimulationMode && (timeWindow = ((RSimSimulationMode)clientMode).getSimTimeWindow()) != null) {
            object = timeWindow;
        }
        for (TimeSeriesDataSource<?> timeSeriesDataSource2 : list) {
            if (object != null) {
                parameterMap = new ParameterMap();
                parameterMap.a(TimeSeriesDataSource.TIME_WINDOW_PARAMETER, object);
                if (timeSeriesDataSource2 instanceof ComputedCloudinessDataSource && this._parentDataSource instanceof MetVariableDataSource) {
                    timeSeriesDataSource = ((MetVariableDataSource)this._parentDataSource).b();
                    timeSeriesDataSource = CloudinessUtils.a((MetStation)timeSeriesDataSource);
                    parameterMap.a(ComputedCloudinessDataSource.LAT_LONG_PARAMETER, timeSeriesDataSource);
                }
                if (timeSeriesDataSource2 instanceof DssDataSource && ((DssDataSource)timeSeriesDataSource2).d() != null && ((DssDataSource)timeSeriesDataSource2).d().isProfileData()) {
                    linkedHashSet.add(((DssDataSource)timeSeriesDataSource2).getPairedData(parameterMap));
                    continue;
                }
                linkedHashSet.addAll(timeSeriesDataSource2.getTimeSeries(parameterMap));
                continue;
            }
            if (timeSeriesDataSource2 instanceof DssDataSource && ((DssDataSource)timeSeriesDataSource2).d() != null && ((DssDataSource)timeSeriesDataSource2).d().isProfileData()) {
                linkedHashSet.add(((DssDataSource)timeSeriesDataSource2).e());
                continue;
            }
            linkedHashSet.addAll(timeSeriesDataSource2.getTimeSeries());
        }
        linkedHashMap.put(this._parameterLabel, new ArrayList(linkedHashSet));
        TimeSeriesDataSourcePlotUtil.a(this.mPlotPanel, plotLayout, linkedHashMap);
    }

    protected List<TimeSeriesDataSource<?>> getPlotSources(TimeSeriesDataSource<?> timeSeriesDataSource) {
        return Collections.singletonList(timeSeriesDataSource);
    }

    public TimeSeriesDataSource getSelectedDataSource() {
        return this._selectedDataSource;
    }

    public void fillPanel(BoundaryCondition boundaryCondition, Constituent constituent) {
        ArrayList<Data> arrayList = new ArrayList<Data>();
        List list = boundaryCondition.getDataSources();
        if (list != null) {
            list = list.stream().filter(data -> data instanceof DssData || data instanceof ConstantData || data instanceof AmbientData).collect(Collectors.toList());
            for (Object object : list) {
                if (object instanceof TableData) {
                    ((TableData)object).setVariableName(constituent.getDisplayName());
                }
                String[] stringArray = new String[]{constituent.getUnit()};
                object.setAvailableUnits(stringArray);
                object = (TimeSeriesDataSource)DataSourceFactory.a(object);
                arrayList.add((Data)object);
            }
        }
        this.mDataSourceListModel = new RmaListModel(false, arrayList);
        this.jComboBox1.setModel(this.mDataSourceListModel);
        if (!arrayList.isEmpty()) {
            this.jComboBox1.setSelectedIndex(0);
        }
        this.setParameterLabel(constituent.getDisplayName());
        list = boundaryCondition.getSelectedDataSource();
        if (list != null) {
            this.setSelectedDataSourceName(list.getName());
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        Component[] componentArray = this.mDataSourceEditorPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!componentArray[i].isVisible()) continue;
            componentArray[i].firePropertyChange("closing", 0L, 1L);
        }
    }

    public static void a(String[] object) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getLogger(DataEditorPanel.class.getName()).log(Level.SEVERE, null, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            Logger.getLogger(DataEditorPanel.class.getName()).log(Level.SEVERE, null, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(DataEditorPanel.class.getName()).log(Level.SEVERE, null, illegalAccessException);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            Logger.getLogger(DataEditorPanel.class.getName()).log(Level.SEVERE, null, unsupportedLookAndFeelException);
        }
        object = new DataEditorPanel(Arrays.asList(new ConstantDataSource(new ConstantData()), new ExcelDataSource(new ExcelData()), new DssDataSource(new DssData()), new TableDataSource(new TableData()), new ElevationDataSource(new ElevationData()), new ComputedCloudinessDataSource(new ObservedData()), new LatLongDataSource(new LatLongData())));
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add((Component)object, "Center");
        jFrame.setLocation(500, 500);
        jFrame.setSize(750, 400);
        jFrame.setVisible(true);
    }
}

