/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client;

import hec.appInterface.AppDaddy;
import hec.clientapp.client.ClientApp;
import hec.gui.NameDialog;
import hec.map.ManagerGlyphSelection;
import hec.map.appInterface.MapApplicationFrame;
import hec.rss.wq.client.WaterQualityDPData;
import hec.rss.wq.client.WaterQualityDrawingPropertiesEditor$1;
import hec.rss.wq.client.WaterQualityDrawingPropertiesTabPanel;
import hec.rss.wq.util.WqI18n;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import rma.swing.ButtonCmdPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTabbedPane;
import rma.swing.RmaJTextField;
import rma.swing.text.IntegerDocument;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class WaterQualityDrawingPropertiesEditor
extends RmaJDialog
implements Observer {
    private final ManagerGlyphSelection _initialSelection;
    private ButtonCmdPanel _cmdPanel;
    private RmaJTextField _currentScaleTxt;
    private RmaJTabbedPane _scaleTabbedPanel;
    private JMenuItem _deleteMenuItem;
    private JMenuItem _newMenuItem;
    private JMenuItem _setDefaultMenuItem;

    public WaterQualityDrawingPropertiesEditor(Window window, Dialog.ModalityType modalityType, ManagerGlyphSelection managerGlyphSelection) {
        super(window, WqI18n.a("WqDrawingPropertiesEditor.Title").getText(), modalityType);
        this._initialSelection = managerGlyphSelection;
        this.setSize(480, 350);
        this.setMinimumSize(new Dimension(480, 350));
        this.buildControls();
        this.updateCurrentScale();
        this.addListeners();
    }

    private void addListeners() {
        this._scaleTabbedPanel.addChangeListener(changeEvent -> {
            int n = this._scaleTabbedPanel.getSelectedIndex();
            this._deleteMenuItem.setEnabled(n != 0);
        });
        this._deleteMenuItem.addActionListener(actionEvent -> this.deleteTabAction());
        this._newMenuItem.addActionListener(actionEvent -> this.addTabAction());
        this._setDefaultMenuItem.addActionListener(actionEvent -> this.setToDefaultsAction());
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setLocation();
        this._currentScaleTxt = new RmaJTextField(WqI18n.a("WqDrawingPropertiesEditor.Label.Scale").getText());
        this._currentScaleTxt.setEditable(false);
        this._currentScaleTxt.setBorder(null);
        this._currentScaleTxt.setMinimumSize(this._currentScaleTxt.getPreferredSize());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._currentScaleTxt, gridBagConstraints);
        this._scaleTabbedPanel = new RmaJTabbedPane();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._scaleTabbedPanel, gridBagConstraints);
        this.buildPanels();
        this.buildMenus();
        this._cmdPanel = new ButtonCmdPanel(14);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this._cmdPanel, gridBagConstraints);
        this.addWindowListener(new WaterQualityDrawingPropertiesEditor$1(this));
        this._cmdPanel.addCmdPanelListener(actionEvent -> {
            switch (actionEvent.getID()) {
                case 8: {
                    this.saveForm();
                    this.setVisible(false);
                    return;
                }
                case 2: {
                    this.saveForm();
                    return;
                }
                case 4: {
                    this.windowClosing();
                    this.setVisible(false);
                }
            }
        });
    }

    protected void buildMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(WqI18n.a("WqDrawingPropertiesEditor.Menu.Scale.Name").getText());
        jMenu.setMnemonic('S');
        jMenuBar.add(jMenu);
        this._newMenuItem = new JMenuItem(WqI18n.a("WqDrawingPropertiesEditor.Menu.Scale.Item.New").getText(), 78);
        this._newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        jMenu.add(this._newMenuItem);
        this._deleteMenuItem = new JMenuItem(WqI18n.a("WqDrawingPropertiesEditor.Menu.Scale.Item.Delete").getText(), 68);
        this._deleteMenuItem.setEnabled(false);
        jMenu.add(this._deleteMenuItem);
        jMenu.addSeparator();
        this._setDefaultMenuItem = new JMenuItem(WqI18n.a("WqDrawingPropertiesEditor.Menu.Scale.Item.SetToDefaults").getText(), 83);
        jMenu.add(this._setDefaultMenuItem);
        this.setJMenuBar(jMenuBar);
    }

    protected void buildPanels() {
        Object object = WaterQualityDPData.a();
        this._scaleTabbedPanel.removeAll();
        int[] nArray = object;
        int n = ((int[])object).length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (n2 == 0) {
                object = WqI18n.a("WqDrawingPropertiesEditor.Tab.Default").getText();
                this._scaleTabbedPanel.insertTab((String)object, null, (Component)((Object)new WaterQualityDrawingPropertiesTabPanel(n2, this._initialSelection)), null, 0);
                continue;
            }
            object = String.valueOf(n2);
            this._scaleTabbedPanel.addTab((String)object, (Component)((Object)new WaterQualityDrawingPropertiesTabPanel(n2, this._initialSelection)));
        }
    }

    public void saveForm() {
        Object object;
        Component component;
        WaterQualityDPData.a(this.getScales());
        for (int i = 0; i < this._scaleTabbedPanel.getTabCount(); ++i) {
            component = this._scaleTabbedPanel.getComponentAt(i);
            if (!(component instanceof WaterQualityDrawingPropertiesTabPanel)) continue;
            object = (WaterQualityDrawingPropertiesTabPanel)((Object)component);
            ((WaterQualityDrawingPropertiesTabPanel)((Object)object)).saveForm();
        }
        MapApplicationFrame mapApplicationFrame = (MapApplicationFrame)AppDaddy.getFrame();
        component = mapApplicationFrame.getMapPanel();
        object = this.getParent();
        if (object != null) {
            this.getParent().repaint();
        }
        if (component != null) {
            component.paintMap();
        }
        this.setModified(false);
    }

    private int[] getScales() {
        int[] nArray = new int[this._scaleTabbedPanel.getTabCount()];
        for (int i = 0; i < this._scaleTabbedPanel.getTabCount(); ++i) {
            Object object = this._scaleTabbedPanel.getComponentAt(i);
            if (!(object instanceof WaterQualityDrawingPropertiesTabPanel)) continue;
            object = (WaterQualityDrawingPropertiesTabPanel)((Object)object);
            nArray[i] = ((WaterQualityDrawingPropertiesTabPanel)((Object)object)).getScale();
        }
        return nArray;
    }

    public void windowClosing() {
        int n;
        if (this.isModified() && (n = JOptionPane.showConfirmDialog((Component)((Object)this), WqI18n.a("WqDrawingPropertiesEditor.Save.Confirm.Message").getText(), WqI18n.a("WqDrawingPropertiesEditor.Save.Confirm.Title").getText(), 0)) == 0) {
            this.saveForm();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if ("zoomIn".equals(object) || "zoomByFactor".equals(object) || "showAll".equals(object)) {
            this.updateCurrentScale();
        }
    }

    private void updateCurrentScale() {
        double d = ClientApp.frame().getMapPanel().viewport().computeMapScale();
        this._currentScaleTxt.setText(WqI18n.a("WqDrawingPropertiesEditor.Label.Scale").getText() + (int)d);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            ClientApp.frame().getMapPanel().addObserver((Observer)this);
            return;
        }
        ClientApp.frame().getMapPanel().deleteObserver((Observer)this);
    }

    public void setToDefaultsAction() {
        WaterQualityDrawingPropertiesTabPanel waterQualityDrawingPropertiesTabPanel = (WaterQualityDrawingPropertiesTabPanel)((Object)this._scaleTabbedPanel.getSelectedComponent());
        waterQualityDrawingPropertiesTabPanel.setToDefaults();
    }

    public void addTabAction() {
        NameDialog nameDialog = new NameDialog((Dialog)((Object)this), WqI18n.a("WqDrawingPropertiesEditor.Dialog.NewScale.Title").getText(), true);
        nameDialog.setNameLabel(WqI18n.a("WqDrawingPropertiesEditor.Dialog.NewScale.Label.Scale").getText());
        nameDialog.setExistingNames(this.getTabNames());
        Object object = new IntegerDocument();
        object.setMin(1);
        nameDialog.setNameFieldDocument((Document)object);
        nameDialog.setDescriptionVisible(false);
        nameDialog.setVisible(true);
        if (nameDialog.isCanceled()) {
            return;
        }
        int n = RMAIO.parseInt((String)nameDialog.getName());
        if (RMAConst.isUndefinedValue((int)n)) {
            return;
        }
        object = (WaterQualityDrawingPropertiesTabPanel)((Object)this._scaleTabbedPanel.getSelectedComponent());
        WaterQualityDrawingPropertiesTabPanel waterQualityDrawingPropertiesTabPanel = new WaterQualityDrawingPropertiesTabPanel(n, this._initialSelection);
        waterQualityDrawingPropertiesTabPanel.fillFormFrom(n, (WaterQualityDrawingPropertiesTabPanel)((Object)object));
        for (int i = 1; i < this._scaleTabbedPanel.getTabCount(); ++i) {
            object = (WaterQualityDrawingPropertiesTabPanel)((Object)this._scaleTabbedPanel.getComponentAt(i));
            if (n <= object.getScale()) continue;
            this._scaleTabbedPanel.insertTab(String.valueOf(n), null, (Component)((Object)waterQualityDrawingPropertiesTabPanel), null, i);
            return;
        }
        this._scaleTabbedPanel.addTab(String.valueOf(n), (Component)((Object)waterQualityDrawingPropertiesTabPanel));
    }

    private List<String> getTabNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this._scaleTabbedPanel.getTabCount(); ++i) {
            arrayList.add(this._scaleTabbedPanel.getTitleAt(i));
        }
        return arrayList;
    }

    public void deleteTabAction() {
        WaterQualityDrawingPropertiesTabPanel waterQualityDrawingPropertiesTabPanel = (WaterQualityDrawingPropertiesTabPanel)((Object)this._scaleTabbedPanel.getSelectedComponent());
        int n = waterQualityDrawingPropertiesTabPanel.getScale();
        int n2 = JOptionPane.showConfirmDialog((Component)((Object)this), "<html>" + WqI18n.a("WqDrawingPropertiesEditor.Dialog.Delete.Confirm.Message").getText() + " <b>1:" + n + "</b></html>", WqI18n.a("WqDrawingPropertiesEditor.Dialog.Delete.Confirm.Title").getText(), 0);
        if (n2 != 0) {
            return;
        }
        WaterQualityDPData.a(n);
        ClientApp.frame().getMapPanel().paintMap();
        this.buildPanels();
    }
}

