/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client;

import hec.map.ManagerGlyphSelection;
import hec.rss.wq.client.geometry.ExtentDrawPropData;
import hec.rss.wq.client.geometry.ExtentDrawPropDataPanel;
import hec.rss.wq.client.geometry.GeometryMapGlyphSelection;
import hec.rss.wq.client.geometry.ReachCellDrawDataPanel;
import hec.rss.wq.client.geometry.ReachCellsDrawPropData;
import hec.rss.wq.client.geometry.ReachCellsGlyphSelection;
import hec.rss.wq.client.geometry.RegionsDrawDataPanel;
import hec.rss.wq.client.geometry.RegionsDrawPropData;
import hec.rss.wq.client.massinjection.MassInjectionDrawPropData;
import hec.rss.wq.client.massinjection.MassInjectionDrawPropDataPanel;
import hec.rss.wq.client.massinjection.MassInjectionMapGlyphSelection;
import hec.rss.wq.client.metstation.MetStationMapGlyphSelection;
import hec.rss.wq.client.metstation.StationSetDrawPropData;
import hec.rss.wq.client.metstation.StationSetPropPanel;
import hec.rss.wq.client.observeddataset.ObsStationMapGlyphSelection;
import hec.rss.wq.util.WqI18n;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Map;
import rma.swing.RmaInsets;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTabbedPane;

final class WaterQualityDrawingPropertiesTabPanel
extends RmaJPanel {
    private final int _scale;
    private RmaJTabbedPane _tabbedPane;
    private StationSetPropPanel _stationPanel;
    private RegionsDrawDataPanel _regionsPanel;
    private ExtentDrawPropDataPanel _extentsPanel;
    private ReachCellDrawDataPanel _reachCellPanel;
    private MassInjectionDrawPropDataPanel _miPanel;
    private final Map<Class<? extends ManagerGlyphSelection>, Component> _panelMapping = new HashMap<Class<? extends ManagerGlyphSelection>, Component>();

    WaterQualityDrawingPropertiesTabPanel(int n, ManagerGlyphSelection managerGlyphSelection) {
        this._scale = n;
        this.setLayout(new GridBagLayout());
        this.buildControls();
        this.initializePanelMapping();
        this.setActivePanelFromSelection(managerGlyphSelection);
    }

    private void initializePanelMapping() {
        this._panelMapping.put(GeometryMapGlyphSelection.class, this._regionsPanel);
        this._panelMapping.put(ReachCellsGlyphSelection.class, (Component)((Object)this._reachCellPanel));
        this._panelMapping.put(MassInjectionMapGlyphSelection.class, this._miPanel);
        this._panelMapping.put(MetStationMapGlyphSelection.class, this._stationPanel);
        this._panelMapping.put(ObsStationMapGlyphSelection.class, this._stationPanel);
    }

    private void setActivePanelFromSelection(ManagerGlyphSelection managerGlyphSelection) {
        if (managerGlyphSelection == null || !this._panelMapping.containsKey(managerGlyphSelection.getClass())) {
            this._tabbedPane.setSelectedIndex(0);
            return;
        }
        this._tabbedPane.setSelectedComponent(this._panelMapping.get(managerGlyphSelection.getClass()));
    }

    private void buildControls() {
        this._tabbedPane = new RmaJTabbedPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gridBagConstraints.weightx = 1.0;
        WaterQualityDrawingPropertiesTabPanel waterQualityDrawingPropertiesTabPanel = this;
        waterQualityDrawingPropertiesTabPanel.add((Component)waterQualityDrawingPropertiesTabPanel._tabbedPane, gridBagConstraints);
        this._stationPanel = new StationSetPropPanel(this.getStationSetDrawPropData(), this._scale);
        this._extentsPanel = new ExtentDrawPropDataPanel(this.getExtentsDrawPropData(), this._scale);
        this._miPanel = new MassInjectionDrawPropDataPanel(this.getMassInjectionDrawPropData(), this._scale);
        this._regionsPanel = new RegionsDrawDataPanel(this.getRegionsDrawPropData(), this._scale);
        this._reachCellPanel = new ReachCellDrawDataPanel(this.getReachCellDrawPropData(), this._scale);
        this._tabbedPane.add((Component)this._stationPanel, (Object)WqI18n.a("WqDrawingPropertiesEditor.Tab.Station.Name").getText());
        this._tabbedPane.add((Component)this._regionsPanel, (Object)WqI18n.a("WqDrawingPropertiesEditor.Tab.Region.Name").getText());
        this._tabbedPane.add((Component)this._extentsPanel, (Object)WqI18n.a("WqDrawingPropertiesEditor.Tab.Extent.Name").getText());
        this._tabbedPane.add((Component)((Object)this._reachCellPanel), (Object)WqI18n.a("WqDrawingPropertiesEditor.Tab.ReachCell.Name").getText());
        this._tabbedPane.add((Component)this._miPanel, (Object)WqI18n.a("WqDrawingPropertiesEditor.Tab.MassInjection.Name").getText());
    }

    private ReachCellsDrawPropData getReachCellDrawPropData() {
        return ReachCellsDrawPropData.b(this._scale);
    }

    private StationSetDrawPropData getStationSetDrawPropData() {
        return StationSetDrawPropData.b(this._scale);
    }

    private ExtentDrawPropData getExtentsDrawPropData() {
        return ExtentDrawPropData.b(this._scale);
    }

    private MassInjectionDrawPropData getMassInjectionDrawPropData() {
        return MassInjectionDrawPropData.b(this._scale);
    }

    private RegionsDrawPropData getRegionsDrawPropData() {
        return RegionsDrawPropData.b(this._scale);
    }

    final void saveForm() {
        this._stationPanel.savePanel();
        this._extentsPanel.savePanel();
        this._miPanel.savePanel();
        this._regionsPanel.savePanel();
        this._reachCellPanel.savePanel();
    }

    final int getScale() {
        return this._scale;
    }

    final void setToDefaults() {
        this._stationPanel.setToDefaults();
        this._extentsPanel.setToDefaults();
        this._miPanel.setToDefaults();
        this._regionsPanel.setToDefaults();
        this._reachCellPanel.setToDefaults();
    }

    final void fillFormFrom(int n, WaterQualityDrawingPropertiesTabPanel waterQualityDrawingPropertiesTabPanel) {
        this._stationPanel.fillPanel(waterQualityDrawingPropertiesTabPanel._stationPanel.copyData(n));
        this._regionsPanel.fillPanel(waterQualityDrawingPropertiesTabPanel._regionsPanel.copyData(n));
        this._extentsPanel.fillPanel(waterQualityDrawingPropertiesTabPanel._extentsPanel.copyData(n));
        this._reachCellPanel.fillPanel(waterQualityDrawingPropertiesTabPanel._reachCellPanel.copyData(n));
        this._miPanel.fillPanel(waterQualityDrawingPropertiesTabPanel._miPanel.copyData(n));
    }
}

