/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.TSDataSet;
import hec.rss.model.RssAlt;
import hec.rss.wq.client.WaterQualityEditors$1;
import hec.rss.wq.client.WaterQualityEditors$2;
import hec.rss.wq.client.WaterQualityEditors$3;
import hec.rss.wq.client.WaterQualityEditors$4;
import hec.rss.wq.client.WaterQualityEditors$5;
import hec.rss.wq.client.WaterQualityEditors$6;
import hec.rss.wq.client.WaterQualityEditors$7;
import hec.rss.wq.client.WaterQualityEditors$8;
import hec.rss.wq.client.WaterQualityMode;
import hec.rss.wq.client.WqTsTable;
import hec.rss.wq.client.boundarycondition.BoundaryConditionEditorDialog;
import hec.rss.wq.client.constituentSet.ConstituentSetEditor;
import hec.rss.wq.client.dispersionCoeff.client.DispersionCoefEditor;
import hec.rss.wq.client.geometry.GeometryEditor;
import hec.rss.wq.client.initialcondition.InitialConditionsEditor;
import hec.rss.wq.client.massinjection.MassInjectionEditor;
import hec.rss.wq.client.metstation.MetStationSetDialog;
import hec.rss.wq.client.observeddataset.ObservedStationSetDialog;
import hec.rss.wq.client.wqParameters.ParameterSetEditor;
import hec.rss.wq.model.BoundaryConditionSetManager;
import hec.rss.wq.model.ConstituentSetManager;
import hec.rss.wq.model.InitialConditionSetManager;
import hec.rss.wq.model.MetData;
import hec.rss.wq.model.ObsDatasetManager;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.model.dispersionCoeff.DispersionSetManager;
import hec.rss.wq.model.massinjection.MassInjectionSetManager;
import hec.rss.wq.model.wqParameters.ParameterSetManager;
import hec.rss.wq.util.WqI18n;
import hec.wqengineimpl.massInjection.WQMassInjectionSite;
import hec.wqengineimpl.observed.WQObsStation;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;

public class WaterQualityEditors {
    public static final String MODELNAME = "rss";
    private ManagerProxyListContainer _wksp;
    private GeometryEditor _geoEditor;
    private BoundaryConditionEditorDialog _boundaryConditionsEditor;
    private DispersionCoefEditor _dispersionSetEditor;
    private InitialConditionsEditor _initCondEditor;
    private ParameterSetEditor _parameterSetEditor;
    private MetStationSetDialog _metStationSetDialog;
    private ObservedStationSetDialog _observedDataSetDialog;
    private ConstituentSetEditor _constituentSetEditor;
    private RssAlt _rssAlt;
    private MassInjectionEditor _massInjectEditor;

    public void setWorkspace(ManagerProxyListContainer managerProxyListContainer) {
        this._wksp = managerProxyListContainer;
        this.resetEditors();
    }

    public GeometryEditor displayGeometryEditor(WqGeometry wqGeometry) {
        if (this._geoEditor == null) {
            this._geoEditor = new GeometryEditor((Frame)ClientApp.frame());
        }
        this._geoEditor.fillForm(this._wksp);
        if (wqGeometry != null) {
            this._geoEditor.setSelectedGeometry(wqGeometry);
        }
        this._geoEditor.setVisible(true);
        return this._geoEditor;
    }

    public BoundaryConditionEditorDialog displayBoundaryConditionEditor() {
        return this.displayBoundaryConditionEditor(null);
    }

    public BoundaryConditionEditorDialog displayBoundaryConditionEditor(BoundaryConditionSetManager boundaryConditionSetManager) {
        if (this._boundaryConditionsEditor == null) {
            this._boundaryConditionsEditor = new BoundaryConditionEditorDialog((Window)ClientApp.frame(), Dialog.ModalityType.MODELESS);
            this._boundaryConditionsEditor.setTitle(WqI18n.a("BC.BoundaryConditionsEditor.Title").getText());
            this._boundaryConditionsEditor.addPropertyChangeListener("ReturnStatus", propertyChangeEvent -> {
                if ((Integer)propertyChangeEvent.getNewValue() != 0) {
                    this._boundaryConditionsEditor.saveForm();
                }
            });
        }
        this._boundaryConditionsEditor.fillForm(this._wksp);
        if (boundaryConditionSetManager != null) {
            this._boundaryConditionsEditor.setSelectedBoundaryConditionSet(boundaryConditionSetManager);
        }
        this._boundaryConditionsEditor.pack();
        this._boundaryConditionsEditor.setLocationRelativeTo((Component)ClientApp.frame());
        this._boundaryConditionsEditor.setVisible(true);
        return this._boundaryConditionsEditor;
    }

    public DispersionCoefEditor displayDispersionCoeffEditor() {
        return this.displayDispersionCoeffEditor(null);
    }

    public DispersionCoefEditor displayDispersionCoeffEditor(DispersionSetManager dispersionSetManager) {
        if (this._dispersionSetEditor == null) {
            try {
                ClientApp.frame().setWaitCursor();
                this._dispersionSetEditor = new WaterQualityEditors$1(this, (Frame)ClientApp.frame());
                this._dispersionSetEditor.fillForm(this._wksp);
                if (dispersionSetManager != null) {
                    this._dispersionSetEditor.setSelectedDispersionSet(dispersionSetManager);
                }
                this._dispersionSetEditor.setVisible(true);
            }
            finally {
                ClientApp.frame().setDefaultCursor();
            }
        }
        return this._dispersionSetEditor;
    }

    public InitialConditionsEditor displayInitialConditionsEditor() {
        return this.displayInitialConditionsEditor(null);
    }

    public InitialConditionsEditor displayInitialConditionsEditor(InitialConditionSetManager initialConditionSetManager) {
        if (this._initCondEditor == null) {
            try {
                ClientApp.frame().setWaitCursor();
                this._initCondEditor = new InitialConditionsEditor((Frame)ClientApp.frame());
                this._initCondEditor.fillForm(this._wksp);
                if (initialConditionSetManager != null) {
                    this._initCondEditor.setSelectedInitialConditionsSetMgr(initialConditionSetManager);
                }
                this._initCondEditor.pack();
                this._initCondEditor.setLocationRelativeTo((Component)ClientApp.frame());
            }
            finally {
                ClientApp.frame().setDefaultCursor();
            }
        }
        this._initCondEditor.setVisible(true);
        return this._initCondEditor;
    }

    public ParameterSetEditor displayWqParameterEditor() {
        return this.displayWqParameterEditor(null);
    }

    public ParameterSetEditor displayWqParameterEditor(ParameterSetManager parameterSetManager) {
        if (this._parameterSetEditor == null) {
            try {
                ClientApp.frame().setWaitCursor();
                this._parameterSetEditor = new WaterQualityEditors$2(this, (Frame)ClientApp.frame());
                this._parameterSetEditor.fillForm(this._wksp);
                if (parameterSetManager != null) {
                    this._parameterSetEditor.setSelectedParameterSetManager(parameterSetManager);
                }
                this._parameterSetEditor.setVisible(true);
            }
            finally {
                ClientApp.frame().setDefaultCursor();
            }
        }
        return this._parameterSetEditor;
    }

    public ObservedStationSetDialog displayObservedDataSetEditor() {
        return this.displayObservedDataSetEditor(null);
    }

    public ObservedStationSetDialog displayObservedDataSetEditor(ObsDatasetManager obsDatasetManager) {
        return this.displayObservedDataSetEditor(obsDatasetManager, null);
    }

    public ObservedStationSetDialog displayObservedDataSetEditor(ObsDatasetManager obsDatasetManager, WQObsStation wQObsStation) {
        Object object;
        Object object2 = this._wksp.getManagerProxyList(MODELNAME, ObsDatasetManager.class.getName());
        ArrayList<ObsDatasetManager> arrayList = new ArrayList<ObsDatasetManager>();
        object2 = ((Vector)object2).iterator();
        while (object2.hasNext()) {
            object = (ManagerProxy)object2.next();
            if (object == null) continue;
            ObsDatasetManager obsDatasetManager2 = (ObsDatasetManager)object.getManager();
            if (obsDatasetManager2 == null) {
                if ((object = object.loadManager(null, null)) == null) continue;
                obsDatasetManager2 = (ObsDatasetManager)object;
            }
            arrayList.add(obsDatasetManager2);
        }
        if (this._observedDataSetDialog == null) {
            this._observedDataSetDialog = new ObservedStationSetDialog((Window)ClientApp.frame(), Dialog.ModalityType.MODELESS);
            this._observedDataSetDialog.setTitle(WqI18n.a("ObsData.Editor").getText());
            object2 = new Dimension(940, 810);
            this._observedDataSetDialog.setSize((Dimension)object2);
            this._observedDataSetDialog.setPreferredSize((Dimension)object2);
            this._observedDataSetDialog.setMinimumSize((Dimension)object2);
            this._observedDataSetDialog.pack();
            this._observedDataSetDialog.setLocationRelativeTo((Component)ClientApp.frame());
            if (this._wksp instanceof ClientWorkspace) {
                object = (WaterQualityMode)ClientApp.frame().getModeByClass(WaterQualityMode.class);
                this._observedDataSetDialog.addNewObsStationCreator(() -> this.lambda$displayObservedDataSetEditor$1((WaterQualityMode)object));
                this._observedDataSetDialog.addObsStationDeleter(arg_0 -> this.lambda$displayObservedDataSetEditor$2((WaterQualityMode)object, arg_0));
                this._observedDataSetDialog.addObsStationRename((arg_0, arg_1, arg_2) -> this.lambda$displayObservedDataSetEditor$3((WaterQualityMode)object, arg_0, arg_1, arg_2));
                this._observedDataSetDialog.addSaveAsObsStation((arg_0, arg_1, arg_2) -> this.lambda$displayObservedDataSetEditor$4((WaterQualityMode)object, arg_0, arg_1, arg_2));
            }
            this._observedDataSetDialog.setLocationRelativeTo((Component)ClientApp.frame());
            this._observedDataSetDialog.addPropertyChangeListener("ReturnStatus", propertyChangeEvent -> {
                if ((Integer)propertyChangeEvent.getNewValue() != 0) {
                    this._observedDataSetDialog.saveForm();
                }
            });
        }
        if (this._wksp instanceof ClientWorkspace) {
            this._observedDataSetDialog.fillForm(arrayList, obsDatasetManager);
        } else {
            this._observedDataSetDialog.fillFormForSimulation(arrayList, obsDatasetManager);
        }
        if (wQObsStation != null) {
            this._observedDataSetDialog.setSelectedStation(wQObsStation);
        }
        this._observedDataSetDialog.setVisible(true);
        return this._observedDataSetDialog;
    }

    public MetStationSetDialog displayMetDataSetEditor() {
        return this.displayMetDataSetEditor(null);
    }

    public MetStationSetDialog displayMetDataSetEditor(MetData metData) {
        Object object;
        Object object2 = this._wksp.getManagerProxyList(MODELNAME, MetData.class.getName());
        new ArrayList();
        ArrayList<MetData> arrayList = new ArrayList<MetData>();
        object2 = ((Vector)object2).iterator();
        while (object2.hasNext()) {
            object = (ManagerProxy)object2.next();
            if (object == null) continue;
            MetData metData2 = (MetData)object.getManager();
            if (metData2 == null) {
                WqI18n.a("MetData.Type").getText();
                if ((object = object.loadManager(null, null)) == null) continue;
                metData2 = (MetData)object;
            }
            arrayList.add(metData2);
        }
        if (this._metStationSetDialog == null) {
            this._metStationSetDialog = new MetStationSetDialog((Window)ClientApp.frame(), Dialog.ModalityType.MODELESS);
            this._metStationSetDialog.setTitle("Meteorological Dataset Editor");
            object2 = new Dimension(940, 810);
            this._metStationSetDialog.setSize((Dimension)object2);
            this._metStationSetDialog.setPreferredSize((Dimension)object2);
            this._metStationSetDialog.setMinimumSize((Dimension)object2);
            this._metStationSetDialog.pack();
            this._metStationSetDialog.setLocationRelativeTo((Component)ClientApp.frame());
            if (this._wksp instanceof ClientWorkspace) {
                object = (WaterQualityMode)ClientApp.frame().getModeByClass(WaterQualityMode.class);
                this._metStationSetDialog.addNewMetStationCreator(new WaterQualityEditors$3(this, (WaterQualityMode)object));
                this._metStationSetDialog.addMetStationDeleter(new WaterQualityEditors$4(this, (WaterQualityMode)object));
                this._metStationSetDialog.addMetStationRename(new WaterQualityEditors$5(this, (WaterQualityMode)object));
                this._metStationSetDialog.addSaveAsMetStation(new WaterQualityEditors$6(this, (WaterQualityMode)object));
            }
            this._metStationSetDialog.setLocationRelativeTo((Component)ClientApp.frame());
        }
        this._metStationSetDialog.fillForm(arrayList, metData);
        this._metStationSetDialog.setVisible(true);
        return this._metStationSetDialog;
    }

    public ConstituentSetEditor displayWqConstituentsEditor() {
        return this.displayWqConstituentsEditor(null);
    }

    public ConstituentSetEditor displayWqConstituentsEditor(ConstituentSetManager constituentSetManager2) {
        if (this._constituentSetEditor == null) {
            try {
                ClientApp.frame().setWaitCursor();
                this._constituentSetEditor = new WaterQualityEditors$7(this, (Frame)ClientApp.frame());
                WaterQualityMode waterQualityMode = (WaterQualityMode)ClientApp.frame().getModeByClass(WaterQualityMode.class);
                this._constituentSetEditor.setCreator(() -> waterQualityMode.constituentSetNew((Frame)ClientApp.frame()));
                this._constituentSetEditor.setDeleter(constituentSetManager -> waterQualityMode.constituentSetDelete(ClientApp.frame(), (ConstituentSetManager)((Object)constituentSetManager)));
                this._constituentSetEditor.setSaveAs(constituentSetManager -> waterQualityMode.constituentSetSaveAs((Frame)ClientApp.frame(), (ConstituentSetManager)((Object)constituentSetManager)));
                this._constituentSetEditor.setRename(constituentSetManager -> waterQualityMode.constituentSetRename(ClientApp.frame(), (ConstituentSetManager)((Object)constituentSetManager)));
                this._constituentSetEditor.setLocationByPlatform(true);
                this._constituentSetEditor.setLocationRelativeTo((Component)ClientApp.frame());
                this._constituentSetEditor.fillForm(this._wksp);
                if (constituentSetManager2 != null) {
                    this._constituentSetEditor.setSelectedConstituentSetManager(constituentSetManager2);
                }
                this._constituentSetEditor.setVisible(true);
            }
            finally {
                ClientApp.frame().setDefaultCursor();
            }
        }
        return this._constituentSetEditor;
    }

    public void resetEditors() {
        if (this._geoEditor != null) {
            this._geoEditor.closeDialog();
            this._geoEditor.dispose();
        }
        this._geoEditor = null;
        if (this._boundaryConditionsEditor != null) {
            this._boundaryConditionsEditor.setVisible(false);
            this._boundaryConditionsEditor.dispose();
        }
        this._boundaryConditionsEditor = null;
        if (this._dispersionSetEditor != null) {
            this._dispersionSetEditor.closeDialog();
            this._dispersionSetEditor.dispose();
        }
        this._dispersionSetEditor = null;
        if (this._initCondEditor != null) {
            this._initCondEditor.closeDialog();
            this._initCondEditor.dispose();
        }
        this._initCondEditor = null;
        if (this._parameterSetEditor != null) {
            this._parameterSetEditor.closeDialog();
            this._parameterSetEditor.dispose();
        }
        this._parameterSetEditor = null;
        if (this._metStationSetDialog != null) {
            this._metStationSetDialog.setVisible(false);
            this._metStationSetDialog.dispose();
        }
        this._metStationSetDialog = null;
        if (this._observedDataSetDialog != null) {
            this._observedDataSetDialog.setVisible(false);
            this._observedDataSetDialog.dispose();
        }
        this._observedDataSetDialog = null;
        if (this._constituentSetEditor != null) {
            this._constituentSetEditor.closeDialog();
            this._constituentSetEditor.dispose();
        }
        this._constituentSetEditor = null;
        if (this._massInjectEditor != null) {
            this._massInjectEditor.closeDialog();
            this._massInjectEditor.dispose();
        }
        this._massInjectEditor = null;
    }

    public void setActiveAlternative(RssAlt rssAlt) {
        this._rssAlt = rssAlt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MassInjectionEditor displayMassInjectionEditor(MassInjectionSetManager massInjectionSetManager, WQMassInjectionSite wQMassInjectionSite) {
        if (this._massInjectEditor == null) {
            try {
                ClientApp.frame().setWaitCursor();
                this._massInjectEditor = new WaterQualityEditors$8(this, (JFrame)ClientApp.frame());
                this._massInjectEditor.fillForm(this._wksp);
                this._massInjectEditor.setVisible(true);
                if (massInjectionSetManager == null) return this._massInjectEditor;
                this._massInjectEditor.setSelectedMassInjection(massInjectionSetManager);
                if (wQMassInjectionSite == null) return this._massInjectEditor;
                this._massInjectEditor.setSelectedMassInjectionSite(wQMassInjectionSite);
                return this._massInjectEditor;
            }
            finally {
                ClientApp.frame().setDefaultCursor();
            }
        } else {
            if (massInjectionSetManager == null) return this._massInjectEditor;
            this._massInjectEditor.setSelectedMassInjection(massInjectionSetManager);
            if (wQMassInjectionSite == null) return this._massInjectEditor;
            this._massInjectEditor.setSelectedMassInjectionSite(wQMassInjectionSite);
        }
        return this._massInjectEditor;
    }

    public MassInjectionEditor displayMassInjectionEditor(MassInjectionSetManager massInjectionSetManager) {
        return this.displayMassInjectionEditor(massInjectionSetManager, null);
    }

    public MassInjectionEditor getMassInjectionEditor() {
        return this._massInjectEditor;
    }

    public WqTsTable displayWqTsTable(RssAlt object) {
        if (object == null) {
            return null;
        }
        TSDataSet tSDataSet = object.getInputWQTSDataSet();
        if (tSDataSet != null) {
            object = new WqTsTable(ClientApp.frame(), object.getProxyList().getContainer());
            object.setVisible(true);
            return object;
        }
        return null;
    }

    public WqTsTable displayWqTsTable(ManagerProxyListContainer object) {
        if (object == null) {
            return null;
        }
        object = new WqTsTable(ClientApp.frame(), (ManagerProxyListContainer)object);
        object.setVisible(true);
        return object;
    }

    private /* synthetic */ ObsDatasetManager lambda$displayObservedDataSetEditor$4(WaterQualityMode waterQualityMode, ObsDatasetManager obsDatasetManager, String string, String string2) {
        return waterQualityMode.obsDataSetSaveAs((Window)((Object)this._observedDataSetDialog), obsDatasetManager, string, string2);
    }

    private /* synthetic */ ObsDatasetManager lambda$displayObservedDataSetEditor$3(WaterQualityMode waterQualityMode, ObsDatasetManager obsDatasetManager, String string, String string2) {
        return waterQualityMode.obsDataSetRename((Window)((Object)this._observedDataSetDialog), obsDatasetManager, string, string2);
    }

    private /* synthetic */ List lambda$displayObservedDataSetEditor$2(WaterQualityMode waterQualityMode, ObsDatasetManager obsDatasetManager) {
        return waterQualityMode.obsDatasetDelete((Window)((Object)this._observedDataSetDialog), obsDatasetManager);
    }

    private /* synthetic */ ObsDatasetManager lambda$displayObservedDataSetEditor$1(WaterQualityMode waterQualityMode) {
        return waterQualityMode.obsDatasetNew((Window)((Object)this._observedDataSetDialog));
    }
}

