/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client;

import com.vividsolutions.jts.geom.Geometry;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.client.HecClientFrame;
import hec.clientapp.client.ManagerChooser;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.StreamAlignment;
import hec.event.ModifiableListener;
import hec.gui.NameDialog;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.map.ButtonGifStrings;
import hec.map.LocalPt;
import hec.map.MapGlyphFactory;
import hec.map.MapToolPanel;
import hec.map.MousePanAdapter;
import hec.rss.client.AbstractAlternativeEditor;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.RSS;
import hec.rss.client.ResSimAdvancedOptionsPanel;
import hec.rss.map.ResSimPointerMouseAdapter;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.wq.client.WaterQualityEditors;
import hec.rss.wq.client.WaterQualityMode$1;
import hec.rss.wq.client.WaterQualityMode$2;
import hec.rss.wq.client.WaterQualityMode$3;
import hec.rss.wq.client.WqClientMode;
import hec.rss.wq.client.WqTsTable;
import hec.rss.wq.client.boundarycondition.BoundaryConditionEditorDialog;
import hec.rss.wq.client.constituentSet.ConstituentSetEditor;
import hec.rss.wq.client.dispersionCoeff.client.DispersionCoefEditor;
import hec.rss.wq.client.geometry.GeometryEditor;
import hec.rss.wq.client.geometry.GeometryMapGlyph;
import hec.rss.wq.client.geometry.ReachCellsMapObject;
import hec.rss.wq.client.initialcondition.InitialConditionsEditor;
import hec.rss.wq.client.massinjection.MassInjectionEditor;
import hec.rss.wq.client.massinjection.MassInjectionSiteMouseHandler;
import hec.rss.wq.client.metstation.MetStationSetDialog;
import hec.rss.wq.client.metstation.MetStationSetMapTool;
import hec.rss.wq.client.metstation.NewMetStationSetPanel;
import hec.rss.wq.client.observeddataset.NewObsStationSetPanel;
import hec.rss.wq.client.observeddataset.ObservedStationMouseHandler;
import hec.rss.wq.client.observeddataset.ObservedStationNamedType;
import hec.rss.wq.client.observeddataset.ObservedStationSetDialog;
import hec.rss.wq.client.wqParameters.ParameterSetEditor;
import hec.rss.wq.map.CrossSectionManagerGlyph;
import hec.rss.wq.map.MassInjectionManagerGlyph;
import hec.rss.wq.model.BoundaryConditionSetManager;
import hec.rss.wq.model.ConstituentSetManager;
import hec.rss.wq.model.CrossSectionManager;
import hec.rss.wq.model.InitialConditionSetManager;
import hec.rss.wq.model.JsonManager;
import hec.rss.wq.model.MetData;
import hec.rss.wq.model.ObsDatasetManager;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.model.dispersionCoeff.DispersionSetManager;
import hec.rss.wq.model.massinjection.MassInjectionManager;
import hec.rss.wq.model.massinjection.MassInjectionSetManager;
import hec.rss.wq.model.wqParameters.ParameterSetManager;
import hec.rss.wq.ui.OkCancelDialog;
import hec.rss.wq.util.WqI18n;
import hec.watershed.map.StationMouseTool;
import hec.watershed.model.Station;
import hec.watershed.model.StationSetDataObject;
import hec.wqenginecore.ConstituentSet;
import hec.wqengineimpl.WQConstituentSet;
import hec.wqengineimpl.massInjection.WQMassInjectionSite;
import hec.wqengineimpl.metstation.WQMetStation;
import hec.wqengineimpl.observed.WQObsStation;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.text.Document;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.lang.Modifiable;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJTextField;
import rma.swing.RmaValidComponent;
import rma.swing.event.ReflectMultiListener;
import rma.swing.list.RmaListModel;
import rma.swing.text.FilenameDocument;
import rma.util.RMAIO;

public class WaterQualityMode
extends ClientMode
implements WqClientMode {
    private static ManagerProxy _noManagerProxy;
    private final String _modeName;
    public static final Logger logger;
    public static final String MODELNAME = "rss";
    private JMenu _wqMenu;
    private JMenu _injectionsMenu;
    private JMenu _obsDataMenu;
    private ReflectMultiListener _listener;
    private JCheckBoxMenuItem _editConfigMenuItem;
    private AlternativeEditor _alternativeEditor;
    private JToggleButton _networkLockButton;
    private JLabel _networkLabel;
    private RmaJTextField _networkFld;
    private JLabel _geometryLabel;
    private RmaJComboBox<ManagerProxy> _geometryCombo;
    private RmaListModel<ManagerProxy> _geometryComboListModel;
    private JLabel _metDataSetLabel;
    private RmaJComboBox<ManagerProxy> _metDataSetCombo;
    private RmaListModel<ManagerProxy> _metDataSetComboListModel;
    private JLabel _obsDataSetLabel;
    private RmaJComboBox<ManagerProxy> _obsDataSetCombo;
    private RmaListModel<ManagerProxy> _obsDataSetComboListModel;
    private JLabel _massInjectLabel;
    private RmaJComboBox<ManagerProxy> _massInjectCombo;
    protected StreamAlignment _alignment;
    private RssSystem _network;
    private WqGeometry _geometry;
    private ReachCellsMapObject _wqCells;
    private MetData _metData;
    private ObsDatasetManager _observedDatasetManager;
    private ModifiableListener _modifiableListener;
    private ResSimAdvancedOptionsPanel _advancedOptionsPanel;
    private ConstituentSetEditor _constituentSetEditor;
    private GeometryEditor _geoEditor;
    private MetStationSetDialog _metStationSetDialog;
    private ParameterSetEditor _parameterSetEditor;
    private DispersionCoefEditor _dispersionSetEditor;
    private InitialConditionsEditor _initCondEditor;
    private BoundaryConditionEditorDialog _boundaryConditionsEditor;
    private WaterQualityEditors _editorLaucher;
    private MassInjectionManager _massInjectionMgr;
    private MassInjectionSetManager _massInjectionSet;
    private RmaListModel<ManagerProxy> _massInjectComboListModel;

    public WaterQualityMode(HecClientFrame hecClientFrame) {
        super(hecClientFrame);
        MapGlyphFactory.addMapping((String)CrossSectionManager.class.getName(), (String)CrossSectionManagerGlyph.class.getName());
        MapGlyphFactory.addMapping((String)MassInjectionManager.class.getName(), (String)MassInjectionManagerGlyph.class.getName());
        MapGlyphFactory.addMapping((String)WqGeometry.class.getName(), (String)GeometryMapGlyph.class.getName());
        hecClientFrame = new Identifier();
        hecClientFrame.setName("");
        _noManagerProxy = new ManagerProxy((Identifier)hecClientFrame);
        this._constituentSetEditor = null;
        this._editConfigMenuItem = new JCheckBoxMenuItem();
        this._modeName = WqI18n.a("WqModule.Name").getText();
        WaterQualityMode waterQualityMode = this;
        waterQualityMode.setMenuName(waterQualityMode._modeName);
        this._listener = new ReflectMultiListener();
        this._modifiableListener = (modifiable, bl) -> this.mgrModifiedStateChanged(modifiable, bl);
        this.createModeMenu();
        this.createModeToolbar();
        this.createFrameToolBar();
        this._editorLaucher = new WaterQualityEditors();
    }

    @Override
    public WaterQualityEditors getEditorLaucher() {
        return this._editorLaucher;
    }

    private void createModeMenu() {
        this._wqMenu = WqI18n.a("WqModule.Name").createMenu();
        WaterQualityMode waterQualityMode = this;
        waterQualityMode.addMenu(waterQualityMode._wqMenu);
        JMenuItem jMenuItem = WqI18n.a("WqModule.MenuItem.Geometry").createMenuItem();
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayGeometryEditor"));
        this._wqMenu.add(jMenuItem);
        this._wqMenu.addSeparator();
        jMenuItem = WqI18n.a("WqModule.Menu.Constituents").createMenuItem();
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayWqConstituentsEditor"));
        this._wqMenu.add(jMenuItem);
        jMenuItem = WqI18n.a("WqModule.Menu.WqParameters").createMenuItem();
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayWqParameterEditor"));
        this._wqMenu.add(jMenuItem);
        this._wqMenu.addSeparator();
        jMenuItem = WqI18n.a("WqModule.Menu.MetData").createMenuItem();
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayMetDataSetEditor"));
        this._wqMenu.add(jMenuItem);
        jMenuItem = WqI18n.a("WqModule.Menu.ObjData").createMenuItem();
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayObservedDataSetEditor"));
        this._wqMenu.add(jMenuItem);
        this._wqMenu.addSeparator();
        jMenuItem = WqI18n.a("WqModule.Menu.BC").createMenuItem();
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayBoundaryConditionEditor"));
        this._wqMenu.add(jMenuItem);
        jMenuItem = WqI18n.a("WqModule.Menu.IC").createMenuItem();
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayInitialConditionsEditor"));
        this._wqMenu.add(jMenuItem);
        jMenuItem = WqI18n.a("WqModule.Menu.MassInjections").createMenuItem();
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayMassInjectionsEditor"));
        this._wqMenu.add(jMenuItem);
        this._wqMenu.addSeparator();
        jMenuItem = WqI18n.a("WqModule.Menu.DispParameters").createMenuItem();
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayDispersionCoeffEditor"));
        this._wqMenu.add(jMenuItem);
        this._wqMenu.addSeparator();
        jMenuItem = WqI18n.a("WqModel.MenuItem.WqTsTable").createMenuItem();
        jMenuItem.setName("WQ Inputs Viewer");
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayWqInputsDialog"));
        this._wqMenu.add(jMenuItem);
        JMenu jMenu = WqI18n.a("WqModule.Menu.Alternative").createMenu();
        jMenuItem = WqI18n.a("WqModule.Menu.Edit").createMenuItem();
        jMenuItem.setName("Sim_Alternative");
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "displayAlternativeEditor"));
        jMenu.add(jMenuItem);
        this.addMenu(jMenu);
    }

    private void createModeToolbar() {
        this.setMapTools(new MapToolPanel(this._frame.getMapPanel()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        JToggleButton jToggleButton = new JToggleButton();
        ButtonGifStrings buttonGifStrings = new ButtonGifStrings();
        new ButtonGifStrings().up = "Images/Point.gif";
        buttonGifStrings.down = "Images/Point.gif";
        buttonGifStrings.over = "Images/Point.gif";
        buttonGifStrings.on = "Images/Point.gif";
        buttonGifStrings.toolTipText = "Pointer Tool";
        buttonGifStrings.borderPainted = true;
        buttonGifStrings.adapter = ResSimPointerMouseAdapter.class.getName();
        this._mapTools.addToolButton(jToggleButton, buttonGifStrings, gridBagConstraints);
        jToggleButton = new JToggleButton();
        buttonGifStrings = new ButtonGifStrings();
        new ButtonGifStrings().up = "Images/ZoomUp.gif";
        buttonGifStrings.down = "Images/ZoomDown.gif";
        buttonGifStrings.over = "Images/ZoomUp.gif";
        buttonGifStrings.on = "Images/ZoomDown.gif";
        buttonGifStrings.toolTipText = "Zoom Tool";
        buttonGifStrings.borderPainted = true;
        buttonGifStrings.adapter = "hec.map.MouseZoomAdapter";
        buttonGifStrings.cursorType = 1;
        this._mapTools.addToolButton(jToggleButton, buttonGifStrings, gridBagConstraints);
        if (Boolean.getBoolean("Map.HasPanMouseTool")) {
            jToggleButton = new JToggleButton();
            buttonGifStrings = MousePanAdapter.buildDefaultButtonGifStrings();
            gridBagConstraints.weighty = 0.0;
            this._mapTools.addToolButton(jToggleButton, buttonGifStrings, gridBagConstraints);
        }
        buttonGifStrings = new ButtonGifStrings();
        new ButtonGifStrings().up = "Images/rss/wq/RegionToolYellow_dashedlines23.png";
        buttonGifStrings.down = "Images/rss/wq/RegionToolYellow_dashedlines23.png";
        buttonGifStrings.over = "Images/rss/wq/RegionToolYellow_dashedlines23.png";
        buttonGifStrings.on = "Images/rss/wq/RegionToolYellow_dashedlines23.png";
        buttonGifStrings.toolTipText = "Use to create or edit WQ Extent and Regions";
        buttonGifStrings.adapter = "hec.rss.wq.client.geometry.GeometryMouseAdapter";
        buttonGifStrings.borderPainted = true;
        jToggleButton = new JToggleButton();
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this._mapTools.addToolButton(jToggleButton, buttonGifStrings, gridBagConstraints);
        buttonGifStrings = new ButtonGifStrings();
        new ButtonGifStrings().up = "Images/rss/wq/massInjectionTool23.png";
        buttonGifStrings.down = "Images/rss/wq/massInjectionTool23.png";
        buttonGifStrings.over = "Images/rss/wq/massInjectionTool23.png";
        buttonGifStrings.on = "Images/rss/wq/massInjectionTool23.png";
        buttonGifStrings.toolTipText = "Mass Injection Tool";
        buttonGifStrings.adapter = "hec.rss.wq.client.geometry.MassInjectionMouseAdapter";
        buttonGifStrings.borderPainted = true;
        jToggleButton = new JToggleButton();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this._mapTools.addToolButton(jToggleButton, buttonGifStrings, gridBagConstraints);
        buttonGifStrings = new StationMouseTool();
        new StationMouseTool().adapter = MetStationSetMapTool.class.getName();
        jToggleButton = new JToggleButton();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this._mapTools.addToolButton(jToggleButton, buttonGifStrings, gridBagConstraints);
    }

    private void createFrameToolBar() {
        Serializable serializable = new JPanel(new GridBagLayout());
        this.addToolBarComponent((JComponent)serializable);
        Object object = WqI18n.a("WqModule.Text.None").getText();
        this._networkLabel = WqI18n.a("WqModule.Label.Network").createJLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0505;
        serializable.add(this._networkLabel, gridBagConstraints);
        this._networkFld = new RmaJTextField((String)object);
        this._networkFld.setEditable(false);
        object = this._networkFld.getPreferredSize();
        this._networkFld.getPreferredSize().width = 125;
        this._networkFld.setMinimumSize((Dimension)object);
        this._networkFld.setPreferredSize((Dimension)object);
        object = WqI18n.a("WqModule.ToolTip.NoNetwork").getText();
        this._networkFld.setToolTipText((String)object);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0505;
        serializable.add((Component)this._networkFld, gridBagConstraints);
        this._geometryLabel = WqI18n.a("WqModule.Label.Geometry").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0505;
        serializable.add(this._geometryLabel, gridBagConstraints);
        this._geometryCombo = new RmaJComboBox();
        object = this._geometryCombo.getPreferredSize();
        this._geometryCombo.getPreferredSize().width = 125;
        this._geometryCombo.setMinimumSize((Dimension)object);
        this._geometryCombo.setPreferredSize((Dimension)object);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0505;
        serializable.add((Component)this._geometryCombo, gridBagConstraints);
        this._geometryCombo.addActionListener(actionEvent -> this.geometryComboActionPerformed());
        object = new JLabel("");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0505;
        serializable.add((Component)object, gridBagConstraints);
        this._metDataSetLabel = WqI18n.a("WqModule.Label.MetDataSet").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        serializable.add(this._metDataSetLabel, gridBagConstraints);
        this._metDataSetCombo = new RmaJComboBox();
        object = this._metDataSetCombo.getPreferredSize();
        this._metDataSetCombo.getPreferredSize().width = 125;
        this._metDataSetCombo.setMinimumSize((Dimension)object);
        this._metDataSetCombo.setPreferredSize((Dimension)object);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        serializable.add((Component)this._metDataSetCombo, gridBagConstraints);
        this._metDataSetCombo.addActionListener(actionEvent -> this.metDataSetComboActionPerformed());
        this._obsDataSetLabel = WqI18n.a("WqModule.Label.ObsDataSet").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        serializable.add(this._obsDataSetLabel, gridBagConstraints);
        this._obsDataSetCombo = new RmaJComboBox();
        object = this._obsDataSetCombo.getPreferredSize();
        this._obsDataSetCombo.getPreferredSize().width = 125;
        this._obsDataSetCombo.setMinimumSize((Dimension)object);
        this._obsDataSetCombo.setPreferredSize((Dimension)object);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        serializable.add((Component)this._obsDataSetCombo, gridBagConstraints);
        this._obsDataSetCombo.addActionListener(actionEvent -> this.obsDataSetComboActionPerformed());
        this._massInjectLabel = WqI18n.a("WqModule.Label.MassInjection").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        serializable.add(this._massInjectLabel, gridBagConstraints);
        this._massInjectCombo = new RmaJComboBox();
        object = this._massInjectCombo.getPreferredSize();
        this._massInjectCombo.getPreferredSize().width = 125;
        this._massInjectCombo.setMinimumSize((Dimension)object);
        this._massInjectCombo.setPreferredSize((Dimension)object);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        serializable.add((Component)this._massInjectCombo, gridBagConstraints);
        this._massInjectCombo.addActionListener(actionEvent -> this.massInjectionSetComboActionPerformed());
        this._networkLockButton = new JToggleButton(this._unlockIcon);
        serializable = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this._networkLockButton.setMargin((Insets)serializable);
        this._networkLockButton.setSelectedIcon(this._lockIcon);
        this._networkLockButton.setToolTipText("Reservoir Network Locked Status");
        this._networkLockButton.setModel(this._editConfigMenuItem.getModel());
        this._geometryCombo.addActionListener(actionEvent -> this.updateManagerComboBoxToolTipListener((JComboBox)actionEvent.getSource()));
        this._geometryCombo.addActionListener(actionEvent -> this.updateUpdateNetworkFieldTipListener((JComboBox)actionEvent.getSource()));
        this._metDataSetCombo.addActionListener(actionEvent -> this.updateManagerComboBoxToolTipListener((JComboBox)actionEvent.getSource()));
        this._obsDataSetCombo.addActionListener(actionEvent -> this.updateManagerComboBoxToolTipListener((JComboBox)actionEvent.getSource()));
        this._massInjectCombo.addActionListener(actionEvent -> this.updateManagerComboBoxToolTipListener((JComboBox)actionEvent.getSource()));
    }

    private void updateUpdateNetworkFieldTipListener(JComboBox object) {
        object = (WqGeometry)WaterQualityMode.mgrComboActionPerformed(this._geometryCombo);
        this._networkFld.setToolTipText("");
        if (object != null && (object = ((WqGeometry)((Object)object)).getNetwork()) != null) {
            object = "<html><b>" + object.getName() + "</b></html>";
            this._networkFld.setToolTipText((String)object);
        }
    }

    private void updateManagerComboBoxToolTipListener(JComboBox jComboBox) {
        Object object = jComboBox.getSelectedItem();
        if (object == null) {
            jComboBox.setToolTipText("");
            return;
        }
        object = "<html><b>" + object.toString() + "</b></html>";
        jComboBox.setToolTipText((String)object);
    }

    private void mgrModifiedStateChanged(Modifiable modifiable, boolean bl) {
        if (modifiable == null) {
            return;
        }
        if (modifiable == this._network) {
            WaterQualityMode.updateMgrField((Manager)this._network, this._networkFld, bl);
            return;
        }
        if (modifiable == this._geometry) {
            WaterQualityMode.updateMgrField((Manager)this._geometry, this._geometryCombo, bl);
            return;
        }
        if (modifiable == this._metData) {
            WaterQualityMode.updateMgrField((Manager)this._metData, this._metDataSetCombo, bl);
        }
    }

    private static void updateMgrField(Manager object, RmaJTextField rmaJTextField, boolean bl) {
        if (object == null) {
            object = WqI18n.a("WqModule.Text.None").getText();
            rmaJTextField.setText((String)object);
            return;
        }
        rmaJTextField.setText(object.getName() + (bl ? "*" : ""));
    }

    private static void updateMgrField(Manager manager, RmaJComboBox<ManagerProxy> rmaJComboBox, boolean bl) {
        if (manager == null) {
            rmaJComboBox.setSelectedIndex(-1);
            return;
        }
        manager = ClientApp.Workspace().getManagerProxy(MODELNAME, manager.getIdentifier());
        if (!((RmaListModel)rmaJComboBox.getModel()).contains((Object)manager)) {
            rmaJComboBox.addItem((Object)manager);
        }
        if (rmaJComboBox.getSelectedItem() == null || !rmaJComboBox.getSelectedItem().equals(manager)) {
            rmaJComboBox.setSelectedItem((Object)manager);
        }
    }

    ObsDatasetManager obsDatasetNew(Window object) {
        String string = WqI18n.a("ObsData.Type").getText();
        Object object2 = WqI18n.a("ObsData.Title.New").getText();
        Object object3 = (StationSetDataObject)ClientApp.Workspace().getDataListContainer().getDataList("hec.watershed.model.StationSet");
        object3 = object3.getObjectArray();
        object3 = (StationSetDataObject)object3[0];
        object3 = object3.getStationSet();
        List<Station> list = Station::isObservedStation;
        object3 = object3.getFeatures(list).stream().sorted(Comparator.comparing(Station::getName)).collect(Collectors.toList());
        list = new NewObsStationSetPanel();
        ((NewObsStationSetPanel)((Object)list)).setStations((List<Station>)object3);
        object = new OkCancelDialog((Window)object, (JComponent)((Object)list), Dialog.ModalityType.APPLICATION_MODAL);
        object.setTitle((String)object2);
        object.setSize(470, 410);
        object.setDefaultSize(470, 410);
        object.setMinimumSize(new Dimension(470, 410));
        object.setLocationRelativeTo((Component)ClientApp.frame());
        ((OkCancelDialog)((Object)object)).addValidator(() -> this.lambda$obsDatasetNew$10((NewObsStationSetPanel)((Object)list)));
        object.setVisible(true);
        int n = ((OkCancelDialog)((Object)object)).getReturnStatus();
        if (n != 1) {
            return null;
        }
        Object object4 = ((NewObsStationSetPanel)((Object)list)).getName();
        object2 = ((NewObsStationSetPanel)((Object)list)).getDescription();
        object3 = ((NewObsStationSetPanel)((Object)list)).getSelectedStations();
        list = ((NewObsStationSetPanel)((Object)list)).getAvailableStations();
        String string2 = RMAIO.userNameToFileName((String)object4);
        File file = new File(ClientApp.Workspace().getWorkspacePath());
        file = new File(file, MODELNAME);
        file = new File(file, "wq");
        String string3 = ".obs";
        file = new File(file, string2 + string3);
        string2 = new Identifier(file.getAbsolutePath());
        string2.setName((String)object4);
        string2.setClassName(ObsDatasetManager.class.getName());
        string2.setDescription((String)object2);
        object4 = (ObsDatasetManager)ClientApp.Workspace().newManager(MODELNAME, ObsDatasetManager.class.getName());
        if (object4 == null) {
            return null;
        }
        object2 = Preferences.userNodeForPackage(WQObsStation.class);
        int n2 = ((Preferences)object2).getInt("NextObsStationId", 0);
        this.addWQObsStations((List<Station>)object3, true, (ObsDatasetManager)object4, n2);
        this.addWQObsStations(list, false, (ObsDatasetManager)object4, n2);
        ((Preferences)object2).putInt("NextObsStationId", n2);
        object4.setIdentifier((Identifier)string2);
        ((ObsDatasetManager)object4).setName(string2.getName());
        ((ObsDatasetManager)object4).setDescription(string2.getDescription());
        object2 = ClientApp.Workspace();
        if (object2 == null) {
            return null;
        }
        boolean bl = ClientApp.Workspace().saveManagerAs(MODELNAME, (Manager)object4, (Identifier)string2);
        if (!bl) {
            string = WqI18n.a("WqModule.Msg.FailedCreateMgr").format((Object)string);
            object4 = WqI18n.a("WqModule.Msg.FailedCreateMgr.Title").getText();
            ClientApp.app().postError(string, (String)object4);
            return null;
        }
        this._observedDatasetManager = object4;
        string = this._observedDatasetManager.getProxyList().getManager(this._observedDatasetManager.getIdentifier());
        this._obsDataSetComboListModel.addElement((Object)string);
        this._obsDataSetCombo.setSelectedItem((Object)string);
        ClientApp.Workspace().saveWorkspace();
        return object4;
    }

    private void addWQObsStations(List<Station> object, boolean bl, ObsDatasetManager obsDatasetManager, int n) {
        object = object.iterator();
        while (object.hasNext()) {
            Station station = (Station)object.next();
            WQObsStation wQObsStation = new WQObsStation();
            wQObsStation.setId(n++);
            wQObsStation.setActive(bl);
            wQObsStation.setName(station.getName());
            wQObsStation.setDescription(station.getDescription());
            wQObsStation.setGeometry((Geometry)station.getGeometry().clone());
            wQObsStation.setStationIconLocation(station.getStationIconLocation());
            wQObsStation.setIsProfileStation(station.isProfileStation());
            wQObsStation.setStreamStation(station.getStreamStation());
            wQObsStation.setNearestMeridian(station.getNearestMeridian());
            wQObsStation.setLatitude(station.getLatitude());
            wQObsStation.setLongitude(station.getLongitude());
            wQObsStation.setReferenceElevation(station.getElevation());
            wQObsStation.setIsMetStation(station.isMetStation());
            wQObsStation.setIsObserved(station.isObservedStation());
            wQObsStation.setStreamName(station.getStreamName());
            obsDatasetManager.getObsStationSet().getStations().add(wQObsStation);
        }
    }

    MetData metDataSetNew(Window object) {
        Object object2;
        String string = WqI18n.a("MetData.Type").getText();
        Object object3 = WqI18n.a("MetData.Title.New").getText();
        Object object4 = (StationSetDataObject)ClientApp.Workspace().getDataListContainer().getDataList("hec.watershed.model.StationSet");
        object4 = object4.getObjectArray();
        object4 = (StationSetDataObject)object4[0];
        object4 = object4.getStationSet();
        List<Station> list = station -> station.isMetStation();
        object4 = object4.getFeatures(list).stream().collect(Collectors.toList());
        object4.sort(new WaterQualityMode$1());
        list = new NewMetStationSetPanel();
        ((NewMetStationSetPanel)((Object)list)).setStations((List<Station>)object4);
        object = new OkCancelDialog((Window)object, (JComponent)((Object)list), Dialog.ModalityType.APPLICATION_MODAL);
        object.setTitle((String)object3);
        object.setSize(470, 410);
        object.setDefaultSize(470, 410);
        object.setMinimumSize(new Dimension(470, 410));
        object.setLocationRelativeTo((Component)ClientApp.frame());
        ((OkCancelDialog)((Object)object)).addValidator(new WaterQualityMode$2(this, (NewMetStationSetPanel)((Object)list)));
        object.setVisible(true);
        int n = ((OkCancelDialog)((Object)object)).getReturnStatus();
        if (n != 1) {
            return null;
        }
        Object object5 = ((NewMetStationSetPanel)((Object)list)).getName();
        object3 = ((NewMetStationSetPanel)((Object)list)).getDescription();
        object4 = ((NewMetStationSetPanel)((Object)list)).getSelectedStations();
        list = ((NewMetStationSetPanel)((Object)list)).getAvailableStations();
        String string2 = RMAIO.userNameToFileName((String)object5);
        File file = new File(ClientApp.Workspace().getWorkspacePath());
        file = new File(file, MODELNAME);
        file = new File(file, "wq");
        String bl = ".met";
        bl = ".met".length() > 0 && bl.charAt(0) == '.' ? bl : "." + bl;
        file = new File(file, string2 + bl);
        string2 = new Identifier(file.getAbsolutePath());
        string2.setName((String)object5);
        string2.setClassName(MetData.class.getName());
        string2.setDescription((String)object3);
        object5 = (MetData)ClientApp.Workspace().newManager(MODELNAME, MetData.class.getName());
        if (object5 == null) {
            return null;
        }
        object3 = Preferences.userNodeForPackage(WQMetStation.class);
        int n2 = ((Preferences)object3).getInt("NextMetStationId", 0);
        object4 = object4.iterator();
        while (object4.hasNext()) {
            Station station2 = (Station)object4.next();
            object2 = new WQMetStation();
            object2.setId(n2++);
            object2.setActive(true);
            object2.setName(station2.getName());
            object2.setDescription(station2.getDescription());
            object2.setGeometry((Geometry)station2.getGeometry().clone());
            object2.setNearestMeridian(station2.getNearestMeridian());
            object2.setLatitude(station2.getLatitude());
            object2.setLongitude(station2.getLongitude());
            object2.setReferenceElevation(station2.getElevation());
            object2.setIsMetStation(station2.isMetStation());
            object2.setIsObserved(station2.isObservedStation());
            ((MetData)object5).getMetStationSet().getStations().add(object2);
        }
        for (Station station3 : list) {
            object2 = new WQMetStation();
            object2.setActive(false);
            object2.setId(n2++);
            object2.setName(station3.getName());
            object2.setDescription(station3.getDescription());
            object2.setGeometry((Geometry)station3.getGeometry().clone());
            object2.setNearestMeridian(station3.getNearestMeridian());
            object2.setLatitude(station3.getLatitude());
            object2.setLongitude(station3.getLongitude());
            object2.setReferenceElevation(station3.getElevation());
            object2.setIsMetStation(station3.isMetStation());
            object2.setIsObserved(station3.isObservedStation());
            ((MetData)object5).getMetStationSet().getStations().add(object2);
        }
        ((Preferences)object3).putInt("NextMetStationId", n2);
        object5.setIdentifier((Identifier)string2);
        ((MetData)object5).setName(string2.getName());
        ((MetData)object5).setDescription(string2.getDescription());
        object4 = ClientApp.Workspace();
        if (object4 == null) {
            return null;
        }
        boolean bl2 = ClientApp.Workspace().saveManagerAs(MODELNAME, (Manager)object5, (Identifier)string2);
        if (!bl2) {
            object2 = WqI18n.a("WqModule.Msg.FailedCreateMgr").format((Object)string);
            object5 = WqI18n.a("WqModule.Msg.FailedCreateMgr.Title").getText();
            ClientApp.app().postError((String)object2, (String)object5);
            return null;
        }
        this._metData = object5;
        object2 = this._metData.getProxyList().getManager(this._metData.getIdentifier());
        this._metDataSetComboListModel.addElement(object2);
        this._metDataSetCombo.setSelectedItem(object2);
        ClientApp.Workspace().saveWorkspace();
        return object5;
    }

    public List<String> getExistingNames(String object) {
        object = ClientApp.Workspace().getManagerIDList(MODELNAME, (String)object);
        ArrayList arrayList = new ArrayList();
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                if (!(object2 instanceof Identifier)) continue;
                object2 = (Identifier)object2;
                arrayList.add(object2);
            }
        }
        object = arrayList.stream().map(NamedType::getName).collect(Collectors.toList());
        return object;
    }

    public boolean hasManagerWithName(String string, String object) {
        boolean bl = false;
        object = ClientApp.Workspace().getManagerIDList(MODELNAME, (String)object);
        if (object != null) {
            object = ((Vector)object).iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                if (!string.equalsIgnoreCase((object2 = (Identifier)object2).getName())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public ObservedStationSetDialog displayObservedDataSetEditor() {
        WaterQualityMode waterQualityMode = this;
        return waterQualityMode.displayObservedDataSetEditor(waterQualityMode._observedDatasetManager);
    }

    public ObservedStationSetDialog displayObservedDataSetEditor(ObsDatasetManager obsDatasetManager) {
        return this.displayObservedDataSetEditor(obsDatasetManager, null);
    }

    public ObservedStationSetDialog displayObservedDataSetEditor(ObsDatasetManager obsDatasetManager, WQObsStation wQObsStation) {
        return this._editorLaucher.displayObservedDataSetEditor(obsDatasetManager, wQObsStation);
    }

    public MetStationSetDialog displayMetDataSetEditor() {
        WaterQualityMode waterQualityMode = this;
        return waterQualityMode.displayMetDataSetEditor(waterQualityMode._metData);
    }

    @Override
    public MetStationSetDialog displayMetDataSetEditor(MetData metData) {
        return this._editorLaucher.displayMetDataSetEditor(metData);
    }

    @Override
    public ObsDatasetManager getSelectedObsDataSet() {
        return this._observedDatasetManager;
    }

    public MassInjectionEditor displayMassInjectionsEditor() {
        return this._editorLaucher.displayMassInjectionEditor(this._massInjectionSet);
    }

    @Override
    public MassInjectionEditor displayMassInjectionEditor(WQMassInjectionSite wQMassInjectionSite) {
        return this._editorLaucher.displayMassInjectionEditor(this._massInjectionSet, wQMassInjectionSite);
    }

    List<String> obsDatasetDelete(Window window, ObsDatasetManager iterator) {
        Object object;
        Object object2 = new MessageFormat("<html><body>Ok to delete Observed Dataset <b>{0}</bold>?</b></body></html>");
        int n = RMAIO.postYesNoMessage((Component)window, (String)(object2 = ((Format)object2).format(new String[]{iterator.getName()})), (String)"Confirm Delete");
        if (n != 0) {
            return Collections.EMPTY_LIST;
        }
        List<Object> list = ClientApp.Workspace().getManagerIDList(MODELNAME, ObsDatasetManager.class.getName());
        list = list.stream().filter(arg_0 -> WaterQualityMode.lambda$obsDatasetDelete$12((ObsDatasetManager)((Object)iterator), arg_0)).collect(Collectors.toList());
        iterator = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            object = (Identifier)list.get(i);
            boolean bl = ClientApp.Workspace().deleteManager(MODELNAME, (Identifier)object, true);
            if (!bl) {
                System.out.println("Unable to delete specified Observed Dataset " + object.getPath());
                continue;
            }
            iterator.add(object);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        object = new ArrayList();
        Iterator iterator2 = iterator.iterator();
        while (iterator2.hasNext()) {
            Object object32;
            list = (Identifier)iterator2.next();
            object.add(list.getName());
            for (Object object32 : this._obsDataSetComboListModel.getList()) {
                if (!object32.getName().equals(list.getName())) continue;
                arrayList.add(object32);
            }
            boolean bl = false;
            object32 = arrayList.iterator();
            while (object32.hasNext()) {
                list = (ManagerProxy)object32.next();
                if (list == this._obsDataSetComboListModel.getSelectedItem()) {
                    bl = true;
                }
                this._obsDataSetComboListModel.removeElement(list);
            }
            if (!bl) continue;
            this._obsDataSetCombo.setSelectedIndex(this._obsDataSetCombo.getItemCount() > 0 ? 0 : -1);
        }
        return object;
    }

    public List<String> metDatasetDelete(Window window, MetData iterator) {
        Object object;
        Object object2 = new MessageFormat("<html><body>Ok to delete Meteorological Dataset <b>{0}</bold>?</b></body></html>");
        int n = RMAIO.postYesNoMessage((Component)window, (String)(object2 = ((Format)object2).format(new String[]{iterator.getName()})), (String)"Confirm Delete");
        if (n != 0) {
            return Collections.EMPTY_LIST;
        }
        List<Object> list = ClientApp.Workspace().getManagerIDList(MODELNAME, MetData.class.getName());
        list = list.stream().filter(arg_0 -> WaterQualityMode.lambda$metDatasetDelete$13((MetData)((Object)iterator), arg_0)).collect(Collectors.toList());
        iterator = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            object = (Identifier)list.get(i);
            boolean bl = ClientApp.Workspace().deleteManager(MODELNAME, (Identifier)object, true);
            if (!bl) {
                System.out.println("Unable to delete specified Meteorological Dataset " + object.getPath());
                continue;
            }
            iterator.add(object);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        object = new ArrayList();
        Iterator iterator2 = iterator.iterator();
        while (iterator2.hasNext()) {
            Object object32;
            list = (Identifier)iterator2.next();
            object.add(list.getName());
            for (Object object32 : this._metDataSetComboListModel.getList()) {
                if (!object32.getName().equals(list.getName())) continue;
                arrayList.add(object32);
            }
            boolean bl = false;
            object32 = arrayList.iterator();
            while (object32.hasNext()) {
                list = (ManagerProxy)object32.next();
                if (list == this._metDataSetComboListModel.getSelectedItem()) {
                    bl = true;
                }
                this._metDataSetComboListModel.removeElement(list);
            }
            if (!bl) continue;
            this._metDataSetCombo.setSelectedIndex(this._metDataSetCombo.getItemCount() > 0 ? 0 : -1);
        }
        return object;
    }

    ObsDatasetManager obsDataSetRename(Window object, ObsDatasetManager obsDatasetManager, String string, String object2) {
        if (obsDatasetManager == null) {
            return null;
        }
        String string2 = WqI18n.a("ObsData.Editor.Rename.Title").getText();
        object = object instanceof JFrame ? new NameDialog((Frame)((JFrame)object), string2, true, 2) : new NameDialog((Dialog)((JDialog)object), string2, true, 2);
        object.setName(string);
        object.setDescription((String)object2);
        object.setLocationRelativeTo((Component)ClientApp.frame());
        WaterQualityMode.addExistingNames((NameDialog)object, ObsDatasetManager.class.getName());
        object.setVisible(true);
        if (object.isCanceled()) {
            return null;
        }
        string = object.getName();
        object2 = MODELNAME + File.separator + "wq";
        string = ClientApp.Workspace().getManagerIdentifier((String)object2, MetData.class.getName(), string, ".met");
        string.setDescription(object.getDescription());
        obsDatasetManager.setDescription(object.getDescription());
        object = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        try {
            object2 = object.newFile(ClientApp.app().getUser(), (Identifier)string);
        }
        catch (RemoteException remoteException) {
            System.out.println("rename Observed Data: RemoteException " + String.valueOf(remoteException));
            remoteException.printStackTrace();
            return null;
        }
        if (object2 == null) {
            try {
                if (object.fileExists(string.getPath())) {
                    System.out.println("renameObservedData: found exising meterological data file " + string.getPath() + ". So stopped rename process");
                    ClientApp.app().postError("Renaming of meteorological data failed.\nAn existing meteorological data file named " + string.getPath() + " was found.", "Rename Failed");
                    return null;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println("renameObservedData: RemoteException " + String.valueOf(remoteException));
                remoteException.printStackTrace();
                return null;
            }
            System.out.println("renameObservedData: failed to open file " + string.getPath());
            ClientApp.app().postError("Renaming of meteorological data failed.\nFailed to open file" + string.getPath(), "Rename Failed");
            return null;
        }
        try {
            this._frame.setWaitCursor();
            if (ClientApp.Workspace().renameManager(MODELNAME, (Manager)obsDatasetManager, (Identifier)object2)) {
                object = ClientApp.Workspace().getManagerProxy(MODELNAME, (Identifier)object2);
                this._obsDataSetCombo.setSelectedItem(object);
                this._obsDataSetCombo.repaint();
                object = (ObsDatasetManager)object.getManager();
                return object;
            }
        }
        finally {
            this._frame.setDefaultCursor();
        }
        return null;
    }

    public MetData metDataSetRename(Window object, MetData metData, String string, String object2) {
        if (metData == null) {
            return null;
        }
        object = object instanceof JFrame ? new NameDialog((Frame)((JFrame)object), "Rename Meteorological Dataset", true, 2) : new NameDialog((Dialog)((JDialog)object), "Rename Meteorological Dataset", true, 2);
        object.setName(string);
        object.setDescription((String)object2);
        object.setLocationRelativeTo((Component)ClientApp.frame());
        WaterQualityMode.addExistingNames((NameDialog)object, MetData.class.getName());
        object.setVisible(true);
        if (object.isCanceled()) {
            return null;
        }
        string = object.getName();
        object2 = MODELNAME + File.separator + "wq";
        string = ClientApp.Workspace().getManagerIdentifier((String)object2, MetData.class.getName(), string, ".met");
        string.setDescription(object.getDescription());
        metData.setDescription(object.getDescription());
        object = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        try {
            object2 = object.newFile(ClientApp.app().getUser(), (Identifier)string);
        }
        catch (RemoteException remoteException) {
            System.out.println("renameMeteoroligical Data: RemoteException " + String.valueOf(remoteException));
            remoteException.printStackTrace();
            return null;
        }
        if (object2 == null) {
            try {
                if (object.fileExists(string.getPath())) {
                    System.out.println("renameMeterologicalData: found exising meterological data file " + string.getPath() + ". So stopped rename process");
                    ClientApp.app().postError("Renaming of meteorological data failed.\nAn existing meteorological data file named " + string.getPath() + " was found.", "Rename Failed");
                    return null;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println("renameMeterologicalData: RemoteException " + String.valueOf(remoteException));
                remoteException.printStackTrace();
                return null;
            }
            System.out.println("renameMeterologicalData: failed to open file " + string.getPath());
            ClientApp.app().postError("Renaming of meteorological data failed.\nFailed to open file" + string.getPath(), "Rename Failed");
            return null;
        }
        try {
            this._frame.setWaitCursor();
            if (ClientApp.Workspace().renameManager(MODELNAME, (Manager)metData, (Identifier)object2)) {
                object = ClientApp.Workspace().getManagerProxy(MODELNAME, (Identifier)object2);
                this._metDataSetCombo.setSelectedItem(object);
                this._metDataSetCombo.repaint();
                object = (MetData)object.getManager();
                return object;
            }
        }
        finally {
            this._frame.setDefaultCursor();
        }
        return null;
    }

    ObsDatasetManager obsDataSetSaveAs(Window object, ObsDatasetManager obsDatasetManager, String string, String object2) {
        if (obsDatasetManager == null) {
            return null;
        }
        String string2 = WqI18n.a("ObsData.Editor.SaveAs.Title").getText();
        string2 = object instanceof JFrame ? new NameDialog((Frame)((JFrame)object), string2, true, 2) : new NameDialog((Dialog)((JDialog)object), string2, true, 2);
        string2.setName(string);
        string2.setDescription((String)object2);
        string2.setLocationRelativeTo((Component)ClientApp.frame());
        WaterQualityMode.addExistingNames((NameDialog)string2, ObsDatasetManager.class.getName());
        string2.setVisible(true);
        if (string2.isCanceled()) {
            return null;
        }
        try {
            string = ClientApp.Workspace();
            object2 = string2.getDescription();
            string2 = string2.getName();
            String string3 = MODELNAME + File.separator + "wq";
            string2 = string.getManagerIdentifier(string3, ObsDatasetManager.class.getName(), string2, ".obs");
            string3 = string.createFile(new Identifier(string2.getPath()));
            if (string3 == null) {
                string3 = string.openFile(new Identifier(string2.getPath()), false);
            }
            string2.setFile(string3.getFile());
            string2.setDescription((String)object2);
            object2 = string.getManagerProxy(MODELNAME, ObsDatasetManager.class.getName(), obsDatasetManager.getIndex());
            if (object2 == null) {
                System.out.println("saveAsNetwork: failed to find ManagerProxy for " + obsDatasetManager.getName());
                return null;
            }
            object2 = (ObsDatasetManager)string.newManager(MODELNAME, ObsDatasetManager.class.getName());
            if (object2 == null) {
                JOptionPane.showMessageDialog((Component)object, "Failed to create new Observed Dataset", "Error", 0);
                return null;
            }
            object2.setIdentifier((Identifier)string2);
            ((ObsDatasetManager)object2).setName(string2.getName());
            ((ObsDatasetManager)object2).setDescription(string2.getDescription());
            string.saveManagerAs(MODELNAME, (Manager)obsDatasetManager, (Manager)object2);
            object = string.getManagerProxy(MODELNAME, ObsDatasetManager.class.getName(), object2.getIndex());
            object2.setIdentifier((Identifier)string2);
            ((ObsDatasetManager)object2).setName(string2.getName());
            ((ObsDatasetManager)object2).setDescription(string2.getDescription());
            object2.setModified(false);
            this._obsDataSetComboListModel.addElement(object);
            this._obsDataSetCombo.setSelectedItem(object);
            object = object2;
            return object;
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public MetData metDataSetSaveAs(Window object, MetData metData, String string, String object2) {
        if (metData == null) {
            return null;
        }
        Object object3 = object instanceof JFrame ? new NameDialog((Frame)((JFrame)object), "Save As Meteorological Dataset", true, 2) : new NameDialog((Dialog)((JDialog)object), "Save As Meteorological Dataset", true, 2);
        object3.setName(string);
        object3.setDescription((String)object2);
        object3.setLocationRelativeTo((Component)ClientApp.frame());
        WaterQualityMode.addExistingNames(object3, MetData.class.getName());
        object3.setVisible(true);
        if (object3.isCanceled()) {
            return null;
        }
        try {
            string = ClientApp.Workspace();
            object2 = object3.getDescription();
            object3 = object3.getName();
            String string2 = MODELNAME + File.separator + "wq";
            object3 = string.getManagerIdentifier(string2, MetData.class.getName(), (String)object3, ".met");
            string2 = string.createFile(new Identifier(object3.getPath()));
            if (string2 == null) {
                string2 = string.openFile(new Identifier(object3.getPath()), false);
            }
            object3.setFile(string2.getFile());
            object3.setDescription((String)object2);
            object2 = string.getManagerProxy(MODELNAME, MetData.class.getName(), metData.getIndex());
            if (object2 == null) {
                System.out.println("saveAsNetwork: failed to find ManagerProxy for " + metData.getName());
                return null;
            }
            object2 = (MetData)string.newManager(MODELNAME, MetData.class.getName());
            if (object2 == null) {
                JOptionPane.showMessageDialog((Component)object, "Failed to create new Meterological Dataset", "Error", 0);
                return null;
            }
            object2.setIdentifier((Identifier)object3);
            ((MetData)object2).setName(object3.getName());
            ((MetData)object2).setDescription(object3.getDescription());
            string.saveManagerAs(MODELNAME, (Manager)metData, (Manager)object2);
            object = string.getManagerProxy(MODELNAME, MetData.class.getName(), object2.getIndex());
            object2.setIdentifier((Identifier)object3);
            ((MetData)object2).setName(object3.getName());
            ((MetData)object2).setDescription(object3.getDescription());
            object2.setModified(false);
            this._metDataSetComboListModel.addElement(object);
            this._metDataSetCombo.setSelectedItem(object);
            object = object2;
            return object;
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public GeometryEditor displayGeometryEditor() {
        return this._editorLaucher.displayGeometryEditor(this._geometry);
    }

    public void setGeometry(WqGeometry wqGeometry) {
        if (wqGeometry != this._geometry) {
            String string = WqI18n.a("Geometry.Type").getText();
            if (this.checkAndSaveManagerChanges(MODELNAME, this._geometry, WqGeometry.class.getName(), string, false) <= 0) {
                return;
            }
            if (this._geometry != null) {
                this._geometry.removeModifiableListener(this._modifiableListener);
            }
            this._geometry = wqGeometry;
            if (this._geometry != null) {
                int n = this._geometry.getNetworkId();
                ManagerProxy managerProxy = ClientApp.Workspace().getManagerProxy(MODELNAME, RssSystem.class.getName(), n);
                this._network = managerProxy != null ? (RssSystem)managerProxy.loadManager(null, null) : null;
            } else {
                this._network = null;
            }
            this.updateManagerMaps();
            if (this._geometry != null) {
                this._geometry.setModified(false);
                WaterQualityMode.updateMgrField((Manager)this._geometry, this._geometryCombo, this._geometry.isModified());
                this._geometry.addModifiableListener(this._modifiableListener);
                this._wqCells = new ReachCellsMapObject(this._geometry);
            }
        }
    }

    public WqGeometry getGeometry() {
        return this._geometry;
    }

    public void setMassInjectionSet(MassInjectionSetManager object) {
        if (object != this._massInjectionSet) {
            String string = WqI18n.a("MI.Type").getText();
            if (this.checkAndSaveManagerChanges(MODELNAME, this._massInjectionSet, MassInjectionSetManager.class.getName(), string) <= 0) {
                return;
            }
            if (this._massInjectionSet != null) {
                this._massInjectionSet.removeModifiableListener(this._modifiableListener);
            }
            this._massInjectionSet = object;
            object = (MassInjectionManagerGlyph)this._frame.getMapPanel().findGlyphOfClass(MassInjectionManagerGlyph.class.getName());
            if (object != null) {
                ((MassInjectionManagerGlyph)((Object)object)).setSelectedMassInjectionSetManager(this._massInjectionSet);
            }
            this.updateManagerMaps();
            if (this._massInjectionSet != null) {
                this._massInjectionSet.setModified(false);
                WaterQualityMode.updateMgrField((Manager)this._massInjectionSet, this._massInjectCombo, this._massInjectionSet.isModified());
                this._massInjectionSet.addModifiableListener(this._modifiableListener);
            }
        }
    }

    public WqGeometry geometryOpen() {
        Object object = WqI18n.a("Geometry.Type").getText();
        String string = WqI18n.a("Geometry.Title.Open").getText();
        WaterQualityMode waterQualityMode = this;
        object = (WqGeometry)waterQualityMode.openManager(waterQualityMode._geometry, WqGeometry.class.getName(), (String)object, string, ".geometry");
        this.setGeometry((WqGeometry)((Object)object));
        return object;
    }

    public List<Identifier> deleteManager(Window serializable, String string, String string2, String string3, String object) {
        serializable = new ManagerChooser((Window)serializable, true, 2, 1L);
        serializable.setMultipleSelectionsAllowed(true);
        serializable.setTitle((String)object);
        serializable.setNameFilter("^[#_a-zA-Z0-9][^:].*");
        serializable.setManagerType(MODELNAME, string, string2, string3);
        serializable.setVisible(true);
        if (!serializable.ok()) {
            return Collections.emptyList();
        }
        int n = ((Vector)(serializable = serializable.getIdentifierList())).size();
        if (n == 0) {
            System.out.println("No " + string2 + " selected to delete");
            return Collections.emptyList();
        }
        object = new ArrayList();
        for (int i = 0; i < n; ++i) {
            string3 = (Identifier)((Vector)serializable).get(i);
            boolean bl = ClientApp.Workspace().deleteManager(MODELNAME, (Identifier)string3, true);
            if (!bl) {
                System.out.println("Unable to delete specified " + string2 + " " + string3.getPath());
                return object;
            }
            object.add(string3);
        }
        return object;
    }

    public InitialConditionsEditor displayInitialConditionsEditor() {
        return this._editorLaucher.displayInitialConditionsEditor();
    }

    public BoundaryConditionEditorDialog displayBoundaryConditionEditor() {
        return this._editorLaucher.displayBoundaryConditionEditor();
    }

    public DispersionCoefEditor displayDispersionCoeffEditor() {
        return this._editorLaucher.displayDispersionCoeffEditor();
    }

    public void modeClosing() {
        this._editorLaucher.resetEditors();
        super.modeClosing();
    }

    public void refreshMode() {
        this._editorLaucher.resetEditors();
    }

    public void updateWorkspace() {
        super.updateWorkspace();
        this.updateManagerMaps();
    }

    private void obsDataSetComboActionPerformed() {
        this._observedDatasetManager = null;
        this._observedDatasetManager = (ObsDatasetManager)WaterQualityMode.mgrComboActionPerformed(this._obsDataSetCombo);
        this.updateManagerMaps();
    }

    private void metDataSetComboActionPerformed() {
        this._metData = null;
        this._metData = (MetData)WaterQualityMode.mgrComboActionPerformed(this._metDataSetCombo);
        this.updateManagerMaps();
    }

    private void geometryComboActionPerformed() {
        WqGeometry wqGeometry = (WqGeometry)WaterQualityMode.mgrComboActionPerformed(this._geometryCombo);
        this.setGeometry(wqGeometry);
        this.updateManagerMaps();
    }

    private void massInjectionSetComboActionPerformed() {
        MassInjectionSetManager massInjectionSetManager = (MassInjectionSetManager)WaterQualityMode.mgrComboActionPerformed(this._massInjectCombo);
        this.setMassInjectionSet(massInjectionSetManager);
        this._frame.getMapPanel().paintMap();
    }

    private static Manager mgrComboActionPerformed(RmaJComboBox<ManagerProxy> managerProxy) {
        if ((managerProxy = (ManagerProxy)managerProxy.getSelectedItem()) == null || managerProxy == _noManagerProxy) {
            return null;
        }
        Manager manager = managerProxy.getManager();
        if (manager == null) {
            manager = ClientApp.Workspace().openManager(MODELNAME, managerProxy.getId());
        }
        return manager;
    }

    public void resetWorkspace() {
        super.resetWorkspace();
        this._networkFld.setEditable(false);
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        if (clientWorkspace == null) {
            return;
        }
        this._network = null;
        WaterQualityMode.updateMgrField((Manager)this._network, this._networkFld, false);
        this._geometry = null;
        this._wqCells = null;
        this._alignment = null;
        if (!this.openStreamAlignment(false)) {
            return;
        }
        this._massInjectionMgr = null;
        this.openMassInjectionManager();
        if (this._metStationSetDialog != null) {
            this._metStationSetDialog.setVisible(false);
            this._metStationSetDialog.dispose();
            this._metStationSetDialog = null;
        }
        this._metData = null;
        this._metDataSetComboListModel = WaterQualityMode.fillManagerCombo(MetData.class.getName(), this._metDataSetCombo);
        this._geometryComboListModel = WaterQualityMode.fillManagerCombo(WqGeometry.class.getName(), this._geometryCombo);
        this._observedDatasetManager = null;
        this._obsDataSetComboListModel = WaterQualityMode.fillManagerCombo(ObsDatasetManager.class.getName(), this._obsDataSetCombo);
        this._massInjectComboListModel = WaterQualityMode.fillManagerCombo(MassInjectionSetManager.class.getName(), this._massInjectCombo);
        super.resetWorkspace();
        this.updateManagerMaps();
        this._editorLaucher.setWorkspace((ManagerProxyListContainer)clientWorkspace);
    }

    private static RmaListModel<ManagerProxy> fillManagerCombo(String object, RmaJComboBox<ManagerProxy> rmaJComboBox) {
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        object = clientWorkspace.getManagerProxyList(MODELNAME, (String)object);
        ((Vector)object).sort(Comparator.comparing(ManagerProxy::getName));
        object = new RmaListModel(false, (Collection)object);
        object.add(0, (Object)_noManagerProxy);
        rmaJComboBox.setModel((ComboBoxModel)object);
        return object;
    }

    public void updateManagerMaps() {
        if (this._frame.getCurrentMode() != this) {
            return;
        }
        if (this._network != null) {
            WaterQualityMode.updateMgrField((Manager)this._network, this._networkFld, this._network.isModified());
            this._editConfigMenuItem.setSelected(true);
            this._editConfigMenuItem.setEnabled(true);
        } else {
            WaterQualityMode.updateMgrField((Manager)this._network, this._networkFld, false);
            this._editConfigMenuItem.setEnabled(false);
        }
        this.addManagerMaps();
        this._frame.getMapPanel().paintMap();
    }

    public void addManagerMaps() {
        Vector<Object> vector = new Vector<Object>();
        if (this._alignment != null) {
            vector.addElement(this._alignment);
        }
        if (this._network != null) {
            vector.addElement(this._network);
        }
        if (this._geometry != null) {
            vector.addElement((Object)this._geometry);
        }
        if (this._metData != null) {
            vector.addElement(this._metData);
        }
        if (this._observedDatasetManager != null) {
            vector.addElement(this._observedDatasetManager);
        }
        if (this._massInjectionMgr != null) {
            vector.addElement((Object)this._massInjectionMgr);
        }
        this._frame.getMapPanel().resetManagerMaps(vector);
        this._frame.setGlyphStateFromToolbar();
        EventQueue.invokeLater(() -> this.updateMassInjectionGlyph());
    }

    private void updateMassInjectionGlyph() {
        MassInjectionManagerGlyph massInjectionManagerGlyph = (MassInjectionManagerGlyph)this._frame.getMapPanel().findGlyphOfClass(MassInjectionManagerGlyph.class.getName());
        if (massInjectionManagerGlyph != null) {
            massInjectionManagerGlyph.setSelectedMassInjectionSetManager(this._massInjectionSet);
        }
    }

    protected Manager createNewManager(Manager manager, String string, String string2, String string3, String string4) {
        return this.createNewManager(manager, string, string2, string3, string4, "", null, (Window)this._frame);
    }

    protected Manager createNewManager(Manager manager, String string, String string2, String string3, String string4, String string5, RmaValidComponent object, Window object2) {
        if (this.checkAndSaveManagerChanges(MODELNAME, manager, string, string2) <= 0) {
            return manager;
        }
        object2 = new WaterQualityMode$3(this, (Window)object2, true, 3, 1L, (RmaValidComponent)object);
        if (object != null) {
            object2.setAccessoryPanel((JPanel)object);
        }
        object2.setNameFilter("^[#_a-zA-Z0-9][^:].*");
        object2.setNameDocument((Document)new FilenameDocument());
        object2.setTitle(string3);
        object2.setManagerType(MODELNAME, string, string2, string4);
        object2.pack();
        object2.setVisible(true);
        if (!object2.ok()) {
            return manager;
        }
        string3 = object2.getIdentifier();
        if (string3 == null) {
            return manager;
        }
        object = string3.getName().trim();
        object2 = RMAIO.userNameToFileName((String)object);
        File file = new File(ClientApp.Workspace().getWorkspacePath());
        file = new File(file, MODELNAME);
        if (string5 != null && !string5.isEmpty()) {
            file = new File(file, string5);
        }
        file = new File(file, (String)object2 + (String)(string4.length() > 0 && string4.charAt(0) == '.' ? string4 : "." + string4));
        string4 = new Identifier(file.getAbsolutePath());
        string4.setName((String)object);
        string4.setClassName(string);
        string4.setDescription(string3.getDescription());
        string = ClientApp.Workspace().newManager(MODELNAME, string);
        if (string == null) {
            return manager;
        }
        string.setIdentifier((Identifier)string4);
        string.setName(string3.getName());
        string.setDescription(string3.getDescription());
        string3 = ClientApp.Workspace();
        if (string3 == null) {
            return manager;
        }
        boolean bl = ClientApp.Workspace().saveManagerAs(MODELNAME, (Manager)string, (Identifier)string4);
        if (!bl) {
            string = WqI18n.a("WqModule.Msg.FailedCreateMgr").format((Object)string2);
            string2 = WqI18n.a("WqModule.Msg.FailedCreateMgr.Title").getText();
            ClientApp.app().postError(string, string2);
            return manager;
        }
        if (manager != null) {
            RSS.Workspace().unloadManager(MODELNAME, manager.getIdentifier());
        }
        return string;
    }

    protected Manager openManager(Manager object, String string, String string2, String string3, String string4) {
        block7: {
            block6: {
                ManagerChooser managerChooser;
                block5: {
                    if (this.checkAndSaveManagerChanges(MODELNAME, (Manager)object, string, string2) <= 0) {
                        return object;
                    }
                    this._frame.setWaitCursor();
                    try {
                        managerChooser = new ManagerChooser((Frame)this._frame, true, 4, 1L);
                        managerChooser.setTitle(string3);
                        managerChooser.setManagerType(MODELNAME, string, string2, string4);
                        managerChooser.setVisible(true);
                        if (managerChooser.ok()) break block5;
                        string = object;
                    }
                    catch (Throwable throwable) {
                        this._frame.setDefaultCursor();
                        this.updateMenus();
                        throw throwable;
                    }
                    this._frame.setDefaultCursor();
                    this.updateMenus();
                    return string;
                }
                string = managerChooser.getIdentifier();
                if (string != null) break block6;
                string = object;
                this._frame.setDefaultCursor();
                this.updateMenus();
                return string;
            }
            string = this.openManager((Identifier)string, string2);
            if (string != null) break block7;
            this._frame.setDefaultCursor();
            this.updateMenus();
            return object;
        }
        object = string;
        this._frame.setDefaultCursor();
        this.updateMenus();
        return object;
    }

    public Manager openManager(Identifier object, String string) {
        object = ClientApp.Workspace().openManager(MODELNAME, object);
        if (object == null) {
            object = WqI18n.a("WqModule.Msg.FailedOpenMgr").format((Object)string);
            string = WqI18n.a("WqModule.Msg.FailedOpenMgr.Title").getText();
            ClientApp.app().postError((String)object, string);
            return null;
        }
        return object;
    }

    protected void updateMenus() {
    }

    protected boolean openStreamAlignment(boolean bl) {
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        if (clientWorkspace == null) {
            return false;
        }
        Vector vector = clientWorkspace.getManagerIDList(StreamAlignment.class.getName());
        if (vector.size() <= 0) {
            this._alignment = (StreamAlignment)clientWorkspace.newManager(StreamAlignment.class.getName());
            vector = this._alignment.getIdentifier();
            vector.setPath("stream.align");
            RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            Identifier identifier = new Identifier(ClientApp.Workspace().getWorkspacePath() + "/stream.align");
            try {
                identifier = rmiFileManager.openFile(ClientApp.app().getUser(), identifier);
                if (identifier != null) {
                    System.out.println("openStreamAlignment:found existing stream.align file.");
                    this._alignment.readFile(identifier);
                    vector.setName(this._alignment.getName());
                    vector.setDescription(this._alignment.getDescription());
                }
            }
            catch (RemoteException remoteException) {
                System.out.println("openStreamAlignment: Exception opening stream.align file. RemoteException " + String.valueOf(remoteException));
            }
            clientWorkspace.saveManager((Manager)this._alignment);
        } else if ((vector = (Identifier)vector.elementAt(0)) != null) {
            this._alignment = (StreamAlignment)clientWorkspace.openManager((Identifier)vector);
            if (this._alignment == null) {
                String string = WqI18n.a("WqModule.Msg.FailedOpenAlignment").getText();
                ClientApp.app().postMessage(string, "", -1);
                return false;
            }
        }
        return true;
    }

    public ParameterSetEditor displayWqParameterEditor() {
        return this._editorLaucher.displayWqParameterEditor();
    }

    public ConstituentSetEditor displayWqConstituentsEditor() {
        return this._editorLaucher.displayWqConstituentsEditor();
    }

    List<Identifier> constituentSetDelete(HecClientFrame hecClientFrame, ConstituentSetManager constituentSetManager) {
        String string;
        ArrayList<Identifier> arrayList = new ArrayList<Identifier>();
        String string2 = WqI18n.a("Constituent.Delete").format((Object)((JsonManager)constituentSetManager).getName());
        int n = JOptionPane.showConfirmDialog((Component)hecClientFrame, string2, string = WqI18n.a("Constituent.Delete.Title").getText(), 0);
        if (n == 0) {
            Identifier identifier = constituentSetManager.getIdentifier();
            boolean bl = ClientApp.Workspace().deleteManager(MODELNAME, identifier, true);
            if (bl) {
                arrayList.add(identifier);
            }
        }
        return arrayList;
    }

    public static void addExistingNames(NameDialog nameDialog, String list) {
        list = ClientApp.Workspace().getManagerIDList(MODELNAME, (String)((Object)list));
        list = list.stream().map(identifier -> identifier.getName()).collect(Collectors.toList());
        nameDialog.setExistingNames(list);
    }

    ConstituentSetManager constituentSetRename(HecClientFrame object, ConstituentSetManager constituentSetManager) {
        Object object2 = null;
        if (constituentSetManager != null) {
            if (constituentSetManager.isModified()) {
                ClientApp.Workspace().saveManager(MODELNAME, (Manager)constituentSetManager);
            }
            object = new NameDialog((Frame)object, WqI18n.a("Constituent.Rename.Title").getText(), true, 2);
            WaterQualityMode.addExistingNames((NameDialog)object, ConstituentSetManager.class.getName());
            ConstituentSet constituentSet = null;
            if (constituentSetManager != null) {
                constituentSet = constituentSetManager.getSet();
            }
            if (constituentSet != null) {
                object.setName(constituentSet.getName());
                object.setDescription(constituentSet.getDescription());
                object.setVisible(true);
                if (!object.isCanceled()) {
                    object2 = object.getName();
                    object = object.getDescription();
                    object2 = WaterQualityMode.constituentSetRename(constituentSetManager, object2, (String)object);
                }
            }
        }
        return object2;
    }

    private static ConstituentSetManager constituentSetRename(ConstituentSetManager object, String string, String string2) {
        Identifier identifier;
        Object object2 = null;
        Identifier identifier2 = ClientApp.Workspace().getManagerIdentifier(MODELNAME, ConstituentSetManager.class.getName(), string, ".constituentSet");
        identifier2.setDescription(string2);
        string = WaterQualityMode.getManagerPath(string, "wq/", ".constituentSet");
        identifier2.setPath(string);
        string = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        try {
            identifier = string.newFile(ClientApp.app().getUser(), identifier2);
            if (identifier == null) {
                if (string.fileExists(identifier2.getPath())) {
                    object = WqI18n.a("Constituent.Rename.Exists").format((Object)identifier2.getPath());
                    ClientApp.app().postError((String)object, WqI18n.a("Constituent.Rename.Error.Title").getText());
                    return null;
                }
                object = WqI18n.a("Constituent.Rename.Open").format((Object)identifier2.getPath());
                ClientApp.app().postError((String)object, WqI18n.a("Constituent.Rename.Error.Title").getText());
                return null;
            }
        }
        catch (RemoteException remoteException) {
            logger.log(Level.WARNING, "rename: RemoteException ", remoteException);
            return null;
        }
        object.setName(identifier.getName());
        object.setDescription(string2);
        if (ClientApp.Workspace().renameManager(MODELNAME, (Manager)object, identifier)) {
            object2 = object;
        }
        return object2;
    }

    ConstituentSetManager constituentSetSaveAs(Frame frame, ConstituentSetManager constituentSetManager) {
        if (constituentSetManager != null) {
            if (constituentSetManager.isModified()) {
                ClientApp.Workspace().saveManager(MODELNAME, (Manager)constituentSetManager);
            }
            Object object = WqI18n.a("Constituent.SaveAs.Title").format((Object)((JsonManager)constituentSetManager).getName());
            object = new NameDialog(frame, object, true, 2);
            object.setName(((JsonManager)constituentSetManager).getName());
            object.setDescription(((JsonManager)constituentSetManager).getDescription());
            object.setLocationRelativeTo((Component)ClientApp.frame());
            WaterQualityMode.addExistingNames((NameDialog)object, ConstituentSetManager.class.getName());
            object.setVisible(true);
            if (object.isCanceled()) {
                return null;
            }
            ClientWorkspace clientWorkspace = ClientApp.Workspace();
            String string = object.getDescription();
            if ((object = object.getName()).length() == 0) {
                JOptionPane.showMessageDialog(frame, WqI18n.a("Constituent.SaveAs.InvalidName").getText());
                return null;
            }
            Identifier identifier = clientWorkspace.getManagerIdentifier(MODELNAME, ConstituentSetManager.class.getName(), object, ".constituentSet");
            object = WaterQualityMode.getManagerPath(object, "wq/", ".constituentSet");
            identifier.setPath(object);
            object = clientWorkspace.createFile(new Identifier(identifier.getPath()));
            if (object == null) {
                object = clientWorkspace.openFile(new Identifier(identifier.getPath()), false);
            }
            identifier.setFile(object.getFile());
            identifier.setDescription(string);
            object = clientWorkspace.getManagerProxy(MODELNAME, ConstituentSetManager.class.getName(), constituentSetManager.getIndex());
            if (object == null) {
                logger.log(Level.WARNING, "saveAs: failed to find ManagerProxy for {0}", ((JsonManager)constituentSetManager).getName());
                return null;
            }
            object = (ConstituentSetManager)clientWorkspace.newManager(MODELNAME, ConstituentSetManager.class.getName());
            if (object == null) {
                JOptionPane.showMessageDialog(frame, "Failed to create new Constituent Set", "Error", 0);
                return null;
            }
            int n = ((JsonManager)((Object)object)).getIndex();
            object.setIdentifier(identifier);
            ((ConstituentSetManager)((Object)object)).setName(identifier.getName());
            ((ConstituentSetManager)((Object)object)).setDescription(identifier.getDescription());
            clientWorkspace.saveManagerAs(MODELNAME, (Manager)constituentSetManager, (Manager)object);
            object.setIndex(n);
            object.setIdentifier(identifier);
            ((ConstituentSetManager)((Object)object)).setName(identifier.getName());
            ((ConstituentSetManager)((Object)object)).setDescription(identifier.getDescription());
            if (!clientWorkspace.saveManager(MODELNAME, (Manager)object)) {
                logger.log(Level.WARNING, "saveAs: Failed to save new Constituent Set:{0}", ((JsonManager)((Object)object)).getName());
            }
            clientWorkspace.saveWorkspace();
            return object;
        }
        return null;
    }

    ConstituentSetManager constituentSetNew(Frame frame) {
        frame = new NameDialog(frame, WqI18n.a("Constituent.New.Title").getText(), true, 2);
        List<String> list = this.getExistingNames(ConstituentSetManager.class.getName());
        frame.setExistingNames(list);
        frame.setVisible(true);
        if (frame.isCanceled()) {
            return null;
        }
        return this.constituentSetNew(frame.getName(), frame.getDescription());
    }

    private ConstituentSetManager constituentSetNew(String string, String string2) {
        if (this.hasManagerWithName(string, ConstituentSetManager.class.getName())) {
            return null;
        }
        Object object = ClientApp.Workspace();
        object = (ConstituentSetManager)object.newManager(MODELNAME, ConstituentSetManager.class.getName());
        string = new WQConstituentSet(string, string2);
        ((ConstituentSetManager)((Object)object)).setSet((ConstituentSet)string);
        string2 = object.getIdentifier();
        string2.setName(((JsonManager)((Object)object)).getName());
        string2.setDescription(string.getDescription());
        string = WaterQualityMode.getManagerPath(((JsonManager)((Object)object)).getName(), "wq/", ".constituentSet");
        string2.setPath(string);
        boolean bl = ClientApp.Workspace().saveManagerAs(MODELNAME, (Manager)object, (Identifier)string2);
        if (!bl) {
            String string3 = WqI18n.a("Constituent.Type").getText();
            string3 = WqI18n.a("WqModule.Msg.FailedCreateMgr").format((Object)string3);
            string2 = WqI18n.a("WqModule.Msg.FailedCreateMgr.Title").getText();
            ClientApp.app().postError(string3, string2);
            return null;
        }
        return object;
    }

    public static String getManagerPath(String string, String string2, String string3) {
        string = RMAIO.userNameToFileName((String)string);
        string = string2.concat(string).concat(string3);
        string = RMAIO.concatPath((String)MODELNAME, (String)string);
        string = ClientApp.Workspace().makeAbsolutePath(string);
        return string;
    }

    public AlternativeEditor displayAlternativeEditor() {
        return this.displayAlternativeEditor(null);
    }

    public AlternativeEditor displayAlternativeEditor(RssAlt object) {
        if (ClientApp.Workspace().getManagerIDList(MODELNAME, RssSystem.class.getName()).size() <= 0) {
            object = WqI18n.a("WqModule.Msg.CreateNetwork").getText();
            String string = WqI18n.a("WqModule.Msg.CreateNetwork.Title").getText();
            ClientApp.app().postWarning((String)object, string);
            return null;
        }
        try {
            this._frame.setWaitCursor();
            if (this._alternativeEditor == null) {
                this._alternativeEditor = new AlternativeEditor((Frame)this._frame, false);
                this._alternativeEditor.setLocationByPlatform(true);
                this._alternativeEditor.setLocation(this._frame.getX() + this._frame.getWidth() / 4, this._frame.getY() + this._frame.getHeight() / 4);
            }
            this._alternativeEditor.fillForm((ManagerProxyListContainer)ClientApp.Workspace());
            if (object != null) {
                ((AbstractAlternativeEditor)this._alternativeEditor).setSelectedAlternative(object.getName());
            } else {
                ((AbstractAlternativeEditor)this._alternativeEditor).setSelectedAlternative(null);
            }
            ((AbstractAlternativeEditor)this._alternativeEditor).setVisible(true);
            this._alternativeEditor.setAlwaysOnTop(true);
            this._alternativeEditor.toFront();
            this._alternativeEditor.requestFocus();
            this._alternativeEditor.setAlwaysOnTop(false);
        }
        finally {
            this._frame.setDefaultCursor();
        }
        return this._alternativeEditor;
    }

    public DefaultJPanel[] getModuleOptionsPanels() {
        DefaultJPanel[] defaultJPanelArray = super.getModuleOptionsPanels();
        int n = defaultJPanelArray != null ? defaultJPanelArray.length : 0;
        int n2 = n + 1;
        DefaultJPanel[] defaultJPanelArray2 = new DefaultJPanel[n2];
        for (int i = 0; i < n; ++i) {
            defaultJPanelArray2[i] = defaultJPanelArray[i];
        }
        if (this._advancedOptionsPanel == null) {
            this._advancedOptionsPanel = new ResSimAdvancedOptionsPanel();
        }
        defaultJPanelArray2[defaultJPanelArray2.length - 1] = this._advancedOptionsPanel;
        return defaultJPanelArray2;
    }

    public void refreshGeometryField() {
        if (this._geometry != null) {
            EventQueue.invokeLater(() -> WaterQualityMode.updateMgrField((Manager)this._geometry, this._geometryCombo, this._geometry.isModified()));
        }
    }

    public void geometryDeleted(ManagerProxy managerProxy) {
        if (managerProxy == null) {
            return;
        }
        this._geometryCombo.removeItem((Object)managerProxy);
    }

    public void massInjectionSetDeleted(ManagerProxy managerProxy) {
        if (managerProxy == null) {
            return;
        }
        this._massInjectCombo.removeItem((Object)managerProxy);
    }

    public boolean validateManagers() {
        boolean bl = this.validateManagers(MetData.class.getName(), "Meteorological Data");
        if (!bl) {
            return bl;
        }
        bl = this.validateManagers(WqGeometry.class.getName(), WqI18n.a("Geometry.Type").getText());
        if (!bl) {
            return bl;
        }
        bl = this.validateManagers(InitialConditionSetManager.class.getName(), WqI18n.a("IC.Type").getText());
        if (!bl) {
            return bl;
        }
        bl = this.validateManagers(BoundaryConditionSetManager.class.getName(), WqI18n.a("BC.Type").getText());
        if (!bl) {
            return bl;
        }
        bl = this.validateManagers(ObsDatasetManager.class.getName(), WqI18n.a("ObsData.Type").getText());
        if (!bl) {
            return bl;
        }
        bl = this.validateManagers(ParameterSetManager.class.getName(), WqI18n.a("Parameter.Type").getText());
        if (!bl) {
            return bl;
        }
        bl = this.validateManagers(ConstituentSetManager.class.getName(), WqI18n.a("Constituent.Type").getText());
        if (!bl) {
            return bl;
        }
        bl = this.validateManagers(DispersionSetManager.class.getName(), WqI18n.a("Dispersion.Type").getText());
        if (!bl) {
            return bl;
        }
        bl = this.validateManagers(MassInjectionSetManager.class.getName(), WqI18n.a("MI.Type").getText());
        if (!bl) {
            return bl;
        }
        if (this._massInjectionMgr != null && this._massInjectionMgr.isModified()) {
            ClientApp.Workspace().saveManager(MODELNAME, (Manager)this._massInjectionMgr);
        }
        return bl;
    }

    protected boolean validateManagers(String string, String string2) {
        Object object = ClientApp.Workspace().getManagerIDList(MODELNAME, string);
        ArrayList<Identifier> arrayList = new ArrayList<Identifier>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        object = ((Vector)object).iterator();
        while (object.hasNext()) {
            Identifier identifier = (Identifier)object.next();
            identifier = ClientApp.Workspace().getManager(MODELNAME, identifier);
            if (identifier == null || (identifier = identifier.getManager()) == null || !identifier.isModified()) continue;
            arrayList.add(identifier);
            arrayList2.add(string2);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            int n = this.checkAndSaveManagerChanges(MODELNAME, (Manager)arrayList.get(i), string, (String)arrayList2.get(i), false);
            if (n != 0) continue;
            return false;
        }
        return true;
    }

    private boolean openMassInjectionManager() {
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        if (clientWorkspace == null) {
            return false;
        }
        Vector vector = clientWorkspace.getManagerIDList(MODELNAME, MassInjectionManager.class.getName());
        if (vector.size() <= 0) {
            this._massInjectionMgr = (MassInjectionManager)clientWorkspace.newManager(MODELNAME, MassInjectionManager.class.getName());
            this._massInjectionMgr.setName("Mass Injection Sites");
            vector = this._massInjectionMgr.getIdentifier();
            vector.setName("Mass Injection Sites");
            vector.setDescription("Manager to hold Watershed Mass Injection Sites");
            vector.setPath(clientWorkspace.getWorkspacePath() + "/rss/wq/massInjectionSites.massInject");
            try {
                RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
                if (rmiFileManager.fileExists(vector.getPath())) {
                    logger.log(Level.INFO, "found existing massInjections file. " + vector.getPath() + " reading...");
                    rmiFileManager = rmiFileManager.openFile(ClientApp.app().getUser(), (Identifier)vector);
                    if (rmiFileManager != null) {
                        this._massInjectionMgr.readFile((Identifier)rmiFileManager);
                    }
                }
            }
            catch (RemoteException remoteException) {
                logger.log(Level.WARNING, "openMassInjectionManager: error reading " + vector.getPath() + " file ", remoteException);
            }
            clientWorkspace.saveManager(MODELNAME, (Manager)this._massInjectionMgr);
            clientWorkspace.saveWorkspace();
        } else if ((vector = (Identifier)vector.elementAt(0)) != null) {
            this._massInjectionMgr = (MassInjectionManager)clientWorkspace.openManager(MODELNAME, (Identifier)vector);
            if (this._massInjectionMgr == null) {
                JOptionPane.showMessageDialog((Component)this._frame, "Failed to Open Mass Injection Manager");
                return false;
            }
        }
        return true;
    }

    public boolean objectPopupMenu(NamedType namedType, LocalPt localPt) {
        if (namedType instanceof WQMassInjectionSite) {
            return this.objectPopupMenu((WQMassInjectionSite)namedType, localPt);
        }
        if (namedType instanceof ObservedStationNamedType) {
            return this.objectPopupMenu((ObservedStationNamedType)namedType, localPt);
        }
        return false;
    }

    public boolean objectPopupMenu(ObservedStationNamedType observedStationNamedType, LocalPt localPt) {
        ObservedStationMouseHandler observedStationMouseHandler = new ObservedStationMouseHandler(this);
        return observedStationMouseHandler.a(observedStationNamedType, localPt);
    }

    public boolean objectPopupMenu(WQMassInjectionSite wQMassInjectionSite, LocalPt localPt) {
        MassInjectionSiteMouseHandler massInjectionSiteMouseHandler = new MassInjectionSiteMouseHandler(this);
        return massInjectionSiteMouseHandler.a(wQMassInjectionSite, localPt);
    }

    public MassInjectionManager getMassInjectionManager() {
        return this._massInjectionMgr;
    }

    public StreamAlignment getStreamAlignment() {
        return this._alignment;
    }

    @Override
    public MassInjectionSetManager getMassInjectionSetManager() {
        return this._massInjectionSet;
    }

    @Override
    public MassInjectionManager getMassInjectionMgr() {
        return this._massInjectionMgr;
    }

    public WqTsTable displayWqInputsDialog() {
        return this._editorLaucher.displayWqTsTable((ManagerProxyListContainer)ClientApp.Workspace());
    }

    public String getScriptableName() {
        return this._modeName;
    }

    private static /* synthetic */ boolean lambda$metDatasetDelete$13(MetData metData, Identifier identifier) {
        return identifier.getName().equals(metData.getName());
    }

    private static /* synthetic */ boolean lambda$obsDatasetDelete$12(ObsDatasetManager obsDatasetManager, Identifier identifier) {
        return identifier.getName().equals(obsDatasetManager.getName());
    }

    private /* synthetic */ void lambda$obsDatasetNew$10(NewObsStationSetPanel object) throws IOException {
        String string = ((NewObsStationSetPanel)object).getName();
        if (string == null || string.isEmpty()) {
            throw new IOException(WqI18n.a("ObsData.Editor.Error.New.Name.Empty").getText());
        }
        if (this.hasManagerWithName(string, ObsDatasetManager.class.getName())) {
            object = WqI18n.a("ObsData.Editor.Error.New.Name.Repeat").getText();
            throw new IOException((String)object);
        }
        if (this.hasManagerWithName(string, MetData.class.getName())) {
            object = WqI18n.a("MetData.Menu.RepeatName").getText();
            throw new IOException((String)object);
        }
        if ((object = ((NewObsStationSetPanel)object).getSelectedStations()) == null || object.isEmpty()) {
            object = WqI18n.a("ObsData.Editor.Error.New.Station.None").getText();
            throw new IOException((String)object);
        }
    }

    static {
        logger = Logger.getLogger(WaterQualityMode.class.getName());
    }
}

