/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client;

import hec.clientapp.client.HecClientFrame;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.model.AbstractTSRecord;
import hec.rss.client.DeleteVariantAction;
import hec.rss.model.PDCRecord;
import hec.rss.model.RssAlt;
import hec.rss.model.TsVariant;
import hec.rss.wq.client.WqTsTable$1;
import hec.rss.wq.client.WqTsTable$2;
import hec.rss.wq.client.WqTsTable$3;
import hec.rss.wq.util.WqI18n;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.table.TableRowSorter;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.list.RmaListModel;

public class WqTsTable
extends RmaJDialog {
    private RmaJComboBox<ManagerProxy> _altCombo;
    private RmaJComboBox<TsVariant> _variantCombo;
    private RmaJTable _tsTable;
    private RmaJTable _pdcTable;
    private ButtonCmdPanel _cmdPanel;
    private TsVariant _standAloneVariant;
    private boolean _fillingForm;
    private JButton _deleteBtn;

    public WqTsTable(HecClientFrame hecClientFrame, ManagerProxyListContainer managerProxyListContainer) {
        super((Frame)hecClientFrame, false);
        this.buildControls();
        this.addListeners();
        this.fillAltCombo(managerProxyListContainer);
        EventQueue.invokeLater(() -> {
            if (this._altCombo.getSelectedItem() != null) {
                WqTsTable wqTsTable = this;
                wqTsTable.fillForm((ManagerProxy)wqTsTable._altCombo.getSelectedItem());
            }
        });
        this.pack();
        this.setSize(1000, 500);
        WqTsTable wqTsTable = this;
        wqTsTable.setLocationRelativeTo(wqTsTable.getParent());
    }

    private void buildControls() {
        this._standAloneVariant = new TsVariant("Standalone");
        this.getContentPane().setLayout(new GridBagLayout());
        Object object = WqI18n.a("WqTsTable.Title").getText();
        this.setTitle((String)object);
        object = WqI18n.a("WqTsTable.Label.Alternative").createJLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)object, gridBagConstraints);
        this._altCombo = new RmaJComboBox();
        ((JLabel)object).setLabelFor((Component)this._altCombo);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._altCombo, gridBagConstraints);
        object = WqI18n.a("WqTsTable.Label.Variant").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)object, gridBagConstraints);
        this._variantCombo = new RmaJComboBox();
        ((JLabel)object).setLabelFor((Component)this._variantCombo);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._variantCombo, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add(new JSeparator(), gridBagConstraints);
        object = WqI18n.a("WqTsTable.Label.TS").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add((Component)object, gridBagConstraints);
        Object[] objectArray = new String[]{WqI18n.a("WqTsTable.Header.Index").getText(), WqI18n.a("WqTsTable.Header.Type").getText(), WqI18n.a("WqTsTable.Header.Name").getText(), WqI18n.a("WqTsTable.Header.Parameter").getText(), WqI18n.a("WqTsTable.Header.DssFile").getText(), WqI18n.a("WqTsTable.Header.DssPath").getText()};
        WqTsTable wqTsTable = this;
        this._tsTable = new WqTsTable$1(wqTsTable, (Component)((Object)wqTsTable), objectArray);
        this._tsTable.removePopupMenuSumOptions();
        this._tsTable.removePopupMenuRowEditingOptions();
        this._tsTable.setHorizontalAlignment(0, 0);
        this._tsTable.setColumnWidths(new int[]{50, 70, 240, 137, 300, 300});
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._tsTable.getScrollPane(), gridBagConstraints);
        object = WqI18n.a("WqTsTable.Label.PDC").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add((Component)object, gridBagConstraints);
        WqTsTable wqTsTable2 = this;
        this._pdcTable = new WqTsTable$2(wqTsTable2, (Component)((Object)wqTsTable2), objectArray);
        this._pdcTable.removePopupMenuSumOptions();
        this._pdcTable.removePopupMenuRowEditingOptions();
        this._pdcTable.setHorizontalAlignment(0, 0);
        this._pdcTable.setColumnWidths(new int[]{50, 70, 240, 137, 300, 300});
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._pdcTable.getScrollPane(), gridBagConstraints);
        this._deleteBtn = new JButton("Delete Variant");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        WqTsTable wqTsTable3 = this;
        wqTsTable3.add(wqTsTable3._deleteBtn, gridBagConstraints);
        this._cmdPanel = new ButtonCmdPanel(256);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._cmdPanel, gridBagConstraints);
    }

    private void addListeners() {
        this._altCombo.addItemListener(itemEvent -> this.alternativeSelected(itemEvent));
        this._variantCombo.addItemListener(itemEvent -> this.variantSelected(itemEvent));
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new WqTsTable$3(this));
        this._deleteBtn.addActionListener(actionEvent -> this.deleteVariantAction());
    }

    private void deleteVariantAction() {
        TsVariant tsVariant = this.getSelectedVariant();
        DeleteVariantAction deleteVariantAction = new DeleteVariantAction(this.getSelectedAlternative(), tsVariant);
        if (deleteVariantAction.a((Component)((Object)this), true)) {
            this._variantCombo.removeItem((Object)tsVariant);
            this._tsTable.deleteCells();
            this._pdcTable.deleteCells();
        }
    }

    private RssAlt getSelectedAlternative() {
        Object object = (ManagerProxy)this._altCombo.getSelectedItem();
        object = (RssAlt)object.loadManager(null, null);
        return object;
    }

    private void variantSelected(ItemEvent object) {
        object = this.getSelectedVariant();
        this._deleteBtn.setEnabled(object != null);
        WqTsTable wqTsTable = this;
        wqTsTable.fillForm((ManagerProxy)wqTsTable._altCombo.getSelectedItem());
    }

    private void alternativeSelected(ItemEvent itemEvent) {
        if (2 == itemEvent.getStateChange()) {
            return;
        }
        itemEvent = (ManagerProxy)this._altCombo.getSelectedItem();
        this.fillVariantCombo((RssAlt)itemEvent.loadManager(null, null));
        this.fillForm((ManagerProxy)itemEvent);
    }

    private void fillAltCombo(ManagerProxyListContainer object) {
        object = object.getManagerProxyList("rss", RssAlt.class.getName());
        object = new RmaListModel(true, (Collection)object);
        this._altCombo.setModel((ComboBoxModel)object);
        object = (ManagerProxy)this._altCombo.getSelectedItem();
        if (object != null) {
            this.fillVariantCombo((RssAlt)object.loadManager(null, null));
        }
    }

    private void fillForm(ManagerProxy object) {
        if (this._fillingForm) {
            return;
        }
        this._fillingForm = true;
        try {
            object = (RssAlt)object.loadManager(null, null);
            this.fillTsTable((RssAlt)object);
            this.fillPdcTable((RssAlt)object);
            return;
        }
        finally {
            this._fillingForm = false;
        }
    }

    private void fillVariantCombo(RssAlt rmaListModel) {
        if (rmaListModel == null) {
            rmaListModel = new RmaListModel(false);
            this._variantCombo.setModel((ComboBoxModel)rmaListModel);
            return;
        }
        rmaListModel = rmaListModel.getInputTSVariants();
        rmaListModel = new ArrayList(rmaListModel);
        rmaListModel.add(0, this._standAloneVariant);
        rmaListModel = new RmaListModel(false, rmaListModel);
        this._variantCombo.setModel((ComboBoxModel)rmaListModel);
        EventQueue.invokeLater(() -> {
            if (rmaListModel.size() > 0) {
                this._variantCombo.setSelectedItem((Object)this._standAloneVariant);
            }
        });
    }

    private void fillForm(RssAlt rssAlt) {
        this._tsTable.deleteCells();
        if (rssAlt == null) {
            this._altCombo.setSelectedIndex(-1);
            return;
        }
        if ((rssAlt = this.getProxyForAlt(rssAlt)) != null) {
            this._altCombo.setSelectedItem((Object)rssAlt);
            return;
        }
        this._altCombo.setSelectedIndex(-1);
    }

    private ManagerProxy getProxyForAlt(RssAlt rssAlt) {
        int n = this._altCombo.getItemCount();
        for (int i = 0; i < n; ++i) {
            ManagerProxy managerProxy = (ManagerProxy)this._altCombo.getItemAt(i);
            if (managerProxy.getManager() != rssAlt) continue;
            return managerProxy;
        }
        return null;
    }

    private void fillTsTable(RssAlt cloneable) {
        this._tsTable.deleteCells();
        this._tsTable.setRowSorter(null);
        Object object = this.getSelectedVariant();
        cloneable = object == null ? ((RssAlt)cloneable).getInputWQTSDataSet() : ((RssAlt)cloneable).getInputWQTSDataSet((TsVariant)((Object)object));
        if (cloneable != null) {
            object = cloneable.getTSRecords();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                AbstractTSRecord abstractTSRecord = (AbstractTSRecord)((Vector)object).get(i);
                cloneable = new Vector<Integer>();
                ((Vector)cloneable).add(i + 1);
                String string = abstractTSRecord.getDescription();
                if (string.startsWith("Met")) {
                    ((Vector)cloneable).add("Met Data");
                } else if (string.startsWith("SubDomain")) {
                    ((Vector)cloneable).add("BC Data");
                } else if (string.startsWith("MassInject")) {
                    ((Vector)cloneable).add("MI Data");
                } else {
                    ((Vector)cloneable).add("");
                }
                ((Vector)cloneable).add(abstractTSRecord);
                ((Vector)cloneable).add(abstractTSRecord.getParamName());
                ((Vector)cloneable).add(abstractTSRecord.getDSSFilename());
                ((Vector)cloneable).add(abstractTSRecord.getDSSPathname());
                this._tsTable.appendRow((Vector)cloneable);
            }
        }
        object = this._tsTable.getModel();
        this._tsTable.setRowSorter(new TableRowSorter<Object>(object));
    }

    private TsVariant getSelectedVariant() {
        TsVariant tsVariant = (TsVariant)((Object)this._variantCombo.getSelectedItem());
        if (tsVariant == this._standAloneVariant) {
            return null;
        }
        return tsVariant;
    }

    private void fillPdcTable(RssAlt object) {
        this._pdcTable.deleteCells();
        this._pdcTable.setRowSorter(null);
        Object object2 = this.getSelectedVariant();
        object = object2 == null ? object.getInputWQPDCDataSet() : object.getInputWQPDCDataSet((TsVariant)((Object)object2));
        if (object != null) {
            object2 = object.getAll();
            for (int i = 0; i < object2.size(); ++i) {
                PDCRecord pDCRecord = (PDCRecord)object2.get(i);
                object = new Vector<Integer>();
                object.add(i + 1);
                pDCRecord.getDescription();
                object.add("IC");
                object.add(pDCRecord);
                object.add(pDCRecord.getParamName());
                object.add(pDCRecord.getDSSFilename());
                object.add(pDCRecord.getDSSPathname());
                this._pdcTable.appendRow((Vector)object);
            }
        }
        object2 = this._pdcTable.getModel();
        this._pdcTable.setRowSorter(new TableRowSorter<Object>(object2));
    }
}

