/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.boundarycondition;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.gui.SelectorPanel;
import hec.io.Identifier;
import hec.lang.UserId;
import hec.rss.wq.client.boundarycondition.BoundaryConditionEditorPanel;
import hec.rss.wq.client.boundarycondition.actions.DeleteBoundaryConditionSetAction;
import hec.rss.wq.client.boundarycondition.actions.NewBoundaryConditionSetAction;
import hec.rss.wq.client.boundarycondition.actions.RenameBoundaryConditionSetAction;
import hec.rss.wq.client.boundarycondition.actions.SaveAsBoundaryConditionSetAction;
import hec.rss.wq.model.BoundaryConditionSetManager;
import hec.rss.wq.model.JsonManager;
import hec.rss.wq.model.ManagerProxyWrapper;
import hec.rss.wq.ui.OkApplyCancelDialog;
import hec.rss.wq.util.WqI18n;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Window;
import java.rmi.RemoteException;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;

public class BoundaryConditionEditorDialog
extends OkApplyCancelDialog {
    private JMenuItem _newBCMenuItem;
    private JMenuItem _saveAsMenuItem;
    private JMenuItem _deleteBCMenuItem;
    private ManagerProxyListContainer _wksp;
    private JMenu _boundaryMenu;

    public BoundaryConditionEditorDialog(Window container, Dialog.ModalityType modalityType) {
        super((Window)container, new BoundaryConditionEditorPanel(), modalityType);
        container = new JMenuBar();
        this.setJMenuBar((JMenuBar)container);
        this._boundaryMenu = new JMenu(WqI18n.a("BC.BoundaryConditionsEditor.Menu.Title").getText());
        this._newBCMenuItem = new JMenuItem(WqI18n.a("BC.BoundaryConditionsEditor.Menu.New").getText());
        this._boundaryMenu.add(this._newBCMenuItem);
        this._saveAsMenuItem = new JMenuItem(WqI18n.a("BC.BoundaryConditionsEditor.Menu.SaveAs").getText());
        this._boundaryMenu.add(this._saveAsMenuItem);
        this._deleteBCMenuItem = new JMenuItem(WqI18n.a("BC.BoundaryConditionsEditor.Menu.Delete").getText());
        this._boundaryMenu.add(this._deleteBCMenuItem);
        ((JMenuBar)container).add(this._boundaryMenu);
        this.addActionListeners();
        EventQueue.invokeLater(() -> {
            BoundaryConditionEditorDialog boundaryConditionEditorDialog = this;
            boundaryConditionEditorDialog.setMinimumSize(boundaryConditionEditorDialog.getSize());
        });
    }

    public void saveForm() {
        ((BoundaryConditionEditorPanel)this._payload).savePanel();
    }

    private void setMenuItemsEnabled(boolean bl) {
        this._saveAsMenuItem.setEnabled(bl);
        this._deleteBCMenuItem.setEnabled(bl);
    }

    public void fillForm(ManagerProxyListContainer object) {
        this._wksp = object;
        this._boundaryMenu.setVisible(this._wksp instanceof ClientWorkspace);
        object = this._wksp.getManagerProxyList("rss", BoundaryConditionSetManager.class.getName());
        object = object.stream().map(ManagerProxyWrapper::new).collect(Collectors.toList());
        this.setMenuItemsEnabled(!object.isEmpty());
        ((BoundaryConditionEditorPanel)this._payload).setIgnoreModelReset(true);
        ((BoundaryConditionEditorPanel)this._payload).fillPanel((List<ManagerProxyWrapper>)object, this._wksp);
        ((BoundaryConditionEditorPanel)this._payload).setIgnoreModelReset(false);
    }

    private void addActionListeners() {
        this._newBCMenuItem.addActionListener(actionEvent -> this.launchCreateNewBoundaryCondition());
        this._saveAsMenuItem.addActionListener(actionEvent -> this.launchSaveAs());
        this._deleteBCMenuItem.addActionListener(actionEvent -> this.launchDelete());
    }

    private void launchDelete() {
        Object object = (ManagerProxyWrapper)((Object)this.getSelectorPanel().getSelectedItem());
        if (object == null) {
            return;
        }
        ManagerProxy managerProxy = object.getManagerProxy();
        managerProxy = managerProxy.getId();
        DeleteBoundaryConditionSetAction deleteBoundaryConditionSetAction = new DeleteBoundaryConditionSetAction((Dialog)((Object)this));
        if ((managerProxy = deleteBoundaryConditionSetAction.a((Identifier)managerProxy)) != null) {
            this.setModified(false);
            int n = this.getSelectorPanel().getComboBox().getSelectedIndex();
            this.getSelectorPanel().getComboBox().removeItem(object);
            object = this.getSelectorPanel().getSelectorItems();
            if (n == 0 && object.isEmpty()) {
                this.clearForm();
                this.setModified(false);
                this.setMenuItemsEnabled(false);
                this.getSelectorPanel().setSelectedIndex(-1);
                return;
            }
            if (n > 0) {
                this.getSelectorPanel().setSelectedIndex(n - 1);
                return;
            }
            if (n == 0) {
                this.getSelectorPanel().setSelectedIndex(n);
            }
        }
    }

    private void launchRename() {
        Object object = (ManagerProxyWrapper)((Object)this.getSelectorPanel().getSelectedItem());
        if (object == null) {
            return;
        }
        object = object.getManagerProxy();
        object = (BoundaryConditionSetManager)object.loadManager(null, null);
        RenameBoundaryConditionSetAction renameBoundaryConditionSetAction = new RenameBoundaryConditionSetAction((Dialog)((Object)this));
        if ((object = renameBoundaryConditionSetAction.a((BoundaryConditionSetManager)object, this.getSelectorPanel().getDescription())) != null) {
            this.getSelectorPanel().getComboBox().repaint();
            this.getSelectorPanel().setDescription(((JsonManager)((Object)object)).getDescription());
        }
    }

    private void launchSaveAs() {
        Object object;
        Object object2;
        Object object3 = (ManagerProxyWrapper)((Object)this.getSelectorPanel().getSelectedItem());
        if (object3 == null) {
            return;
        }
        object3 = object3.getManagerProxy();
        object3 = (BoundaryConditionSetManager)object3.loadManager(null, null);
        boolean bl = false;
        if (this.isModified() && object3 != null) {
            String string = WqI18n.a("BC.BoundaryConditionsEditor.Msg.SaveMgr").format(object3);
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), string, (String)(object2 = WqI18n.a("BC.BoundaryConditionsEditor.Msg.SaveMgr.Title").getText()), 1);
            if (n == 0) {
                this.saveForm();
                bl = true;
            } else if (2 == n) {
                return;
            }
        }
        if ((object2 = ((SaveAsBoundaryConditionSetAction)(object = new SaveAsBoundaryConditionSetAction((Dialog)((Object)this)))).a((BoundaryConditionSetManager)object3, this.getSelectorPanel().getDescription())) != null) {
            object = ((BoundaryConditionEditorPanel)this._payload).getSelectedBoundaryConditionSet();
            object3 = object.getIdentifier();
            object3 = object3.getPath();
            object3 = ((String)object3).concat(".temp");
            RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            object3 = new Identifier((String)object3);
            Identifier identifier = null;
            if (!bl) {
                if (object.isModified()) {
                    this._wksp.saveManager("rss", (Manager)object);
                }
                this.saveForm();
            }
            try {
                identifier = rmiFileManager.newFile(UserId.getUserId(), (Identifier)object3);
                if (identifier == null) {
                    identifier = rmiFileManager.openFile(UserId.getUserId(), (Identifier)object3);
                }
            }
            catch (RemoteException remoteException) {
                object3 = remoteException;
                remoteException.printStackTrace();
            }
            if (identifier != null) {
                ((JsonManager)((Object)object)).writeFile(identifier);
                if (!bl) {
                    Object object4 = object;
                    ((JsonManager)((Object)object4)).readFile(object4.getIdentifier());
                }
                object3 = ((JsonManager)((Object)object2)).getName();
                String string = ((JsonManager)((Object)object2)).getDescription();
                int n = ((JsonManager)((Object)object2)).getIndex();
                ((JsonManager)((Object)object2)).readFile(identifier);
                ((BoundaryConditionSetManager)object2).setName((String)object3);
                ((BoundaryConditionSetManager)object2).setDescription(string);
                object2.setIndex(n);
                try {
                    rmiFileManager.deleteFile(identifier.getPath());
                }
                catch (RemoteException remoteException) {
                    System.out.println("SaveAsBoundaryConditionSetAction: exception deleting file " + identifier.getPath() + " error:" + String.valueOf(remoteException));
                }
                this.setModified(false);
                object3 = this._wksp.getManagerProxy("rss", object2.getIdentifier());
                this.getSelectorPanel().addSelectionItem((Object)new ManagerProxyWrapper((ManagerProxy)object3), true);
            }
        }
    }

    private void launchCreateNewBoundaryCondition() {
        Object object = new NewBoundaryConditionSetAction((Dialog)((Object)this));
        if ((object = ((NewBoundaryConditionSetAction)object).h()) != null) {
            object = this._wksp.getManagerProxy("rss", object.getIdentifier());
            ((BoundaryConditionEditorPanel)this._payload).getSelectorPanel().addSelectionItem((Object)new ManagerProxyWrapper((ManagerProxy)object), true);
        }
        this.setMenuItemsEnabled(true);
    }

    private SelectorPanel getSelectorPanel() {
        return ((BoundaryConditionEditorPanel)this._payload).getSelectorPanel();
    }

    public void setSelectedBoundaryConditionSet(BoundaryConditionSetManager object) {
        if (object != null) {
            object = object.getProxyList().getManagerProxy(object.getIdentifier());
            object = new ManagerProxyWrapper((ManagerProxy)object);
            ((BoundaryConditionEditorPanel)this._payload).getSelectorPanel().setSelectedItem(object);
        }
    }
}

