/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.boundarycondition;

import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.gui.SelectorPanel;
import hec.rss.client.RssSystemGlyph;
import hec.rss.model.JunctionElement;
import hec.rss.model.RssSystem;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.wq.client.boundarycondition.BoundaryConditionEditorPanel$1;
import hec.rss.wq.client.boundarycondition.BoundaryConditionEditorPanel$BoundaryConditionsTreeCellRenderer;
import hec.rss.wq.client.boundarycondition.BoundaryConditionEditorPanel$TreeMouseListener;
import hec.rss.wq.client.boundarycondition.BoundaryConditionEditorPanel$TreeSelectorPanelActionListener;
import hec.rss.wq.client.boundarycondition.BoundaryConditionEditorPanel$ViewSelectionListener;
import hec.rss.wq.client.boundarycondition.BoundaryConditionUtilities;
import hec.rss.wq.client.boundarycondition.ConstituentAtJunctionDataSource;
import hec.rss.wq.client.boundarycondition.ConstituentDataSource;
import hec.rss.wq.client.boundarycondition.ConstituentJunctionDataSource;
import hec.rss.wq.client.boundarycondition.ConstituentViewTreeModel;
import hec.rss.wq.client.boundarycondition.JunctionConstituentDataSource;
import hec.rss.wq.client.boundarycondition.JunctionDataSource;
import hec.rss.wq.client.boundarycondition.LocationViewTreeModel;
import hec.rss.wq.model.BoundaryConditionSetManager;
import hec.rss.wq.model.JsonManager;
import hec.rss.wq.model.ManagerProxyWrapper;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.ui.DataSource;
import hec.rss.wq.ui.OkApplyCancelDialog;
import hec.rss.wq.ui.PreventRootNodeFromCollapseListener;
import hec.rss.wq.ui.TreeView;
import hec.rss.wq.ui.View$SelectionListener;
import hec.rss.wq.ui.ViewPanel;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.BoundaryCondition;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.ConstituentSet;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.geometry.SubDomainBoundary;
import hec.wqengineimpl.geometry.WQSubDomainBoundaryRef;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import rma.lang.Modifiable;
import rma.swing.RmaJComboBox;
import rma.swing.list.RmaListModel;

public class BoundaryConditionEditorPanel
extends JPanel {
    private int _treeSelectorIndex = 0;
    private boolean _ignoreTreeSelectorEvents = false;
    private TreeView _treeView;
    private final SelectorPanel _treeSelectorPanel;
    private BoundaryConditionSetManager _selectedBCSetManager;
    private Map<JunctionElement, List<SubDomainBoundary>> _selectedBCJunctionMap;
    private JLabel _titledSeperatorLabel;
    private JSeparator _titledSeperator;
    private Map<BoundaryConditionSetManager, Map<JunctionElement, List<SubDomainBoundary>>> _boundaryConditionSetsToJunctionMaps = new HashMap<BoundaryConditionSetManager, Map<JunctionElement, List<SubDomainBoundary>>>();
    private ViewPanel _viewPanel;
    private SelectorPanel _topSelectorPanel;
    private JTextField _constituentField;
    private JTextField _geometryField;
    private JRadioButton _locationViewRadio;
    private JPanel _viewPanelContainer;
    private JMenuItem _copyFromMI;
    private ManagerProxyListContainer _wksp;
    private LocationViewTreeModel _locationTreeModel;
    private ConstituentViewTreeModel _constituentTreeModel;
    private TreeView _locationTreeView;
    private TreeView _constituentTreeView;
    private BoundaryConditionSetManager _prevBcSetManager;
    private boolean _ignoreTreeModelReset;

    public BoundaryConditionEditorPanel() {
        this.initComponents();
        this._viewPanelContainer.setLayout(new GridBagLayout());
        this._viewPanel = new ViewPanel();
        Object object2 = new TreeView(new DefaultTreeModel(null));
        ((TreeView)object2).a().addTreeWillExpandListener(new PreventRootNodeFromCollapseListener());
        this._viewPanel.setView(object2);
        this._viewPanelContainer.add((Component)this._viewPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        object2 = new JPanel();
        this._treeSelectorPanel = new SelectorPanel();
        this._treeSelectorPanel.setNameLabel(WqI18n.a("BC.BoundaryConditionsEditor.Label.Constituent").getText());
        this._treeSelectorPanel.setDescriptionPanelVisible(false);
        this._treeSelectorPanel.getComboBox().addActionListener((ActionListener)new BoundaryConditionEditorPanel$TreeSelectorPanelActionListener(this));
        ((Container)object2).setLayout(new GridBagLayout());
        ((Container)object2).add((Component)this._treeSelectorPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this._titledSeperator = new JSeparator();
        this._titledSeperatorLabel = new JLabel("");
        ((Container)object2).add((Component)this._titledSeperatorLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        ((Container)object2).add((Component)this._titledSeperator, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this._viewPanel.setDisplayHeader(new BoundaryConditionEditorPanel$1((JPanel)object2));
        this._topSelectorPanel.getComboBox().addActionListener(actionEvent -> this.topSelectionChanged());
        this._topSelectorPanel.getComboBox().addItemListener(object -> {
            if (((ItemEvent)object).getStateChange() == 2 && this.isModified()) {
                if ((object = ((ItemEvent)object).getItem()) == null) {
                    return;
                }
                int n = JOptionPane.showConfirmDialog(this, object.toString() + " has changed.\nWould you like to save?", "Save", 0);
                if (n == 0) {
                    this.savePanel();
                }
                this.setParentModified(false);
            }
        });
        this._locationViewRadio.setSelected(true);
    }

    private void setParentModified(boolean bl) {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Modifiable)) continue;
            ((Modifiable)container).setModified(bl);
        }
    }

    private boolean isModified() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Modifiable)) continue;
            return ((Modifiable)container).isModified();
        }
        return false;
    }

    private void topSelectionChanged() {
        this.clearErrorMsg();
        BoundaryConditionSetManager boundaryConditionSetManager = this.getSelectedBoundaryConditionSet();
        if (boundaryConditionSetManager == null) {
            this.clearForm();
            return;
        }
        if (!this._boundaryConditionSetsToJunctionMaps.containsKey(boundaryConditionSetManager)) {
            Map<JunctionElement, List<SubDomainBoundary>> map = this.getJunctionMap(boundaryConditionSetManager.getGeometry());
            this._boundaryConditionSetsToJunctionMaps.put(boundaryConditionSetManager, map);
        }
        this.setViewPanelHeaderPanelVisible(true);
        this.fillPanel(boundaryConditionSetManager, this._boundaryConditionSetsToJunctionMaps.get(boundaryConditionSetManager));
    }

    private void clearForm() {
        this._selectedBCSetManager = null;
        TreeView treeView = new TreeView(new DefaultTreeModel(null));
        treeView.a().addTreeWillExpandListener(new PreventRootNodeFromCollapseListener());
        this._viewPanel.setView(treeView);
        this._treeView = treeView;
        this.setViewPanelHeaderPanelVisible(false);
        this._constituentField.setText("");
        this._geometryField.setText("");
    }

    private void clearErrorMsg() {
        Window window = SwingUtilities.windowForComponent(this);
        if (window instanceof OkApplyCancelDialog) {
            ((OkApplyCancelDialog)((Object)window)).setErrorMessage(null);
        }
    }

    private void setViewPanelHeaderPanelVisible(boolean bl) {
        this._treeSelectorPanel.setVisible(bl);
        this._titledSeperator.setVisible(bl);
        this._titledSeperatorLabel.setVisible(bl);
    }

    public SelectorPanel getSelectorPanel() {
        return this._topSelectorPanel;
    }

    private void updateTreeView() {
        if (this._selectedBCSetManager != null) {
            if (this._locationViewRadio.isSelected()) {
                if (this._locationTreeModel == null || this._selectedBCSetManager != this._prevBcSetManager || this._locationTreeModel.c() != this._selectedBCSetManager) {
                    this._locationTreeModel = new LocationViewTreeModel(this._selectedBCSetManager, this._selectedBCJunctionMap);
                    this._locationTreeView = new TreeView(this._locationTreeModel);
                }
                this._treeView = this._locationTreeView;
                RmaListModel rmaListModel = new RmaListModel();
                rmaListModel.addAll(this._locationTreeModel.b());
                this._treeSelectorPanel.getComboBox().setModel((ComboBoxModel)rmaListModel);
                this._treeSelectorPanel.setNameLabel(WqI18n.a("BC.BoundaryConditionsEditor.Label.Junction").getText());
            } else {
                if (this._constituentTreeModel == null || this._selectedBCSetManager != this._prevBcSetManager || this._constituentTreeModel.b() != this._selectedBCSetManager || this._constituentTreeView.a().getModel() != this._constituentTreeModel) {
                    this._constituentTreeModel = new ConstituentViewTreeModel(this._selectedBCSetManager, this._selectedBCJunctionMap);
                    this._constituentTreeView = new TreeView(this._constituentTreeModel);
                }
                this._treeView = this._constituentTreeView;
                this._treeSelectorPanel.setNameLabel(WqI18n.a("BC.BoundaryConditionsEditor.Label.Constituent").getText());
                ConstituentSet constituentSet = this._selectedBCSetManager.getConstituentSet().getSet();
                if (constituentSet != null) {
                    constituentSet = new RmaListModel();
                    constituentSet.addAll(this._constituentTreeModel.a());
                    this._treeSelectorPanel.getComboBox().setModel((ComboBoxModel)constituentSet);
                }
            }
            this._prevBcSetManager = this._selectedBCSetManager;
            this._treeView.a(new BoundaryConditionEditorPanel$BoundaryConditionsTreeCellRenderer());
            this._treeView.a(new BoundaryConditionEditorPanel$TreeMouseListener(this));
            this._treeView.addSelectionListener((View$SelectionListener)new BoundaryConditionEditorPanel$ViewSelectionListener(this));
            this._treeView.a().addTreeWillExpandListener(new PreventRootNodeFromCollapseListener());
            this._viewPanel.setView(this._treeView);
        }
    }

    private void fillPanel(BoundaryConditionSetManager object, Map<JunctionElement, List<SubDomainBoundary>> object2) {
        this.clearErrorMsg();
        if (object != null && ((JsonManager)((Object)object)).getName() != null) {
            this._selectedBCJunctionMap = object2;
            this._topSelectorPanel.getDescriptionField().setText(((JsonManager)((Object)object)).getDescription());
            object2 = ((BoundaryConditionSetManager)object).getGeometry();
            this._selectedBCSetManager = object;
            this._constituentField.setText("");
            Object object3 = ((BoundaryConditionSetManager)object).getConstituentSet();
            ConstituentSet constituentSet = null;
            if (object3 != null && (constituentSet = object3.getSet()) != null) {
                this._constituentField.setText(constituentSet.getName());
            }
            this._geometryField.setText("");
            if (object2 != null) {
                this._geometryField.setText(((JsonManager)((Object)object2)).getName());
                if (((WqGeometry)((Object)object2)).getNetwork() == null && (object3 = SwingUtilities.windowForComponent(this)) instanceof OkApplyCancelDialog) {
                    object = WqI18n.a("BC.BoundaryConditionsEditor.Msg.FailedToFindNetwork").format((Object)((JsonManager)((Object)object2)).getName());
                    ((OkApplyCancelDialog)((Object)object3)).setErrorMessage((String)object);
                }
            } else {
                object3 = SwingUtilities.windowForComponent(this);
                if (object3 instanceof OkApplyCancelDialog) {
                    object = WqI18n.a("BC.BoundaryConditionsEditor.Msg.FailedToFindGeometry").format((Object)((JsonManager)((Object)object)).getName());
                    ((OkApplyCancelDialog)((Object)object3)).setErrorMessage((String)object);
                }
            }
            if (constituentSet != null && object2 != null) {
                this.updateBoundaryConditions();
                this.updateTreeView();
                return;
            }
            this.clearForm();
        }
    }

    private void updateBoundaryConditions() {
        boolean bl;
        BoundaryCondition boundaryCondition2;
        if (this._selectedBCSetManager == null) {
            return;
        }
        Collection collection = this._selectedBCSetManager.getConstituentSet().getSet().getConstituentList();
        Collection collection2 = this._selectedBCSetManager.getSet().getBoundaryConditions();
        ArrayList<BoundaryCondition> arrayList = new ArrayList<BoundaryCondition>();
        ArrayList<Constituent> arrayList2 = new ArrayList<Constituent>();
        for (BoundaryCondition boundaryCondition2 : collection2) {
            bl = false;
            for (Constituent constituent : collection) {
                if (boundaryCondition2.getConstituentId() != constituent.getId()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(boundaryCondition2);
        }
        for (BoundaryCondition boundaryCondition2 : collection) {
            if (!boundaryCondition2.getIsAdvected().booleanValue()) continue;
            bl = false;
            for (Constituent constituent : collection2) {
                if (constituent.getConstituentId() != boundaryCondition2.getId()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList2.add((Constituent)boundaryCondition2);
        }
        List<BoundaryCondition> list = BoundaryConditionUtilities.a(arrayList2, this._selectedBCJunctionMap);
        boundaryCondition2 = this._selectedBCSetManager.getSet();
        boundaryCondition2.removeBoundaryConditions(arrayList);
        boundaryCondition2.addBoundaryConditions((Collection)list);
    }

    public void fillPanel(List<ManagerProxyWrapper> list, ManagerProxyListContainer managerProxyListContainer) {
        this._wksp = managerProxyListContainer;
        this._topSelectorPanel.setSelectionList(list);
        if (list.isEmpty()) {
            this.getSelectorPanel().setSelectedIndex(-1);
        } else {
            this.getSelectorPanel().setSelectedIndex(0);
        }
        if (!this._ignoreTreeModelReset) {
            this._locationTreeModel = null;
            this._constituentTreeModel = null;
        }
        if (this._treeView != null) {
            this.updateSelectedJunction();
        }
    }

    private void updateSelectedJunction() {
        RmaJComboBox rmaJComboBox = this._treeSelectorPanel.getComboBox();
        if (this._treeView.getSelectedObject() == null) {
            this._locationTreeModel = null;
            this._constituentTreeModel = null;
            return;
        }
        rmaJComboBox.setSelectedItem((Object)this._treeView.getSelectedObject());
        int n = -1;
        if (this._treeView.getSelectedObject() instanceof JunctionConstituentDataSource) {
            n = ((JunctionConstituentDataSource)this._treeView.getSelectedObject()).b().getBoundaryRef().getJnctId();
        } else if (this._treeView.getSelectedObject() instanceof ConstituentJunctionDataSource) {
            n = ((ConstituentJunctionDataSource)this._treeView.getSelectedObject()).d().getJnctId();
        }
        for (int i = 0; i < rmaJComboBox.getItemCount(); ++i) {
            SubDomainBoundary subDomainBoundary;
            if (!(rmaJComboBox.getItemAt(i) instanceof JunctionDataSource) || (subDomainBoundary = ((JunctionDataSource)rmaJComboBox.getItemAt(i)).b()) == null || n != subDomainBoundary.getJnctId()) continue;
            rmaJComboBox.setSelectedIndex(i);
            return;
        }
    }

    public BoundaryConditionSetManager getSelectedBoundaryConditionSet() {
        Object object = (ManagerProxyWrapper)((Object)this._topSelectorPanel.getComboBox().getSelectedItem());
        if (object != null) {
            object = (BoundaryConditionSetManager)object.getManagerProxy().loadManager(null, null);
            return object;
        }
        return null;
    }

    public void savePanel() {
        if (this._selectedBCSetManager != null) {
            this._selectedBCSetManager.setDescription(this._topSelectorPanel.getDescriptionField().getText());
            this._viewPanel.save();
            this._selectedBCSetManager.setDescription(this._topSelectorPanel.getDescription());
        }
    }

    private void initComponents() {
        Object object = new ButtonGroup();
        Object object2 = new JMenu();
        JPanel jPanel = new JPanel();
        this._topSelectorPanel = new SelectorPanel();
        JPanel jPanel2 = new JPanel();
        this._viewPanelContainer = new JPanel();
        JPanel jPanel3 = new JPanel();
        this._locationViewRadio = new JRadioButton();
        JRadioButton jRadioButton = new JRadioButton();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        this._geometryField = new JTextField();
        this._constituentField = new JTextField();
        ((AbstractButton)object2).setText("jMenu1");
        object2 = new GroupLayout(jPanel);
        jPanel.setLayout((LayoutManager)object2);
        Object object3 = object2;
        ((GroupLayout)object3).setHorizontalGroup(((GroupLayout)object3).createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(((GroupLayout)object2).createSequentialGroup().addContainerGap().addComponent((Component)this._topSelectorPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        Object object4 = object2;
        ((GroupLayout)object4).setVerticalGroup(((GroupLayout)object4).createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, ((GroupLayout)object2).createSequentialGroup().addContainerGap(12, Short.MAX_VALUE).addComponent((Component)this._topSelectorPanel, -2, -1, -2).addContainerGap()));
        ((ButtonGroup)object).add(this._locationViewRadio);
        this._locationViewRadio.setText("Location");
        this._locationViewRadio.addActionListener(actionEvent -> this.locationViewRadioActionPerformed());
        ((ButtonGroup)object).add(jRadioButton);
        jRadioButton.setText("WQ Constituent");
        jRadioButton.addActionListener(actionEvent -> this.constituentViewRadioActionPerformed());
        object = new GroupLayout(jPanel3);
        jPanel3.setLayout((LayoutManager)object);
        Object object5 = object;
        ((GroupLayout)object5).setHorizontalGroup(((GroupLayout)object5).createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(((GroupLayout)object).createSequentialGroup().addContainerGap().addComponent(this._locationViewRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jRadioButton).addContainerGap(549, Short.MAX_VALUE)));
        Object object6 = object;
        ((GroupLayout)object6).setVerticalGroup(((GroupLayout)object6).createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(((GroupLayout)object).createSequentialGroup().addGap(0, 4, Short.MAX_VALUE).addGroup(((GroupLayout)object).createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._locationViewRadio).addComponent(jRadioButton))));
        object = new GroupLayout(jPanel2);
        jPanel2.setLayout((LayoutManager)object);
        Object object7 = object;
        ((GroupLayout)object7).setHorizontalGroup(((GroupLayout)object7).createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel3, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this._viewPanelContainer, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        Object object8 = object;
        ((GroupLayout)object8).setVerticalGroup(((GroupLayout)object8).createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, ((GroupLayout)object).createSequentialGroup().addGap(0, 0, 0).addComponent(jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._viewPanelContainer, -1, 347, Short.MAX_VALUE)));
        jLabel.setText("WQ Constituent:");
        jLabel2.setText("Geometry:");
        this._geometryField.setEditable(false);
        this._constituentField.setEditable(false);
        object = new GroupLayout(this);
        this.setLayout((LayoutManager)object);
        Object object9 = object;
        ((GroupLayout)object9).setHorizontalGroup(((GroupLayout)object9).createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel, -1, -1, Short.MAX_VALUE).addComponent(jPanel2, -1, -1, Short.MAX_VALUE).addGroup(((GroupLayout)object).createSequentialGroup().addContainerGap().addComponent(jLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._constituentField, -2, 206, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._geometryField, -2, 206, -2).addContainerGap(-1, Short.MAX_VALUE)));
        Object object10 = object;
        ((GroupLayout)object10).setVerticalGroup(((GroupLayout)object10).createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(((GroupLayout)object).createSequentialGroup().addComponent(jPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(((GroupLayout)object).createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel).addComponent(jLabel2).addComponent(this._geometryField, -2, -1, -2).addComponent(this._constituentField, -2, -1, -2)).addGap(13, 13, 13).addComponent(jPanel2, -1, -1, Short.MAX_VALUE)));
    }

    private Map<JunctionElement, List<SubDomainBoundary>> getJunctionMap(WqGeometry object) {
        Object object2 = SwingUtilities.windowForComponent(this);
        OkApplyCancelDialog okApplyCancelDialog = null;
        if (object2 instanceof OkApplyCancelDialog) {
            okApplyCancelDialog = (OkApplyCancelDialog)((Object)object2);
        }
        if (object == null) {
            if (okApplyCancelDialog != null) {
                object2 = WqI18n.a("BC.BoundaryConditionsEditor.Msg.FailedToFindGeometry").getText();
                okApplyCancelDialog.setErrorMessage((String)object2);
            }
            return new HashMap<JunctionElement, List<SubDomainBoundary>>();
        }
        if (okApplyCancelDialog != null) {
            okApplyCancelDialog.setErrorMessage(null);
        }
        if ((object2 = object.getRssWqGeometry()) != null) {
            int n = object.getNetworkId();
            ManagerProxy managerProxy = this._wksp.getManagerProxy("rss", RssSystem.class.getName(), n);
            if (managerProxy != null) {
                ManagerProxy managerProxy2 = managerProxy;
                managerProxy2.loadManager(managerProxy2.getClassName(), managerProxy.getId());
                object = managerProxy.getManager();
                return ((RssWQGeometry)object2).getBoundariesForBCEd((RssSystem)object);
            }
            if (okApplyCancelDialog != null) {
                object = WqI18n.a("BC.BoundaryConditionsEditor.Msg.FailedToFindNetwork").format((Object)object.getName());
                okApplyCancelDialog.setErrorMessage((String)object);
            }
        }
        return new HashMap<JunctionElement, List<SubDomainBoundary>>();
    }

    private void locationViewRadioActionPerformed() {
        this.updateTreeView();
        if (this._treeSelectorPanel.getSelectedItem() == null) {
            DataSource dataSource = this._locationTreeView.getSelectedObject();
            this._treeSelectorPanel.setSelectedItem((Object)dataSource);
            if (dataSource instanceof JunctionConstituentDataSource) {
                dataSource = (JunctionConstituentDataSource)dataSource;
                if ((dataSource = (WQSubDomainBoundaryRef)((ConstituentAtJunctionDataSource)dataSource).b().getBoundaryRef()) != null) {
                    this._treeSelectorPanel.getSelectorItems().stream().filter(arg_0 -> BoundaryConditionEditorPanel.a((WQSubDomainBoundaryRef)dataSource, arg_0)).findFirst().ifPresent(object -> this._treeSelectorPanel.setSelectedItem(object));
                }
            }
        }
    }

    private void constituentViewRadioActionPerformed() {
        this.updateTreeView();
        if (this._treeSelectorPanel.getSelectedItem() == null && this._constituentTreeView != null) {
            DataSource dataSource = this._constituentTreeView.getSelectedObject();
            this._treeSelectorPanel.setSelectedItem((Object)dataSource);
            if (dataSource instanceof ConstituentJunctionDataSource) {
                this._treeSelectorPanel.getSelectorItems().stream().filter(object -> object instanceof ConstituentDataSource && ((ConstituentDataSource)object).a() == ((ConstituentJunctionDataSource)dataSource).c()).findFirst().ifPresent(arg_0 -> ((SelectorPanel)this._treeSelectorPanel).setSelectedItem(arg_0));
            }
        }
    }

    void setIgnoreModelReset(boolean bl) {
        this._ignoreTreeModelReset = bl;
    }

    private void updateJunctionPanel(Map<DataSource, List<? extends DataSource>> object, BoundaryCondition boundaryCondition) {
        for (Map.Entry entry : object.entrySet()) {
            List list = (List)entry.getValue();
            for (DataSource dataSource : list) {
                if (!(dataSource instanceof JunctionConstituentDataSource) || ((ConstituentAtJunctionDataSource)(dataSource = (JunctionConstituentDataSource)dataSource)).b() != boundaryCondition) continue;
                ((ConstituentAtJunctionDataSource)dataSource).a();
            }
        }
    }

    private boolean validateDataNotEmpty(List<Data> object) {
        boolean bl = true;
        if (object != null && !object.isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                Data data = (Data)object.next();
                if (data.isEmpty()) continue;
                bl = false;
                break;
            }
        }
        return !bl;
    }

    private static /* synthetic */ boolean a(WQSubDomainBoundaryRef wQSubDomainBoundaryRef, Object object) {
        return object instanceof JunctionDataSource && ((JunctionDataSource)object).b() != null && ((JunctionDataSource)object).b().getName().equalsIgnoreCase(wQSubDomainBoundaryRef.getName());
    }

    static {
        RssSystemGlyph.initIcons();
    }
}

