/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.boundarycondition;

import hec.rss.model.JunctionElement;
import hec.rss.wq.client.boundarycondition.BoundaryConditionUtilities;
import hec.rss.wq.model.BoundaryConditionSetManager;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.BoundaryConditionSet;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.ConstituentSet;
import hec.wqenginecore.dataSource.constant.ConstantData;
import hec.wqenginecore.geometry.BoundaryType;
import hec.wqenginecore.geometry.SubDomainBoundary;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;
import rma.swing.table.MleHeadRenderer;
import rma.swing.table.RmaTableModel;

public class BoundaryConditionsSummaryPanel
extends JPanel {
    private RmaJTable _boundaryCondSetTable;

    public BoundaryConditionsSummaryPanel() {
        this.initComponents();
    }

    private void initComponents() {
        JScrollPane jScrollPane = new JScrollPane();
        this.setLayout(new GridBagLayout());
        this._boundaryCondSetTable = new RmaJTable((Component)this);
        this._boundaryCondSetTable.getTableHeader().setDefaultRenderer((TableCellRenderer)new MleHeadRenderer());
        jScrollPane.setViewportView((Component)this._boundaryCondSetTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    /*
     * WARNING - void declaration
     */
    public void fillPanel(BoundaryConditionSetManager boundaryConditionSetManager, Map<JunctionElement, List<SubDomainBoundary>> vector) {
        void var6_14;
        Serializable serializable;
        Serializable serializable2;
        Object object;
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        vector3.add(WqI18n.a("BC.BoundaryConditionsEditor.BCSummaryPanel.Junction").getText());
        ConstituentSet constituentSet = boundaryConditionSetManager.getConstituentSet().getSet();
        if (constituentSet == null) {
            return;
        }
        Collection object222 = constituentSet.getConstituentList();
        Object object2 = object222.toArray();
        for (int i = 0; i < object222.size(); ++i) {
            object = (Constituent)object2[i];
            if (!object.getIsAdvected().booleanValue()) continue;
            vector2.add(this.makeTableColumnLabel(object.getDisplayName()));
        }
        Vector<Serializable> vector4 = new Vector<Serializable>();
        object = new Vector();
        vector = new TreeMap(vector);
        for (Map.Entry rmaTableModel : vector.entrySet()) {
            object2 = BoundaryConditionUtilities.a((List)rmaTableModel.getValue());
            serializable2 = new Vector();
            serializable = new Vector();
            if (object2 == null) {
                serializable.add(((JunctionElement)rmaTableModel.getKey()).getName());
            } else {
                serializable2 = this.createRow((SubDomainBoundary)object2, constituentSet, boundaryConditionSetManager.getSet());
                serializable = this.createFirstColRow((SubDomainBoundary)object2);
            }
            vector4.add(serializable2);
            ((Vector)object).add(serializable);
            List<SubDomainBoundary> i = BoundaryConditionUtilities.b((List)rmaTableModel.getValue());
            for (SubDomainBoundary subDomainBoundary : i) {
                serializable2 = this.createRow(subDomainBoundary, constituentSet, boundaryConditionSetManager.getSet());
                Vector vector5 = this.createFirstColRow(subDomainBoundary);
                vector4.add(serializable2);
                ((Vector)object).add(vector5);
            }
        }
        vector = new Vector<Boolean>();
        boolean bl = false;
        while (var6_14 < vector2.size()) {
            vector.add(Boolean.FALSE);
            ++var6_14;
        }
        RmaTableModel rmaTableModel = new RmaTableModel(vector2, vector4, vector);
        object2 = new RmaTableModel(vector3, (Vector)object, vector);
        this._boundaryCondSetTable.setModel((TableModel)rmaTableModel);
        this._boundaryCondSetTable.setViewportRowHeader((TableModel)object2, null, null, 220);
        if (this._boundaryCondSetTable.getColumnModel().getColumnCount() > 0) {
            void var6_17;
            this._boundaryCondSetTable.getColumnModel().getColumn(0).setMinWidth(150);
            serializable2 = this._boundaryCondSetTable.getTableHeader();
            serializable = ((JComponent)serializable2).getFontMetrics(((Component)serializable2).getFont());
            boolean bl2 = false;
            while (var6_17 < this._boundaryCondSetTable.getColumnCount()) {
                BoundaryConditionsSummaryPanel boundaryConditionsSummaryPanel = this;
                int n = boundaryConditionsSummaryPanel.getColumnWidth(boundaryConditionsSummaryPanel._boundaryCondSetTable.getColumnName((int)var6_17), (FontMetrics)serializable);
                this._boundaryCondSetTable.getColumnModel().getColumn((int)var6_17).setMinWidth(n + 10);
                ++var6_17;
            }
        }
        this._boundaryCondSetTable.setAutoResizeMode(0);
    }

    private int getColumnWidth(String string, FontMetrics fontMetrics) {
        int n = 0;
        if (!string.startsWith("<html>")) {
            return fontMetrics.stringWidth(string);
        }
        int n2 = string.length();
        string = string.substring(6, n2 -= 7);
        String[] stringArray = string.split("<br>");
        for (int i = 0; i < stringArray.length; ++i) {
            int n3 = fontMetrics.stringWidth(stringArray[i]);
            n = Math.max(n, n3);
        }
        return n;
    }

    private String makeTableColumnLabel(String charSequence) {
        String[] stringArray = ((String)charSequence).split(" ");
        if (stringArray == null || stringArray.length == 0) {
            return charSequence;
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("<html>");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                ((StringBuilder)charSequence).append("<br>");
            }
            ((StringBuilder)charSequence).append(stringArray[i]);
        }
        ((StringBuilder)charSequence).append("</html>");
        return ((StringBuilder)charSequence).toString();
    }

    private Vector createFirstColRow(SubDomainBoundary subDomainBoundary) {
        Vector<Object> vector = new Vector<Object>();
        if (subDomainBoundary.getBoundaryType() == BoundaryType.LOCAL_INFLOW) {
            vector.add("   " + subDomainBoundary.getName());
        } else {
            vector.add(subDomainBoundary.getName());
        }
        return vector;
    }

    private Vector createRow(SubDomainBoundary subDomainBoundary, ConstituentSet object, BoundaryConditionSet boundaryConditionSet) {
        Vector<Object> vector = new Vector<Object>();
        for (Constituent constituent : object.getConstituentList()) {
            if (!constituent.getIsAdvected().booleanValue()) continue;
            if ((constituent = boundaryConditionSet.getBoundaryCondition(constituent, subDomainBoundary)) != null) {
                if (constituent.getSelectedDataSource() != null) {
                    if (constituent.getSelectedDataSource() instanceof ConstantData) {
                        ConstantData constantData = (ConstantData)constituent.getSelectedDataSource();
                        if (constantData.getConstantValue() != Double.NEGATIVE_INFINITY) {
                            vector.add(constituent.getSelectedDataSource().getName() + " - " + constituent.getSelectedDataSource().getUnits());
                            continue;
                        }
                        vector.add("");
                        continue;
                    }
                    vector.add(constituent.getSelectedDataSource().getName() + " - " + constituent.getSelectedDataSource().getUnits());
                    continue;
                }
                vector.add("");
                continue;
            }
            vector.add("");
        }
        return vector;
    }
}

