/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.boundarycondition;

import hec.clientapp.client.ClientApp;
import hec.data.TimeWindow;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.PlotLayout;
import hec.gfx2d.TimeSeriesDataSet;
import hec.io.TimeSeriesContainer;
import hec.rss.client.RSimSimulationMode;
import hec.rss.model.JunctionElement;
import hec.rss.wq.client.boundarycondition.BoundaryConditionUtilities;
import hec.rss.wq.dataSources.DataSourceFactory;
import hec.rss.wq.model.BoundaryConditionSetManager;
import hec.rss.wq.ui.DataSource;
import hec.rss.wq.ui.ParameterMap;
import hec.rss.wq.ui.TimeSeriesDataSource;
import hec.wqenginecore.BoundaryCondition;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.geometry.SubDomainBoundary;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

public class ConstituentPlotPanel
extends JPanel {
    private G2dPanel _plotPanel;
    private List<SubDomainBoundary> _boundaries;
    private BoundaryConditionSetManager _bcSetManager;

    public ConstituentPlotPanel() {
        this.initControls();
    }

    private void initControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
        this._plotPanel = new G2dPanel();
        ConstituentPlotPanel constituentPlotPanel = this;
        constituentPlotPanel.add((Component)constituentPlotPanel._plotPanel, gridBagConstraints);
    }

    private List<SubDomainBoundary> getAllBoundariesFromMap(Map<JunctionElement, List<SubDomainBoundary>> object) {
        ArrayList<SubDomainBoundary> arrayList = new ArrayList<SubDomainBoundary>();
        for (Map.Entry entry : object.entrySet()) {
            SubDomainBoundary subDomainBoundary = BoundaryConditionUtilities.a((List)entry.getValue());
            if (subDomainBoundary != null) {
                arrayList.add(subDomainBoundary);
            }
            List<SubDomainBoundary> object2 = BoundaryConditionUtilities.b((List)entry.getValue());
            arrayList.addAll(object2);
        }
        return arrayList;
    }

    public void setData(BoundaryConditionSetManager boundaryConditionSetManager, Map<JunctionElement, List<SubDomainBoundary>> map, Constituent constituent) {
        this._boundaries = this.getAllBoundariesFromMap(map);
        this._bcSetManager = boundaryConditionSetManager;
        this.showConstituent(constituent);
    }

    private void showConstituent(Constituent constituent) {
        TimeWindow timeWindow;
        Object object;
        ArrayList<String> arrayList;
        Object object2;
        this._plotPanel.setVisible(false);
        this._plotPanel.clearPanel();
        if (constituent == null) {
            this._plotPanel.setVisible(true);
            return;
        }
        TimeWindow object6 = null;
        for (SubDomainBoundary object52 : this._boundaries) {
            object2 = this._bcSetManager.getSet().getBoundaryCondition(constituent, object52);
            if (object2 == null) continue;
            arrayList = object2.getDataSources();
            for (Data data : arrayList) {
                DataSource dataSource;
                if (object2.getSelectedDataSource() == null || !((dataSource = DataSourceFactory.a(data)) instanceof TimeSeriesDataSource) || (object = ((TimeSeriesDataSource)dataSource).getTimeWindow()) == null) continue;
                if (object6 == null) {
                    object6 = object;
                    continue;
                }
                if (object.getStartDate().before(object6.getStartDate())) {
                    object6.setStartDate(object.getStartDate());
                }
                if (!object.getEndDate().after(object6.getEndDate())) continue;
                object6.setEndDate(object.getEndDate());
            }
        }
        Object object722 = ClientApp.frame().getCurrentMode();
        if (object722 instanceof RSimSimulationMode && (timeWindow = ((RSimSimulationMode)object722).getSimTimeWindow()) != null) {
            object6 = timeWindow;
        }
        ArrayList<TimeSeriesDataSet> arrayList2 = new ArrayList<TimeSeriesDataSet>();
        object2 = new HashMap();
        arrayList = new ArrayList<String>();
        for (SubDomainBoundary subDomainBoundary : this._boundaries) {
            BoundaryCondition boundaryCondition = this._bcSetManager.getSet().getBoundaryCondition(constituent, subDomainBoundary);
            if (boundaryCondition == null) continue;
            for (Object object722 : boundaryCondition.getDataSources()) {
                DataSource dataSource = DataSourceFactory.a((Data)object722);
                if (!(dataSource instanceof TimeSeriesDataSource)) continue;
                if (object6 != null) {
                    object722 = new ParameterMap();
                    ((ParameterMap)object722).a(TimeSeriesDataSource.TIME_WINDOW_PARAMETER, object6);
                    object722 = ((TimeSeriesDataSource)dataSource).getTimeSeries((ParameterMap)object722);
                } else {
                    object722 = ((TimeSeriesDataSource)dataSource).getTimeSeries();
                }
                object722 = object722.iterator();
                while (object722.hasNext()) {
                    TimeSeriesContainer timeSeriesContainer = (TimeSeriesContainer)object722.next();
                    TimeSeriesDataSet timeSeriesDataSet = new TimeSeriesDataSet(timeSeriesContainer);
                    String string = timeSeriesDataSet.getData().getUnits();
                    if (!arrayList.contains(string)) {
                        arrayList.add(string);
                    }
                    timeSeriesDataSet.setName(subDomainBoundary.getName() + " - " + dataSource.getName());
                    arrayList2.add(timeSeriesDataSet);
                }
            }
        }
        Iterator<Object> iterator = new PlotLayout();
        for (TimeSeriesDataSet timeSeriesDataSet : arrayList2) {
            object = timeSeriesDataSet.getData().getUnits();
            if (object2.containsKey(object)) {
                ((List)object2.get(object)).add(timeSeriesDataSet);
                continue;
            }
            object722 = new ArrayList<TimeSeriesDataSet>();
            object722.add(timeSeriesDataSet);
            object2.put(object, object722);
        }
        for (Map.Entry entry : object2.entrySet()) {
            object = iterator.addViewport();
            for (DataSource dataSource : (List)entry.getValue()) {
                object.addCurve("Y1", (Object)dataSource);
            }
            object.setAxisLabel("Y1", constituent.getDisplayName() + "\n(" + (String)entry.getKey() + ")");
        }
        this._plotPanel.buildComponents(iterator);
        this._plotPanel.setVisible(true);
        this._plotPanel.revalidate();
    }
}

