/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.boundarycondition;

import hec.rss.wq.client.boundarycondition.JunctionSummaryPanel;
import hec.rss.wq.client.boundarycondition.JunctionSummaryPlotPanel;
import hec.rss.wq.model.BoundaryConditionSetManager;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.geometry.SubDomainBoundary;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import rma.swing.RmaInsets;

public class JunctionSummaryCardPanel
extends JPanel {
    private JPanel _cardPanel;
    private JunctionSummaryPanel _junctionSummaryPanel;
    private JunctionSummaryPlotPanel _junctionSummaryPlotPanel;
    private JRadioButton _summaryRadioButton;
    private JRadioButton _stackedPlotRadioButton;
    private final BoundaryConditionSetManager _wqSet;
    private final SubDomainBoundary _boundary;

    public JunctionSummaryCardPanel(BoundaryConditionSetManager boundaryConditionSetManager, SubDomainBoundary subDomainBoundary) {
        this.initComponents();
        this._boundary = subDomainBoundary;
        this._wqSet = boundaryConditionSetManager;
    }

    private void initComponents() {
        this._cardPanel = new JPanel();
        this._cardPanel.setLayout(new CardLayout());
        this._junctionSummaryPanel = new JunctionSummaryPanel();
        this._junctionSummaryPlotPanel = new JunctionSummaryPlotPanel();
        this._cardPanel.add((Component)this._junctionSummaryPanel, "SUMMARY");
        this._cardPanel.add((Component)this._junctionSummaryPlotPanel, "PLOT");
        Serializable serializable = new ButtonGroup();
        this._summaryRadioButton = new JRadioButton(WqI18n.a("BC.BoundaryConditionsEditor.JunctionSummaryCardPanel.Summary").getText());
        this._summaryRadioButton.setSelected(true);
        this._stackedPlotRadioButton = new JRadioButton(WqI18n.a("BC.BoundaryConditionsEditor.JunctionSummaryCardPanel.StackedPlot").getText());
        serializable.add(this._summaryRadioButton);
        serializable.add(this._stackedPlotRadioButton);
        this._stackedPlotRadioButton.addActionListener(actionEvent -> this.stackedPlotRadioButtonActionPerformed());
        this._summaryRadioButton.addActionListener(this::summaryRadioButtonActionPerformed);
        this.setLayout(new GridBagLayout());
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5505;
        JunctionSummaryCardPanel junctionSummaryCardPanel = this;
        junctionSummaryCardPanel.add((Component)junctionSummaryCardPanel.buildTopRadioButtonsPanel(), serializable);
        ((GridBagConstraints)serializable).gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5555;
        JunctionSummaryCardPanel junctionSummaryCardPanel2 = this;
        junctionSummaryCardPanel2.add((Component)junctionSummaryCardPanel2._cardPanel, serializable);
    }

    private JPanel buildTopRadioButtonsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.add(this._summaryRadioButton);
        jPanel.add(this._stackedPlotRadioButton);
        return jPanel;
    }

    private void summaryRadioButtonActionPerformed(ActionEvent actionEvent) {
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, "SUMMARY");
    }

    private void stackedPlotRadioButtonActionPerformed() {
        this._junctionSummaryPlotPanel.fillPanel(this._wqSet, this._boundary);
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, "PLOT");
    }

    public void fillPanel(SubDomainBoundary subDomainBoundary, BoundaryConditionSetManager boundaryConditionSetManager) {
        this._junctionSummaryPanel.fillPanel(subDomainBoundary, boundaryConditionSetManager);
        this._junctionSummaryPlotPanel.fillPanel(boundaryConditionSetManager, subDomainBoundary);
    }

    public void validateData() {
    }

    public void save() {
    }
}

