/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.boundarycondition;

import hec.rss.wq.model.BoundaryConditionSetManager;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.BoundaryCondition;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.constant.ConstantData;
import hec.wqenginecore.dataSource.excel.ExcelData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.geometry.SubDomainBoundary;
import hec.wqengineimpl.WQConstituentSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;
import rma.swing.table.MleHeadRenderer;
import rma.swing.table.RmaTableModel;
import rma.util.RMAIO;

public class JunctionSummaryPanel
extends JPanel {
    private RmaJTable _junctionSummaryTable;

    public JunctionSummaryPanel() {
        this.initComponents();
    }

    private void initComponents() {
        JScrollPane jScrollPane = new JScrollPane();
        this.setLayout(new GridBagLayout());
        this._junctionSummaryTable = new RmaJTable((Component)this);
        this._junctionSummaryTable.getTableHeader().setDefaultRenderer((TableCellRenderer)new MleHeadRenderer());
        jScrollPane.setViewportView((Component)this._junctionSummaryTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    public void fillPanel(SubDomainBoundary subDomainBoundary, BoundaryConditionSetManager boundaryConditionSetManager) {
        Object object;
        Vector<String> vector = new Vector<String>();
        vector.add(WqI18n.a("BC.BoundaryConditionsEditor.JunctionSummaryPanel.Column.Constituents").getText());
        vector.add(WqI18n.a("BC.BoundaryConditionsEditor.JunctionSummaryPanel.Column.DataSource").getText());
        vector.add(WqI18n.a("BC.BoundaryConditionsEditor.JunctionSummaryPanel.Column.Value").getText());
        Vector vector2 = new Vector();
        if (subDomainBoundary != null && (object = boundaryConditionSetManager.getConstituentSet().getSet()) != null) {
            BoundaryCondition boundaryCondition2 = object.getConstituentList();
            for (BoundaryCondition boundaryCondition2 : boundaryCondition2) {
                Constituent constituent;
                Vector<Object> vector3 = new Vector<Object>();
                boundaryCondition2 = boundaryConditionSetManager.getSet().getBoundaryCondition((Constituent)boundaryCondition2, subDomainBoundary);
                if (boundaryCondition2 == null || !(constituent = ((WQConstituentSet)boundaryConditionSetManager.getConstituentSet().getSet()).getConstituent(boundaryCondition2.getConstituentId())).getIsAdvected().booleanValue()) continue;
                String string = constituent.getDisplayName();
                vector3.add(string + " (" + constituent.getUnit() + ")");
                if (boundaryCondition2.getSelectedDataSource() != null) {
                    boundaryCondition2 = this.getDataValues(boundaryCondition2.getSelectedDataSource());
                    vector3.add(boundaryCondition2[0]);
                    vector3.add(boundaryCondition2[1]);
                } else {
                    vector3.add("");
                    vector3.add("");
                }
                vector2.add(vector3);
            }
        }
        object = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            ((Vector)object).add(Boolean.FALSE);
        }
        RmaTableModel rmaTableModel = new RmaTableModel(vector, vector2, (Vector)object);
        this._junctionSummaryTable.setModel((TableModel)rmaTableModel);
    }

    private String[] getDataValues(Data data) {
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray[0] = data.getName();
        stringArray2[1] = "";
        if (data instanceof ConstantData) {
            stringArray2[1] = RMAIO.toTable((double)((ConstantData)data).getConstantValue());
        } else if (data instanceof DssData) {
            stringArray2[1] = ((DssData)data).getDssFilePath();
        } else if (data instanceof ExcelData) {
            stringArray2[1] = ((ExcelData)data).getExcelFilePath() + ":" + ((ExcelData)data).getWorksheetName();
        }
        return stringArray2;
    }

    public void validateData() throws IOException {
    }

    public void save() throws IOException {
    }
}

