/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.constituentSet;

import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.Constituent;
import hec.wqengineimpl.WQConstituent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import rma.lang.Modifiable;
import rma.swing.table.AbstractRmaTableModel;

public class ConstituentSelectionModel
extends AbstractRmaTableModel
implements Modifiable {
    public static final Logger LOGGER = Logger.getLogger(ConstituentSelectionModel.class.getName());
    public static final int SEL_COL = 0;
    public static final int NAME_COL = 1;
    public static final int OBJECT_COL = 2;
    private final List<Constituent> _constituents = new ArrayList<Constituent>();
    private final BitSet _selected = new BitSet();
    private boolean _modified;

    public ConstituentSelectionModel() {
        this.m_columnNames = new String[]{WqI18n.a("ConstituentSelector.TableHeader.Select").getText(), WqI18n.a("ConstituentSelector.TableHeader.Constituent").getText(), WqI18n.a("ConstituentSelector.TableHeader.Object").getText()};
    }

    public void setData(Set<Constituent> object, List<Constituent> list) {
        this._selected.clear();
        this._constituents.clear();
        int n = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Constituent constituent = (Constituent)object.next();
            if (!(constituent instanceof WQConstituent)) continue;
            constituent = (WQConstituent)constituent;
            this._constituents.add(constituent);
            boolean bl = false;
            if (list != null) {
                bl = list.contains(constituent);
            }
            this._selected.set(n++, bl);
        }
        this.fireTableDataChanged();
    }

    public boolean isCellEditable(int n, int n2) {
        n = 0;
        if (n2 == 0) {
            n = 1;
        }
        return n != 0;
    }

    public int getRowCount() {
        return this._constituents.size();
    }

    public Object getValueAt(int n, int n2) {
        Object object = null;
        Constituent constituent = this._constituents.get(n);
        if (constituent != null) {
            switch (n2) {
                case 0: {
                    object = this._selected.get(n);
                    break;
                }
                case 1: {
                    object = constituent.getDisplayName();
                    break;
                }
                case 2: {
                    object = constituent;
                }
            }
        }
        return object;
    }

    public void setValueAt(Object object, int n, int n2) {
        Constituent constituent = this._constituents.get(n);
        if (constituent instanceof WQConstituent) {
            constituent = (WQConstituent)constituent;
            switch (n2) {
                case 0: {
                    n2 = 0;
                    if (object instanceof Boolean) {
                        n2 = ((Boolean)object).booleanValue() ? 1 : 0;
                    } else if (object instanceof String) {
                        n2 = Boolean.parseBoolean((String)object) ? 1 : 0;
                    }
                    this._modified = true;
                    this._selected.set(n, n2 != 0);
                    return;
                }
                case 1: {
                    constituent.setName(String.valueOf(object));
                    return;
                }
                case 2: {
                    if (!(object instanceof Constituent)) break;
                    object = (Constituent)object;
                    this._constituents.set(n, (Constituent)object);
                }
            }
        }
    }

    public void deleteRow(int n) {
        if (n < 0) {
            return;
        }
        if (n < this._constituents.size()) {
            this._constituents.remove(n);
        }
        int n2 = n;
        this.fireTableRowsDeleted(n2, n2);
    }

    public List<Constituent> getSelected() {
        List<Constituent> list = IntStream.range(0, this._constituents.size()).filter(this._selected::get).mapToObj(this._constituents::get).collect(Collectors.toList());
        return list;
    }

    public void clearSelections() {
        for (int i = 0; i < this._constituents.size(); ++i) {
            this._selected.set(i, false);
        }
        this._modified = true;
        this.fireTableRowsUpdated(0, this._constituents.size());
    }

    public boolean isModified() {
        return this._modified;
    }

    public void setModified(boolean bl) {
        this._modified = bl;
    }
}

