/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.constituentSet;

import hec.rss.wq.client.constituentSet.ConstituentSelectionModel;
import hec.rss.wq.client.constituentSet.ConstituentSetEditor;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.Library;
import hec.wqenginecore.LibraryRegistry;
import hec.wqengineimpl.WQLibraryRegistryImpl;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.table.TableModel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;

public class ConstituentSelector
extends RmaJDialog
implements ActionListener {
    private static LibraryRegistry a = new WQLibraryRegistryImpl();
    private ConstituentSetEditor _parent;
    private RmaJComboBox<Library> _libraryComboBox;
    private ButtonCmdPanel _cmdButtonPanel;
    private RmaJTable _libraryTable;
    private ConstituentSelectionModel _libraryModel;
    private Runnable _updateModelRunnable;
    private JButton _clearSelectionsBtn;
    private Map<Library, ConstituentSelectionModel> _libraryToModelMap = new HashMap<Library, ConstituentSelectionModel>();

    public ConstituentSelector(ConstituentSetEditor constituentSetEditor, boolean bl) {
        super((Dialog)((Object)constituentSetEditor), bl);
        this._parent = constituentSetEditor;
        this.buildControls();
        this.initControls();
        this.addListeners();
        this._libraryComboBox.setSelectedIndex(0);
    }

    public void addCmdPanelListener(ButtonCmdPanelListener buttonCmdPanelListener) {
        this._cmdButtonPanel.addCmdPanelListener(buttonCmdPanelListener);
    }

    private void addListeners() {
        this._libraryComboBox.addActionListener((ActionListener)this);
        this._clearSelectionsBtn.addActionListener(actionEvent -> this.clearSelections());
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(350, 350);
        ConstituentSelector constituentSelector = this;
        constituentSelector.setLocationRelativeTo(constituentSelector.getParent());
        this.setTitle(WqI18n.a("ConstituentSelector.Title").getText());
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)jPanel, new RmaGridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 1, RmaInsets.INSETS0000, 0, 0));
        JComponent jComponent = new JPanel(new GridBagLayout());
        JLabel jLabel = WqI18n.a("ConstituentSelector.Label.Library").createJLabel();
        jComponent.add((Component)jLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, RmaInsets.INSETS5500, 0, 0));
        this._libraryComboBox = new RmaJComboBox();
        jComponent.add((Component)this._libraryComboBox, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, RmaInsets.INSETS5500, 0, 0));
        this._libraryTable = new RmaJTable((Component)((Object)this));
        this._libraryTable.setRowHeight(this._libraryTable.getRowHeight() + 5);
        this._libraryTable.removePopuMenuFillOptions();
        this._libraryTable.removePopupMenuRowEditingOptions();
        this._libraryTable.removePopupMenuSumOptions();
        this._libraryTable.setModel((TableModel)((Object)new ConstituentSelectionModel()));
        this._libraryTable.setCheckBoxCellEditor(0);
        this._libraryTable.setColumnVisible(2, false, 0);
        jComponent.add((Component)this._libraryTable.getScrollPane(), new RmaGridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, RmaInsets.INSETS5500, 0, 0));
        this._clearSelectionsBtn = WqI18n.a("ConstituentSelector.Button.ClearSelections").createJButton();
        jPanel.add((Component)this._clearSelectionsBtn, new RmaGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5505, 0, 0));
        jPanel.add((Component)jComponent, new RmaGridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 1, RmaInsets.INSETS5505, 0, 0));
        jComponent = new JSeparator();
        jPanel.add((Component)jComponent, new RmaGridBagConstraints(0, 3, 5, 1, 0.0, 0.0, 18, 2, RmaInsets.INSETS5500, 0, 0));
        this._cmdButtonPanel = new ButtonCmdPanel(14);
        this.getContentPane().add((Component)this._cmdButtonPanel, new RmaGridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
    }

    private void initControls() {
        this._libraryToModelMap.clear();
        for (Library library : a.getLibraries()) {
            ConstituentSelectionModel constituentSelectionModel = new ConstituentSelectionModel();
            List<Constituent> list = this._parent.getConstituents(library.getName());
            Set set = library.listConstituents();
            constituentSelectionModel.setData(set, list);
            this._libraryToModelMap.put(library, constituentSelectionModel);
            this._libraryComboBox.addItem((Object)library);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this._libraryComboBox == actionEvent.getSource() && this._updateModelRunnable == null) {
            actionEvent = (Library)this._libraryComboBox.getSelectedItem();
            this._libraryModel = this._libraryToModelMap.get(actionEvent);
            this._libraryTable.setModel((TableModel)((Object)this._libraryModel));
            this._libraryTable.setCheckBoxCellEditor(0);
            if (this._libraryTable.getColumnCount() > 2) {
                this._libraryTable.setColumnVisible(2, false, 0);
            }
        }
    }

    private void clearSelections() {
        this._libraryModel.clearSelections();
        this.setModified(true);
    }

    public void updateLibraryModels() {
        for (Library library : a.getLibraries()) {
            ConstituentSelectionModel constituentSelectionModel = new ConstituentSelectionModel();
            List<Constituent> list = this._parent.getConstituents(library.getName());
            Set set = library.listConstituents();
            constituentSelectionModel.setData(set, list);
            this._libraryToModelMap.put(library, constituentSelectionModel);
        }
        Library library = (Library)this._libraryComboBox.getSelectedItem();
        this._libraryModel = this._libraryToModelMap.get(library);
        this._libraryTable.setModel((TableModel)((Object)this._libraryModel));
        this._libraryTable.setCheckBoxCellEditor(0);
        this._libraryTable.setColumnVisible(2, false, 0);
    }

    public void updateModel() {
        Object object = this._libraryComboBox.getSelectedItem();
        if (object instanceof Library) {
            object = (Library)object;
            List<Constituent> list = this._parent.getConstituents(object.getName());
            object = object.listConstituents();
            this._libraryModel.setData((Set<Constituent>)object, list);
        }
    }

    public void setSelectedConstituents(Library object, Collection<Constituent> collection) {
        if (object == null) {
            return;
        }
        ConstituentSelectionModel constituentSelectionModel = this._libraryToModelMap.get(object);
        object = object.listConstituents();
        constituentSelectionModel.setData((Set<Constituent>)object, collection.stream().collect(Collectors.toList()));
        this.setModified(true);
    }

    public Library getSelectedLibrary() {
        Object object = this._libraryComboBox.getSelectedItem();
        if (object instanceof Library) {
            return (Library)object;
        }
        return null;
    }

    public List<Library> getModifiedLibraries() {
        ArrayList<Library> arrayList = new ArrayList<Library>();
        Object object = this._libraryToModelMap.entrySet();
        object = object.iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            if (!((ConstituentSelectionModel)((Object)entry.getValue())).isModified()) continue;
            arrayList.add((Library)entry.getKey());
        }
        return arrayList;
    }

    public List<Constituent> getSelectedConstituents(Library object) {
        object = this._libraryToModelMap.get(object);
        return object.getSelected();
    }
}

