/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.constituentSet;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.gui.SelectorPanelEditor;
import hec.io.Identifier;
import hec.rss.wq.client.WaterQualityMode$Creator;
import hec.rss.wq.client.WaterQualityMode$Deleter;
import hec.rss.wq.client.WaterQualityMode$Rename;
import hec.rss.wq.client.WaterQualityMode$SaveAs;
import hec.rss.wq.client.constituentSet.ConstituentSetPanel;
import hec.rss.wq.model.ConstituentSetManager;
import hec.rss.wq.model.JsonManager;
import hec.rss.wq.model.ManagerProxyWrapper;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.Constituent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class ConstituentSetEditor
extends SelectorPanelEditor {
    private JMenuItem _menuItemNew;
    private JMenuItem _menuItemDelete;
    private JMenuItem _menuItemSaveAs;
    private ManagerProxyListContainer _wksp;
    private WaterQualityMode$Creator<ConstituentSetManager> _creator;
    private WaterQualityMode$Deleter<ConstituentSetManager> _deleter;
    private WaterQualityMode$SaveAs<ConstituentSetManager> _saveAs;
    private WaterQualityMode$Rename<ConstituentSetManager> _rename;
    private String _title;
    private ConstituentSetPanel _constituentPanel;
    private JMenu _wqSetMenu;

    public ConstituentSetEditor(Frame frame) {
        super(frame, false);
        this.createControls();
        this.buildMenuBar();
        this.addListeners();
    }

    private void createControls() {
        this._constituentPanel = new ConstituentSetPanel(this);
        ConstituentSetEditor constituentSetEditor = this;
        constituentSetEditor.addPanel(constituentSetEditor._constituentPanel);
        this.pack();
        this.setSize(700, 400);
        ConstituentSetEditor constituentSetEditor2 = this;
        constituentSetEditor2.setMinimumSize(constituentSetEditor2.getSize());
        ConstituentSetEditor constituentSetEditor3 = this;
        constituentSetEditor3.setLocationRelativeTo(constituentSetEditor3.getParent());
        this._title = WqI18n.a("Constituent.Editor.Title").getText();
        ConstituentSetEditor constituentSetEditor4 = this;
        constituentSetEditor4.setTitle(constituentSetEditor4._title);
    }

    private void buildMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        this._wqSetMenu = WqI18n.a("Constituent.Menu.Set").createMenu();
        this._menuItemNew = WqI18n.a("Constituent.Menu.New").createMenuItem();
        this._wqSetMenu.add(this._menuItemNew);
        this._menuItemSaveAs = WqI18n.a("Constituent.Menu.SaveAs").createMenuItem();
        this._wqSetMenu.add(this._menuItemSaveAs);
        this._menuItemDelete = WqI18n.a("Constituent.Menu.Delete").createMenuItem();
        this._wqSetMenu.add(this._menuItemDelete);
        jMenuBar.add(this._wqSetMenu);
        this.setJMenuBar(jMenuBar);
    }

    private void addListeners() {
        this._menuItemNew.addActionListener(object -> {
            object = this._creator.create();
            if (object != null) {
                ClientWorkspace clientWorkspace = ClientApp.Workspace();
                clientWorkspace = clientWorkspace.getManagerProxyList("rss");
                object = clientWorkspace.getManagerProxy(ConstituentSetManager.class.getName(), ((JsonManager)((Object)((Object)object))).getIndex());
                this.getSelectorPanel().addSelectionItem((Object)new ManagerProxyWrapper((ManagerProxy)object), true);
            }
        });
        this._menuItemDelete.addActionListener(object -> {
            object = this._deleter.delete(this._constituentPanel.getSelectedManager());
            this.removeProxiesMatching((List<Identifier>)((Object)object));
        });
        this._menuItemSaveAs.addActionListener(actionEvent -> this.saveConstituentSetAs());
    }

    private void renameConstituentSet() {
        ConstituentSetManager constituentSetManager = this._rename.rename(this._constituentPanel.getSelectedManager());
        if (constituentSetManager != null) {
            this.getSelectorPanel().getComboBox().repaint();
            this.getSelectorPanel().setDescription(((JsonManager)constituentSetManager).getDescription());
        }
    }

    private void saveConstituentSetAs() {
        Object object;
        ConstituentSetManager constituentSetManager = this._constituentPanel.getSelectedManager();
        if (this.isModified() && constituentSetManager != null) {
            String string;
            object = WqI18n.a("Constituent.Editor.Msg.SaveMgr").format((Object)constituentSetManager);
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), object, string = WqI18n.a("Constituent.Editor.Msg.SaveMgr.Title").getText(), 1);
            if (n == 0) {
                this.saveForm();
            } else if (2 == n) {
                return;
            }
        }
        if ((object = this._saveAs.saveAs(constituentSetManager)) != null) {
            String string = ((JsonManager)((Object)object)).getDescription();
            this._constituentPanel.savePanel((ConstituentSetManager)((Object)object));
            ((ConstituentSetManager)((Object)object)).setDescription(string);
            string = ClientApp.Workspace();
            constituentSetManager = string.getManagerProxy("rss", ConstituentSetManager.class.getName(), ((JsonManager)((Object)object)).getIndex());
            this.setModified(false);
            this.getSelectorPanel().addSelectionItem((Object)new ManagerProxyWrapper((ManagerProxy)constituentSetManager), true);
        }
    }

    private void updateEditEnable() {
        boolean bl = this.getSelectorPanel().getSelectorItems().isEmpty();
        if (bl) {
            this.getSelectorPanel().setSelectedIndex(-1);
        }
    }

    private void removeProxiesMatching(List<Identifier> list) {
        boolean bl = false;
        int n = this.getSelectorPanel().getSelectedIndex();
        List list2 = this.getSelectorPanel().getSelectorItems();
        for (int i = list2.size() - 1; i >= 0; --i) {
            ManagerProxyWrapper managerProxyWrapper = (ManagerProxyWrapper)((Object)list2.get(i));
            ManagerProxy managerProxy = managerProxyWrapper.getManagerProxy();
            if (!list.contains(managerProxy = managerProxy.getId())) continue;
            this.getSelectorPanel().getComboBox().removeItem((Object)managerProxyWrapper);
            if (i != n) continue;
            bl = true;
        }
        if (bl) {
            this.setModified(false);
            EventQueue.invokeLater(() -> {
                if (this.getSelectorPanel().getSelectorItems().isEmpty()) {
                    this.updateEditEnable();
                    this._constituentPanel.fillPanel(null);
                    this.clearForm();
                    return;
                }
                this.getSelectorPanel().setSelectedIndex(0);
            });
        }
    }

    public void fillForm(ManagerProxyListContainer managerProxyListContainer) {
        this._wksp = managerProxyListContainer;
        this._wqSetMenu.setVisible(this._wksp instanceof ClientWorkspace);
        this._constituentPanel.setWorkspace(managerProxyListContainer);
        this.fillCombo();
        this.updateEditEnable();
    }

    private void fillCombo() {
        Vector vector = this._wksp.getManagerProxyList("rss", ConstituentSetManager.class.getName());
        List list = vector.stream().map(managerProxy -> new ManagerProxyWrapper((ManagerProxy)managerProxy)).collect(Collectors.toList());
        this.getSelectorPanel().setSelectionList(list);
        if (vector.isEmpty()) {
            this.getSelectorPanel().setSelectedIndex(-1);
            this._constituentPanel.setEnabled(false);
            return;
        }
        this.getSelectorPanel().setSelectedIndex(0);
    }

    public void setCreator(WaterQualityMode$Creator<ConstituentSetManager> waterQualityMode$Creator) {
        this._creator = waterQualityMode$Creator;
    }

    public void setDeleter(WaterQualityMode$Deleter<ConstituentSetManager> waterQualityMode$Deleter) {
        this._deleter = waterQualityMode$Deleter;
    }

    public void setRename(WaterQualityMode$Rename<ConstituentSetManager> waterQualityMode$Rename) {
        this._rename = waterQualityMode$Rename;
    }

    public void setSaveAs(WaterQualityMode$SaveAs<ConstituentSetManager> waterQualityMode$SaveAs) {
        this._saveAs = waterQualityMode$SaveAs;
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
        String string = this._title;
        if (bl) {
            string = string.concat("*");
        }
        this.setTitle(string);
    }

    public List<Constituent> getConstituents(String string) {
        return this._constituentPanel.getConstituents(string);
    }

    public void setSelectedConstituentSetManager(ConstituentSetManager object) {
        object = object.getProxyList().getManagerProxy(object.getIdentifier());
        object = new ManagerProxyWrapper((ManagerProxy)object);
        this.selectorPanel.setSelectedItem(object);
    }

    static {
        Logger.getLogger(ConstituentSetEditor.class.getName());
    }
}

