/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.constituentSet;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.rss.wq.client.constituentSet.ConstituentSelector;
import hec.rss.wq.client.constituentSet.ConstituentSetEditor;
import hec.rss.wq.client.constituentSet.ConstituentSetPanel$1;
import hec.rss.wq.client.constituentSet.ConstituentTableModel;
import hec.rss.wq.model.ConstituentSetManager;
import hec.rss.wq.model.JsonManager;
import hec.rss.wq.model.ManagerProxyWrapper;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.ConstituentSet;
import hec.wqenginecore.Library;
import hec.wqengineimpl.WQConstituent;
import hec.wqengineimpl.WQConstituentSet;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;

public class ConstituentSetPanel
extends AbstractEditorPanel {
    private static final Logger a = Logger.getLogger(ConstituentSetEditor.class.getName());
    private ConstituentSetEditor _editor;
    private RmaJTable _constituentTable;
    private ConstituentTableModel _tableModel;
    private JButton _editConstituentsBtn;
    private ConstituentSelector _constituentSelector;
    private ManagerProxyListContainer _wksp;
    private ManagerProxyWrapper _selectedWrapper;

    public ConstituentSetPanel(ConstituentSetEditor constituentSetEditor) {
        super((LayoutManager)new GridBagLayout());
        this._editor = constituentSetEditor;
        this.buildControls();
        this.addListeners();
    }

    private void buildControls() {
        ConstituentSetPanel constituentSetPanel = this;
        this._constituentTable = new ConstituentSetPanel$1(constituentSetPanel, (Component)((Object)constituentSetPanel));
        this._constituentTable.removePopuMenuFillOptions();
        this._constituentTable.removePopupMenuInsertAppendOnly();
        this._constituentTable.removePopupMenuSumOptions();
        this._constituentTable.setRowSelectionAllowed(true);
        Serializable serializable = UIManager.getFont("ToolTip.font");
        Font font = this._constituentTable.getFont();
        serializable = new Font(serializable.getName(), font.getStyle(), font.getSize());
        this._constituentTable.setFont(serializable);
        this._constituentTable.setRowHeight(this._constituentTable.getRowHeight() + 5);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5505;
        ConstituentSetPanel constituentSetPanel2 = this;
        constituentSetPanel2.add(constituentSetPanel2._constituentTable.getScrollPane(), serializable);
        this._editConstituentsBtn = WqI18n.a("Constituent.Editor.Button.Edit").createJButton();
        ((GridBagConstraints)serializable).gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 0.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5505;
        ConstituentSetPanel constituentSetPanel3 = this;
        constituentSetPanel3.add(constituentSetPanel3._editConstituentsBtn, serializable);
    }

    private void addListeners() {
        this._editConstituentsBtn.addActionListener(actionEvent -> this.editBtnAction());
    }

    private void editBtnAction() {
        if (this._constituentSelector == null) {
            this._constituentSelector = new ConstituentSelector(this._editor, true);
            this._constituentSelector.addCmdPanelListener(this::selectorButtonCmdActionPerformed);
        }
        this._constituentSelector.updateLibraryModels();
        this._constituentSelector.setModified(false);
        this._constituentSelector.setVisible(true);
    }

    public String getTabname() {
        return "";
    }

    public void fillPanel(NamedType namedType) {
        if (namedType == null) {
            this.setEnabled(false);
            this._constituentTable.deleteCells();
            this._selectedWrapper = null;
            return;
        }
        if (namedType instanceof ManagerProxyWrapper) {
            this.setEnabled(true);
            this._selectedWrapper = (ManagerProxyWrapper)namedType;
            namedType = this._selectedWrapper.getManagerProxy();
            this.fillWithSelectedSet((ManagerProxy)namedType);
        }
    }

    private void fillWithSelectedSet(ManagerProxy object) {
        object = (ConstituentSetManager)object.loadManager(null, null);
        object = (object = object.getSet()) != null ? object.getConstituentList() : Collections.emptyList();
        this.fillTable((Collection<Constituent>)object);
    }

    private void fillTable(Collection<Constituent> collection) {
        this._constituentTable.setRowSorter(null);
        this._tableModel = new ConstituentTableModel(collection);
        this._constituentTable.setModel((TableModel)((Object)this._tableModel));
        this._constituentTable.setRowSorter(new TableRowSorter<ConstituentTableModel>(this._tableModel));
        this._constituentTable.setDoubleCellEditor(5);
        this._constituentTable.setColumnVisible(0, false, 0);
    }

    public boolean savePanel(NamedType object) {
        if (object == null) {
            object = this._selectedWrapper;
        }
        if (object instanceof ManagerProxyWrapper) {
            object = ((ManagerProxyWrapper)((Object)object)).getManagerProxy();
            object = this.getConstituentSetManager((ManagerProxy)object);
            boolean bl = this.savePanel((ConstituentSetManager)((Object)object));
            return bl;
        }
        return true;
    }

    public boolean savePanel(ConstituentSetManager constituentSetManager) {
        if (constituentSetManager != null) {
            ConstituentSet constituentSet = constituentSetManager.getSet();
            this._constituentTable.commitEdit(true);
            if (!this.applyChanges(constituentSetManager, constituentSet)) {
                return false;
            }
            constituentSetManager.setModified(true);
            this.setModified(false);
        }
        return true;
    }

    private boolean applyChanges(ConstituentSetManager object, ConstituentSet constituentSet) {
        boolean bl = false;
        this._constituentTable.commitEdit(true);
        List<String> list = this.getDuplicateNames();
        if (list.isEmpty()) {
            if (constituentSet != null) {
                boolean bl2;
                Collection<Constituent> collection = this.getConstituentsFromTable();
                this.applyChanges(constituentSet, collection);
                if (object != null && !(bl2 = this._wksp.saveManager("rss", (Manager)object))) {
                    a.log(Level.INFO, "Failed to saveManager:{0}", ((JsonManager)((Object)object)).getName());
                    object = WqI18n.a("WqModule.Msg.FailedCreateMgr").format((Object)"Constituent Set");
                    String string = WqI18n.a("WqModule.Msg.FailedCreateMgr.Title").getText();
                    ClientApp.app().postError((String)object, string);
                    return false;
                }
            }
            bl = true;
            this.setModified(false);
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), WqI18n.a("Constituent.NonUnique").format(list));
        }
        return bl;
    }

    private ConstituentSet getSelectedConstituentSet() {
        ConstituentSet constituentSet = null;
        ConstituentSetManager constituentSetManager = this.getSelectedManager();
        if (constituentSetManager != null) {
            constituentSet = constituentSetManager.getSet();
        }
        return constituentSet;
    }

    ConstituentSetManager getSelectedManager() {
        ManagerProxyWrapper managerProxyWrapper = (ManagerProxyWrapper)((Object)this._editor.getSelectorPanel().getSelectedItem());
        if (managerProxyWrapper == null) {
            return null;
        }
        return this.getConstituentSetManager(managerProxyWrapper.getManagerProxy());
    }

    private void applyChanges(ConstituentSet constituentSet, Collection<Constituent> collection) {
        if (constituentSet instanceof WQConstituentSet) {
            constituentSet = (WQConstituentSet)constituentSet;
            constituentSet.setConstituentList(collection);
            constituentSet.setDescription(this._editor.getSelectorPanel().getDescription());
        }
    }

    private Collection<Constituent> getConstituentsFromTable() {
        ArrayList<Constituent> arrayList = new ArrayList<Constituent>();
        for (int i = 0; i < this._tableModel.getRowCount(); ++i) {
            Constituent constituent = (Constituent)this._tableModel.getValueAt(i, 0);
            arrayList.add(constituent);
        }
        return arrayList;
    }

    ConstituentSetManager getConstituentSetManager(ManagerProxy managerProxy) {
        ConstituentSetManager constituentSetManager = null;
        if (managerProxy != null) {
            Manager manager = managerProxy.getManager();
            if (manager == null) {
                manager = managerProxy.loadManager(null, null);
            }
            if (manager instanceof ConstituentSetManager) {
                constituentSetManager = (ConstituentSetManager)manager;
            }
        }
        return constituentSetManager;
    }

    public void selectorButtonCmdActionPerformed(ActionEvent object) {
        if ("cancel".equalsIgnoreCase((String)(object = ((ActionEvent)object).getActionCommand()))) {
            this._constituentSelector.setVisible(false);
            this._constituentSelector.setModified(false);
            return;
        }
        if ("ok".equalsIgnoreCase((String)object)) {
            if (this.applyConstituentChanges(true)) {
                this._constituentSelector.setVisible(false);
                return;
            }
        } else if ("apply".equalsIgnoreCase((String)object) && this.applyConstituentChanges(false)) {
            this._constituentSelector.updateModel();
        }
    }

    private boolean applyConstituentChanges(boolean bl) {
        int n = 1;
        List<Library> list = this._constituentSelector.getModifiedLibraries();
        for (int i = 0; i < list.size(); ++i) {
            boolean bl2;
            Library library = list.get(i);
            Collection<Object> collection = this._constituentSelector.getSelectedConstituents(library);
            Collection collection2 = library.addRequired(new LinkedHashSet<Constituent>(collection));
            List<Constituent> list2 = collection;
            collection = collection2;
            CharSequence charSequence = null;
            if (!Objects.equals(collection, list2)) {
                Object object;
                charSequence = new StringBuilder();
                LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
                if (collection != null) {
                    linkedHashSet.addAll(collection);
                }
                linkedHashSet.removeAll(list2);
                if (!linkedHashSet.isEmpty()) {
                    object = linkedHashSet.stream().map(Constituent::getName).collect(Collectors.toList());
                    ((StringBuilder)charSequence).append(WqI18n.a("Constituent.Selection.Xpand").getText());
                    int n2 = 5;
                    Object object2 = new AtomicInteger(0);
                    object = object.stream().collect(Collectors.groupingBy(arg_0 -> ConstituentSetPanel.a((AtomicInteger)object2, 5, arg_0))).values();
                    object = object.iterator();
                    while (object.hasNext()) {
                        object2 = (List)object.next();
                        ((StringBuilder)charSequence).append("\n  ");
                        object2 = String.join((CharSequence)", ", (Iterable<? extends CharSequence>)object2);
                        ((StringBuilder)charSequence).append((String)object2);
                    }
                }
                object = new LinkedHashSet<Constituent>();
                if (list2 != null) {
                    object.addAll(list2);
                }
                object.removeAll(collection);
                if (!object.isEmpty()) {
                    ((StringBuilder)charSequence).append(WqI18n.a("Constituent.Selection.Shrink").getText()).append(linkedHashSet).append("\n");
                }
                charSequence = ((StringBuilder)charSequence).toString();
            }
            if (bl2 = (collection = charSequence) != null && !((String)((Object)collection)).isEmpty()) {
                n = JOptionPane.showConfirmDialog((Component)((Object)this), collection, WqI18n.a("Constituent.Selection").format((Object)library.getName()), 2);
                if (n == 0) {
                    n = bl ? 1 : 0;
                    this._constituentSelector.setSelectedConstituents(library, collection2);
                } else {
                    n = 0;
                }
            }
            if (n == 0) continue;
            this.applyConstituentSelectorToTable(library.getName(), collection2);
            this._constituentSelector.setModified(false);
        }
        return n != 0;
    }

    public void applyConstituentSelectorToTable(String object, Collection<Constituent> constituent2) {
        if (object == null) {
            return;
        }
        SequencedCollection<Constituent> sequencedCollection = this.getConstituents((String)object);
        sequencedCollection = new LinkedHashSet<Constituent>(sequencedCollection);
        LinkedHashSet<Constituent> linkedHashSet = new LinkedHashSet<Constituent>(sequencedCollection);
        linkedHashSet.removeAll((Collection<?>)constituent2);
        constituent2 = new LinkedHashSet<Constituent>((Collection<Constituent>)constituent2);
        constituent2.removeAll(sequencedCollection);
        object = this._tableModel.getDisplayNameForLibName((String)object);
        this.removeRows((String)object, linkedHashSet.stream().map(Constituent::getName).collect(Collectors.toList()));
        for (Constituent constituent2 : constituent2) {
            this._tableModel.appendConstituent((WQConstituent)constituent2);
        }
        this.setModified(true);
    }

    private void removeRows(String string, List<String> list) {
        for (int i = this._tableModel.getRowCount() - 1; i >= 0; --i) {
            if (!Objects.equals(this._tableModel.getValueAt(i, 2), string) || !list.contains(this._tableModel.getValueAt(i, 1))) continue;
            this._tableModel.deleteRow(i);
        }
    }

    public List<Constituent> getConstituents(String string) {
        if (this._tableModel != null) {
            return this._tableModel.getConstituents(string);
        }
        return Collections.emptyList();
    }

    private List<String> getDuplicateNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        Object object = this.getConstituentDisplayNamesFromTable();
        HashSet<String> hashSet2 = new HashSet<String>();
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (hashSet2.contains(string)) {
                arrayList.add(string);
                if (hashSet.contains(string)) continue;
                arrayList.add(string);
                hashSet.add(string);
                continue;
            }
            hashSet2.add(string);
        }
        return arrayList;
    }

    private List<String> getConstituentDisplayNamesFromTable() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this._tableModel.getRowCount(); ++i) {
            String string = (String)this._tableModel.getValueAt(i, 3);
            arrayList.add(string);
        }
        return arrayList;
    }

    private boolean tableDisplayNamesUnique() {
        boolean bl = false;
        List<String> list = this.getConstituentDisplayNamesFromTable();
        if (list.size() > 1) {
            HashSet<String> hashSet = new HashSet<String>(list);
            bl = list.size() == hashSet.size();
        }
        return bl;
    }

    public void setWorkspace(ManagerProxyListContainer managerProxyListContainer) {
        this._wksp = managerProxyListContainer;
    }

    private static /* synthetic */ Integer a(AtomicInteger atomicInteger, int n, Object object) {
        return atomicInteger.getAndIncrement() / n;
    }
}

