/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.constituentSet;

import hec.wqenginecore.Constituent;
import hec.wqenginecore.Library;
import hec.wqengineimpl.WQConstituent;
import hec.wqengineimpl.WQLibraryRegistryImpl;
import hec.wqengineimpl.libraries.BaseWQLibrary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import rma.swing.table.AbstractRmaTableModel;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class ConstituentTableModel
extends AbstractRmaTableModel
implements RmaTableModelInterface {
    public static final Logger logger = Logger.getLogger(ConstituentTableModel.class.getName());
    public static final int OBJECT_COL = 0;
    public static final int NAME_COL = 1;
    public static final int LIBNAME_COL = 2;
    public static final int DISPLAY_COL = 3;
    public static final int UNIT_COL = 4;
    public static final int REF_COL = 5;
    private final List<Constituent> _constituents = new ArrayList<Constituent>();
    private WQLibraryRegistryImpl _library;

    public ConstituentTableModel() {
        this.m_columnNames = new String[]{"Obj", "Constituent", "Library", "Display Name", "Units", "Reference Value"};
    }

    public ConstituentTableModel(Collection<Constituent> object) {
        this();
        object = object.iterator();
        while (object.hasNext()) {
            Constituent constituent = (Constituent)object.next();
            if (!(constituent instanceof WQConstituent)) continue;
            constituent = (WQConstituent)constituent;
            this._constituents.add(constituent.copy());
        }
    }

    public boolean isCellEditable(int n, int n2) {
        n = 0;
        if (n2 == 3) {
            n = 1;
        }
        if (n2 == 5) {
            n = 1;
        }
        return n != 0;
    }

    public int getRowCount() {
        return this._constituents.size();
    }

    public Object getValueAt(int n, int n2) {
        Object object;
        Object object2 = null;
        if (n >= 0 && n < this._constituents.size() && (object = this._constituents.get(n)) != null) {
            switch (n2) {
                case 0: {
                    object2 = object;
                    break;
                }
                case 1: {
                    object2 = object.getName();
                    break;
                }
                case 2: {
                    object = object.getLibraryName();
                    object2 = this.getDisplayNameForLibName((String)object);
                    break;
                }
                case 3: {
                    object2 = object.getDisplayName();
                    break;
                }
                case 4: {
                    object2 = object.getUnit();
                    break;
                }
                case 5: {
                    object2 = object.getReferenceValue();
                    if (!(object2 instanceof Double) || !RMAConst.isUndefinedValue((double)((Double)object2))) break;
                    object2 = "";
                }
            }
        }
        return object2;
    }

    public String getDisplayNameForLibName(String string) {
        if (this._library == null) {
            this._library = new WQLibraryRegistryImpl();
        }
        string = (BaseWQLibrary)this._library.getLibrary(string);
        return string.getDisplayName();
    }

    public String getLibNameForDisplayName(String string) {
        if (this._library == null) {
            this._library = new WQLibraryRegistryImpl();
        }
        Object object = this._library.getLibraries();
        object = object.iterator();
        while (object.hasNext()) {
            Library library = (Library)object.next();
            if (!library.getDisplayName().equals(string)) continue;
            return library.getName();
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        Constituent constituent;
        if (n >= 0 && n < this._constituents.size() && (constituent = this._constituents.get(n)) instanceof WQConstituent) {
            constituent = (WQConstituent)constituent;
            switch (n2) {
                case 0: {
                    if (!(object instanceof Constituent)) break;
                    object = (Constituent)object;
                    this._constituents.set(n, (Constituent)object);
                    return;
                }
                case 1: {
                    constituent.setName(String.valueOf(object));
                    return;
                }
                case 2: {
                    object = this.getLibNameForDisplayName(String.valueOf(object));
                    constituent.setLibraryName((String)object);
                    return;
                }
                case 3: {
                    constituent.setDisplayName(String.valueOf(object));
                    return;
                }
                case 4: {
                    constituent.setUnit(String.valueOf(object));
                    return;
                }
                case 5: {
                    Double d = null;
                    if (object instanceof Double) {
                        d = (Double)object;
                    } else if (object instanceof String) {
                        object = (String)object;
                        d = RMAIO.parseDouble((String)object, (double)Double.NEGATIVE_INFINITY);
                    }
                    constituent.setReferenceValue(d);
                }
            }
        }
    }

    public void deleteRow(int n) {
        if (n < 0) {
            return;
        }
        if (n < this._constituents.size()) {
            this._constituents.remove(n);
        }
        int n2 = n;
        this.fireTableRowsDeleted(n2, n2);
    }

    public void appendConstituent(WQConstituent wQConstituent) {
        this._constituents.size();
        this._constituents.add(wQConstituent.copy());
        this.fireTableDataChanged();
    }

    public List<Constituent> getConstituents(String string) {
        return this._constituents.stream().filter(constituent -> constituent.getLibraryName().equals(string)).collect(Collectors.toList());
    }

    public void clearAll() {
        this._constituents.clear();
        this.fireTableDataChanged();
    }
}

