/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.dispersionCoeff.client;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.gui.SelectorPanelEditor;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.rss.wq.client.dispersionCoeff.client.ReachPanel;
import hec.rss.wq.client.dispersionCoeff.client.ReservoirPanel;
import hec.rss.wq.client.dispersionCoeff.client.actions.DeleteDispersionSetAction;
import hec.rss.wq.client.dispersionCoeff.client.actions.NewDispersionSetAction;
import hec.rss.wq.client.dispersionCoeff.client.actions.RenameDispersionSetAction;
import hec.rss.wq.client.dispersionCoeff.client.actions.SaveDispersionSetAsAction;
import hec.rss.wq.model.JsonManager;
import hec.rss.wq.model.ManagerProxyWrapper;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.model.dispersionCoeff.DispersionSetManager;
import hec.rss.wq.util.WqI18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import rma.swing.RmaInsets;
import rma.swing.RmaJTextField;

public class DispersionCoefEditor
extends SelectorPanelEditor {
    private static final FluentLogger a = FluentLogger.forEnclosingClass();
    private ReservoirPanel _reservoirPanel;
    private ReachPanel _reachPanel;
    private RmaJTextField _geoFld;
    private JMenu _wqSetMenu;
    private JMenuItem _menuItemNew;
    private JMenuItem _menuItemSaveAs;
    private JMenuItem _menuItemDelete;
    private String _title;
    private ManagerProxyListContainer _wksp;
    private DispersionSetManager _currentMgr;
    private JPanel _messagesPanel;
    private RmaJTextField _msgText;

    public DispersionCoefEditor(Frame frame) {
        super(frame, false);
        this.createControls();
        this.addListeners();
        this.pack();
        this.setSize(800, 785);
        DispersionCoefEditor dispersionCoefEditor = this;
        dispersionCoefEditor.setMinimumSize(dispersionCoefEditor.getSize());
        DispersionCoefEditor dispersionCoefEditor2 = this;
        dispersionCoefEditor2.setLocationRelativeTo(dispersionCoefEditor2.getParent());
    }

    private void createControls() {
        this._title = WqI18n.a("Dispersion.Editor.Title").getText();
        DispersionCoefEditor dispersionCoefEditor = this;
        dispersionCoefEditor.setTitle(dispersionCoefEditor._title);
        this._reservoirPanel = new ReservoirPanel(this);
        DispersionCoefEditor dispersionCoefEditor2 = this;
        dispersionCoefEditor2.addPanel(dispersionCoefEditor2._reservoirPanel);
        this._reachPanel = new ReachPanel(this);
        DispersionCoefEditor dispersionCoefEditor3 = this;
        dispersionCoefEditor3.addPanel(dispersionCoefEditor3._reachPanel);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getSelectorPanel().add((Component)jPanel, (Object)gridBagConstraints);
        JLabel jLabel = WqI18n.a("Param.ParamSetPanel.Label.Geometry").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._geoFld = new RmaJTextField();
        this._geoFld.setEditable(false);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._geoFld, gridBagConstraints);
        this._messagesPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.getBottomPanel().add((Component)this._messagesPanel, gridBagConstraints);
        this._msgText = new RmaJTextField();
        this._msgText.setEditable(false);
        this._msgText.setBorder(null);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this._messagesPanel.add((Component)this._msgText, gridBagConstraints);
        this._messagesPanel.setVisible(false);
        this.buildMenubar();
    }

    private void buildMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        this._wqSetMenu = WqI18n.a("Dispersion.Editor.Menu.DispersionSet").createMenu();
        this._menuItemNew = WqI18n.a("Dispersion.Editor.Menu.New").createMenuItem();
        this._wqSetMenu.add(this._menuItemNew);
        this._menuItemSaveAs = WqI18n.a("Dispersion.Editor.Menu.SaveAs").createMenuItem();
        this._wqSetMenu.add(this._menuItemSaveAs);
        this._menuItemDelete = WqI18n.a("Dispersion.Editor.Menu.Delete").createMenuItem();
        this._wqSetMenu.add(this._menuItemDelete);
        jMenuBar.add(this._wqSetMenu);
        this.setJMenuBar(jMenuBar);
    }

    private void addListeners() {
        this._menuItemNew.addActionListener(actionEvent -> this.newDispersionSetAction());
        this._menuItemSaveAs.addActionListener(actionEvent -> this.saveDispersionSetAsAction());
        this._menuItemDelete.addActionListener(actionEvent -> this.deleteDispersionSetAction());
    }

    private void deleteDispersionSetAction() {
        ManagerProxyWrapper managerProxyWrapper = (ManagerProxyWrapper)((Object)this.getSelectorPanel().getSelectedItem());
        if (managerProxyWrapper == null) {
            return;
        }
        ManagerProxy managerProxy = managerProxyWrapper.getManagerProxy();
        managerProxy = managerProxy.getId();
        DeleteDispersionSetAction deleteDispersionSetAction = new DeleteDispersionSetAction((Dialog)((Object)this));
        if ((managerProxy = deleteDispersionSetAction.a((Identifier)managerProxy)) != null) {
            this.setModified(false);
            this.getSelectorPanel().getComboBox().removeItem((Object)managerProxyWrapper);
            if (this.getSelectorPanel().getSelectedItem() == null && this.getSelectorPanel().getSelectorItems().size() > 0) {
                this.getSelectorPanel().setSelectedIndex(0);
                return;
            }
            this.clearForm();
            this.setDialogEnabled(false);
            this.setModified(false);
        }
    }

    private void renameDispersionSetAction() {
        Object object = (ManagerProxyWrapper)((Object)this.getSelectorPanel().getSelectedItem());
        if (object == null) {
            return;
        }
        object = object.getManagerProxy();
        object = (DispersionSetManager)object.loadManager(null, null);
        RenameDispersionSetAction renameDispersionSetAction = new RenameDispersionSetAction((Dialog)((Object)this));
        if ((object = renameDispersionSetAction.a((DispersionSetManager)object, this.getSelectorPanel().getDescription())) != null) {
            this.getSelectorPanel().getComboBox().repaint();
            this.getSelectorPanel().setDescription(((JsonManager)((Object)object)).getDescription());
        }
    }

    private void saveDispersionSetAsAction() {
        SaveDispersionSetAsAction saveDispersionSetAsAction;
        Object object;
        Object object2 = (ManagerProxyWrapper)((Object)this.getSelectorPanel().getSelectedItem());
        if (object2 == null) {
            return;
        }
        object2 = object2.getManagerProxy();
        object2 = (DispersionSetManager)object2.loadManager(null, null);
        if (this.isModified() && object2 != null) {
            String string = WqI18n.a("Dispersion.Editor.Msg.SaveMgr").format(object2);
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), string, (String)(object = WqI18n.a("Dispersion.Editor.Msg.SaveMgr.Title").getText()), 1);
            if (n == 0) {
                this.saveForm();
            } else if (2 == n) {
                return;
            }
        }
        if ((object = (saveDispersionSetAsAction = new SaveDispersionSetAsAction((Dialog)((Object)this))).a((DispersionSetManager)object2, this.getSelectorPanel().getDescription())) != null) {
            this.saveForm((NamedType)object);
            this.setModified(false);
            object2 = ClientApp.Workspace().getManagerProxy("rss", object.getIdentifier());
            this.getSelectorPanel().addSelectionItem((Object)new ManagerProxyWrapper((ManagerProxy)object2), true);
        }
    }

    private void newDispersionSetAction() {
        Object object = new NewDispersionSetAction((Dialog)((Object)this));
        if ((object = ((NewDispersionSetAction)object).h()) != null) {
            object = ClientApp.Workspace().getManagerProxy("rss", object.getIdentifier());
            this.getSelectorPanel().addSelectionItem((Object)new ManagerProxyWrapper((ManagerProxy)object), true);
        }
    }

    public void fillForm(ManagerProxyListContainer object) {
        this._wksp = object;
        this._wqSetMenu.setVisible(this._wksp instanceof ClientWorkspace);
        object = object.getManagerProxyList("rss", DispersionSetManager.class.getName());
        List list = object.stream().map(managerProxy -> new ManagerProxyWrapper((ManagerProxy)managerProxy)).collect(Collectors.toList());
        this.getSelectorPanel().setSelectionList(list);
        if (object.isEmpty()) {
            this.getSelectorPanel().setSelectedIndex(-1);
            this.setDialogEnabled(false);
            return;
        }
        this.getSelectorPanel().setSelectedIndex(0);
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
        String string = this._title;
        if (bl) {
            string = string.concat("*");
        }
        this.setTitle(string);
    }

    public void fillForm(NamedType namedType) {
        super.fillForm(namedType);
        this.setDialogEnabled(namedType != null);
        this.setModified(false);
        if (namedType instanceof ManagerProxyWrapper) {
            namedType = (ManagerProxyWrapper)namedType;
            namedType = namedType.getManagerProxy();
            this._currentMgr = (DispersionSetManager)namedType.loadManager(null, null);
            int n = this._currentMgr.getGeometryId();
            ManagerProxy managerProxy = this._wksp.getManagerProxy("rss", WqGeometry.class.getName(), n);
            if (managerProxy != null) {
                this._geoFld.setText(managerProxy.getName());
            } else {
                this._geoFld.setText("");
            }
            DispersionCoefEditor dispersionCoefEditor = this;
            dispersionCoefEditor.updateUnitSystem(dispersionCoefEditor.getContentPane());
            return;
        }
        this._currentMgr = null;
    }

    public boolean saveForm() {
        boolean bl = super.saveForm();
        if (bl && this._currentMgr != null) {
            this._wksp.saveManager("rss", (Manager)this._currentMgr);
        }
        return bl;
    }

    private void setDialogEnabled(boolean bl) {
        this._menuItemDelete.setEnabled(bl);
        this._menuItemSaveAs.setEnabled(bl);
        this._reservoirPanel.setEnabled(bl);
        this._reachPanel.setEnabled(bl);
    }

    public void setSelectedDispersionSet(DispersionSetManager object) {
        object = object.getProxyList().getManagerProxy(object.getIdentifier());
        object = new ManagerProxyWrapper((ManagerProxy)object);
        this.selectorPanel.setSelectedItem(object);
    }

    public void setErrorMessage(String string) {
        this._messagesPanel.setVisible(string != null);
        if (string != null) {
            this._msgText.setText(string);
            ((FluentLogger.Api)a.atWarning()).log(string);
            this._msgText.setForeground(Color.RED);
            return;
        }
        this._msgText.setText("");
    }

    public void setMessage(String string) {
        this._messagesPanel.setVisible(string != null);
        if (string != null) {
            this._msgText.setText(string);
            ((FluentLogger.Api)a.atInfo()).log(string);
            this._msgText.setForeground(UIManager.getColor("TextField.foreground"));
            return;
        }
        this._msgText.setText("");
    }
}

