/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.dispersionCoeff.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.rss.wq.client.dispersionCoeff.client.DispersionReachTableModel$TableRow;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.model.dispersionCoeff.DispersionSetManager;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.dispersion.ReachDispersionValues;
import hec.wqenginecore.geometry.SubDomain;
import java.util.ArrayList;
import java.util.List;
import rma.swing.table.AbstractRmaTableModel;
import rma.util.RMAIO;

public class DispersionReachTableModel
extends AbstractRmaTableModel {
    private DispersionSetManager _dispersionSet;
    private List<DispersionReachTableModel$TableRow> _rows = new ArrayList<DispersionReachTableModel$TableRow>();
    private ParamDouble _paramDouble;
    private Integer _precision;

    public DispersionReachTableModel(DispersionSetManager dispersionSetManager) {
        this.m_columnNames = new String[]{WqI18n.a("Dispersion.ReachPanel.Header.Reach").getText(), WqI18n.a("Dispersion.ReachPanel.Header.Dispersion").getText(), WqI18n.a("Dispersion.ReachPanel.Header.LowerEnd").getText(), WqI18n.a("Dispersion.ReachPanel.Header.UpperEnd").getText()};
        int n = ClientApp.Workspace().getUnitSystem();
        this._paramDouble = new ParamDouble(0.0, -1, n);
        this._precision = Integer.getInteger("Dispersion.Reach.Precision", 3);
        this._paramDouble.setPrecision(this._precision.intValue());
        this._dispersionSet = dispersionSetManager;
        this.buildModel();
    }

    private void buildModel() {
        Object object;
        if (this._dispersionSet != null && (object = this._dispersionSet.getGeometry()) != null && (object = ((WqGeometry)((Object)object)).getRssWqGeometry()) != null) {
            List list = this._dispersionSet.getSet().getReachSettings().getReachValues();
            object = object.getReaches();
            object = object.iterator();
            while (object.hasNext()) {
                DispersionReachTableModel$TableRow dispersionReachTableModel$TableRow = new DispersionReachTableModel$TableRow((SubDomain)object.next());
                List list2 = list;
                DispersionReachTableModel$TableRow dispersionReachTableModel$TableRow2 = dispersionReachTableModel$TableRow;
                int n = dispersionReachTableModel$TableRow.d().getId();
                for (int i = 0; i < list2.size(); ++i) {
                    ReachDispersionValues reachDispersionValues = (ReachDispersionValues)list2.get(i);
                    if (reachDispersionValues.getReachId() != n) continue;
                    dispersionReachTableModel$TableRow2.c(reachDispersionValues.getConstant());
                    dispersionReachTableModel$TableRow2.a(reachDispersionValues.getUpperEnd());
                    dispersionReachTableModel$TableRow2.b(reachDispersionValues.getLowerEnd());
                }
                this._rows.add(dispersionReachTableModel$TableRow);
            }
        }
    }

    public int getRowCount() {
        return this._rows.size();
    }

    public Object getValueAt(int n, int n2) {
        if (n < 0 || n >= this._rows.size() || n2 < 0 || n2 >= this.getColumnCount()) {
            return null;
        }
        DispersionReachTableModel$TableRow dispersionReachTableModel$TableRow = this._rows.get(n);
        switch (n2) {
            case 0: {
                return dispersionReachTableModel$TableRow.d();
            }
            case 1: {
                this._paramDouble.setValue(dispersionReachTableModel$TableRow.c());
                break;
            }
            case 2: {
                this._paramDouble.setValue(dispersionReachTableModel$TableRow.b());
                break;
            }
            case 3: {
                this._paramDouble.setValue(dispersionReachTableModel$TableRow.a());
                break;
            }
            default: {
                return null;
            }
        }
        try {
            this._paramDouble.setPrecision(this._precision.intValue());
            return this._paramDouble.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n < 0 || n >= this._rows.size()) {
            return;
        }
        if (n2 < 0 || n2 >= this.getColumnCount()) {
            return;
        }
        DispersionReachTableModel$TableRow dispersionReachTableModel$TableRow = this._rows.get(n);
        double d = RMAIO.parseDouble((Object)object);
        object = null;
        try {
            object = (ParamDouble)this._paramDouble.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        int n3 = object.getPrecision();
        object.setValue(d);
        object.setPrecision(n3);
        switch (n2) {
            case 1: {
                dispersionReachTableModel$TableRow.c(object.getValue());
                break;
            }
            case 2: {
                dispersionReachTableModel$TableRow.b(object.getValue());
                break;
            }
            case 3: {
                dispersionReachTableModel$TableRow.a(object.getValue());
            }
        }
        this.fireTableCellUpdated(n, n2);
    }

    public List<ReachDispersionValues> getReachValues() {
        int n = this.getRowCount();
        ArrayList<ReachDispersionValues> arrayList = new ArrayList<ReachDispersionValues>();
        for (int i = 0; i < n; ++i) {
            DispersionReachTableModel$TableRow dispersionReachTableModel$TableRow = this._rows.get(i);
            ReachDispersionValues reachDispersionValues = new ReachDispersionValues();
            reachDispersionValues.setReachId(dispersionReachTableModel$TableRow.d().getId());
            reachDispersionValues.setConstant(dispersionReachTableModel$TableRow.c());
            reachDispersionValues.setUpperEnd(dispersionReachTableModel$TableRow.a());
            reachDispersionValues.setLowerEnd(dispersionReachTableModel$TableRow.b());
            arrayList.add(reachDispersionValues);
        }
        return arrayList;
    }
}

